/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultsList {
    private List<Object> delegate = new ArrayList<Object>();

    public void add(Object key, Object value) {
        this.add(key, value, true);
    }

    public void add(Object key, Object value, boolean enableChecking) {
        if (enableChecking) {
            DefaultsList.asUIResource(value, value + " must be a UIResource");
        }
        if (value == null && this.delegate.contains(key)) {
            int i2 = this.delegate.indexOf(key);
            this.delegate.remove(i2 + 1);
            this.delegate.remove(i2);
        } else if (value != null) {
            this.delegate.add(Contract.asNotNull(key, "key cannot be null"));
            this.delegate.add(value);
        }
    }

    private static <T> T asUIResource(T value, String message) {
        if (!(value instanceof UIResource)) {
            boolean shouldThrow = false;
            shouldThrow |= value instanceof ActionMap;
            shouldThrow |= value instanceof Border;
            shouldThrow |= value instanceof Color;
            shouldThrow |= value instanceof Dimension;
            shouldThrow |= value instanceof Font;
            shouldThrow |= value instanceof Icon;
            shouldThrow |= value instanceof InputMap;
            shouldThrow |= value instanceof Insets;
            if (shouldThrow |= value instanceof Painter) {
                throw new IllegalArgumentException(message);
            }
        }
        return value;
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }
}

