/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.layout;

import java.beans.Beans;
import java.beans.ExceptionListener;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.layout.ResizeConstraint;
import net.miginfocom.layout.UnitValue;

public final class LayoutUtil {
    public static final int INF = 2097051;
    static final int NOT_SET = -2147471302;
    public static final int MIN = 0;
    public static final int PREF = 1;
    public static final int MAX = 2;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static volatile WeakHashMap<Object, String> CR_MAP = null;
    private static volatile WeakHashMap<Object, Boolean> DT_MAP = null;
    private static int eSz = 0;
    private static int globalDebugMillis = 0;
    public static final boolean HAS_BEANS = LayoutUtil.hasBeans();
    private static ByteArrayOutputStream writeOutputStream = null;
    private static byte[] readBuf = null;
    private static final IdentityHashMap<Object, Object> SER_MAP = new IdentityHashMap(2);

    private static boolean hasBeans() {
        try {
            LayoutUtil.class.getClassLoader().loadClass("java.beans.Beans");
            return true;
        }
        catch (Throwable e2) {
            return false;
        }
    }

    private LayoutUtil() {
    }

    public static String getVersion() {
        return "5.0";
    }

    public static int getGlobalDebugMillis() {
        return globalDebugMillis;
    }

    public static void setGlobalDebugMillis(int millis) {
        globalDebugMillis = millis;
    }

    public static void setDesignTime(ContainerWrapper cw, boolean b2) {
        if (DT_MAP == null) {
            DT_MAP = new WeakHashMap();
        }
        DT_MAP.put(cw != null ? cw.getComponent() : null, b2);
    }

    public static boolean isDesignTime(ContainerWrapper cw) {
        if (DT_MAP == null) {
            return HAS_BEANS && Beans.isDesignTime();
        }
        if (cw == null && DT_MAP != null && !DT_MAP.isEmpty()) {
            return true;
        }
        if (cw != null && !DT_MAP.containsKey(cw.getComponent())) {
            cw = null;
        }
        Boolean b2 = DT_MAP.get(cw != null ? cw.getComponent() : null);
        return b2 != null && b2 != false;
    }

    public static int getDesignTimeEmptySize() {
        return eSz;
    }

    public static void setDesignTimeEmptySize(int pixels) {
        eSz = pixels;
    }

    static void putCCString(Object con, String s2) {
        if (s2 != null && con != null && LayoutUtil.isDesignTime(null)) {
            if (CR_MAP == null) {
                CR_MAP = new WeakHashMap(64);
            }
            CR_MAP.put(con, s2);
        }
    }

    static synchronized void setDelegate(Class<?> c2, PersistenceDelegate del) {
        try {
            Introspector.getBeanInfo(c2, 3).getBeanDescriptor().setValue("persistenceDelegate", del);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static String getCCString(Object con) {
        return CR_MAP != null ? CR_MAP.get(con) : null;
    }

    static void throwCC() {
        throw new IllegalStateException("setStoreConstraintData(true) must be set for strings to be saved.");
    }

    static int[] calculateSerial(int[][] sizes, ResizeConstraint[] resConstr, Float[] defPushWeights, int startSizeType, int bounds) {
        float[] lengths = new float[sizes.length];
        float usedLength = 0.0f;
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            if (sizes[i2] == null) continue;
            float len = sizes[i2][startSizeType] != -2147471302 ? (float)sizes[i2][startSizeType] : 0.0f;
            int newSizeBounded = LayoutUtil.getBrokenBoundary(len, sizes[i2][0], sizes[i2][2]);
            if (newSizeBounded != -2147471302) {
                len = newSizeBounded;
            }
            usedLength += len;
            lengths[i2] = len;
        }
        int useLengthI = Math.round(usedLength);
        if (useLengthI != bounds && resConstr != null) {
            boolean isGrow = useLengthI < bounds;
            TreeSet<Integer> prioList = new TreeSet<Integer>();
            for (int i3 = 0; i3 < sizes.length; ++i3) {
                ResizeConstraint resC = (ResizeConstraint)LayoutUtil.getIndexSafe(resConstr, i3);
                if (resC == null) continue;
                prioList.add(isGrow ? resC.growPrio : resC.shrinkPrio);
            }
            Integer[] prioIntegers = prioList.toArray(new Integer[prioList.size()]);
            for (int force = 0; force <= (isGrow && defPushWeights != null ? 1 : 0); ++force) {
                for (int pr = prioIntegers.length - 1; pr >= 0; --pr) {
                    boolean hit;
                    int curPrio = prioIntegers[pr];
                    float totWeight = 0.0f;
                    Float[] resizeWeight = new Float[sizes.length];
                    for (int i4 = 0; i4 < sizes.length; ++i4) {
                        int prio;
                        ResizeConstraint resC;
                        if (sizes[i4] == null || (resC = (ResizeConstraint)LayoutUtil.getIndexSafe(resConstr, i4)) == null) continue;
                        int n2 = prio = isGrow ? resC.growPrio : resC.shrinkPrio;
                        if (curPrio != prio) continue;
                        resizeWeight[i4] = isGrow ? (force == 0 || resC.grow != null ? resC.grow : defPushWeights[i4 < defPushWeights.length ? i4 : defPushWeights.length - 1]) : resC.shrink;
                        if (resizeWeight[i4] == null) continue;
                        totWeight += resizeWeight[i4].floatValue();
                    }
                    if (!(totWeight > 0.0f)) continue;
                    do {
                        float toChange = (float)bounds - usedLength;
                        hit = false;
                        float changedWeight = 0.0f;
                        for (int i5 = 0; i5 < sizes.length && totWeight > 1.0E-4f; ++i5) {
                            int newSizeBounded;
                            Float weight = resizeWeight[i5];
                            if (weight == null) continue;
                            float sizeDelta = toChange * weight.floatValue() / totWeight;
                            float newSize = lengths[i5] + sizeDelta;
                            if (sizes[i5] != null && (newSizeBounded = LayoutUtil.getBrokenBoundary(newSize, sizes[i5][0], sizes[i5][2])) != -2147471302) {
                                resizeWeight[i5] = null;
                                hit = true;
                                changedWeight += weight.floatValue();
                                newSize = newSizeBounded;
                                sizeDelta = newSize - lengths[i5];
                            }
                            lengths[i5] = newSize;
                            usedLength += sizeDelta;
                        }
                        totWeight -= changedWeight;
                    } while (hit);
                }
            }
        }
        return LayoutUtil.roundSizes(lengths);
    }

    static Object getIndexSafe(Object[] arr, int ix) {
        return arr != null ? arr[ix < arr.length ? ix : arr.length - 1] : null;
    }

    private static int getBrokenBoundary(float sz, int lower, int upper) {
        if (lower != -2147471302) {
            if (sz < (float)lower) {
                return lower;
            }
        } else if (sz < 0.0f) {
            return 0;
        }
        if (upper != -2147471302 && sz > (float)upper) {
            return upper;
        }
        return -2147471302;
    }

    static int sum(int[] terms, int start, int len) {
        int s2 = 0;
        int iSz = start + len;
        for (int i2 = start; i2 < iSz; ++i2) {
            s2 += terms[i2];
        }
        return s2;
    }

    static int sum(int[] terms) {
        return LayoutUtil.sum(terms, 0, terms.length);
    }

    static float clamp(float f2, float min, float max) {
        return Math.max(min, Math.min(f2, max));
    }

    static int clamp(int i2, int min, int max) {
        return Math.max(min, Math.min(i2, max));
    }

    public static int getSizeSafe(int[] sizes, int sizeType) {
        if (sizes == null || sizes[sizeType] == -2147471302) {
            return sizeType == 2 ? 2097051 : 0;
        }
        return sizes[sizeType];
    }

    static BoundSize derive(BoundSize bs, UnitValue min, UnitValue pref, UnitValue max) {
        if (bs == null || bs.isUnset()) {
            return new BoundSize(min, pref, max, null);
        }
        return new BoundSize(min != null ? min : bs.getMin(), pref != null ? pref : bs.getPreferred(), max != null ? max : bs.getMax(), bs.getGapPush(), null);
    }

    public static boolean isLeftToRight(LC lc2, ContainerWrapper container) {
        if (lc2 != null && lc2.getLeftToRight() != null) {
            return lc2.getLeftToRight();
        }
        return container == null || container.isLeftToRight();
    }

    static int[] roundSizes(float[] sizes) {
        int[] retInts = new int[sizes.length];
        float posD = 0.0f;
        for (int i2 = 0; i2 < retInts.length; ++i2) {
            int posI = (int)(posD + 0.5f);
            retInts[i2] = (int)((posD += sizes[i2]) + 0.5f) - posI;
        }
        return retInts;
    }

    static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o2 != null && o1.equals(o2);
    }

    static UnitValue getInsets(LC lc2, int side, boolean getDefault) {
        UnitValue[] i2 = lc2.getInsets();
        return i2 != null && i2[side] != null ? i2[side] : (getDefault ? PlatformDefaults.getPanelInsets(side) : UnitValue.ZERO);
    }

    static void writeXMLObject(OutputStream os, Object o2, ExceptionListener listener) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(LayoutUtil.class.getClassLoader());
        XMLEncoder encoder = new XMLEncoder(os);
        if (listener != null) {
            encoder.setExceptionListener(listener);
        }
        encoder.writeObject(o2);
        encoder.close();
        Thread.currentThread().setContextClassLoader(oldClassLoader);
    }

    public static synchronized void writeAsXML(ObjectOutput out, Object o2) throws IOException {
        if (writeOutputStream == null) {
            writeOutputStream = new ByteArrayOutputStream(16384);
        }
        writeOutputStream.reset();
        LayoutUtil.writeXMLObject(writeOutputStream, o2, new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e2) {
                e2.printStackTrace();
            }
        });
        byte[] buf = writeOutputStream.toByteArray();
        out.writeInt(buf.length);
        out.write(buf);
    }

    public static synchronized Object readAsXML(ObjectInput in) throws IOException {
        if (readBuf == null) {
            readBuf = new byte[16384];
        }
        Thread cThread = Thread.currentThread();
        ClassLoader oldCL = null;
        try {
            oldCL = cThread.getContextClassLoader();
            cThread.setContextClassLoader(LayoutUtil.class.getClassLoader());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Object o2 = null;
        try {
            int length = in.readInt();
            if (length > readBuf.length) {
                readBuf = new byte[length];
            }
            in.readFully(readBuf, 0, length);
            o2 = new XMLDecoder(new ByteArrayInputStream(readBuf, 0, length)).readObject();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (oldCL != null) {
            cThread.setContextClassLoader(oldCL);
        }
        return o2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSerializedObject(Object caller, Object o2) {
        IdentityHashMap<Object, Object> identityHashMap = SER_MAP;
        synchronized (identityHashMap) {
            SER_MAP.put(caller, o2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSerializedObject(Object caller) {
        IdentityHashMap<Object, Object> identityHashMap = SER_MAP;
        synchronized (identityHashMap) {
            return SER_MAP.remove(caller);
        }
    }
}

