/*
 * Decompiled with CFR 0.152.
 */
package de.centigrade.cezanne.image;

import de.centigrade.cezanne.CezanneContext;
import de.centigrade.cezanne.image.CezanneImage;
import de.centigrade.cezanne.util.CezanneUtil;
import de.centigrade.cezanne.util.log.Logger;
import de.centigrade.util.integrated.CodeGroup;
import de.centigrade.util.integrated.PrivateAPI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.SinglePixelPackedSampleModel;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

@PrivateAPI
@CodeGroup(value={"cezanne-core"})
public class CezanneImageUtil {
    protected static final Logger a;
    private static final String[] z;

    public Image a(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage bufferedImage = this.createCompatibleBufferedImage(this.getDefaultGraphicsConfiguration(), icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }

    public Icon a(Icon icon, int n2, int n3, int n4) {
        if (icon == null) {
            return null;
        }
        Dimension dimension = this.a(icon.getIconWidth(), icon.getIconHeight(), n2, n3);
        return this.b(icon, dimension.width, dimension.height, n4);
    }

    public Dimension a(int n2, int n3, int n4, int n5) {
        float f2 = (float)n4 / (float)n2;
        f2 = Math.min(f2, (float)n5 / (float)n3);
        n2 = Math.round((float)n2 * f2);
        n3 = Math.round((float)n3 * f2);
        return new Dimension(n2, n3);
    }

    public Icon b(Icon icon, int n2, int n3, int n4) {
        if (icon == null) {
            return null;
        }
        Image image = this.a(this.a(icon), n2, n3, n4);
        if (image == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(image);
        return imageIcon;
    }

    public Image a(Image image, int n2, int n3, int n4) {
        if (image == null) {
            return null;
        }
        return image.getScaledInstance(n2, n3, n4);
    }

    @PrivateAPI
    public BufferedImage createCompatibleBufferedImage(CezanneContext<?> cezanneContext, int n2, int n3, int n4) {
        return this.createCompatibleBufferedImage(this.a(cezanneContext), n2, n3, n4);
    }

    @PrivateAPI
    public BufferedImage createCompatibleBufferedImage(GraphicsConfiguration graphicsConfiguration, int n2, int n3, int n4) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = this.getDefaultGraphicsConfiguration();
        }
        return graphicsConfiguration.createCompatibleImage(n2, n3, n4);
    }

    public GraphicsConfiguration a(CezanneContext<?> cezanneContext) {
        Object obj;
        if (cezanneContext != null && (obj = cezanneContext.getComponent()) != null) {
            return ((Component)obj).getGraphicsConfiguration();
        }
        return this.getDefaultGraphicsConfiguration();
    }

    @PrivateAPI
    public GraphicsConfiguration getDefaultGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public void a(BufferedImage bufferedImage, Image image) {
        if (image == null) {
            return;
        }
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
    }

    @PrivateAPI
    public Image loadImage(URL uRL) {
        if (uRL == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (imageIcon.getImageLoadStatus() != 8) {
            a.warn(null, z[2] + uRL + z[1]);
        }
        return imageIcon.getImage();
    }

    public void a(Image image, Image image2, Graphics2D graphics2D, int n2, int n3, float f2) {
        graphics2D.setComposite(AlphaComposite.getInstance(2, f2));
        graphics2D.setColor(Color.YELLOW);
        graphics2D.fillRect(0, 0, n2, n3);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.drawImage(image2, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.SrcIn);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - f2));
        graphics2D.drawImage(image2, 0, 0, null);
    }

    @PrivateAPI
    public Image createAcceleratedImage(Image image) {
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(image.getSource())).getImage();
    }

    public int a(int n2) {
        int n3 = n2 & 0xFF000000;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        int n7 = n4 * 77 + n5 * 151 + n6 * 28 >> 8;
        n2 = n3 | n7 << 16 | n7 << 8 | n7;
        return n2;
    }

    @PrivateAPI
    public int filterPixelColorize(int n2, float f2, float f3, float f4, float f5, float f6) {
        int n3 = n2 & 0xFF000000;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        float[] fArray = new float[3];
        fArray = Color.RGBtoHSB(n4, n5, n6, fArray);
        fArray[0] = f2;
        fArray[1] = Math.max(0.0f, Math.min(1.0f, f3 + fArray[1] * f4));
        fArray[2] = Math.max(0.0f, Math.min(1.0f, f5 + fArray[2] * f6));
        n2 = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]) & 0xFFFFFF;
        n2 = n3 | n2;
        return n2;
    }

    public void a(Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(n2, n3, n4, n5);
        graphics2D.setComposite(composite);
    }

    @PrivateAPI
    public void drawImage(Graphics graphics, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        image = this.a(image, graphics);
        graphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, imageObserver);
    }

    @PrivateAPI
    public void drawImage(Graphics graphics, Image image, int n2, int n3, ImageObserver imageObserver) {
        image = this.a(image, graphics);
        graphics.drawImage(image, n2, n3, imageObserver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Image a(Image image, Graphics graphics) {
        boolean bl = CezanneImage.f;
        if (!CezanneUtil.b(graphics)) {
            return image;
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        if (n2 <= 0 || n3 <= 0) {
            new ImageIcon(image);
        }
        n2 = image.getWidth(null);
        n3 = image.getHeight(null);
        if (n2 <= 0) return image;
        if (n3 <= 0) {
            return image;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        try {
            int n4;
            int n5;
            boolean bl2;
            int n6;
            int n7;
            int n8;
            int[] nArray;
            block15: {
                DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
                nArray = dataBufferInt.getData();
                n8 = bufferedImage.getMinX();
                n7 = bufferedImage.getMinY();
                int n9 = n8 + bufferedImage.getWidth();
                int n10 = n7 + bufferedImage.getHeight();
                n6 = ((SinglePixelPackedSampleModel)bufferedImage.getRaster().getSampleModel()).getScanlineStride();
                int n11 = 0;
                bl2 = false;
                n5 = n7;
                block9: while (true) {
                    int n12 = n5;
                    int n13 = n10;
                    block10: while (n12 < n13) {
                        int n14 = n5 * n6 + n8;
                        n4 = n8;
                        if (bl) break block15;
                        for (int i2 = v254927; i2 < n9; ++n14, ++i2) {
                            n12 = nArray[n14] & 0xFF000000;
                            n13 = -16777216;
                            if (bl) continue block10;
                            if (n12 == n13) continue;
                            n11 = 1;
                            if (n5 != n7) break block9;
                            bl2 = true;
                            if (!bl) break block9;
                            if (!bl) continue;
                        }
                        ++n5;
                        if (!bl) continue block9;
                    }
                    break;
                }
                n4 = n11;
            }
            if (n4 == 0) return bufferedImage;
            if (bl2) return bufferedImage;
            n5 = n7 * n6 + n8;
            nArray[n5] = nArray[n5] & 0xFEFFFFFF;
            return bufferedImage;
        }
        catch (Throwable throwable) {
            a.warn(this, z[0], throwable);
        }
        return bufferedImage;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "xW2~*\u001bV(fnH[&|nRU&u+\u001bL5s HH&`+U[>2(TJgb<RV3{ \\\u0016";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 59;
                                break;
                            }
                            case 1: {
                                n9 = 56;
                                break;
                            }
                            case 2: {
                                n9 = 71;
                                break;
                            }
                            case 3: {
                                n9 = 18;
                                break;
                            }
                            default: {
                                n9 = 78;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u001c\u0016";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "xY)5:\u001bT(s*\u001bQ*s)^\u0018!`!V\u0018`";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        a = Logger.getLogger(CezanneImageUtil.class);
    }
}

