/*
 * Decompiled with CFR 0.152.
 */
package com.sun.animation.effects;

import com.sun.animation.effects.ComponentEffect;
import com.sun.animation.effects.ComponentState;
import java.awt.Component;
import java.awt.Graphics2D;

public class Rotate
extends ComponentEffect {
    private final int xCenter;
    private final int yCenter;
    private final int degrees;

    public Rotate(Component component, int degrees) {
        this.degrees = degrees;
        this.xCenter = component.getWidth() / 2;
        this.yCenter = component.getHeight() / 2;
    }

    public Rotate(ComponentState start, ComponentState end, int degrees, int xCenter, int yCenter) {
        this.setComponentStates(start, end);
        this.degrees = degrees;
        this.xCenter = xCenter;
        this.yCenter = yCenter;
    }

    @Override
    public void setup(Graphics2D g2d, float fraction) {
        g2d.translate(this.xCenter, this.yCenter);
        g2d.rotate(Math.toRadians(fraction * (float)this.degrees));
        g2d.translate(-this.xCenter, -this.yCenter);
        super.setup(g2d, fraction);
    }
}

