/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.widgets;

import com.jtechdev.widgets.WindowUtils;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class ImageButton
extends JButton {
    private static final int ALPHA_BAND = 3;
    private final BufferedImage fMask;
    private Icon fInactiveIcon;

    public ImageButton(Icon icon) {
        this(icon, icon);
    }

    public ImageButton(Icon icon, Icon mask) {
        super(icon);
        if (icon == null) {
            throw new IllegalArgumentException("The icon cannot be null.");
        }
        if (mask == null) {
            throw new IllegalArgumentException("The mask cannot be null.");
        }
        ImageButton.checkIconMatchesMaskBounds(icon, mask);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setContentAreaFilled(false);
        this.fMask = this.createMask(mask);
        WindowUtils.installJComponentRepainterOnWindowFocusChanged(this);
    }

    private BufferedImage createMask(Icon mask) {
        BufferedImage image = new BufferedImage(mask.getIconWidth(), mask.getIconHeight(), 2);
        Graphics graphics = image.getGraphics();
        mask.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return image;
    }

    @Override
    public Icon getIcon() {
        return WindowUtils.isParentWindowFocused(this) || this.fInactiveIcon == null ? super.getIcon() : this.fInactiveIcon;
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon);
        if (this.fMask != null) {
            ImageButton.checkIconMatchesMaskBounds(defaultIcon, new ImageIcon(this.fMask));
        }
    }

    public void setInactiveIcon(Icon inactiveIcon) {
        ImageButton.checkIconMatchesMaskBounds(inactiveIcon, new ImageIcon(this.fMask));
        this.fInactiveIcon = inactiveIcon;
    }

    @Override
    public void updateUI() {
        this.setUI(new CustomButtonUI());
    }

    private static void checkIconMatchesMaskBounds(Icon icon, Icon mask) {
        if (mask.getIconWidth() != icon.getIconWidth() || mask.getIconHeight() != icon.getIconHeight()) {
            throw new IllegalArgumentException("The mask must be the same size as the icon.");
        }
    }

    private class CustomButtonUI
    extends BasicButtonUI {
        private Rectangle fIconRect;

        private CustomButtonUI() {
        }

        private boolean maskContains(int x2, int y2) {
            return this.fIconRect != null && this.fIconRect.contains(x2, y2) && ImageButton.this.fMask.getRaster().getSample(x2 - this.fIconRect.x, y2 - this.fIconRect.y, 3) > 0;
        }

        @Override
        public boolean contains(JComponent c2, int x2, int y2) {
            return this.maskContains(x2, y2);
        }

        @Override
        protected void paintIcon(Graphics g2, JComponent c2, Rectangle iconRect) {
            super.paintIcon(g2, c2, iconRect);
            if (this.fIconRect == null || !this.fIconRect.equals(iconRect)) {
                this.fIconRect = new Rectangle(iconRect);
            }
        }
    }
}

