/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.vecmath;

import com.jhlabs.vecmath.Tuple3f;

public class Vector3f
extends Tuple3f {
    public Vector3f() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3f(float[] x2) {
        this.x = x2[0];
        this.y = x2[1];
        this.z = x2[2];
    }

    public Vector3f(float x2, float y2, float z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public Vector3f(Vector3f t2) {
        this.x = t2.x;
        this.y = t2.y;
        this.z = t2.z;
    }

    public Vector3f(Tuple3f t2) {
        this.x = t2.x;
        this.y = t2.y;
        this.z = t2.z;
    }

    public float angle(Vector3f v2) {
        return (float)Math.acos(this.dot(v2) / (this.length() * v2.length()));
    }

    public float dot(Vector3f v2) {
        return v2.x * this.x + v2.y * this.y + v2.z * this.z;
    }

    public void cross(Vector3f v1, Vector3f v2) {
        this.x = v1.y * v2.z - v1.z * v2.y;
        this.y = v1.z * v2.x - v1.x * v2.z;
        this.z = v1.x * v2.y - v1.y * v2.x;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void normalize() {
        float d2 = 1.0f / (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
    }
}

