/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.PointFilter;
import java.awt.image.BufferedImage;

public abstract class TransferFilter
extends PointFilter {
    protected int[] rTable;
    protected int[] gTable;
    protected int[] bTable;
    protected boolean initialized = false;

    public TransferFilter() {
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x2, int y2, int rgb) {
        int a2 = rgb & 0xFF000000;
        int r2 = rgb >> 16 & 0xFF;
        int g2 = rgb >> 8 & 0xFF;
        int b2 = rgb & 0xFF;
        r2 = this.rTable[r2];
        g2 = this.gTable[g2];
        b2 = this.bTable[b2];
        return a2 | r2 << 16 | g2 << 8 | b2;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (!this.initialized) {
            this.initialize();
        }
        return super.filter(src, dst);
    }

    protected void initialize() {
        this.initialized = true;
        this.bTable = this.makeTable();
        this.gTable = this.bTable;
        this.rTable = this.bTable;
    }

    protected int[] makeTable() {
        int[] table = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            table[i2] = PixelUtils.clamp((int)(255.0f * this.transferFunction((float)i2 / 255.0f)));
        }
        return table;
    }

    protected float transferFunction(float v2) {
        return 0.0f;
    }

    public int[] getLUT() {
        if (!this.initialized) {
            this.initialize();
        }
        int[] lut = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            lut[i2] = this.filterRGB(0, 0, i2 << 24 | i2 << 16 | i2 << 8 | i2);
        }
        return lut;
    }
}

