/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

public class Spectrum {
    private static int adjust(float color, float factor, float gamma) {
        if ((double)color == 0.0) {
            return 0;
        }
        return (int)Math.round(255.0 * Math.pow(color * factor, gamma));
    }

    public static int wavelengthToRGB(float wavelength) {
        float b2;
        float g2;
        float r2;
        float gamma = 0.8f;
        int w2 = (int)wavelength;
        if (w2 < 380) {
            r2 = 0.0f;
            g2 = 0.0f;
            b2 = 0.0f;
        } else if (w2 < 440) {
            r2 = -(wavelength - 440.0f) / 60.0f;
            g2 = 0.0f;
            b2 = 1.0f;
        } else if (w2 < 490) {
            r2 = 0.0f;
            g2 = (wavelength - 440.0f) / 50.0f;
            b2 = 1.0f;
        } else if (w2 < 510) {
            r2 = 0.0f;
            g2 = 1.0f;
            b2 = -(wavelength - 510.0f) / 20.0f;
        } else if (w2 < 580) {
            r2 = (wavelength - 510.0f) / 70.0f;
            g2 = 1.0f;
            b2 = 0.0f;
        } else if (w2 < 645) {
            r2 = 1.0f;
            g2 = -(wavelength - 645.0f) / 65.0f;
            b2 = 0.0f;
        } else if (w2 <= 780) {
            r2 = 1.0f;
            g2 = 0.0f;
            b2 = 0.0f;
        } else {
            r2 = 0.0f;
            g2 = 0.0f;
            b2 = 0.0f;
        }
        float factor = 380 <= w2 && w2 <= 419 ? 0.3f + 0.7f * (wavelength - 380.0f) / 40.0f : (420 <= w2 && w2 <= 700 ? 1.0f : (701 <= w2 && w2 <= 780 ? 0.3f + 0.7f * (780.0f - wavelength) / 80.0f : 0.0f));
        int ir = Spectrum.adjust(r2, factor, gamma);
        int ig = Spectrum.adjust(g2, factor, gamma);
        int ib2 = Spectrum.adjust(b2, factor, gamma);
        return 0xFF000000 | ir << 16 | ig << 8 | ib2;
    }
}

