/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.BinaryFilter;
import java.awt.Rectangle;

public class SkeletonFilter
extends BinaryFilter {
    private static final byte[] skeletonTable = new byte[]{0, 0, 0, 1, 0, 0, 1, 3, 0, 0, 3, 1, 1, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 3, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 3, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 2, 0, 0, 1, 3, 1, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 1, 3, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 1, 0, 0, 0, 0, 2, 2, 0, 0, 2, 0, 0, 0};

    public SkeletonFilter() {
        this.newColor = -1;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int[] outPixels = new int[width * height];
        int count = 0;
        int black = -16777216;
        int white = -1;
        for (int i2 = 0; i2 < this.iterations; ++i2) {
            count = 0;
            for (int pass = 0; pass < 2; ++pass) {
                for (int y2 = 1; y2 < height - 1; ++y2) {
                    int offset = y2 * width + 1;
                    for (int x2 = 1; x2 < width - 1; ++x2) {
                        int pixel = inPixels[offset];
                        if (pixel == black) {
                            int tableIndex = 0;
                            if (inPixels[offset - width - 1] == black) {
                                tableIndex |= 1;
                            }
                            if (inPixels[offset - width] == black) {
                                tableIndex |= 2;
                            }
                            if (inPixels[offset - width + 1] == black) {
                                tableIndex |= 4;
                            }
                            if (inPixels[offset + 1] == black) {
                                tableIndex |= 8;
                            }
                            if (inPixels[offset + width + 1] == black) {
                                tableIndex |= 0x10;
                            }
                            if (inPixels[offset + width] == black) {
                                tableIndex |= 0x20;
                            }
                            if (inPixels[offset + width - 1] == black) {
                                tableIndex |= 0x40;
                            }
                            if (inPixels[offset - 1] == black) {
                                tableIndex |= 0x80;
                            }
                            byte code = skeletonTable[tableIndex];
                            if (pass == 1) {
                                if (code == 2 || code == 3) {
                                    pixel = this.colormap != null ? this.colormap.getColor((float)i2 / (float)this.iterations) : this.newColor;
                                    ++count;
                                }
                            } else if (code == 1 || code == 3) {
                                pixel = this.colormap != null ? this.colormap.getColor((float)i2 / (float)this.iterations) : this.newColor;
                                ++count;
                            }
                        }
                        outPixels[offset++] = pixel;
                    }
                }
                if (pass != 0) continue;
                inPixels = outPixels;
                outPixels = new int[width * height];
            }
            if (count == 0) break;
        }
        return outPixels;
    }

    public String toString() {
        return "Binary/Skeletonize...";
    }
}

