/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.Point;
import java.awt.Rectangle;

public class RotateFilter
extends TransformFilter {
    static final long serialVersionUID = 1166374736665848180L;
    private float angle;
    private float cos;
    private float sin;
    private boolean resize = true;

    public RotateFilter() {
        this((float)Math.PI);
    }

    public RotateFilter(float angle) {
        this(angle, true);
    }

    public RotateFilter(float angle, boolean resize) {
        this.setAngle(angle);
        this.resize = resize;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.cos = (float)Math.cos(this.angle);
        this.sin = (float)Math.sin(this.angle);
    }

    public float getAngle() {
        return this.angle;
    }

    protected void transformSpace(Rectangle rect) {
        if (this.resize) {
            Point out = new Point(0, 0);
            int minx = Integer.MAX_VALUE;
            int miny = Integer.MAX_VALUE;
            int maxx = Integer.MIN_VALUE;
            int maxy = Integer.MIN_VALUE;
            int w2 = rect.width;
            int h2 = rect.height;
            int x2 = rect.x;
            int y2 = rect.y;
            for (int i2 = 0; i2 < 4; ++i2) {
                switch (i2) {
                    case 0: {
                        this.transform(x2, y2, out);
                        break;
                    }
                    case 1: {
                        this.transform(x2 + w2, y2, out);
                        break;
                    }
                    case 2: {
                        this.transform(x2, y2 + h2, out);
                        break;
                    }
                    case 3: {
                        this.transform(x2 + w2, y2 + h2, out);
                    }
                }
                minx = Math.min(minx, out.x);
                miny = Math.min(miny, out.y);
                maxx = Math.max(maxx, out.x);
                maxy = Math.max(maxy, out.y);
            }
            rect.x = minx;
            rect.y = miny;
            rect.width = maxx - rect.x;
            rect.height = maxy - rect.y;
        }
    }

    protected void transform(int x2, int y2, Point out) {
        out.x = (int)((float)x2 * this.cos + (float)y2 * this.sin);
        out.y = (int)((float)y2 * this.cos - (float)x2 * this.sin);
    }

    protected void transformInverse(int x2, int y2, float[] out) {
        out[0] = (float)x2 * this.cos - (float)y2 * this.sin;
        out[1] = (float)y2 * this.cos + (float)x2 * this.sin;
    }

    public String toString() {
        return "Rotate " + (int)((double)(this.angle * 180.0f) / Math.PI);
    }
}

