/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class OilFilter
extends WholeImageFilter {
    static final long serialVersionUID = 1722613531684653826L;
    private int range = 3;
    private int levels = 256;

    public void setRange(int range) {
        this.range = range;
    }

    public int getRange() {
        return this.range;
    }

    public void setLevels(int levels) {
        this.levels = levels;
    }

    public int getLevels() {
        return this.levels;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int index = 0;
        int[] rHistogram = new int[this.levels];
        int[] gHistogram = new int[this.levels];
        int[] bHistogram = new int[this.levels];
        int[] rTotal = new int[this.levels];
        int[] gTotal = new int[this.levels];
        int[] bTotal = new int[this.levels];
        int[] outPixels = new int[width * height];
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                for (int i2 = 0; i2 < this.levels; ++i2) {
                    bTotal[i2] = 0;
                    gTotal[i2] = 0;
                    rTotal[i2] = 0;
                    bHistogram[i2] = 0;
                    gHistogram[i2] = 0;
                    rHistogram[i2] = 0;
                }
                for (int row = -this.range; row <= this.range; ++row) {
                    int iy = y2 + row;
                    if (0 > iy || iy >= height) continue;
                    int ioffset = iy * width;
                    for (int col = -this.range; col <= this.range; ++col) {
                        int ix = x2 + col;
                        if (0 > ix || ix >= width) continue;
                        int rgb = inPixels[ioffset + ix];
                        int r2 = rgb >> 16 & 0xFF;
                        int g2 = rgb >> 8 & 0xFF;
                        int b2 = rgb & 0xFF;
                        int ri = r2 * this.levels / 256;
                        int gi = g2 * this.levels / 256;
                        int bi = b2 * this.levels / 256;
                        int n2 = ri;
                        rTotal[n2] = rTotal[n2] + r2;
                        int n3 = gi;
                        gTotal[n3] = gTotal[n3] + g2;
                        int n4 = bi;
                        bTotal[n4] = bTotal[n4] + b2;
                        int n5 = ri;
                        rHistogram[n5] = rHistogram[n5] + 1;
                        int n6 = gi;
                        gHistogram[n6] = gHistogram[n6] + 1;
                        int n7 = bi;
                        bHistogram[n7] = bHistogram[n7] + 1;
                    }
                }
                int r3 = 0;
                int g3 = 0;
                int b3 = 0;
                for (int i3 = 1; i3 < this.levels; ++i3) {
                    if (rHistogram[i3] > rHistogram[r3]) {
                        r3 = i3;
                    }
                    if (gHistogram[i3] > gHistogram[g3]) {
                        g3 = i3;
                    }
                    if (bHistogram[i3] <= bHistogram[b3]) continue;
                    b3 = i3;
                }
                r3 = rTotal[r3] / rHistogram[r3];
                g3 = gTotal[g3] / gHistogram[g3];
                b3 = bTotal[b3] / bHistogram[b3];
                outPixels[index++] = 0xFF000000 | r3 << 16 | g3 << 8 | b3;
            }
        }
        return outPixels;
    }

    public String toString() {
        return "Stylize/Oil...";
    }
}

