/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Quantizer;
import java.io.PrintStream;
import java.util.Vector;

public class OctTreeQuantizer
implements Quantizer {
    static final int MAX_LEVEL = 5;
    private int nodes = 0;
    private OctTreeNode root;
    private int reduceColors;
    private int maximumColors;
    private int colors = 0;
    private Vector[] colorList;

    public OctTreeQuantizer() {
        this.setup(256);
        this.colorList = new Vector[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            this.colorList[i2] = new Vector();
        }
        this.root = new OctTreeNode();
    }

    public void setup(int numColors) {
        this.maximumColors = numColors;
        this.reduceColors = Math.max(512, numColors * 2);
    }

    public void addPixels(int[] pixels, int offset, int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            this.insertColor(pixels[i2 + offset]);
            if (this.colors <= this.reduceColors) continue;
            this.reduceTree(this.reduceColors);
        }
    }

    public int getIndexForColor(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        OctTreeNode node = this.root;
        for (int level = 0; level <= 5; ++level) {
            OctTreeNode child;
            int bit = 128 >> level;
            int index = 0;
            if ((red & bit) != 0) {
                index += 4;
            }
            if ((green & bit) != 0) {
                index += 2;
            }
            if ((blue & bit) != 0) {
                ++index;
            }
            if ((child = node.leaf[index]) == null) {
                return node.index;
            }
            if (child.isLeaf) {
                return child.index;
            }
            node = child;
        }
        System.out.println("getIndexForColor failed");
        return 0;
    }

    private void insertColor(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        OctTreeNode node = this.root;
        for (int level = 0; level <= 5; ++level) {
            OctTreeNode child;
            int bit = 128 >> level;
            int index = 0;
            if ((red & bit) != 0) {
                index += 4;
            }
            if ((green & bit) != 0) {
                index += 2;
            }
            if ((blue & bit) != 0) {
                ++index;
            }
            if ((child = node.leaf[index]) == null) {
                ++node.children;
                child = new OctTreeNode();
                child.parent = node;
                node.leaf[index] = child;
                node.isLeaf = false;
                ++this.nodes;
                this.colorList[level].addElement(child);
                if (level == 5) {
                    child.isLeaf = true;
                    child.count = 1;
                    child.totalRed = red;
                    child.totalGreen = green;
                    child.totalBlue = blue;
                    child.level = level;
                    ++this.colors;
                    return;
                }
                node = child;
                continue;
            }
            if (child.isLeaf) {
                ++child.count;
                child.totalRed += red;
                child.totalGreen += green;
                child.totalBlue += blue;
                return;
            }
            node = child;
        }
        System.out.println("insertColor failed");
    }

    private void reduceTree(int numColors) {
        for (int level = 4; level >= 0; --level) {
            Vector v2 = this.colorList[level];
            if (v2 == null || v2.size() <= 0) continue;
            for (int j2 = 0; j2 < v2.size(); ++j2) {
                OctTreeNode node = (OctTreeNode)v2.elementAt(j2);
                if (node.children <= 0) continue;
                for (int i2 = 0; i2 < 8; ++i2) {
                    OctTreeNode child = node.leaf[i2];
                    if (child == null) continue;
                    if (!child.isLeaf) {
                        System.out.println("not a leaf!");
                    }
                    node.count += child.count;
                    node.totalRed += child.totalRed;
                    node.totalGreen += child.totalGreen;
                    node.totalBlue += child.totalBlue;
                    node.leaf[i2] = null;
                    --node.children;
                    --this.colors;
                    --this.nodes;
                    this.colorList[level + 1].removeElement(child);
                }
                node.isLeaf = true;
                ++this.colors;
                if (this.colors > numColors) continue;
                return;
            }
        }
        System.out.println("Unable to reduce the OctTree");
    }

    public int[] buildColorTable() {
        int[] table = new int[this.colors];
        this.buildColorTable(this.root, table, 0);
        return table;
    }

    public void buildColorTable(int[] inPixels, int[] table) {
        int count = inPixels.length;
        this.maximumColors = table.length;
        for (int i2 = 0; i2 < count; ++i2) {
            this.insertColor(inPixels[i2]);
            if (this.colors <= this.reduceColors) continue;
            this.reduceTree(this.reduceColors);
        }
        if (this.colors > this.maximumColors) {
            this.reduceTree(this.maximumColors);
        }
        this.buildColorTable(this.root, table, 0);
    }

    private int buildColorTable(OctTreeNode node, int[] table, int index) {
        if (this.colors > this.maximumColors) {
            this.reduceTree(this.maximumColors);
        }
        if (node.isLeaf) {
            int count = node.count;
            table[index] = 0xFF000000 | node.totalRed / count << 16 | node.totalGreen / count << 8 | node.totalBlue / count;
            node.index = index++;
        } else {
            for (int i2 = 0; i2 < 8; ++i2) {
                if (node.leaf[i2] == null) continue;
                node.index = index;
                index = this.buildColorTable(node.leaf[i2], table, index);
            }
        }
        return index;
    }

    class OctTreeNode {
        int children;
        int level;
        OctTreeNode parent;
        OctTreeNode[] leaf = new OctTreeNode[8];
        boolean isLeaf;
        int count;
        int totalRed;
        int totalGreen;
        int totalBlue;
        int index;

        OctTreeNode() {
        }

        public void list(PrintStream s2, int level) {
            int i2;
            for (i2 = 0; i2 < level; ++i2) {
                System.out.print(' ');
            }
            if (this.count == 0) {
                System.out.println(this.index + ": count=" + this.count);
            } else {
                System.out.println(this.index + ": count=" + this.count + " red=" + this.totalRed / this.count + " green=" + this.totalGreen / this.count + " blue=" + this.totalBlue / this.count);
            }
            for (i2 = 0; i2 < 8; ++i2) {
                if (this.leaf[i2] == null) continue;
                this.leaf[i2].list(s2, level + 2);
            }
        }
    }
}

