/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LoggingFormatter
extends Formatter {
    @Override
    public synchronized String format(LogRecord record) {
        StringBuilder sb2 = new StringBuilder();
        if (record.getSourceClassName() != null) {
            sb2.append(record.getSourceClassName().substring(record.getSourceClassName().lastIndexOf(46) + 1));
        } else {
            sb2.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb2.append(".");
            sb2.append(record.getSourceMethodName());
        }
        sb2.append(" ");
        String message = this.formatMessage(record);
        sb2.append(record.getLevel().getLocalizedName());
        sb2.append(": ");
        sb2.append(message);
        sb2.append(System.getProperty("line.separator"));
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            sb2.append(sw.toString());
        }
        return sb2.toString();
    }
}

