/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import com.dlsc.flexgantt.model.gantt.RelationshipType;
import com.dlsc.flexgantt.swing.util.PathCalculator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import javax.swing.JPanel;

class MyPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final Dimension dim = new Dimension(60, 20);
    private RelationshipType relationshipType = RelationshipType.END_TO_START;
    private PathCalculator calculator = new PathCalculator();
    private Rectangle sourceRect;
    private Rectangle targetRect;
    private Rectangle draggedRect;
    private Point dragLocation;
    private boolean drawArrowHead = true;

    public MyPanel() {
        this.setBackground(Color.WHITE);
        this.sourceRect = new Rectangle(50, 50, MyPanel.dim.width, MyPanel.dim.height);
        this.targetRect = new Rectangle(350, 250, MyPanel.dim.width, MyPanel.dim.height);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setDrawArrowHead(boolean drawArrowHead) {
        this.drawArrowHead = drawArrowHead;
        this.repaint();
    }

    public void setPathCalculator(PathCalculator c2) {
        this.calculator = c2;
        this.repaint();
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.RED);
        g2d.fillRect(this.sourceRect.x, this.sourceRect.y, this.sourceRect.width, this.sourceRect.height);
        g2d.setColor(Color.BLUE);
        g2d.fillRect(this.targetRect.x, this.targetRect.y, this.targetRect.width, this.targetRect.height);
        GeneralPath path = null;
        switch (this.relationshipType) {
            case END_TO_START: {
                path = this.calculator.calculatePathEndToStart(this.sourceRect, this.targetRect);
                break;
            }
            case START_TO_END: {
                path = this.calculator.calculatePathStartToEnd(this.sourceRect, this.targetRect);
                break;
            }
            case START_TO_START: {
                path = this.calculator.calculatePathStartToStart(this.sourceRect, this.targetRect);
                break;
            }
            case END_TO_END: {
                path = this.calculator.calculatePathEndToEnd(this.sourceRect, this.targetRect);
            }
        }
        g2d.setColor(Color.GRAY);
        g2d.draw(path);
        if (this.drawArrowHead) {
            int x2 = (int)path.getCurrentPoint().getX();
            int y2 = (int)path.getCurrentPoint().getY();
            switch (this.calculator.getArrowDirection()) {
                case RIGHT: {
                    for (int i2 = 0; i2 < 5; ++i2) {
                        g2d.drawLine(x2 - i2, y2 - i2, x2 - i2, y2 + i2);
                    }
                    break;
                }
                case LEFT: {
                    for (int i3 = 0; i3 < 5; ++i3) {
                        g2d.drawLine(x2 + i3, y2 - i3, x2 + i3, y2 + i3);
                    }
                    break;
                }
            }
        }
        PathCalculator.TargetLocation location = this.calculator.getTargetLocation();
        g2d.drawString(location.toString(), 20, 20);
        g2d.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (this.sourceRect.contains(e2.getPoint())) {
            this.draggedRect = this.sourceRect;
        } else if (this.targetRect.contains(e2.getPoint())) {
            this.draggedRect = this.targetRect;
        }
        this.dragLocation = e2.getPoint();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.draggedRect = null;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (this.draggedRect != null) {
            Point p2 = e2.getPoint();
            this.draggedRect.translate(p2.x - this.dragLocation.x, p2.y - this.dragLocation.y);
            this.dragLocation = p2;
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }
}

