/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.TooManyListenersException;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class MultiDropTarget
extends DropTarget {
    private static final Logger LOGGER = Logger.getLogger(MultiDropTarget.class.getName());
    private EventListenerList listenerList = new EventListenerList();

    public MultiDropTarget(Component c2, int ops, DropTargetListener dtl) {
        super(c2, ops, dtl);
        try {
            super.addDropTargetListener(dtl);
        }
        catch (TooManyListenersException ex) {
            LOGGER.throwing(MultiDropTarget.class.getName(), "<init>", ex);
        }
    }

    @Override
    public void addDropTargetListener(DropTargetListener dtl) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DropTargetListener.class, dtl);
    }

    @Override
    public void removeDropTargetListener(DropTargetListener dtl) {
        if (this.listenerList != null) {
            this.listenerList.remove(DropTargetListener.class, dtl);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e2) {
        super.dragEnter(e2);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i2 + 1]).dragEnter(e2);
            }
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e2) {
        super.dragOver(e2);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i2 + 1]).dragOver(e2);
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent e2) {
        super.dragExit(e2);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i2 + 1]).dragExit(e2);
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent e2) {
        super.drop(e2);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i2 + 1]).drop(e2);
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e2) {
        super.dropActionChanged(e2);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i2 + 1]).dropActionChanged(e2);
            }
        }
    }
}

