/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.treetable.DefaultColumnModel;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.DefaultComponentFactory;
import com.dlsc.flexgantt.swing.IComponentFactory;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.ITimelineObjectPathMessage;
import com.dlsc.flexgantt.swing.ITreePathMessage;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.print.PrintContext;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableRowHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableScrollPane;
import java.awt.BorderLayout;
import javax.swing.tree.TreePath;

public class TreeTableContainer
extends AbstractGanttChart {
    private TreeTable treeTable;
    private TreeTableScrollPane treeTableScrollPane;
    private TreeTableRowHeader treeTableRowHeader;

    public TreeTableContainer(IGanttChartModel model, IColumnModel columnModel, IComponentFactory compFactory) {
        super(model, columnModel, compFactory);
        TreeTableHeader treeTableHeader = this.getTreeTableHeader();
        IComponentFactory factory = this.getComponentFactory();
        this.treeTable = factory.createTreeTable(this, model);
        this.treeTableRowHeader = new TreeTableRowHeader(this.treeTable);
        this.treeTableScrollPane = new TreeTableScrollPane(this.treeTable, this.treeTableRowHeader, treeTableHeader, true);
        this.treeTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.treeTableScrollPane.setVerticalScrollBarPolicy(20);
        this.setLayout(new BorderLayout());
        this.add("Center", this.treeTableScrollPane);
    }

    public TreeTableContainer(IGanttChartModel model, IColumnModel columnModel) {
        this(model, columnModel, DefaultComponentFactory.getInstance());
    }

    public TreeTableContainer(IGanttChartModel model, IComponentFactory compFactory) {
        this(model, new DefaultColumnModel(), compFactory);
    }

    public TreeTableContainer(IGanttChartModel model) {
        this(model, new DefaultColumnModel());
    }

    public TreeTableContainer(IColumnModel columnModel) {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()));
    }

    public TreeTableContainer(IComponentFactory compFactory) {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()), compFactory);
    }

    public TreeTableContainer() {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()));
    }

    public TreeTable getTreeTable() {
        return this.treeTable;
    }

    public TreeTableRowHeader getRowHeader() {
        return this.treeTableRowHeader;
    }

    public TreeTableScrollPane getTreeTableScrollPane() {
        return this.treeTableScrollPane;
    }

    @Override
    public void showEarliestObjects() {
        throw new UnsupportedOperationException("showing earliest objects is not supported by this class");
    }

    @Override
    public void showLatestObjects() {
        throw new UnsupportedOperationException("showing latest objects is not supported by this class");
    }

    @Override
    public void showAllObjects() {
        throw new UnsupportedOperationException("showing all objects is not supported by this class");
    }

    @Override
    public void showTime(long time, boolean center) {
        throw new UnsupportedOperationException("showing a specific time is not supported by this class");
    }

    @Override
    public void showTimeNow(boolean center) {
        throw new UnsupportedOperationException("showing time now is not supported by this class");
    }

    @Override
    public void print(boolean preview, ITimeSpan span) {
        throw new UnsupportedOperationException("printing is not supported by this class");
    }

    @Override
    public void expandAll() {
        this.treeTable.expandAll();
    }

    @Override
    public void collapseAll() {
        this.treeTable.collapseAll();
    }

    @Override
    public void showMessageContext(IMessage msg) {
        ITreePathMessage pm;
        TreePath treePath;
        if (msg instanceof ITimelineObjectPathMessage) {
            ITimelineObjectPathMessage pm2 = (ITimelineObjectPathMessage)msg;
            TimelineObjectPath path = pm2.getTimelineObjectPath();
            if (this.treeTable.containsPath(path)) {
                this.treeTable.expandPath(path);
                this.treeTable.scrollTo(path);
            }
        } else if (msg instanceof ITreePathMessage && this.treeTable.containsPath(treePath = (pm = (ITreePathMessage)msg).getTreePath())) {
            this.treeTable.expandPath(treePath);
            this.treeTable.scrollTo(treePath);
        }
    }

    @Override
    public void resetToPreferredSizes() {
        throw new UnsupportedOperationException("resetting to preferred sizes is not supported by this class");
    }

    @Override
    public void alignEndTimes() {
        throw new UnsupportedOperationException("aligning end times is not supported by this class");
    }

    @Override
    public void alignStartTimes() {
        throw new UnsupportedOperationException("aligning start times is not supported by this class");
    }

    @Override
    public PrintContext[] getPrintContexts() {
        return null;
    }

    @Override
    public LayerContainerScrollPane[] getLayerContainerScrollPanes() {
        throw new UnsupportedOperationException("this gantt chart does not have layer container scrollpanes");
    }

    @Override
    public TreeTableScrollPane[] getTreeTableScrollPanes() {
        return new TreeTableScrollPane[]{this.treeTableScrollPane};
    }

    @Override
    public IGridComponent[] getGridComponents() {
        return new IGridComponent[0];
    }

    @Override
    public LayerContainer[] getLayerContainers() {
        return new LayerContainer[0];
    }

    @Override
    public TreeTable[] getTreeTables() {
        return new TreeTable[]{this.treeTable};
    }
}

