/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.command.CommandStackEvent;
import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.ICommandStack;
import com.dlsc.flexgantt.command.ICommandStackListener;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.treetable.ColumnModelEvent;
import com.dlsc.flexgantt.model.treetable.ColumnModelIterator;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.model.treetable.IColumnModelListener;
import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.model.treetable.ITreeTableModelListener;
import com.dlsc.flexgantt.model.treetable.KeyColumn;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.model.treetable.TreeTableModelEvent;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.PolicyProvider;
import com.dlsc.flexgantt.policy.layer.IPopupPolicy;
import com.dlsc.flexgantt.policy.treetable.DefaultNodeDragAndDropPolicy;
import com.dlsc.flexgantt.policy.treetable.DefaultNodeEditPolicy;
import com.dlsc.flexgantt.policy.treetable.DefaultRowPolicy;
import com.dlsc.flexgantt.policy.treetable.INodeDragAndDropPolicy;
import com.dlsc.flexgantt.policy.treetable.INodeEditPolicy;
import com.dlsc.flexgantt.policy.treetable.IRowPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.DefaultTreeTableCellEditor;
import com.dlsc.flexgantt.swing.IEditable;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.SpreadsheetLayer;
import com.dlsc.flexgantt.swing.treetable.CellFocusManager;
import com.dlsc.flexgantt.swing.treetable.DefaultTreeTableCellRenderer;
import com.dlsc.flexgantt.swing.treetable.DefaultTreeTableMenuProvider;
import com.dlsc.flexgantt.swing.treetable.DefaultTreeTableSelectionModel;
import com.dlsc.flexgantt.swing.treetable.INodeFilter;
import com.dlsc.flexgantt.swing.treetable.ITreeTableCellEditor;
import com.dlsc.flexgantt.swing.treetable.ITreeTableCellRenderer;
import com.dlsc.flexgantt.swing.treetable.ITreeTableMenuProvider;
import com.dlsc.flexgantt.swing.treetable.ITreeTableSelectionModel;
import com.dlsc.flexgantt.swing.treetable.NodeAnimationController;
import com.dlsc.flexgantt.swing.treetable.TreeTableDragAndDropManager;
import com.dlsc.flexgantt.swing.treetable.TreeTableHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import com.dlsc.flexgantt.swing.treetable.TreeTableRowHeader;
import com.dlsc.flexgantt.swing.util.AutoscrollSupport;
import com.dlsc.flexgantt.swing.util.ColorField;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.swing.util.GraphicsUtilities;
import com.dlsc.flexgantt.swing.util.TableUtils;
import com.dlsc.flexgantt.util.INamedObject;
import com.dlsc.flexgantt.util.Messages;
import java.applet.Applet;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragSource;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.CellRendererPane;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTargetAdapter;

public class TreeTable
extends JPanel
implements PropertyChangeListener,
TreeSelectionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
TreeWillExpandListener,
TreeExpansionListener,
ITreeTableModelListener,
RowMapper,
CellEditorListener,
IColumnModelListener,
Autoscroll,
IEditable {
    private static final Logger LOGGER = Logger.getLogger(TreeTable.class.getName());
    private static final int DEFAULT_INSET = 16;
    private static final int DEFAULT_ROW_HEIGHT = 20;
    public static final String PROPERTY_MODEL = "treeTableModel";
    public static final String PROPERTY_SELECTION_MODEL = "treeTableSelectionModel";
    public static final String PROPERTY_ROOT_VISIBLE = "rootVisible";
    public static final String PROPERTY_HORIZONTAL_LINES_VISIBLE = "horizontalLinesVisible";
    public static final String PROPERTY_VERTICAL_LINES_VISIBLE = "verticalLinesVisible";
    public static final String PROPERTY_ALT_FOREGROUND_COLOR = "alternatingForegroundColor";
    public static final String PROPERTY_ALT_BACKGROUND_COLOR = "alternatingBackgroundColor";
    public static final String PROPERTY_ROW_NUMBERS_VISIBLE = "rowNumbersVisible";
    public static final String PROPERTY_SELECTION_BACKGROUND_COLOR = "selectionBackgroundColor";
    public static final String PROPERTY_SELECTION_FOREGROUND_COLOR = "selectionForegroundColor";
    public static final String PROPERTY_VERTICAL_GRID_COLOR = "verticalGridColor";
    public static final String PROPERTY_HORIZONTAL_GRID_COLOR = "horizontalGridColor";
    public static final String PROPERTY_INDENT_ENABLED = "indentEnabled";
    public static final String PROPERTY_DRAGGING_ENABLED = "draggingEnabled";
    public static final String PROPERTY_DROPPING_ENABLED = "droppingEnabled";
    public static final String PROPERTY_RESIZING_ENABLED = "resizingEnabled";
    public static final String PROPERTY_CREATION_ENABLED = "creationEnabled";
    public static final String PROPERTY_DELETION_ENABLED = "deletionEnabled";
    public static final String PROPERTY_EDITING_ENABLED = "editingEnabled";
    public static final String PROPERTY_POLICY_PROVIDER = "policyProvider";
    public static final String PROPERTY_DEFAULT_ROW_HEIGHT = "defaultRowHeight";
    public static Cursor INDENT_CURSOR = Cursor.getPredefinedCursor(11);
    private List<TreeTableNode> nodes;
    private Map<TreePath, TreeTableNode> modelMap;
    private Map<Object, TreeTableNode> nodeCache = new HashMap<Object, TreeTableNode>();
    private int totalHeight;
    private boolean resizingEnabled = true;
    private boolean indentEnabled = true;
    private boolean draggingAllowed = true;
    private boolean droppingAllowed = true;
    private boolean verticalLinesVisible = true;
    private boolean horizontalLinesVisible = true;
    private boolean rootVisible = true;
    private boolean rowNumbersVisible = true;
    private Color selectionBackground = ColorUtil.getSelectionBackground();
    private Color selectionForeground = ColorUtil.getSelectionForeground();
    private Color alternatingForeground;
    private Color alternatingBackground;
    private Color verticalGridColor = ColorUtil.getGridColor();
    private Color horizontalGridColor = ColorUtil.getGridColor();
    private int inset = 16;
    private AbstractGanttChart ganttChart;
    private RootNode root;
    private TreeTableHeader treeTableHeader;
    private ITreeTableModel model;
    private CellRendererPane rendererPane = new CellRendererPane();
    private ITreeTableSelectionModel selectionModel;
    private ITreeTableCellEditor cellEditor;
    private CellEditorRemover editorRemover;
    private Component editorComp;
    private int editingRow = -1;
    private int editingColumn = -1;
    private LayerContainer lc;
    private boolean creationEnabled = false;
    private boolean deletionEnabled = true;
    private boolean editingEnabled = true;
    private IPolicyProvider policyProvider = new PolicyProvider();
    private CellFocusManager cellFocusManager;
    private int defaultRowHeight = 20;
    private IColumnModel columnModel;
    private Image texture;
    private TexturePaint texturePaint;
    private float alpha = 1.0f;
    private ITreeTableMenuProvider menuProvider = new DefaultTreeTableMenuProvider();
    private JPopupMenu popup;
    private TreeTableRowHeader treeTableRowHeader;
    private Map<Class, ITreeTableCellRenderer> rendererMap;
    private Map<Class, ITreeTableCellEditor> editorMap;
    private Map<Class, ITreeTableCellRenderer> rendererCache;
    private TreeTableDragAndDropManager dndManager;
    private AutoscrollSupport autoscroll;
    private Set<Integer> dropRows = new HashSet<Integer>();
    private float dropNodeVisibility = 1.0f;
    private Color dropColorValid = Color.GREEN.darker();
    private Color dropColorInvalid = Color.RED;
    private Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
    private KeyListener escapeListener;
    private int indentationLineOrigin = -1;
    private int indentationLineLocation = -1;
    private EventObject editingEvent;
    private NodeAnimationController animationController = new NodeAnimationController();
    private double animationPercentage;
    private AbstractNodeTimingTarget nodeTimingTarget;
    private Animator anim;
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private INodeFilter nodeFilter;

    public TreeTable(AbstractGanttChart ganttChart, ITreeTableModel model) {
        super(true);
        this.setName("TreeTable");
        this.ganttChart = ganttChart;
        this.treeTableHeader = ganttChart.getTreeTableHeader();
        this.cellFocusManager = new CellFocusManager(this);
        this.rendererCache = new HashMap<Class, ITreeTableCellRenderer>();
        this.dndManager = this.createDragAndDropManager();
        this.autoscroll = new AutoscrollSupport(this);
        this.policyProvider.setPolicy(INodeDragAndDropPolicy.class, new DefaultNodeDragAndDropPolicy());
        this.policyProvider.setPolicy(INodeEditPolicy.class, new DefaultNodeEditPolicy());
        this.policyProvider.setPolicy(IRowPolicy.class, new DefaultRowPolicy());
        this.rendererMap = new HashMap<Class, ITreeTableCellRenderer>(10);
        this.editorMap = new HashMap<Class, ITreeTableCellEditor>(10);
        this.rendererCache = new HashMap<Class, ITreeTableCellRenderer>(10);
        this.add(this.rendererPane);
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.setLayout(null);
        this.setDoubleBuffered(true);
        this.setModel(model);
        this.setSelectionModel(new DefaultTreeTableSelectionModel());
        this.setColumnModel(ganttChart.getColumnModel());
        this.setFocusable(false);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.ganttChart = ganttChart;
        this.ganttChart.addPropertyChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addTreeWillExpandListener(this);
        this.addTreeExpansionListener(this);
        this.addPropertyChangeListener(this);
        this.setCellRenderer(Object.class, new DefaultTreeTableCellRenderer());
        this.setCellRenderer(Boolean.class, new BooleanRenderer());
        this.setCellRenderer(Date.class, new DateRenderer());
        this.setCellRenderer(Calendar.class, new CalendarRenderer());
        this.setCellRenderer(Number.class, new NumberRenderer());
        this.setCellRenderer(Double.class, new DoubleRenderer());
        this.setCellRenderer(ImageIcon.class, new IconRenderer());
        this.setCellRenderer(Color.class, new ColorRenderer());
        this.setCellRenderer(Enum.class, new EnumRenderer());
        this.setCellEditor(Object.class, new GenericEditor());
        this.setCellEditor(Boolean.class, new BooleanEditor());
        this.setCellEditor(Number.class, new NumberEditor());
        this.setCellEditor(Color.class, new ColorEditor());
        this.setCellEditor(Enum.class, new EnumEditor());
        this.setForeground(UIManager.getColor("Tree.foreground"));
        this.setBackground(UIManager.getColor("Tree.background"));
        this.escapeListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                ITreeTableCellEditor editor;
                if (e2.getKeyCode() == 27 && (editor = TreeTable.this.getCellEditor()) != null) {
                    editor.cancelCellEditing();
                }
            }
        };
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeNotify();
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }

    public ITreeTableModel getModel() {
        return this.model;
    }

    public ITreeTableSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ITreeTableSelectionModel model) {
        if (model == null) {
            throw new IllegalArgumentException("selection model can not be NULL");
        }
        ITreeTableSelectionModel oldModel = this.selectionModel;
        if (oldModel != null) {
            oldModel.removeTreeSelectionListener(this);
            oldModel.setRowMapper(null);
        }
        this.selectionModel = model;
        this.selectionModel.addTreeSelectionListener(this);
        this.selectionModel.setRowMapper(this);
        this.firePropertyChange(PROPERTY_SELECTION_MODEL, oldModel, this.selectionModel);
    }

    public void setModel(ITreeTableModel model) {
        if (model == null) {
            throw new IllegalArgumentException("tree table model can not be NULL");
        }
        ITreeTableModel oldModel = this.model;
        if (oldModel != null) {
            oldModel.removeTreeTableModelListener(this);
        }
        this.model = model;
        model.addTreeTableModelListener(this);
        this.root = new RootNode(this, model.getRoot());
        this.root.expand();
        this.updateNodes();
        this.firePropertyChange(PROPERTY_MODEL, oldModel, model);
    }

    public void setColumnModel(IColumnModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (model != this.columnModel) {
            int i2;
            int count;
            TreeTableColumn column = null;
            if (this.columnModel != null) {
                this.columnModel.removeColumnModelListener(this);
                column = this.columnModel.getKeyColumn();
                if (column != null) {
                    column.removePropertyChangeListener(this);
                }
                count = this.columnModel.getColumnCount();
                for (i2 = 0; i2 < count; ++i2) {
                    column = this.columnModel.getColumn(i2);
                    column.removePropertyChangeListener(this);
                }
            }
            this.columnModel = model;
            this.columnModel.addColumnModelListener(this);
            column = this.columnModel.getKeyColumn();
            if (column != null) {
                column.addPropertyChangeListener(this);
            }
            count = this.columnModel.getColumnCount();
            for (i2 = 0; i2 < count; ++i2) {
                column = this.columnModel.getColumn(i2);
                column.addPropertyChangeListener(this);
            }
        }
    }

    public IColumnModel getColumnModel() {
        return this.columnModel;
    }

    public KeyColumn getKeyColumn() {
        return this.ganttChart.getKeyColumn();
    }

    public TreeTableColumn getColumn(int index) {
        return this.treeTableHeader.getColumn(index);
    }

    public int getColumnIndex(TreeTableColumn col) {
        return this.getColumnModel().getColumnIndex(col);
    }

    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    public int getKeyColumnPosition() {
        return this.ganttChart.getKeyColumnPosition();
    }

    public void setLayerContainer(LayerContainer lc2) {
        if (lc2 == null) {
            throw new IllegalArgumentException("layer container can not be NULL");
        }
        this.lc = lc2;
        this.lc.addMouseWheelListener(this);
    }

    public LayerContainer getLayerContainer() {
        return this.lc;
    }

    public ITreeTableCellEditor getCellEditor(int row, int column) {
        TreeTableColumn ttc = this.getKeyColumn();
        if (column > -1) {
            ttc = this.getColumn(column);
        }
        if (ttc == null) {
            throw new IllegalArgumentException("no column found at position " + column);
        }
        int modelIndex = ttc.getModelIndex();
        Object node = this.nodes.get(row).getModelNode();
        Object value = this.model.getColumnValue(node, modelIndex);
        Class<?> cl = ttc.getColumnClass();
        if (value != null) {
            cl = value.getClass();
        }
        return this.getCellEditor(cl);
    }

    public void setCreationEnabled(boolean enabled) {
        boolean oldValue = this.creationEnabled;
        this.creationEnabled = enabled;
        this.root.load();
        this.updateNodes();
        this.firePropertyChange(PROPERTY_CREATION_ENABLED, oldValue, enabled);
    }

    public boolean isCreationEnabled() {
        if (this.creationEnabled) {
            INodeEditPolicy tep = this.policyProvider.getPolicy(INodeEditPolicy.class);
            return tep.isCreateEnabled(this.model);
        }
        return false;
    }

    public void setDeletionEnabled(boolean enabled) {
        boolean oldValue = this.deletionEnabled;
        this.deletionEnabled = enabled;
        this.firePropertyChange(PROPERTY_DELETION_ENABLED, oldValue, enabled);
    }

    public boolean isDeletionEnabled() {
        return this.deletionEnabled;
    }

    public void setEditingEnabled(boolean enabled) {
        boolean oldValue = this.editingEnabled;
        this.editingEnabled = enabled;
        this.firePropertyChange(PROPERTY_EDITING_ENABLED, oldValue, enabled);
    }

    public boolean isEditingEnabled() {
        return this.editingEnabled;
    }

    public boolean isCellEditable(int row, int column) {
        if (!(this.editingEnabled || this.creationEnabled && row == this.nodes.size() - 1)) {
            return false;
        }
        TreeTableColumn ttc = this.getKeyColumn();
        if (column != -1) {
            ttc = this.treeTableHeader.getColumn(column);
        }
        if (ttc == null) {
            throw new IllegalArgumentException("no column exists for index " + column);
        }
        if (this.nodes.get(row) instanceof NewEntryNode && column != -1) {
            return false;
        }
        INodeEditPolicy ep = this.policyProvider.getPolicy(INodeEditPolicy.class);
        if (ttc instanceof KeyColumn) {
            return ep.isKeyEditable(this.nodes.get(row).getModelNode(), this.model);
        }
        int modelIndex = ttc.getModelIndex();
        return ep.isValueEditable(this.nodes.get(row).getModelNode(), this.model, modelIndex);
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public void setEditingColumn(int col) {
        this.editingColumn = col;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public void setEditingRow(int row) {
        this.editingRow = row;
    }

    public Rectangle getCellRect(int row, int column) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getting cell rect for row = " + row + " column = " + column);
        }
        Rectangle colBounds = this.treeTableHeader.getColumnBounds(column);
        boolean isCreateCell = false;
        int r2 = row;
        if (row >= this.nodes.size()) {
            isCreateCell = true;
            r2 = this.nodes.size() - 1;
        }
        int y2 = this.nodes.get(r2).getY();
        int x2 = colBounds.x;
        int width = colBounds.width;
        int height = this.nodes.get(row).getHeight();
        if (isCreateCell) {
            y2 += height;
            height = this.defaultRowHeight;
        }
        Rectangle cellRect = new Rectangle(x2, y2, width - 1, height - 1);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("cell rect = " + cellRect);
        }
        return cellRect;
    }

    public boolean editCellAt(int row, int column) {
        return this.editCellAt(row, column, null);
    }

    public int getFocusedRow() {
        return this.cellFocusManager.getFocusedRow();
    }

    public int getFocusedColumn() {
        return this.cellFocusManager.getFocusedColumnIndex();
    }

    @Override
    public boolean editCellFocused(InputEvent evt) {
        int row = this.getFocusedRow();
        int col = this.getFocusedColumn();
        return this.editCellAt(row, col, evt);
    }

    public boolean editCellAt(int row, int column, EventObject e2) {
        ITreeTableCellEditor editor;
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (row == -1 || column < -1 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        if ((editor = this.getCellEditor(row, column)) != null && editor.isCellEditable(e2)) {
            this.editingEvent = e2;
            this.cellFocusManager.focusOnCell(row, column);
            this.editorComp = this.prepareEditor(editor, row, column, e2);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellRect(row, column));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.setCellEditor(editor);
            this.setEditingRow(row);
            this.setEditingColumn(column);
            editor.addCellEditorListener(this);
            this.editorComp.requestFocusInWindow();
            return true;
        }
        return false;
    }

    private void reshapeEditorComponent() {
        if (this.isEditing() && this.editorComp != null) {
            this.editorComp.setBounds(this.getCellRect(this.editingRow, this.editingColumn));
        }
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        ITreeTableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.removeCellEditorListener(this);
            if (this.editorComp != null) {
                this.remove(this.editorComp);
                this.editorComp.removeKeyListener(this.escapeListener);
            }
            Rectangle cellRect = this.getCellRect(this.editingRow, this.editingColumn);
            this.setCellEditor(null);
            this.editorComp = null;
            this.repaint(cellRect);
            this.ganttChart.requestFocusInWindow();
        }
    }

    @Override
    public Component getEditorComponent() {
        return this.editorComp;
    }

    @Override
    public boolean isEditing() {
        return this.cellEditor != null;
    }

    public ITreeTableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    private void setCellEditor(ITreeTableCellEditor editor) {
        this.cellEditor = editor;
    }

    private Component prepareEditor(ITreeTableCellEditor editor, int row, int column, EventObject evt) {
        boolean selected;
        Object value = null;
        TreeTableColumn col = this.getColumn(column);
        value = column == -1 ? this.nodes.get(row).getKey() : this.nodes.get(row).getValueAt(col.getModelIndex());
        Component comp = editor.getTreeTableCellEditorComponent(this, value, selected = this.isRowSelected(row), row, column);
        if (comp != null) {
            JComponent jComp;
            comp.setFont(this.getFont());
            if (comp instanceof JComponent && (jComp = (JComponent)comp).getNextFocusableComponent() == null) {
                jComp.setNextFocusableComponent(this.ganttChart);
            }
            comp.addKeyListener(this.escapeListener);
            comp.setBackground(this.getBackground());
            return comp;
        }
        JOptionPane.showMessageDialog(this.ganttChart, "No suitable editor found for table cell.\n   Column type = " + col.getColumnClass() + "\n   value = " + value, "Error", 0);
        return null;
    }

    public TreeTableHeader getTreeTableHeader() {
        return this.treeTableHeader;
    }

    public void updateNodes() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TreeTable.this.updateNodes(false);
                    }
                });
            }
            catch (Exception ex) {
                LOGGER.throwing(this.getClass().getName(), "updateNodes()", ex);
            }
        } else {
            this.updateNodes(false);
        }
    }

    private void updateNodes(boolean expandAll) {
        LOGGER.fine("updating table entries");
        this.nodes = new ArrayList<TreeTableNode>();
        this.modelMap = new HashMap<TreePath, TreeTableNode>();
        if (this.rootVisible) {
            this.nodes.add(this.root);
            this.modelMap.put(this.root.getPath(), this.root);
        }
        this.updateNodes(this.root, 0, expandAll);
        this.totalHeight = 0;
        int row = 0;
        for (TreeTableNode node : this.nodes) {
            node.setRow(row++);
            node.setY(this.totalHeight);
            this.totalHeight += node.getHeight();
        }
        if (this.lc != null) {
            this.lc.revalidate();
            this.lc.repaint();
        }
        this.revalidate();
        this.repaint();
    }

    private void updateNodes(TreeTableNode node, int depth, boolean expandAll) {
        node.setDepth(depth);
        this.modelMap.put(node.getPath(), node);
        if (expandAll) {
            node.expand();
        }
        if (node.isExpanded() || expandAll) {
            TreeTableNode[] children;
            node.load(this.nodeCache);
            for (TreeTableNode element : children = node.getChildren()) {
                boolean ok = true;
                if (this.nodeFilter != null) {
                    ok = this.nodeFilter.includeNode(element.getModelNode());
                }
                if (!ok) continue;
                this.nodes.add(element);
                this.updateNodes(element, depth + 1, expandAll);
            }
        }
    }

    public void setInset(int inset) {
        if (inset <= 0) {
            throw new IllegalArgumentException("inset must be a positive number larger than 0 but was " + inset);
        }
        this.inset = inset;
    }

    public int getInset() {
        return this.inset;
    }

    public void addTreeExpansionListener(TreeExpansionListener l2) {
        this.listenerList.add(TreeExpansionListener.class, l2);
    }

    public void removeTreeExpansionListener(TreeExpansionListener l2) {
        this.listenerList.remove(TreeExpansionListener.class, l2);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener l2) {
        this.listenerList.add(TreeWillExpandListener.class, l2);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener l2) {
        this.listenerList.remove(TreeWillExpandListener.class, l2);
    }

    public void addTreeSelectionListener(TreeSelectionListener l2) {
        this.selectionModel.addTreeSelectionListener(l2);
    }

    public void removeTreeSelectionListener(TreeSelectionListener l2) {
        this.selectionModel.removeTreeSelectionListener(l2);
    }

    protected void fireTreeWillExpand(TreePath path) throws ExpandVetoException {
        Object[] listeners = this.listenerList.getListenerList();
        TreeExpansionEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TreeWillExpandListener.class) continue;
            if (e2 == null) {
                e2 = new TreeExpansionEvent(this, path);
            }
            ((TreeWillExpandListener)listeners[i2 + 1]).treeWillExpand(e2);
        }
    }

    protected void fireTreeWillCollapse(TreePath path) throws ExpandVetoException {
        Object[] listeners = this.listenerList.getListenerList();
        TreeExpansionEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TreeWillExpandListener.class) continue;
            if (e2 == null) {
                e2 = new TreeExpansionEvent(this, path);
            }
            ((TreeWillExpandListener)listeners[i2 + 1]).treeWillCollapse(e2);
        }
    }

    protected void fireTreeExpanded(TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeExpansionEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TreeExpansionListener.class) continue;
            if (e2 == null) {
                e2 = new TreeExpansionEvent(this, path);
            }
            ((TreeExpansionListener)listeners[i2 + 1]).treeExpanded(e2);
        }
    }

    protected void fireTreeCollapsed(TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeExpansionEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TreeExpansionListener.class) continue;
            if (e2 == null) {
                e2 = new TreeExpansionEvent(this, path);
            }
            ((TreeExpansionListener)listeners[i2 + 1]).treeCollapsed(e2);
        }
    }

    private TreePath[] getPaths(List<TreeTableNode> nodes) {
        int l2 = nodes.size();
        if (l2 > 0 && nodes.get(l2 - 1) instanceof NewEntryNode) {
            --l2;
        }
        TreePath[] paths = new TreePath[l2];
        for (int i2 = 0; i2 < l2; ++i2) {
            paths[i2] = nodes.get(i2).getPath();
        }
        return paths;
    }

    public void setResizingEnabled(boolean enabled) {
        boolean oldValue = this.resizingEnabled;
        this.resizingEnabled = enabled;
        this.firePropertyChange(PROPERTY_RESIZING_ENABLED, oldValue, enabled);
    }

    public boolean isResizingEnabled() {
        return this.resizingEnabled;
    }

    public void setDraggingEnabled(boolean enabled) {
        boolean oldValue = this.draggingAllowed;
        this.draggingAllowed = enabled;
        this.firePropertyChange(PROPERTY_DRAGGING_ENABLED, oldValue, enabled);
    }

    public boolean isDraggingEnabled() {
        return this.draggingAllowed;
    }

    public void setDroppingEnabled(boolean enabled) {
        boolean oldValue = this.droppingAllowed;
        this.droppingAllowed = enabled;
        this.firePropertyChange(PROPERTY_DROPPING_ENABLED, oldValue, enabled);
    }

    public boolean isDroppingEnabled() {
        return this.droppingAllowed;
    }

    public void setIndentEnabled(boolean enabled) {
        boolean oldValue = this.indentEnabled;
        this.indentEnabled = enabled;
        this.firePropertyChange(PROPERTY_INDENT_ENABLED, oldValue, enabled);
    }

    public boolean isIndentEnabled() {
        return this.indentEnabled;
    }

    public int getFirstVisibleRow() {
        Rectangle rect = this.getVisibleRect();
        return this.getRowAt(rect.y + 1);
    }

    public int getLastVisibleRow() {
        Rectangle rect = this.getVisibleRect();
        int row = this.getRowAt(rect.y + rect.height) + 1;
        if (row == 0) {
            row = this.nodes.size() - 1;
        }
        return row;
    }

    public int getRowCount() {
        if (this.nodes != null) {
            return this.nodes.size();
        }
        return 0;
    }

    public void selectAll() {
        TreePath[] paths = this.getPaths(this.nodes);
        LinkedList<TreePath> pathList = new LinkedList<TreePath>();
        INodeEditPolicy nep = this.policyProvider.getPolicy(INodeEditPolicy.class);
        for (TreePath tp : paths) {
            if (!nep.isSelectable(tp.getLastPathComponent(), this.model)) continue;
            pathList.add(tp);
        }
        int s2 = pathList.size();
        if (s2 > 0) {
            TreePath[] selectionPaths = new TreePath[s2];
            pathList.toArray(selectionPaths);
            this.setSelectionPaths(selectionPaths);
        }
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public void setSelectionPath(TreePath path) {
        this.selectionModel.setSelectionPath(path);
    }

    public void setSelectionPaths(TreePath[] paths) {
        this.selectionModel.setSelectionPaths(paths);
    }

    public void addSelectionPath(TreePath path) {
        this.selectionModel.addSelectionPath(path);
    }

    public void removeSelectionPath(TreePath path) {
        this.selectionModel.removeSelectionPath(path);
    }

    public void addSelectionPaths(TreePath[] paths) {
        this.selectionModel.addSelectionPaths(paths);
    }

    public void removeSelectionPaths(TreePath[] paths) {
        this.selectionModel.removeSelectionPaths(paths);
    }

    public void addSelectionRow(int row) {
        this.selectionModel.addSelectionPath(this.getTreePath(row));
    }

    public void addSelectionRows(int[] rows) {
        this.selectionModel.addSelectionPaths(this.getTreePaths(rows));
    }

    public void setSelectionRow(int row) {
        this.setSelectionRows(new int[]{row});
    }

    public void setSelectionRows(int[] rows) {
        this.selectionModel.setSelectionPaths(this.getTreePaths(rows));
    }

    public TreePath getSelectionPath() {
        return this.selectionModel.getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.selectionModel.getSelectionPaths();
    }

    public void setSelectionInterval(int start, int end) {
        TreePath[] paths = this.getPathsBetweenRows(start, end);
        this.selectionModel.setSelectionPaths(paths);
    }

    public void addSelectionInterval(int start, int end) {
        TreePath[] paths = this.getPathsBetweenRows(start, end);
        this.selectionModel.addSelectionPaths(paths);
    }

    public void removeSelectionInterval(int start, int end) {
        TreePath[] paths = this.getPathsBetweenRows(start, end);
        this.selectionModel.removeSelectionPaths(paths);
    }

    public boolean isPathSelected(TreePath path) {
        return this.selectionModel.isPathSelected(path);
    }

    public boolean isRowSelected(int row) {
        TreePath path = this.getTreePath(row);
        return this.selectionModel.isPathSelected(path);
    }

    public void setSelectionMode(int mode) {
        this.selectionModel.setSelectionMode(mode);
    }

    public int getSelectionMode() {
        return this.selectionModel.getSelectionMode();
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public TreePath[] getPathsBetweenRows(int start, int end) {
        int s2 = Math.min(start, end);
        int e2 = Math.max(start, end);
        if (s2 >= 0 && e2 <= this.nodes.size() - 1) {
            TreePath[] result = new TreePath[e2 - s2 + 1];
            for (int i2 = s2; i2 <= e2; ++i2) {
                result[i2 - s2] = this.nodes.get(i2).getPath();
            }
            return result;
        }
        throw new IllegalArgumentException("indices must be between 0 and max number of rows minus 1 (" + (this.nodes.size() - 1) + ")");
    }

    public boolean isTreePathExpanded(TreePath path) {
        if (path == null) {
            throw new IllegalArgumentException("tree path can not be NULL");
        }
        TreeTableNode node = this.root;
        int count = path.getPathCount();
        Object data = path.getPathComponent(0);
        if (this.root.getModelNode() != data) {
            return false;
        }
        if (count > 1) {
            for (int i2 = 1; i2 < count; ++i2) {
                Object obj = path.getPathComponent(i2);
                if (!node.isExpanded()) {
                    return false;
                }
                if ((node = node.getChildNode(obj)) != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTreeNodeExpanded(TreePath path) {
        if (path == null) {
            throw new IllegalArgumentException("tree path can not be NULL");
        }
        if (this.isTreePathExpanded(path)) {
            int row = this.getRowForPath(path);
            return this.nodes.get(row).isExpanded();
        }
        return false;
    }

    public TreePath getTreePath(int row) {
        if (row < 0) {
            throw new IllegalArgumentException("row index can not be smaller than zero");
        }
        if (row < this.nodes.size()) {
            return this.nodes.get(row).getPath();
        }
        throw new IllegalArgumentException("row index invalid (must be larger than 0 and smaller than or equal to " + (this.nodes.size() - 1) + " but was " + row + ")");
    }

    public TreePath getTreePathAt(int y2) {
        int row = this.getRowAt(y2);
        if (row != -1) {
            return this.getTreePath(row);
        }
        return null;
    }

    public TreePath[] getTreePaths(int[] rows) {
        if (rows == null) {
            throw new IllegalArgumentException("the array of rows can not be NULL");
        }
        TreePath[] paths = new TreePath[rows.length];
        for (int i2 = 0; i2 < rows.length; ++i2) {
            paths[i2] = this.getTreePath(rows[i2]);
        }
        return paths;
    }

    private List<TreeTableNode> getTreeTableNodes(TreePath[] paths) {
        if (paths == null) {
            throw new IllegalArgumentException("paths can not be NULL");
        }
        int count = paths.length;
        ArrayList<TreeTableNode> ttn = new ArrayList<TreeTableNode>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            ttn.add(this.getTreeTableNode(paths[i2]));
        }
        return ttn;
    }

    private TreeTableNode getTreeTableNode(TreePath path) {
        if (path == null) {
            throw new IllegalArgumentException("path can not be NULL");
        }
        int count = path.getPathCount();
        if (count == 0) {
            throw new IllegalArgumentException("invalid tree path (count == 0)");
        }
        TreeTableNode node = this.root;
        Object data = path.getPathComponent(0);
        if (this.root.getModelNode() != data) {
            throw new IllegalArgumentException("invalid tree path (wrong root object)");
        }
        if (count > 1) {
            for (int i2 = 1; i2 < count; ++i2) {
                Object obj = path.getPathComponent(i2);
                if (!node.isLoaded()) {
                    node.load();
                }
                if ((node = node.getChildNode(obj)) != null) continue;
                throw new IllegalArgumentException("invalid tree path: " + path);
            }
        }
        return node;
    }

    public boolean containsPath(TreePath path) {
        if (path == null) {
            throw new IllegalArgumentException("path can not be NULL");
        }
        int count = path.getPathCount();
        if (count == 0) {
            throw new IllegalArgumentException("invalid tree path (count == 0)");
        }
        TreeTableNode node = this.root;
        Object data = path.getPathComponent(0);
        if (this.root.getModelNode() != data) {
            return false;
        }
        if (count > 1) {
            for (int i2 = 1; i2 < count; ++i2) {
                Object obj = path.getPathComponent(i2);
                if (!node.isLoaded()) {
                    node.load();
                }
                if ((node = node.getChildNode(obj)) != null) continue;
                return false;
            }
        }
        return true;
    }

    public void expandAll() {
        TreePath path = this.root.getPath();
        this.doExpandCollapse(path, true, true, false);
    }

    public void expandPath(TreePath path) {
        this.doExpandCollapse(path, true, false, false);
    }

    public void expandPathAnimated(TreePath path) {
        this.doExpandCollapse(path, true, false, true);
    }

    public void expandRow(int row) {
        this.expandPath(this.getTreePath(row));
    }

    public void expandRowAnimated(int row) {
        this.expandPathAnimated(this.getTreePath(row));
    }

    public void collapseAll() {
        TreePath path = this.root.getPath();
        this.doExpandCollapse(path, false, true, false);
    }

    public void collapsePath(TreePath path) {
        this.doExpandCollapse(path, false, false, false);
    }

    public void collapsePathAnimated(TreePath path) {
        this.doExpandCollapse(path, false, false, true);
    }

    public void collapseRow(int row) {
        this.collapsePath(this.getTreePath(row));
    }

    public void collapseRowAnimated(int row) {
        this.collapsePathAnimated(this.getTreePath(row));
    }

    private void doExpandCollapse(TreePath path, boolean expand, boolean recursive, boolean animate) {
        try {
            if (expand) {
                this.fireTreeWillExpand(path);
                TreeTableNode node = this.getTreeTableNode(path);
                if (recursive) {
                    this.updateNodes(true);
                    this.fireTreeExpanded(path);
                } else {
                    for (TreeTableNode parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
                        parent.expand();
                    }
                    node.expand();
                    if (animate && this.animationController.isNodeAnimated(node)) {
                        if (this.anim == null || !this.anim.isRunning()) {
                            int count = node.getTotalChildrenCount();
                            int duration = this.animationController.getAnimationDuration(count);
                            this.nodeTimingTarget = new ExpandNodeTimingTarget(node);
                            this.anim = new Animator(duration, this.nodeTimingTarget);
                            this.anim.setAcceleration(0.5f);
                            this.anim.setDeceleration(0.5f);
                            this.anim.start();
                        }
                    } else {
                        this.updateNodes();
                        this.fireTreeExpanded(path);
                    }
                }
            } else {
                this.fireTreeWillCollapse(path);
                TreeTableNode node = this.getTreeTableNode(path);
                if (animate && this.animationController.isNodeAnimated(node)) {
                    if (this.anim == null || !this.anim.isRunning()) {
                        int count = node.getTotalChildrenCount();
                        int duration = this.animationController.getAnimationDuration(count);
                        this.nodeTimingTarget = new CollapseNodeTimingTarget(node, recursive);
                        this.anim = new Animator(duration, this.nodeTimingTarget);
                        this.anim.setStartFraction(1.0f);
                        this.anim.setStartDirection(Animator.Direction.BACKWARD);
                        this.anim.setAcceleration(0.5f);
                        this.anim.setDeceleration(0.5f);
                        this.anim.start();
                    }
                } else {
                    if (recursive) {
                        this.doCollapseRecursively(node);
                    }
                    if (this.rootVisible || node != this.root) {
                        node.collapse();
                    }
                    this.updateNodes();
                    this.fireTreeCollapsed(path);
                }
            }
        }
        catch (ExpandVetoException e2) {
            LOGGER.throwing(TreeTable.class.getName(), "doExpandCollapse(TreePath, boolean, boolean)", e2);
        }
    }

    private void doCollapseRecursively(TreeTableNode node) throws ExpandVetoException {
        TreeTableNode[] children = node.getChildren();
        if (children != null) {
            int count = children.length;
            for (int i2 = 0; i2 < count; ++i2) {
                this.doCollapseRecursively(children[i2]);
                this.fireTreeWillCollapse(children[i2].getPath());
                children[i2].collapse();
            }
        }
    }

    public List<TreeTableNode> getTreeTableNodes() {
        return this.nodes;
    }

    public void setGridColor(Color color) {
        this.setHorizontalGridColor(color);
        this.setVerticalGridColor(color);
    }

    public void setVerticalGridColor(Color color) {
        Color oldColor = this.verticalGridColor;
        this.verticalGridColor = color;
        this.firePropertyChange(PROPERTY_VERTICAL_GRID_COLOR, oldColor, this.verticalGridColor);
    }

    public Color getVerticalGridColor() {
        return this.verticalGridColor;
    }

    public void setHorizontalGridColor(Color color) {
        Color oldColor = this.horizontalGridColor;
        this.horizontalGridColor = color;
        this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_COLOR, oldColor, this.horizontalGridColor);
    }

    public Color getHorizontalGridColor() {
        return this.horizontalGridColor;
    }

    public boolean isHorizontalLinesVisible() {
        return this.horizontalLinesVisible;
    }

    public void setHorizontalLinesVisible(boolean visible) {
        boolean oldValue = this.horizontalLinesVisible;
        this.horizontalLinesVisible = visible;
        this.firePropertyChange(PROPERTY_HORIZONTAL_LINES_VISIBLE, oldValue, visible);
    }

    public boolean isRowNumbersVisible() {
        return this.rowNumbersVisible;
    }

    public void setRowNumbersVisible(boolean visible) {
        boolean oldValue = this.rowNumbersVisible;
        this.rowNumbersVisible = visible;
        this.firePropertyChange(PROPERTY_ROW_NUMBERS_VISIBLE, oldValue, visible);
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean visible) {
        boolean oldValue = this.rootVisible;
        this.rootVisible = visible;
        this.firePropertyChange(PROPERTY_ROOT_VISIBLE, oldValue, this.rootVisible);
    }

    public boolean isVerticalLinesVisible() {
        return this.verticalLinesVisible;
    }

    public void setVerticalLinesVisible(boolean visible) {
        boolean oldValue = this.verticalLinesVisible;
        this.verticalLinesVisible = visible;
        this.firePropertyChange(PROPERTY_VERTICAL_LINES_VISIBLE, oldValue, this.verticalLinesVisible);
    }

    public Color getAlternatingForeground() {
        return this.alternatingForeground;
    }

    public void setAlternatingForeground(Color color) {
        Color oldColor = this.alternatingForeground;
        this.alternatingForeground = color;
        this.firePropertyChange(PROPERTY_ALT_FOREGROUND_COLOR, oldColor, color);
    }

    public Color getAlternatingBackground() {
        return this.alternatingBackground;
    }

    public void setAlternatingBackground(Color color) {
        Color oldColor = this.alternatingBackground;
        this.alternatingBackground = color;
        this.firePropertyChange(PROPERTY_ALT_BACKGROUND_COLOR, oldColor, color);
    }

    public void setSelectionBackground(Color color) {
        Color oldColor = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange(PROPERTY_SELECTION_BACKGROUND_COLOR, oldColor, color);
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        Color oldColor = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange(PROPERTY_SELECTION_FOREGROUND_COLOR, oldColor, this.selectionForeground);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.paintBackground(g2);
        this.paintColumns(g2);
        this.paintDragAndDrop(g2);
        if (this.isEditing()) {
            this.reshapeEditorComponent();
        }
        if (this.indentationLineLocation != -1) {
            this.paintIndentationLine(g2, this.indentationLineLocation);
        }
    }

    protected void paintIndentationLine(Graphics g2, int x2) {
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(this.getForeground());
        g2d.drawLine(x2, 0, x2, this.getHeight());
    }

    protected void paintBackground(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2;
        Rectangle clip = g2d.getClipBounds();
        g2.clearRect(clip.x, clip.y, clip.width, clip.height);
        if (this.texturePaint != null) {
            g2d.setPaint(this.texturePaint);
        } else {
            g2d.setPaint(this.getBackground());
        }
        int x1 = clip.x;
        int x2 = clip.x + clip.width;
        int y1 = clip.y;
        int y2 = clip.y + clip.height;
        TreeTableHeader header = this.getTreeTableHeader();
        boolean showFillerColumn = header.isShowingFillerColumn();
        if (!showFillerColumn) {
            x1 = Math.min(x1, header.getPreferredSize().width - 1);
            x2 = Math.min(x2, header.getPreferredSize().width - 1);
        }
        g2d.fillRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        int startRow = Math.max(0, this.getRowAt(clip.y));
        Composite comp = g2d.getComposite();
        if (this.alpha < 1.0f) {
            g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        }
        int row = startRow;
        int fadeCount = 0;
        int y3 = 0;
        int clipLine = 0;
        if (startRow != -1 && this.nodes != null && this.nodes.size() > 0) {
            int i2;
            IRowPolicy rp = this.policyProvider.getPolicy(IRowPolicy.class);
            y3 = this.nodes.get(startRow).getY();
            for (i2 = startRow; i2 < this.nodes.size(); ++i2) {
                Composite innerComp = g2d.getComposite();
                if (this.isRowSelected(i2) && this.animationController.isUsingTransparency() && fadeCount > 0) {
                    g2d.setComposite(AlphaComposite.getInstance(3, (float)((double)this.alpha * this.animationPercentage)));
                }
                --fadeCount;
                TreeTableNode currentNode = this.nodes.get(i2);
                int rowHeight = this.nodes.get(i2).getHeight();
                g2d.clipRect(0, clipLine, this.getWidth(), this.getHeight());
                if (this.alternatingBackground != null && i2 % 2 == 1 || this.isRowSelected(i2)) {
                    g2d.setColor(this.getBackground(i2, true));
                    g2d.fillRect(x1, y3, x2 - x1 + 1, rowHeight);
                }
                g2d.setComposite(innerComp);
                y3 += rowHeight;
                if (this.horizontalLinesVisible && rp.isRowLineVisible(currentNode.getModelNode(), currentNode.isExpanded(), this.model)) {
                    g2d.setColor(this.horizontalGridColor);
                    g2d.drawLine(x1, y3 - 1, x2, y3 - 1);
                }
                g2d.setClip(clip);
                if (y3 >= clip.y + clip.height) break;
                TreeTableNode animationNode = this.getAnimationNode();
                if (currentNode != animationNode) continue;
                fadeCount = animationNode.getTotalChildrenCount();
                clipLine = y3;
                y3 -= (int)((double)currentNode.getTotalChildrenHeight() * (1.0 - this.animationPercentage));
            }
            fadeCount = 0;
            g2.setClip(clip);
            row = i2;
        }
        while (y3 < clip.y + clip.height + 1) {
            if (this.alternatingBackground != null && row % 2 == 1) {
                g2d.setColor(this.alternatingBackground);
                g2d.fillRect(x1, y3, x2 - x1, this.defaultRowHeight);
            }
            ++row;
            y3 += this.defaultRowHeight;
            if (!this.horizontalLinesVisible) continue;
            g2d.setColor(this.horizontalGridColor);
            g2d.drawLine(x1, y3 - 1, x2, y3 - 1);
        }
        if (this.verticalLinesVisible) {
            ColumnModelIterator iter = new ColumnModelIterator(this.getColumnModel(), this.ganttChart.getKeyColumnPosition());
            g2d.setColor(this.verticalGridColor);
            while (iter.hasNext()) {
                TreeTableColumn col = iter.next();
                int loc = header.getColumnLocation(col) + col.getWidth() - 1;
                if (loc < x1 || loc > x2) continue;
                g2d.drawLine(loc, y1, loc, y2);
            }
        }
        g2d.setComposite(comp);
    }

    protected void paintColumns(Graphics g2) {
        Rectangle clip = g2.getClipBounds();
        int firstRow = this.getRowAt(Math.max(0, g2.getClipBounds().y));
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("clip = " + g2.getClipBounds());
            LOGGER.finest("first row = " + firstRow);
        }
        if (this.nodes != null) {
            int x2 = 0;
            ColumnModelIterator iter = new ColumnModelIterator(this.getColumnModel(), this.getKeyColumnPosition());
            while (iter.hasNext()) {
                TreeTableColumn column = iter.next();
                if (x2 + column.getWidth() > clip.x) {
                    this.paintColumn(g2, column, firstRow, x2, clip, false, false);
                }
                boolean abort = x2 + column.getWidth() > clip.x + clip.width;
                x2 += column.getWidth();
                if (!abort) continue;
                break;
            }
            if (this.treeTableHeader.isShowingFillerColumn()) {
                TreeTableColumn fillerColumn = this.ganttChart.getTreeTableHeader().getFillerColumn();
                this.paintColumn(g2, fillerColumn, firstRow, x2, clip, false, true);
            }
        }
    }

    protected void paintColumn(Graphics g2, TreeTableColumn column, int row, int x2, Rectangle clip, boolean dragged, boolean filler) {
        Graphics2D g2d = (Graphics2D)g2;
        int y2 = 0;
        int columnWidth = column.getWidth();
        if (column == this.treeTableHeader.getFillerColumn()) {
            columnWidth = this.getWidth() - x2;
        }
        int col = this.getColumnIndex(column);
        int modelIndex = column.getModelIndex();
        int fadeCount = 0;
        int clipLine = 0;
        Composite comp = g2d.getComposite();
        boolean drawShadow = false;
        if (row != -1) {
            int r2;
            y2 = this.nodes.get(r2).getY();
            for (r2 = row; r2 < this.nodes.size(); ++r2) {
                g2d.setComposite(comp);
                if (this.animationController.isUsingTransparency() && fadeCount > 0) {
                    g2d.setComposite(AlphaComposite.getInstance(3, (float)this.animationPercentage));
                }
                --fadeCount;
                TreeTableNode currentNode = this.nodes.get(r2);
                int rowHeight = currentNode.getHeight();
                g2.clipRect(0, Math.max(clipLine, y2), this.getWidth(), this.getHeight());
                this.paintCell(g2, column, currentNode, x2, y2, columnWidth, rowHeight, r2, col, modelIndex, column.getColumnClass(), filler);
                g2.setClip(clip);
                if ((y2 += rowHeight) > clip.y + clip.height) break;
                TreeTableNode animationNode = this.getAnimationNode();
                if (currentNode != animationNode) continue;
                drawShadow = true;
                fadeCount = animationNode.getTotalChildrenCount();
                clipLine = y2;
                y2 -= (int)((double)currentNode.getTotalChildrenHeight() * (1.0 - this.animationPercentage));
            }
            fadeCount = 0;
            g2d.setComposite(comp);
            if (drawShadow) {
                GraphicsUtilities.drawDropShadow(this, g2d, x2, clipLine, columnWidth);
            }
        }
    }

    protected void paintDragAndDrop(Graphics g2) {
        TreeTableNode draggedNode = this.dndManager.getDraggedNode();
        if (draggedNode != null) {
            int dropRow = this.dndManager.getDropRow();
            if (dropRow != -1) {
                IRowPolicy rp = this.policyProvider.getPolicy(IRowPolicy.class);
                int x2 = 0;
                int y2 = this.nodes.get(dropRow).getY();
                int h2 = rp.getRowHeight(this.nodes.get(dropRow).getModelNode(), this.getModel());
                int w2 = this.treeTableHeader.getPreferredSize().width;
                if (this.dndManager.isValidDropLocation()) {
                    g2.setColor(this.dropColorValid);
                } else {
                    g2.setColor(this.dropColorInvalid);
                }
                if (this.nodes.get(dropRow).isLeaf()) {
                    g2.drawLine(x2, y2 + h2 - 2, x2 + w2 - 1, y2 + h2 - 2);
                    g2.drawLine(x2, y2 + h2 - 1, x2 + w2 - 1, y2 + h2 - 1);
                    g2.drawLine(x2, y2 + h2 - 0, x2 + w2 - 1, y2 + h2 - 0);
                } else {
                    Graphics2D g2d = (Graphics2D)g2;
                    Composite comp = g2d.getComposite();
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.25f));
                    g2d.fillRect(x2, y2, w2 - 2, h2 - 2);
                    g2d.setComposite(comp);
                    g2d.drawRect(x2, y2, w2 - 2, h2 - 2);
                }
            }
            if (!DragSource.isDragImageSupported()) {
                Point dragPoint = this.dndManager.getDragLocation();
                KeyColumn keyColumn = this.getKeyColumn();
                if (keyColumn == null) {
                    List<TreeTableColumn> available = this.ganttChart.getAvailableColumns();
                    for (TreeTableColumn col : available) {
                        if (!(col instanceof KeyColumn)) continue;
                        keyColumn = (KeyColumn)col;
                        break;
                    }
                }
                if (keyColumn != null) {
                    this.paintCell(g2, keyColumn, draggedNode, dragPoint.x, dragPoint.y, -1, -1, 0, Integer.MIN_VALUE, -1, keyColumn.getColumnClass(), false);
                }
            }
        }
    }

    protected void paintCell(Graphics g2, TreeTableColumn column, TreeTableNode node, int x2, int y2, int width, int height, int row, int columnIndex, int modelIndex, Class columnClass, boolean fillerColumn) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "g = " + g2 + " node = " + node + " x = " + x2 + " y = " + y2 + " width = " + width + " height = " + height + " row = " + row + " column = " + columnIndex + " columnClass = " + columnClass);
        }
        Object value = node.getKey();
        if (columnIndex > -1) {
            value = node.getValueAt(modelIndex);
        }
        int depth = node.getDepth();
        if (!this.rootVisible) {
            --depth;
        }
        TreePath path = node.getPath();
        boolean selected = this.selectionModel.isPathSelected(path);
        boolean leaf = node.isLeaf();
        boolean open = node.isExpanded();
        ITreeTableCellRenderer renderer = column.getCellRenderer();
        if (renderer == null && (renderer = value != null ? this.getCellRenderer(value.getClass()) : this.getCellRenderer(columnClass)) == null) {
            renderer = this.getCellRenderer(Object.class);
        }
        boolean focus = this.hasFocus();
        if (columnIndex == Integer.MIN_VALUE) {
            focus = focus && this.cellFocusManager.hasFocus(row, columnIndex);
            depth = 0;
            focus = false;
            selected = false;
        }
        JComponent comp = (JComponent)renderer.getTreeTableCellRendererComponent(this, node.getModelNode(), value, depth, selected, open, leaf, row, columnIndex, false);
        Border border = comp.getBorder();
        if (this.cellFocusManager.hasFocus() && this.cellFocusManager.hasFocus(row, columnIndex)) {
            comp.setBorder(new CompoundBorder(this.focusBorder, border));
        } else {
            comp.setBorder(new CompoundBorder(NO_FOCUS_BORDER, border));
        }
        int xx = x2;
        int yy = y2;
        int w2 = width;
        int h2 = height;
        if (columnIndex == Integer.MIN_VALUE) {
            Dimension dim = comp.getPreferredSize();
            w2 = dim.width + 8;
            h2 = dim.height + 5;
            xx -= w2 / 2;
            yy -= h2 / 2;
        }
        Graphics2D g2d = (Graphics2D)g2;
        Composite composite = g2d.getComposite();
        if (this.dropRows.contains(row)) {
            g2d.setComposite(AlphaComposite.getInstance(3, this.dropNodeVisibility));
        }
        this.rendererPane.paintComponent(g2, comp, this, xx, yy, w2 - 1, h2 - 1, true);
        g2d.setComposite(composite);
        comp.setBorder(border);
    }

    public int getRowHeight(int row) {
        if (row >= 0 && row < this.nodes.size()) {
            return this.nodes.get(row).getHeight();
        }
        return this.defaultRowHeight;
    }

    public Color getForeground(int row, boolean includeSelection) {
        if (row < 0) {
            throw new IllegalArgumentException("row can not be negative but was " + row);
        }
        TreePath path = null;
        if (row >= 0 && row < this.nodes.size()) {
            path = this.getTreePath(row);
        }
        if (includeSelection && path != null && this.selectionModel.isPathSelected(path)) {
            return this.selectionForeground;
        }
        if (this.alternatingForeground != null && row % 2 == 1) {
            return this.alternatingForeground;
        }
        return this.getForeground();
    }

    public Color getForeground(int row) {
        return this.getForeground(row, true);
    }

    public Color getBackground(int row, boolean includeSelection) {
        if (row < 0) {
            throw new IllegalArgumentException("row can not be negative but was " + row);
        }
        TreePath path = null;
        if (row >= 0 && row < this.nodes.size()) {
            path = this.getTreePath(row);
        }
        if (includeSelection && path != null && this.selectionModel.isPathSelected(path)) {
            return this.selectionBackground;
        }
        if (this.alternatingBackground != null && row % 2 == 1) {
            return this.alternatingBackground;
        }
        return this.getBackground();
    }

    public Color getBackground(int row) {
        return this.getBackground(row, true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.treeTableHeader.getPreferredSize().width, this.totalHeight);
    }

    private JViewport getViewport() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JViewport)) continue;
            return (JViewport)parent;
        }
        throw new IllegalStateException("tree table must be located inside a viewport");
    }

    public void scrollTo(int row, boolean showInFirstRow) {
        int l2 = this.nodes.size();
        if (l2 > 0) {
            row = Math.min(row, l2 - 1);
            Rectangle rect = new Rectangle(0, this.nodes.get(row).getY(), this.getWidth(), this.nodes.get(row).getHeight());
            if (showInFirstRow) {
                JViewport viewport = this.getViewport();
                Point p2 = viewport.getViewPosition();
                p2.y = rect.y;
                this.getViewport().setViewPosition(p2);
            } else {
                this.scrollRectToVisible(rect);
            }
        }
    }

    public void scrollTo(int row) {
        this.scrollTo(row, false);
    }

    public void scrollTo(TreePath path, boolean showInFirstRow) {
        TreeTableNode node = this.getTreeTableNode(path);
        this.scrollTo(node.getRow(), showInFirstRow);
    }

    public void scrollTo(TreePath path) {
        this.scrollTo(path, false);
    }

    public void scrollFocusToVisible() {
        Rectangle r2;
        int row = this.getFocusedRow();
        int col = this.getFocusedColumn();
        if (row != -1 && col != Integer.MIN_VALUE && (r2 = this.getCellRect(row, col)) != null) {
            this.scrollRectToVisible(r2);
        }
    }

    public int getColumnIndexAt(int x2) {
        return this.treeTableHeader.getColumnIndexAt(x2);
    }

    public int getRowAt(int y2) {
        TreeTableNode node = this.getTreeTableNodeAt(y2);
        if (node != null) {
            return node.getRow();
        }
        return -1;
    }

    public TreeTableColumn getColumnAt(int x2) {
        return this.treeTableHeader.getColumnAt(x2);
    }

    public int getVisibleRowCount() {
        int first = this.getFirstVisibleRow();
        if (first != -1) {
            int last = this.getLastVisibleRow();
            if (last != -1) {
                return last - first + 1;
            }
            return 1;
        }
        return 0;
    }

    public TreeTableNode getTreeTableNodeAt(int y2) {
        int low = 0;
        int high = this.nodes.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            if (this.nodes.get(mid).getY() + this.nodes.get(mid).getHeight() - 1 < y2) {
                low = mid + 1;
                continue;
            }
            if (this.nodes.get(mid).getY() > y2) {
                high = mid - 1;
                continue;
            }
            return this.nodes.get(mid);
        }
        return null;
    }

    public TreeTableNode[] getTreeTableNodesBetween(int y1, int y2) {
        int yy1 = y1;
        int yy2 = y2;
        if (y1 < 0) {
            throw new IllegalArgumentException("y1 can not be negative but was " + y1);
        }
        if (y2 < 0) {
            throw new IllegalArgumentException("y2 can not be negative but was " + y2);
        }
        if (yy1 > yy2) {
            int temp = yy1;
            yy1 = yy2;
            yy2 = temp;
        }
        ArrayList<TreeTableNode> result = new ArrayList<TreeTableNode>();
        int index = this.getRowAt(yy1);
        if (index == -1) {
            return null;
        }
        TreeTableNode node = this.nodes.get(index);
        int y3 = node.getY();
        while (index < this.nodes.size()) {
            node = this.nodes.get(index);
            result.add(node);
            ++index;
            if ((y3 += node.getHeight()) < yy2) continue;
        }
        int s2 = result.size();
        TreeTableNode[] resultNodes = new TreeTableNode[s2];
        result.toArray(resultNodes);
        return resultNodes;
    }

    @Override
    public void treeNodeKeyChanged(TreeTableModelEvent e2) {
        this.repaint();
    }

    @Override
    public void treeNodeValueChanged(TreeTableModelEvent e2) {
        this.repaint();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e2) {
        this.repaint();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e2) {
        this.updateNodes();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e2) {
        TreePath path = e2.getTreePath();
        TreeTableNode node = this.getTreeTableNode(path);
        if (node.isExpanded()) {
            Object[] children = e2.getChildren();
            int l2 = children.length;
            for (int i2 = 0; i2 < l2; ++i2) {
                TreePath childPath = path.pathByAddingChild(children[i2]);
                TreeTableNode childNode = this.modelMap.get(childPath);
                this.nodeCache.put(children[i2], childNode);
            }
        }
        this.updateNodes();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e2) {
        this.updateNodes();
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (!(!this.isEnabled() || this.maybeShowPopup(e2) || this.popup != null && this.popup.isVisible())) {
            TreeTableNode node = this.getTreeTableNodeAt(e2.getY());
            if (e2.getButton() == 1 && node != null) {
                if (e2.getClickCount() == 1) {
                    if (this.isEditing()) {
                        this.cellEditor.stopCellEditing();
                    }
                } else if (e2.getClickCount() == 2) {
                    int row = this.getRowAt(e2.getY());
                    int column = this.getColumnIndexAt(e2.getX());
                    this.editCellAt(row, column, e2);
                }
            }
        }
        for (LayerContainer lc2 : this.ganttChart.getLayerContainers()) {
            SpreadsheetLayer spreadsheetLayer = lc2.getSystemLayer(SpreadsheetLayer.class);
            if (spreadsheetLayer == null) continue;
            spreadsheetLayer.setHasFocus(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (this.isEnabled()) {
            TreeTableColumn col;
            this.ganttChart.requestFocus();
            int row = this.getRowAt(e2.getY());
            if (row == -1) {
                row = this.nodes.size() - 1;
            }
            if ((col = this.getColumnAt(e2.getX())) == null) {
                col = this.getColumnAt(this.getWidth() - 2);
            }
            if (SwingUtilities.isLeftMouseButton(e2) && this.isEnabled()) {
                this.cellFocusManager.focusOnCell(row, col);
            }
            this.performSelection(e2);
            if (!this.maybeShowPopup(e2) && this.getCursor().equals(INDENT_CURSOR)) {
                TreeTableNode node = this.nodes.get(row);
                this.indentationLineLocation = this.treeTableHeader.getColumnLocation(col) + 2;
                int depth = node.getDepth();
                if (!this.rootVisible) {
                    --depth;
                }
                this.indentationLineLocation += depth * this.inset;
                this.indentationLineOrigin = this.indentationLineLocation;
                this.repaint();
            }
        }
    }

    private void performSelection(MouseEvent e2) {
        int row;
        if (!SwingUtilities.isLeftMouseButton(e2) || !this.isEnabled()) {
            return;
        }
        if (!e2.isShiftDown() && !e2.isControlDown()) {
            this.clearSelection();
            for (TreeTable tt : this.ganttChart.getTreeTables()) {
                if (tt.equals(this)) continue;
                tt.clearSelection();
            }
        }
        if ((row = this.getRowAt(e2.getY())) == -1) {
            row = this.nodes.size() - 1;
        }
        if (row >= 0) {
            INodeEditPolicy nep = this.policyProvider.getPolicy(INodeEditPolicy.class);
            if (e2.isShiftDown()) {
                int leadRow = this.selectionModel.getLeadSelectionRow();
                if (leadRow == -1) {
                    leadRow = row;
                }
                int a2 = Math.min(row, leadRow);
                int b2 = Math.max(row, leadRow);
                int count = b2 - a2 + 1;
                LinkedList<TreePath> pathList = new LinkedList<TreePath>();
                for (int i2 = 0; i2 < count; ++i2) {
                    TreePath treePath = this.getTreePath(a2 + i2);
                    Object node = treePath.getLastPathComponent();
                    if (!nep.isSelectable(node, this.model)) continue;
                    pathList.add(treePath);
                }
                int listSize = pathList.size();
                if (listSize > 0) {
                    TreePath[] paths = new TreePath[listSize];
                    pathList.toArray(paths);
                    this.selectionModel.addSelectionPaths(paths);
                }
            } else {
                TreePath path = this.getTreePath(row);
                Object node = path.getLastPathComponent();
                if (this.isPathSelected(path)) {
                    this.selectionModel.removeSelectionPath(path);
                } else if (nep.isSelectable(node, this.model)) {
                    this.selectionModel.addSelectionPath(path);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.isEnabled()) {
            this.maybeShowPopup(e2);
            if (this.indentationLineLocation != -1) {
                TreePath[] paths = this.getSelectionPaths();
                int delta = this.indentationLineLocation - this.indentationLineOrigin;
                if (delta == this.inset) {
                    this.indentNodes(paths);
                } else if (delta == -this.inset) {
                    this.outdentNodes(paths);
                }
                this.indentationLineLocation = -1;
                this.repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (this.indentationLineLocation != -1) {
            this.indentationLineLocation = e2.getX();
            this.indentationLineLocation = Math.min(this.indentationLineLocation, this.indentationLineOrigin + this.inset);
            this.indentationLineLocation = Math.max(this.indentationLineLocation, this.indentationLineOrigin - this.inset);
            this.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        if ((e2.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0 && !e2.isShiftDown()) {
            int amount = e2.getWheelRotation();
            int firstRow = this.getFirstVisibleRow();
            if (amount < 0) {
                if ((firstRow = Math.max(0, firstRow + amount)) < this.nodes.size()) {
                    TreeTableNode node = this.nodes.get(firstRow);
                    IRowPolicy rowPolicy = this.policyProvider.getPolicy(IRowPolicy.class);
                    int height = rowPolicy.getRowHeight(node.getModelNode(), this.model);
                    while (height <= 0 && firstRow > 0) {
                        node = this.nodes.get(--firstRow);
                        height = rowPolicy.getRowHeight(node.getModelNode(), this.model);
                    }
                    this.scrollTo(firstRow);
                }
            } else {
                Rectangle rect = this.getVisibleRect();
                int row = this.getRowAt(rect.y + rect.height);
                if (row != -1 && (row = Math.min(this.nodes.size() - 1, row + amount)) < this.nodes.size()) {
                    TreeTableNode node = this.nodes.get(row);
                    IRowPolicy rowPolicy = this.policyProvider.getPolicy(IRowPolicy.class);
                    int height = rowPolicy.getRowHeight(node.getModelNode(), this.model);
                    while (height <= 0 && row < this.nodes.size() - 1) {
                        node = this.nodes.get(++row);
                        height = rowPolicy.getRowHeight(node.getModelNode(), this.model);
                    }
                    this.scrollRectToVisible(new Rectangle(0, node.getY(), this.getWidth(), height));
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        int x2;
        TreeTableColumn column;
        int row = this.getRowAt(e2.getY());
        if (this.isEnabled() && this.isIndentEnabled() && row != -1 && (column = this.getColumnAt(x2 = e2.getX())) instanceof KeyColumn) {
            int cx = this.treeTableHeader.getColumnLocation(column);
            INodeEditPolicy ip = this.policyProvider.getPolicy(INodeEditPolicy.class);
            TreeTableNode node = this.nodes.get(row);
            int depth = node.getDepth();
            Object modelNode = node.getModelNode();
            Object newParentNode1 = node.getNewParentForIndentation();
            Object newParentNode2 = node.getNewParentForOutdentation();
            if (this.isReassingLocation(x2, cx, depth) && (ip.isReassignable(modelNode, newParentNode1, this.model) || ip.isReassignable(modelNode, newParentNode2, this.model))) {
                this.setCursor(INDENT_CURSOR);
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private boolean isReassingLocation(int x2, int columnX, int depth) {
        int reassignLocation;
        if (!this.rootVisible) {
            --depth;
        }
        return x2 > (reassignLocation = columnX + this.inset * depth) && x2 < reassignLocation + 4;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        int row = this.getRowAt(evt.getY());
        if (row != -1) {
            if (this.isPopupAvailable(row, evt.isShiftDown())) {
                return null;
            }
            int index = this.ganttChart.getTreeTableHeader().getColumnIndexAt(evt.getX());
            if (index != Integer.MIN_VALUE) {
                TreeTableColumn column = this.columnModel.getKeyColumn();
                if (index != -1) {
                    column = this.columnModel.getColumn(index);
                }
                if (column != null) {
                    Object obj = this.nodes.get(row).getModelNode();
                    IRowPolicy rowPolicy = this.policyProvider.getPolicy(IRowPolicy.class);
                    return rowPolicy.getRowToolTip(obj, this.model, column);
                }
            }
        }
        return super.getToolTipText(evt);
    }

    private boolean isPopupAvailable(int row, boolean extended) {
        LayerContainer lc2;
        if (this.ganttChart.isPopupVisible() && (lc2 = this.getLayerContainer()) != null && this.model instanceof IGanttChartModel) {
            TreePath path = this.getTreePath(row);
            IPopupPolicy pp = lc2.getPolicyProvider().getPolicy(IPopupPolicy.class);
            if (pp.getPopupValue(path, (IGanttChartModel)this.model, extended) != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e2) {
        TableUtils.repaintAfterValueChanged(this, this, e2);
        TreePath path = e2.getNewLeadSelectionPath();
        if (path != null) {
            TreeTableColumn column;
            this.cellFocusManager.setFocusedPath(path);
            if (this.cellFocusManager.getFocusedColumn() == null && (column = this.getColumnAt(0)) != null) {
                this.cellFocusManager.setFocusedColumn(column);
            }
        }
    }

    @Override
    public int[] getRowsForPaths(TreePath[] paths) {
        List<TreeTableNode> nodes = this.getTreeTableNodes(paths);
        int[] rows = new int[nodes.size()];
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            rows[i2] = nodes.get(i2).getRow();
        }
        return rows;
    }

    public int getRowForPath(TreePath path) {
        if (path == null) {
            return -1;
        }
        int[] rows = this.getRowsForPaths(new TreePath[]{path});
        if (rows != null && rows.length > 0) {
            return rows[0];
        }
        return -1;
    }

    public Class getColumnClass(int columnIndex) {
        TreeTableColumn col = this.getColumn(columnIndex);
        return col.getColumnClass();
    }

    @Override
    public void editingStopped(ChangeEvent e2) {
        ITreeTableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            this.removeEditor();
            Object value = editor.getCellEditorValue();
            INodeEditPolicy policy = this.policyProvider.getPolicy(INodeEditPolicy.class);
            TreeTableNode node = this.nodes.get(this.editingRow);
            ICommand cmd = null;
            if (node instanceof NewEntryNode) {
                if (this.editingColumn == -1) {
                    Object parentNode = this.root.getModelNode();
                    if (this.editingRow > 0) {
                        node = this.nodes.get(this.editingRow - 1);
                        if (node.getParentNode() == null) {
                            return;
                        }
                        parentNode = node.getParentNode().getModelNode();
                    }
                    cmd = policy.getCreateNodeCommand(parentNode, this.model, value, null);
                }
            } else {
                Object data = node.getModelNode();
                if (this.editingColumn == -1) {
                    cmd = policy.getChangeKeyCommand(data, this.model, value);
                } else {
                    TreeTableColumn column = this.getColumn(this.editingColumn);
                    cmd = policy.getChangeValueCommand(data, this.model, value, column.getModelIndex());
                }
            }
            if (cmd != null) {
                final ICommandStack stack = this.ganttChart.getCommandStack();
                stack.addCommandStackListener(new ICommandStackListener(){

                    @Override
                    public void commandStackChanged(CommandStackEvent evt) {
                        3 stackListener = this;
                        if (evt.getId().equals((Object)CommandStackEvent.ID.COMMAND_EXECUTED)) {
                            stack.removeCommandStackListener(stackListener);
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!(TreeTable.this.editingEvent instanceof MouseEvent)) {
                                            TreeTable.this.cellFocusManager.focusOnCellBelow();
                                        }
                                        TreePath path = TreeTable.this.cellFocusManager.getFocusedPath();
                                        TreeTable.this.setSelectionPath(path);
                                    }
                                });
                            }
                            catch (Exception ex) {
                                LOGGER.throwing(this.getClass().getName(), "editingStopped()", ex);
                            }
                        }
                    }
                });
                this.ganttChart.commandExecute(cmd);
            }
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e2) {
        this.removeEditor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (evt.getSource().equals(this)) {
            if (propName.equals(PROPERTY_ROOT_VISIBLE)) {
                this.updateNodes();
            } else if (propName.equals(PROPERTY_CREATION_ENABLED)) {
                this.updateNodes();
            } else if (propName.equals("enabled")) {
                this.clearSelection();
            }
            this.repaint();
        } else if (evt.getSource().equals(this.ganttChart)) {
            if (evt.getPropertyName().equals("columnModel")) {
                this.setColumnModel(this.ganttChart.getColumnModel());
            } else if (propName.equals("keyColumnPosition")) {
                this.repaint();
            }
        } else if (evt.getSource() instanceof TreeTableColumn) {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.repaint();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.repaint();
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) {
        if (this.cellEditor != null) {
            this.cellEditor.cancelCellEditing();
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
        if (this.cellEditor != null) {
            this.cellEditor.cancelCellEditing();
        }
    }

    public void deleteSelectedNodes() {
        if (!this.deletionEnabled) {
            throw new IllegalStateException("the table does not allow the deletion of rows");
        }
        TreePath[] selections = this.getSelectionPaths();
        if (selections != null) {
            int[] rows = this.getRowsForPaths(selections);
            Arrays.sort(rows);
            INodeEditPolicy tep = this.policyProvider.getPolicy(INodeEditPolicy.class);
            LinkedList<Object> deletedNodes = new LinkedList<Object>();
            for (int i2 = rows.length - 1; i2 >= 0; --i2) {
                Object data = this.nodes.get(rows[i2]).getModelNode();
                if (!tep.isDeletable(data, this.model)) continue;
                deletedNodes.add(data);
            }
            if (deletedNodes.size() > 0) {
                this.clearSelection();
                ICommand cmd = tep.getDeleteNodesCommand(deletedNodes, this.model);
                this.ganttChart.commandExecute(cmd);
            }
        }
    }

    public void insertNode(int row) {
        if (this.isCreationEnabled()) {
            if (row == 0 && this.rootVisible) {
                return;
            }
            INodeEditPolicy ep = this.policyProvider.getPolicy(INodeEditPolicy.class);
            TreePath path = this.getTreePath(row);
            Object childNode = path.getLastPathComponent();
            TreePath parentPath = path.getParentPath();
            Object parentNode = parentPath.getLastPathComponent();
            int childIndex = this.model.getIndexOfChild(parentNode, childNode);
            if (childIndex == -1) {
                childIndex = this.model.getChildCount(parentNode);
            }
            ICommand cmd = ep.getInsertNodeCommand(parentNode, childIndex, this.model);
            final int fRow = row;
            final ICommandStack stack = this.ganttChart.getCommandStack();
            stack.addCommandStackListener(new ICommandStackListener(){

                @Override
                public void commandStackChanged(CommandStackEvent e2) {
                    if (e2.getId().equals((Object)CommandStackEvent.ID.COMMAND_EXECUTED)) {
                        stack.removeCommandStackListener(this);
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    TreePath newPath = TreeTable.this.getTreePath(fRow);
                                    TreeTable.this.selectionModel.setSelectionPath(newPath);
                                    TreeTable.this.cellFocusManager.setFocusedRow(fRow);
                                }
                            });
                        }
                        catch (Exception ex) {
                            LOGGER.throwing(this.getClass().getName(), "insertNode()", ex);
                        }
                    }
                }
            });
            this.ganttChart.commandExecute(cmd);
        }
    }

    public CellFocusManager getCellFocusManager() {
        return this.cellFocusManager;
    }

    public IPolicyProvider getPolicyProvider() {
        return this.policyProvider;
    }

    public void setPolicyProvider(IPolicyProvider provider) {
        IPolicyProvider oldProvider = this.policyProvider;
        this.policyProvider = provider;
        this.firePropertyChange(PROPERTY_POLICY_PROVIDER, oldProvider, provider);
    }

    public void setDefaultRowHeight(int height) {
        int oldHeight = this.defaultRowHeight;
        this.defaultRowHeight = height;
        this.firePropertyChange(PROPERTY_DEFAULT_ROW_HEIGHT, oldHeight, height);
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public TreeTableNode getRootNode() {
        return this.root;
    }

    public Image getTexture() {
        return this.texture;
    }

    public void setTexture(Image texture) {
        this.texture = texture;
        if (texture != null) {
            BufferedImage buffer = new BufferedImage(texture.getWidth(this), texture.getHeight(this), 1);
            Graphics2D bg = buffer.createGraphics();
            bg.drawImage(texture, 0, 0, this);
            this.texturePaint = new TexturePaint(buffer, new Rectangle(0, 0, buffer.getWidth(), buffer.getHeight()));
        } else {
            this.texturePaint = null;
        }
        this.repaint();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public void columnModelChanged(ColumnModelEvent evt) {
        switch (evt.getId()) {
            case COLUMN_ADDED: {
                TreeTableColumn column = evt.getColumn();
                column.addPropertyChangeListener(this);
                break;
            }
            case COLUMN_REMOVED: {
                TreeTableColumn col = evt.getColumn();
                if (col.equals(this.cellFocusManager.getFocusedColumn())) {
                    this.cellFocusManager.looseFocus();
                    this.clearSelection();
                }
                TreeTableColumn column = evt.getColumn();
                column.removePropertyChangeListener(this);
                break;
            }
            case COLUMN_INSERTED: {
                TreeTableColumn column = evt.getColumn();
                column.addPropertyChangeListener(this);
                break;
            }
        }
        this.invalidate();
        this.validate();
    }

    public ITreeTableMenuProvider getMenuProvider() {
        return this.menuProvider;
    }

    public void setMenuProvider(ITreeTableMenuProvider provider) {
        this.menuProvider = provider;
    }

    private boolean maybeShowPopup(MouseEvent evt) {
        if (evt.isPopupTrigger() && !evt.isConsumed()) {
            this.popup = null;
            int row = this.getRowAt(evt.getY());
            TreePath path = null;
            if (row > -1) {
                path = this.getTreePath(row);
            }
            if (path != null && !this.selectionModel.isPathSelected(path)) {
                this.selectionModel.clearSelection();
                Object node = path.getLastPathComponent();
                INodeEditPolicy nep = this.policyProvider.getPolicy(INodeEditPolicy.class);
                if (nep.isSelectable(node, this.getModel())) {
                    this.selectionModel.addSelectionPath(path);
                }
            }
            if (this.menuProvider != null) {
                TreeTableColumn column = this.treeTableHeader.getColumnAt(evt.getX());
                this.popup = this.menuProvider.getPopupMenu(this, evt, path, column);
            } else {
                this.popup = this.getComponentPopupMenu();
            }
            if (this.popup != null) {
                this.popup.show(this, evt.getX(), evt.getY());
                return true;
            }
        }
        return false;
    }

    public void setCellRenderer(Class cl, ITreeTableCellRenderer renderer) {
        if (cl == null) {
            throw new IllegalArgumentException("object type can not be NULL");
        }
        this.rendererCache.clear();
        this.rendererMap.put(cl, renderer);
    }

    public void setCellEditor(Class cl, ITreeTableCellEditor editor) {
        this.editorMap.put(cl, editor);
    }

    public ITreeTableCellRenderer getCellRenderer(Class cl) {
        if (cl == null) {
            return null;
        }
        ITreeTableCellRenderer renderer = this.rendererCache.get(cl);
        if (renderer != null) {
            return renderer;
        }
        renderer = this.rendererMap.get(cl);
        if (renderer != null) {
            this.rendererCache.put(cl, renderer);
            return renderer;
        }
        renderer = this.getCellRenderer(cl.getSuperclass());
        this.rendererCache.put(cl, renderer);
        return renderer;
    }

    public ITreeTableCellEditor getCellEditor(Class cl) {
        if (cl == null) {
            return null;
        }
        ITreeTableCellEditor editor = this.editorMap.get(cl);
        if (editor != null) {
            return editor;
        }
        return this.getCellEditor(cl.getSuperclass());
    }

    public Map<Class, ITreeTableCellRenderer> getRendererMap() {
        return this.rendererMap;
    }

    public void setRendererMap(Map<Class, ITreeTableCellRenderer> map) {
        if (map == null) {
            throw new IllegalArgumentException("renderer map can not be NULL");
        }
        this.rendererMap = map;
    }

    public TreeTableRowHeader getRowHeader() {
        return this.treeTableRowHeader;
    }

    public void setRowHeader(TreeTableRowHeader header) {
        this.treeTableRowHeader = header;
    }

    @Override
    public void autoscroll(Point cursorLocation) {
        this.autoscroll.autoscroll(cursorLocation);
    }

    @Override
    public Insets getAutoscrollInsets() {
        return this.autoscroll.getAutoscrollInsets();
    }

    public CellRendererPane getRendererPane() {
        return this.rendererPane;
    }

    public TreeTableDragAndDropManager getDragAndDropManager() {
        return this.dndManager;
    }

    protected TreeTableDragAndDropManager createDragAndDropManager() {
        return new TreeTableDragAndDropManager(this);
    }

    public Color getDropColorValid() {
        return this.dropColorValid;
    }

    public void setDropColorValid(Color color) {
        this.dropColorValid = color;
    }

    public Color getDropColorInvalid() {
        return this.dropColorInvalid;
    }

    public void setDropColorInvalid(Color color) {
        this.dropColorInvalid = color;
    }

    public void outdentNodes(TreePath[] paths) {
        if (paths != null && paths.length > 0) {
            if (this.isContinousSelection(paths)) {
                if (this.isOutdentableSelection(paths)) {
                    this.doOutdentNodes(paths);
                } else if (paths.length > 1) {
                    this.ganttChart.showMessage(Messages.getString("TreeTable.MSG_1"), MessageTypeId.ERROR);
                } else {
                    this.ganttChart.showMessage(Messages.getString("TreeTable.MSG_2"), MessageTypeId.ERROR);
                }
            } else {
                this.ganttChart.showMessage(Messages.getString("TreeTable.MSG_3") + System.getProperty("line.separator") + Messages.getString("TreeTable.MSG_4"), MessageTypeId.ERROR);
            }
        }
    }

    private void doOutdentNodes(TreePath[] paths) {
        int count = paths.length;
        int[] oldChildIndices = new int[count];
        int[] newChildIndices = new int[count];
        Object[] nodes = new Object[count];
        TreePath firstPath = paths[0];
        Object draggedNode = firstPath.getLastPathComponent();
        Object oldParent = firstPath.getParentPath().getLastPathComponent();
        if (firstPath.getParentPath().getParentPath() != null) {
            Object newParent = firstPath.getParentPath().getParentPath().getLastPathComponent();
            int oldParentIndex = this.model.getIndexOfChild(newParent, oldParent);
            TreePath[] animatedPaths = new TreePath[count];
            for (int i2 = 0; i2 < count; ++i2) {
                TreePath path = paths[i2];
                draggedNode = path.getLastPathComponent();
                oldChildIndices[i2] = this.model.getIndexOfChild(oldParent, draggedNode);
                newChildIndices[i2] = oldParentIndex + 1 + i2;
                nodes[i2] = draggedNode;
                animatedPaths[i2] = path.getParentPath().getParentPath().pathByAddingChild(draggedNode);
            }
            this.performIndentation(oldParent, oldChildIndices, newParent, newChildIndices, nodes, animatedPaths);
        }
    }

    public void indentNodes(TreePath[] paths) {
        if (paths != null && paths.length > 0) {
            if (this.isContinousSelection(paths)) {
                if (this.isIndentableSelection(paths)) {
                    this.doIndentNodes(paths);
                } else if (paths.length > 1) {
                    this.ganttChart.showMessage(Messages.getString("TreeTable.MSG_5"), MessageTypeId.ERROR);
                } else {
                    this.ganttChart.showMessage(Messages.getString("TreeTable.MSG_6"), MessageTypeId.ERROR);
                }
            } else {
                this.ganttChart.showMessage(Messages.getString("TreeTable.MSG_7") + System.getProperty("line.separator") + Messages.getString("TreeTable.MSG_8"), MessageTypeId.ERROR);
            }
        }
    }

    private void doIndentNodes(TreePath[] paths) {
        int oldChildIndex;
        int count = paths.length;
        int[] oldChildIndices = new int[count];
        int[] newChildIndices = new int[count];
        Object[] nodes = new Object[count];
        TreePath firstPath = paths[0];
        Object draggedNode = firstPath.getLastPathComponent();
        Object oldParent = firstPath.getParentPath().getLastPathComponent();
        int childCount = this.model.getChildCount(oldParent);
        if (childCount > 1 && (oldChildIndex = this.model.getIndexOfChild(oldParent, draggedNode)) > 0) {
            Object newParent = this.model.getChild(oldParent, oldChildIndex - 1);
            int newParentChildCount = this.model.getChildCount(newParent);
            TreePath[] animatedPaths = new TreePath[count];
            for (int i2 = 0; i2 < count; ++i2) {
                TreePath path = paths[i2];
                draggedNode = path.getLastPathComponent();
                oldChildIndices[i2] = this.model.getIndexOfChild(oldParent, draggedNode);
                newChildIndices[i2] = newParentChildCount + i2;
                nodes[i2] = draggedNode;
                animatedPaths[i2] = path.getParentPath().pathByAddingChild(newParent).pathByAddingChild(draggedNode);
            }
            this.performIndentation(oldParent, oldChildIndices, newParent, newChildIndices, nodes, animatedPaths);
        }
    }

    private boolean isContinousSelection(TreePath[] paths) {
        TreePath parentPath = paths[0].getParentPath();
        for (TreePath path : paths) {
            if (parentPath.equals(path.getParentPath())) continue;
            return false;
        }
        return true;
    }

    private boolean isIndentableSelection(TreePath[] paths) {
        Object newParent;
        INodeEditPolicy dnd = this.policyProvider.getPolicy(INodeEditPolicy.class);
        TreeTableNode ttNode = this.getTreeTableNode(paths[0]);
        Object node = paths[0].getLastPathComponent();
        return dnd.isReassignable(node, newParent = ttNode.getNewParentForIndentation(), this.model);
    }

    private boolean isOutdentableSelection(TreePath[] paths) {
        Object newParent;
        INodeEditPolicy dnd = this.policyProvider.getPolicy(INodeEditPolicy.class);
        TreeTableNode ttNode = this.getTreeTableNode(paths[0]);
        Object node = paths[0].getLastPathComponent();
        return dnd.isReassignable(node, newParent = ttNode.getNewParentForOutdentation(), this.model);
    }

    private void performIndentation(Object oldParent, int[] oldChildIndices, Object newParent, int[] newChildIndices, Object[] nodes, final TreePath[] indentedPaths) {
        ICommand cmd;
        INodeEditPolicy ip = this.policyProvider.getPolicy(INodeEditPolicy.class);
        final ICommand fCmd = cmd = ip.getReassignmentCommand(nodes, oldParent, oldChildIndices, newParent, newChildIndices, this.model);
        final ICommandStack stack = this.ganttChart.getCommandStack();
        stack.addCommandStackListener(new ICommandStackListener(){

            @Override
            public void commandStackChanged(CommandStackEvent e2) {
                if (e2.getCommand() == fCmd && e2.getId().equals((Object)CommandStackEvent.ID.COMMAND_EXECUTED)) {
                    stack.removeCommandStackListener(this);
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                TreeTable.this.setSelectionPaths(indentedPaths);
                                TreeTable.this.expandPath(indentedPaths[0].getParentPath());
                            }
                        });
                    }
                    catch (Exception ex) {
                        LOGGER.throwing(this.getClass().getName(), "performIndentation()", ex);
                    }
                }
            }
        });
        this.ganttChart.commandExecute(cmd);
    }

    public TreeTableNode getAnimationNode() {
        if (this.nodeTimingTarget != null) {
            return this.nodeTimingTarget.getTimingTargetNode();
        }
        return null;
    }

    public double getAnimationPercentage() {
        return this.animationPercentage;
    }

    public NodeAnimationController getNodeAnimationController() {
        return this.animationController;
    }

    public void setNodeAnimationController(NodeAnimationController settings) {
        if (settings == null) {
            throw new IllegalArgumentException("animation settings can not be NULL");
        }
        this.animationController = settings;
    }

    public INodeFilter getNodeFilter() {
        return this.nodeFilter;
    }

    public void setNodeFilter(INodeFilter filter) {
        this.nodeFilter = filter;
        this.updateNodes();
        this.getRowHeader().repaint();
    }

    public static class NumberRenderer
    extends DefaultTreeTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    public static class NumberEditor
    extends GenericEditor {
        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    public static class IconRenderer
    extends DefaultTreeTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        protected Icon getIcon(Object node, Object value, int column, boolean leaf, boolean expanded) {
            if (value instanceof Icon) {
                return (Icon)value;
            }
            return null;
        }

        @Override
        protected String getText(Object node, Object value) {
            return "";
        }
    }

    private static class GenericEditor
    extends DefaultTreeTableCellEditor {
        private final Class[] argTypes = new Class[]{String.class};
        private Constructor constructor;
        private Object value;

        public GenericEditor() {
            super(new JTextField());
            this.getComponent().setName("Table.editor");
        }

        @Override
        public boolean stopCellEditing() {
            String s2 = (String)super.getCellEditorValue();
            if ("".equals(s2)) {
                if (this.constructor.getDeclaringClass() == String.class) {
                    this.value = s2;
                }
                super.stopCellEditing();
            }
            try {
                this.value = this.constructor.newInstance(s2);
            }
            catch (Exception e2) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTreeTableCellEditorComponent(TreeTable tree, Object value, boolean selected, int row, int column) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            Class<Object> type = tree.getColumnClass(column);
            if (value != null) {
                type = value.getClass();
            }
            if (type == Object.class) {
                type = String.class;
            }
            try {
                this.constructor = type.getConstructor(this.argTypes);
            }
            catch (SecurityException ex) {
                LOGGER.throwing(this.getClass().getName(), "getTreeTableCellEditorComponent", ex);
            }
            catch (NoSuchMethodException ex) {
                LOGGER.throwing(this.getClass().getName(), "getTreeTableCellEditorComponent", ex);
            }
            return super.getTreeTableCellEditorComponent(tree, value, selected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    public static class EnumRenderer
    extends DefaultTreeTableCellRenderer {
        @Override
        public String getText(Object node, Object value) {
            if (value != null) {
                if (value instanceof INamedObject) {
                    return ((INamedObject)value).getName();
                }
                return value.toString();
            }
            return "";
        }
    }

    public static class EnumEditor
    extends DefaultTreeTableCellEditor {
        public EnumEditor() {
            super(new JComboBox(new DefaultComboBoxModel()));
        }

        private void updateComboBox(Object value) {
            Enum e2 = (Enum)value;
            Class cl = e2.getDeclaringClass();
            E[] obj = cl.getEnumConstants();
            JComboBox box = (JComboBox)this.getComponent();
            box.setRenderer(new NamedObjectListCellRenderer());
            DefaultComboBoxModel model = (DefaultComboBoxModel)box.getModel();
            model.removeAllElements();
            for (Object o2 : obj) {
                model.addElement(o2);
            }
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.updateComboBox(value);
            return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        }

        class NamedObjectListCellRenderer
        extends DefaultListCellRenderer {
            NamedObjectListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof INamedObject) {
                    label.setText(((INamedObject)value).getName());
                }
                return label;
            }
        }
    }

    public static class DoubleRenderer
    extends NumberRenderer {
        private NumberFormat formatter;

        @Override
        public String getText(Object node, Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            if (value != null) {
                return this.formatter.format(value);
            }
            return "";
        }
    }

    public static class DateRenderer
    extends DefaultTreeTableCellRenderer {
        private DateFormat formatter;

        @Override
        public String getText(Object node, Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            if (value != null) {
                return this.formatter.format(value);
            }
            return "";
        }

        public void setFormatter(DateFormat formatter) {
            this.formatter = formatter;
        }
    }

    public static class DateEditor
    extends AbstractCellEditor
    implements ITreeTableCellEditor {
        private static SpinnerDateModel dateModel = new SpinnerDateModel();
        private static JSpinner spinner = new JSpinner(dateModel);

        public Component getEditorComponent(Object value) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("value is not of type Date but " + value.getClass().getName());
            }
            dateModel.setValue(value);
            return spinner;
        }

        @Override
        public Component getTreeTableCellEditorComponent(TreeTable tree, Object value, boolean selected, int row, int column) {
            if (value == null) {
                return this.getEditorComponent(Calendar.getInstance(tree.getGanttChart().getDatelineModel().getTimeZone()).getTime());
            }
            return this.getEditorComponent(((Date)value).clone());
        }

        @Override
        public Object getCellEditorValue() {
            return dateModel.getValue();
        }
    }

    public static class ColorRenderer
    extends AbstractCellEditor
    implements ITreeTableCellRenderer {
        private final ColorField field = new ColorField();

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable tree, Object node, Object value, int depth, boolean selected, boolean expanded, boolean leaf, int row, int column, boolean hasFocus) {
            this.field.setColor((Color)value);
            this.field.setBackground(tree.getBackground(row));
            return this.field;
        }

        @Override
        public Object getCellEditorValue() {
            return this.field.getColor();
        }
    }

    public static class ColorEditor
    extends AbstractCellEditor
    implements ITreeTableCellEditor {
        private static final ColorField label = new ColorField();

        public ColorEditor() {
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    Color c2 = JColorChooser.showDialog(label, Messages.getString("TreeTable.SELECT_COLOR"), label.getBackground());
                    label.setColor(c2);
                    this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTreeTableCellEditorComponent(TreeTable tree, Object value, boolean selected, int row, int column) {
            label.setColor((Color)value);
            return label;
        }

        @Override
        public Object getCellEditorValue() {
            return label.getColor();
        }
    }

    public static class CalendarRenderer
    extends DateRenderer {
        @Override
        public String getText(Object node, Object value) {
            if (value != null) {
                return super.getText(node, ((Calendar)value).getTime());
            }
            return "";
        }
    }

    public static class CalendarEditor
    extends AbstractCellEditor
    implements ITreeTableCellEditor {
        private final SpinnerDateModel dateModel = new SpinnerDateModel();
        private final JSpinner spinner = new JSpinner(this.dateModel);
        private Calendar calendar;

        public Component getEditorComponent(Object value) {
            this.calendar = Calendar.getInstance();
            if (value != null) {
                this.calendar = (Calendar)((Calendar)value).clone();
            }
            this.dateModel.setValue(this.calendar.getTime());
            return this.spinner;
        }

        @Override
        public Component getTreeTableCellEditorComponent(TreeTable tree, Object value, boolean selected, int row, int column) {
            return this.getEditorComponent(value);
        }

        @Override
        public Object getCellEditorValue() {
            Date date = (Date)this.dateModel.getValue();
            this.calendar.setTime(date);
            return this.calendar;
        }
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements ITreeTableCellRenderer {
        private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.setOpaque(false);
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable tree, Object node, Object value, int depth, boolean selected, boolean expanded, boolean leaf, int row, int column, boolean hasFocus) {
            if (selected) {
                this.setForeground(tree.getSelectionForeground());
                super.setBackground(tree.getSelectionBackground());
            } else {
                this.setForeground(tree.getForeground());
                super.setBackground(tree.getBackground(row));
            }
            this.setEnabled(tree.isEnabled());
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(NO_FOCUS_BORDER);
            }
            return this;
        }

        @Override
        public boolean isVisible() {
            return false;
        }
    }

    public static class BooleanEditor
    extends DefaultTreeTableCellEditor {
        public BooleanEditor() {
            super(new JCheckBox());
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setHorizontalAlignment(0);
        }
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!TreeTable.this.isEditing()) {
                return;
            }
            for (Component c2 = this.focusManager.getPermanentFocusOwner(); c2 != null; c2 = c2.getParent()) {
                if (c2 == TreeTable.this) {
                    return;
                }
                if (!(c2 instanceof Window) && (!(c2 instanceof Applet) || c2.getParent() != null)) continue;
                if (c2 != SwingUtilities.getRoot(TreeTable.this) || TreeTable.this.getCellEditor().stopCellEditing()) break;
                TreeTable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    class CollapseNodeTimingTarget
    extends AbstractNodeTimingTarget {
        private boolean recursive;

        public CollapseNodeTimingTarget(TreeTableNode node, boolean recursive) {
            super(node);
            this.recursive = recursive;
        }

        @Override
        public void begin() {
            TreeTable.this.animationPercentage = 0.0;
        }

        @Override
        public void end() {
            TreeTable.this.animationPercentage = 1.0;
            TreeTableNode node = this.getTimingTargetNode();
            this.timingTargetNode = null;
            if (this.recursive) {
                try {
                    TreeTable.this.doCollapseRecursively(node);
                }
                catch (ExpandVetoException e2) {
                    LOGGER.throwing(TreeTable.class.getName(), "doExpandCollapse(TreePath, boolean, boolean)", e2);
                }
            }
            if (TreeTable.this.rootVisible || node != TreeTable.this.root) {
                node.collapse();
            }
            TreeTable.this.updateNodes();
            this.repaintComponents();
            TreeTable.this.fireTreeCollapsed(node.getPath());
        }

        @Override
        public void timingEvent(float fraction) {
            TreeTable.this.animationPercentage = fraction;
            this.repaintComponents();
        }
    }

    class ExpandNodeTimingTarget
    extends AbstractNodeTimingTarget {
        public ExpandNodeTimingTarget(TreeTableNode node) {
            super(node);
        }

        @Override
        public void begin() {
            TreeTable.this.animationPercentage = 0.0;
            TreeTable.this.updateNodes();
        }

        @Override
        public void end() {
            TreePath path = this.timingTargetNode.getPath();
            this.timingTargetNode = null;
            TreeTable.this.animationPercentage = 1.0;
            this.repaintComponents();
            TreeTable.this.fireTreeExpanded(path);
        }

        @Override
        public void timingEvent(float fraction) {
            TreeTable.this.animationPercentage = fraction;
            this.repaintComponents();
        }
    }

    abstract class AbstractNodeTimingTarget
    extends TimingTargetAdapter {
        protected TreeTableNode timingTargetNode;

        public AbstractNodeTimingTarget(TreeTableNode node) {
            this.timingTargetNode = node;
        }

        public TreeTableNode getTimingTargetNode() {
            return this.timingTargetNode;
        }

        protected void repaintComponents() {
            TreeTable.this.repaint();
            if (TreeTable.this.treeTableRowHeader != null) {
                TreeTable.this.treeTableRowHeader.repaint();
            }
            if (TreeTable.this.lc != null) {
                TreeTable.this.lc.repaint();
            }
        }
    }

    class NewEntryNode
    extends TreeTableNode {
        public NewEntryNode(TreeTable table) {
            super(table, new DefaultGanttChartNode());
            DefaultGanttChartNode node = (DefaultGanttChartNode)this.getModelNode();
            node.setKeyEditable(true);
        }

        @Override
        public boolean isNewEntryPlaceholder() {
            return true;
        }
    }

    class RootNode
    extends TreeTableNode {
        private final NewEntryNode newEntryNode;

        public RootNode(TreeTable table, Object data) {
            super(table, data);
            this.newEntryNode = new NewEntryNode(table);
            this.newEntryNode.setParent(this);
        }

        @Override
        protected void load(Map<Object, TreeTableNode> tableCache) {
            super.load(tableCache);
            if (TreeTable.this.isCreationEnabled()) {
                TreeTableNode[] oldChildren = this.getChildren();
                int length = oldChildren.length;
                TreeTableNode[] newChildren = new TreeTableNode[length + 1];
                System.arraycopy(oldChildren, 0, newChildren, 0, length);
                newChildren[length] = this.newEntryNode;
                this.children = newChildren;
            }
        }

        @Override
        public int getChildCount() {
            int count = super.getChildCount();
            if (TreeTable.this.isCreationEnabled()) {
                ++count;
            }
            return count;
        }

        @Override
        public Object getChildAt(int index) {
            return this.children[index];
        }
    }
}

