/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.swing.treetable.ITreeTableCellRenderer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class DefaultTreeTableCellRenderer
extends JLabel
implements ITreeTableCellRenderer {
    private Color dragBackgroundColor = Color.WHITE;
    private Icon collapsedIcon = IconRegistry.getIcon(IconId.FOLDER_CLOSED);
    private Icon expandedIcon = IconRegistry.getIcon(IconId.FOLDER_OPEN);
    private Icon leafIcon = IconRegistry.getIcon(IconId.LEAF);
    private boolean dragged;
    private Color focusColor = Color.BLACK;

    public DefaultTreeTableCellRenderer() {
        this.setDoubleBuffered(true);
        this.setOpaque(false);
    }

    @Override
    public Component getTreeTableCellRendererComponent(TreeTable tree, Object node, Object value, int depth, boolean selected, boolean expanded, boolean leaf, int row, int column, boolean hasFocus) {
        this.setFont(tree.getFont());
        this.setForeground(tree.getForeground(row, true));
        this.setEnabled(tree.isEnabled());
        boolean bl = this.dragged = column == Integer.MIN_VALUE;
        if (column == -1) {
            this.setBorder(new EmptyBorder(2, 4 + depth * tree.getInset(), 2, 4));
        } else if (column == Integer.MIN_VALUE) {
            this.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(2, 4, 2, 4)));
        } else {
            this.setBorder(new EmptyBorder(2, 4, 2, 4));
        }
        this.setText(this.getText(node, value));
        this.setIcon(this.getIcon(node, value, column, leaf, expanded));
        return this;
    }

    protected Icon getIcon(Object node, Object value, int column, boolean leaf, boolean expanded) {
        if (column == -1 || column == Integer.MIN_VALUE) {
            if (value == null) {
                return null;
            }
            if (leaf) {
                return this.leafIcon;
            }
            if (expanded) {
                return this.expandedIcon;
            }
            return this.collapsedIcon;
        }
        return null;
    }

    protected String getText(Object node, Object value) {
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (this.dragged) {
            Graphics2D g2d = (Graphics2D)g2;
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2d.setColor(this.dragBackgroundColor);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setComposite(comp);
        }
        super.paintComponent(g2);
    }

    protected boolean isDragged() {
        return this.dragged;
    }

    public Color getFocusColor() {
        return this.focusColor;
    }

    public void setFocusColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.focusColor = color;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("icon can not be NULL");
        }
        this.collapsedIcon = icon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setExpandedIcon(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("icon can not be NULL");
        }
        this.expandedIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setLeafIcon(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("icon can not be NULL");
        }
        this.leafIcon = icon;
    }

    public Color getDragBackgroundColor() {
        return this.dragBackgroundColor;
    }

    public void setDragBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.dragBackgroundColor = color;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x2, int y2, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

