/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class EventlineObjectPanel
extends JPanel {
    private JTextField labelField;
    private JCheckBox typeBox;
    private JSpinner startTimeSpinner;
    private JSpinner endTimeSpinner;
    private boolean cancelled;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private Eventline eventline;

    public EventlineObjectPanel(Eventline eventline) {
        this.eventline = eventline;
        this.setBorder(new EmptyBorder(10, 10, 5, 10));
        this.labelField = this.createLabelField();
        this.typeBox = this.createTypeBox();
        this.startTimeSpinner = this.createStartTimeSpinner();
        this.endTimeSpinner = this.createEndTimeSpinner();
        this.endTimeSpinner.setEnabled(false);
        this.okButton = this.createOKButton();
        this.cancelButton = this.createCancelButton();
        this.buttonPanel = this.createButtonPanel();
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        JLabel label = new JLabel(Messages.getString("EventlineObjectPanel.LABEL"));
        label.setHorizontalAlignment(2);
        this.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        this.add((Component)this.labelField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        this.add((Component)this.typeBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        label = new JLabel(Messages.getString("EventlineObjectPanel.START_TIME"));
        label.setHorizontalAlignment(2);
        this.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.startTimeSpinner, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        label = new JLabel(Messages.getString("EventlineObjectPanel.END_TIME"));
        label.setHorizontalAlignment(2);
        this.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.endTimeSpinner, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridwidth = 2;
        this.add((Component)this.buttonPanel, gbc);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                EventlineObjectPanel.this.okPressed();
                SwingUtilities.getWindowAncestor(EventlineObjectPanel.this).setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                EventlineObjectPanel.this.cancelled = true;
                EventlineObjectPanel.this.cancelPressed();
                SwingUtilities.getWindowAncestor(EventlineObjectPanel.this).setVisible(false);
            }
        });
        this.typeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                EventlineObjectPanel.this.endTimeSpinner.setEnabled(EventlineObjectPanel.this.typeBox.isSelected());
            }
        });
        this.okButton.requestFocusInWindow();
    }

    protected void okPressed() {
    }

    protected void cancelPressed() {
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected JButton createOKButton() {
        return new JButton(Messages.getString("EventlineObjectPanel.OK_BUTTON"));
    }

    protected JButton createCancelButton() {
        return new JButton(Messages.getString("EventlineObjectPanel.CANCEL_BUTTON"));
    }

    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        panel.add(this.okButton);
        panel.add(this.cancelButton);
        return panel;
    }

    protected JSpinner createStartTimeSpinner() {
        SpinnerDateModel dateModel = new SpinnerDateModel();
        JSpinner spinner = new JSpinner(dateModel);
        spinner.setValue(Calendar.getInstance(this.eventline.getDateline().getTimeZone()).getTime());
        return spinner;
    }

    protected JSpinner createEndTimeSpinner() {
        SpinnerDateModel dateModel = new SpinnerDateModel();
        JSpinner spinner = new JSpinner(dateModel);
        spinner.setValue(Calendar.getInstance(this.eventline.getDateline().getTimeZone()).getTime());
        return spinner;
    }

    protected JCheckBox createTypeBox() {
        JCheckBox box = new JCheckBox(Messages.getString("EventlineObjectPanel.ACTIVITY_CHECKBOX"));
        box.setSelected(false);
        return box;
    }

    protected JTextField createLabelField() {
        return new JTextField(Messages.getString("EventlineObjectPanel.UNTITLED_PLACEHOLDER"));
    }

    public JSpinner getStartTimeSpinner() {
        return this.startTimeSpinner;
    }

    public JSpinner getEndTimeSpinner() {
        return this.endTimeSpinner;
    }

    public JTextField getLabelField() {
        return this.labelField;
    }

    public JCheckBox getTypeBox() {
        return this.typeBox;
    }

    public void setTimeSpan(ITimeSpan span) {
        this.startTimeSpinner.setValue(new Date(span.getStartTime()));
        this.endTimeSpinner.setValue(new Date(span.getEndTime()));
        this.typeBox.setSelected(!span.isEvent());
        if (!span.isEvent()) {
            this.endTimeSpinner.setEnabled(true);
        }
    }

    public ITimeSpan getTimeSpan() {
        long start;
        long end = start = ((Date)this.startTimeSpinner.getValue()).getTime();
        if (this.typeBox.isSelected()) {
            end = ((Date)this.endTimeSpinner.getValue()).getTime();
        }
        return new TimeSpan(start, end);
    }
}

