/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.eventline.DefaultCreateEventlineObjectCommand;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.GridLine;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.dateline.MarkerType;
import com.dlsc.flexgantt.model.eventline.DefaultEventlineModel;
import com.dlsc.flexgantt.model.eventline.DefaultEventlineSelectionModel;
import com.dlsc.flexgantt.model.eventline.EventlineModelEvent;
import com.dlsc.flexgantt.model.eventline.EventlineSelectionModelEvent;
import com.dlsc.flexgantt.model.eventline.IEventlineModel;
import com.dlsc.flexgantt.model.eventline.IEventlineModelListener;
import com.dlsc.flexgantt.model.eventline.IEventlineSelectionListener;
import com.dlsc.flexgantt.model.eventline.IEventlineSelectionModel;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.PolicyProvider;
import com.dlsc.flexgantt.policy.eventline.DefaultEditEventlineObjectPolicy;
import com.dlsc.flexgantt.policy.eventline.DefaultEventlineLabelPolicy;
import com.dlsc.flexgantt.policy.eventline.DefaultEventlineSelectionPolicy;
import com.dlsc.flexgantt.policy.eventline.IEditEventlineObjectPolicy;
import com.dlsc.flexgantt.policy.eventline.IEventlineLabelPolicy;
import com.dlsc.flexgantt.policy.eventline.IEventlineSelectionPolicy;
import com.dlsc.flexgantt.policy.layer.IGridPolicy;
import com.dlsc.flexgantt.policy.layer.TimeGranularityGridPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.ICommandInterceptor;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.IGridComponentListener;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.DragLayerEvent;
import com.dlsc.flexgantt.swing.layer.system.IDragLayerListener;
import com.dlsc.flexgantt.swing.layer.system.ILassoLayerListener;
import com.dlsc.flexgantt.swing.layer.system.LassoLayer;
import com.dlsc.flexgantt.swing.layer.system.LassoLayerEvent;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.DefaultEventlineMenuProvider;
import com.dlsc.flexgantt.swing.timeline.DefaultEventlineObjectRenderer;
import com.dlsc.flexgantt.swing.timeline.EventlineObjectPanel;
import com.dlsc.flexgantt.swing.timeline.IEventlineMenuProvider;
import com.dlsc.flexgantt.swing.timeline.IEventlineObjectRenderer;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.util.LabelType;
import com.dlsc.flexgantt.util.Messages;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class Eventline
extends JPanel
implements IEventlineModelListener,
IEventlineSelectionListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener,
IGridComponent,
IDragLayerListener,
ILassoLayerListener,
KeyEventDispatcher {
    private static final Logger LOGGER = Logger.getLogger(Eventline.class.getName());
    public static final String PROPERTY_TIME_NOW = "timeNow";
    public static final String PROPERTY_EVENTLINE_MODEL = "eventlineModel";
    public static final String PROPERTY_EVENTLINE_SELECTION_MODEL = "eventlineSelectionModel";
    public static final String PROPERTY_POLICY_PROVIDER = "policyProvider";
    public static final String PROPERTY_CREATE_EVENTLNE_OBJECTS_ENABLED = "createEventlineObjectsEnabled";
    private Dateline dateline;
    private Timeline timeline;
    private boolean timeNowVisible = true;
    private long timeNow;
    private IEventlineModel model;
    private IEventlineSelectionModel selectionModel;
    private CellRendererPane rendererPane = new CellRendererPane();
    private IPolicyProvider policyProvider = new PolicyProvider();
    private Object activeEventlineObject;
    private long dragStartTime;
    private ITimeSpan dragSpan;
    private Map<Object, ObjectBounds> boundsMap = new HashMap<Object, ObjectBounds>();
    private IEventlineMenuProvider menuProvider = new DefaultEventlineMenuProvider();
    private JPopupMenu popup;
    private Map<Class, IEventlineObjectRenderer> rendererMap;
    private Map<Class, IEventlineObjectRenderer> rendererCache;
    private Color gridColor = ColorUtil.getGridColor();
    private IGranularity gridGranularity;
    private boolean createEventlineObjectsEnabled = true;
    private Color markerFillColor1 = new Color(255, 255, 235);
    private Color markerFillColor2 = new Color(255, 255, 155);
    private boolean gridAutomatic = true;
    private ITimeSpan dragLayerSpan;
    private Color selectionColor = ColorUtil.getSelectionBackground();
    private boolean gridControlVisible = true;
    private boolean gridAdjustedMouseCursorTime;
    private Map<EventlineEditMode, Cursor> cursorMap;
    private EventlineEditMode editMode = EventlineEditMode.NONE;
    private int resizeHandleSize = 10;
    private boolean timeNowOnTop = true;
    private KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
    private boolean showingDSTMarkers = true;
    private int lookAheadSize = 100;

    public Eventline(Timeline timeline, Dateline dateline) {
        if (timeline == null) {
            throw new IllegalArgumentException("timeline can not be NULL");
        }
        if (dateline == null) {
            throw new IllegalArgumentException("dateline can not be NULL");
        }
        this.setName("Eventline");
        this.cursorMap = new HashMap<EventlineEditMode, Cursor>();
        for (EventlineEditMode mode : EventlineEditMode.values()) {
            Cursor cursor = this.createEditModeCursor(mode);
            this.cursorMap.put(mode, cursor);
        }
        this.rendererMap = new HashMap<Class, IEventlineObjectRenderer>(10);
        this.rendererCache = new HashMap<Class, IEventlineObjectRenderer>(10);
        this.setEventlineObjectRenderer(Object.class, new DefaultEventlineObjectRenderer());
        this.policyProvider.setPolicy(IEventlineLabelPolicy.class, new DefaultEventlineLabelPolicy());
        this.policyProvider.setPolicy(IEditEventlineObjectPolicy.class, new DefaultEditEventlineObjectPolicy());
        this.policyProvider.setPolicy(IGridPolicy.class, new TimeGranularityGridPolicy());
        this.policyProvider.setPolicy(IEventlineSelectionPolicy.class, new DefaultEventlineSelectionPolicy());
        this.timeline = timeline;
        this.dateline = dateline;
        this.timeNow = Calendar.getInstance(dateline.getModel().getTimeZone()).getTimeInMillis();
        this.setModel(new DefaultEventlineModel());
        this.setSelectionModel(new DefaultEventlineSelectionModel());
        this.setOpaque(false);
        this.setLayout(null);
        this.setAutoscrolls(true);
        this.setFocusable(false);
        this.add(this.rendererPane);
        dateline.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
                LOGGER.fine("repainting due to property change event from dateline: " + e2);
                Eventline.this.repaint();
            }
        });
        this.addMouseWheelListener(dateline);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addPropertyChangeListener(this);
        this.keyboardFocusManager.addKeyEventDispatcher(this);
        AbstractGanttChart gc2 = timeline.getGanttChart();
        gc2.setCommandInterceptor(DefaultCreateEventlineObjectCommand.class, new ICommandInterceptor(){

            public boolean intercept(AbstractGanttChart gc2, ICommand cmd) {
                DefaultCreateEventlineObjectCommand createCmd = (DefaultCreateEventlineObjectCommand)cmd;
                ITimeSpan span = createCmd.getTimeSpan();
                EventlineObjectPanel panel = new EventlineObjectPanel(Eventline.this);
                panel.getTypeBox().setSelected(!span.isEvent());
                panel.setTimeSpan(span);
                Window window = SwingUtilities.getWindowAncestor(gc2);
                JDialog dialog = null;
                if (window instanceof Frame) {
                    dialog = new JDialog((Frame)window, Messages.getString("Eventline.EDIT_DIALOG_TITLE"));
                } else if (window instanceof Dialog) {
                    dialog = new JDialog((Dialog)window, Messages.getString("Eventline.EDIT_DIALOG_TITLE"));
                }
                if (dialog != null) {
                    dialog.setLocationRelativeTo(gc2);
                    dialog.setResizable(false);
                    dialog.add("Center", panel);
                    dialog.setModal(true);
                    dialog.pack();
                    dialog.setVisible(true);
                }
                if (!panel.isCancelled()) {
                    createCmd.setTimeSpan(panel.getTimeSpan());
                    createCmd.setEventlineObjectName(panel.getLabelField().getText());
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public IGranularity getGridGranularity() {
        return this.gridGranularity;
    }

    @Override
    public String getGridComponentName() {
        return Messages.getString("Eventline.GRID_COMPONENT_NAME");
    }

    @Override
    public void setGridGranularity(IGranularity granularity) {
        this.gridGranularity = granularity;
        this.fireGridChanged();
    }

    @Override
    public void setGridAutomatic(boolean auto) {
        this.gridAutomatic = auto;
        this.fireGridChanged();
    }

    @Override
    public boolean isGridAutomatic() {
        return this.gridAutomatic;
    }

    public void setGridControlVisible(boolean b2) {
        this.gridControlVisible = b2;
        this.fireGridChanged();
    }

    @Override
    public boolean isGridControlVisible() {
        return this.gridControlVisible;
    }

    @Override
    public IGridPolicy getGridPolicy() {
        return this.policyProvider.getPolicy(IGridPolicy.class);
    }

    public IPolicyProvider getPolicyProvider() {
        return this.policyProvider;
    }

    public void setPolicyProvider(IPolicyProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("policy provider can not be NULL");
        }
        IPolicyProvider oldProvider = this.policyProvider;
        this.policyProvider = provider;
        this.firePropertyChange(PROPERTY_POLICY_PROVIDER, oldProvider, provider);
    }

    public Object[] getEventlineObjectsAt(int x2, int y2) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ObjectBounds ob2 : this.boundsMap.values()) {
            if (!ob2.contains(x2, y2)) continue;
            list.add(ob2.eventlineObject);
            Collections.sort(list, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    ITimeSpan span1 = Eventline.this.model.getTimeSpan(o1);
                    ITimeSpan span2 = Eventline.this.model.getTimeSpan(o2);
                    return span1.compareTo(span2);
                }
            });
        }
        return list.toArray();
    }

    public Object getTopMostEventlineObjectAt(int x2, int y2) {
        Object[] obj = this.getEventlineObjectsAt(x2, y2);
        if (obj != null && obj.length > 0) {
            return obj[obj.length - 1];
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        Font font = this.getFont();
        FontMetrics fm = this.getFontMetrics(font);
        return new Dimension(0, fm.getHeight() + 4);
    }

    public IEventlineModel getModel() {
        return this.model;
    }

    public void setModel(IEventlineModel model) {
        if (model == null) {
            throw new IllegalArgumentException("eventline model can not be NULL");
        }
        IEventlineModel oldModel = this.model;
        if (oldModel != null) {
            oldModel.removeEventlineModelListener(this);
        }
        this.model = model;
        this.model.addEventlineModelListener(this);
        this.firePropertyChange(PROPERTY_EVENTLINE_MODEL, oldModel, model);
    }

    public IEventlineSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(IEventlineSelectionModel model) {
        if (model == null) {
            throw new IllegalArgumentException("eventline selection model can not be NULL");
        }
        IEventlineSelectionModel oldModel = this.selectionModel;
        if (oldModel != null) {
            oldModel.removeEventlineSelectionListener(this);
        }
        this.selectionModel = model;
        this.selectionModel.addEventlineSelectionListener(this);
        this.firePropertyChange(PROPERTY_EVENTLINE_SELECTION_MODEL, oldModel, model);
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public Dateline getDateline() {
        return this.dateline;
    }

    public void setTimeNowVisible(boolean visible) {
        this.timeNowVisible = visible;
    }

    public boolean isTimeNowVisible() {
        return this.timeNowVisible;
    }

    public void setTimeNow(long time) {
        long oldTime = this.timeNow;
        this.timeNow = time;
        this.firePropertyChange(PROPERTY_TIME_NOW, oldTime, time);
    }

    public long getTimeNow() {
        return this.timeNow;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        IDatelineModel model = this.dateline.getModel();
        Rectangle clip = this.getVisibleRect();
        if (this.showingDSTMarkers && model.getGranularity().isDisplayingMarkerType(MarkerType.DAYLIGHT_SAVINGS_TIME)) {
            List<GridLine> minorGrid = model.getGrid(clip.x - this.lookAheadSize, clip.x + clip.width + 2 * this.lookAheadSize, false);
            for (GridLine gl : minorGrid) {
                if (gl.getDstChangeType().equals((Object)GridLine.DstChangeType.NO_CHANGE)) continue;
                this.paintDSTMarker(g2, gl);
            }
        }
        if (this.dragLayerSpan == null && this.timeNowVisible && !this.timeNowOnTop) {
            String label = model.getTimeString(this.timeNow);
            int nowX = this.dateline.getTimeLocation(this.timeNow);
            this.paintMarker(g2, nowX, label, true);
        }
        this.paintEventlineObjects(g2);
        Point cursor = this.timeline.getCursorLocation();
        if (this.dragLayerSpan == null && cursor != Timeline.UNDEF_CURSOR && this.activeEventlineObject == null && this.getMousePosition() == null && !this.dateline.isAnimationThreadRunning()) {
            long cursorTime = this.dateline.getTimeAt(cursor.x);
            if (this.gridAdjustedMouseCursorTime) {
                IGranularity granularity = this.timeline.getCursorGranularity();
                IGridPolicy gridPolicy = this.timeline.getCursorGridPolicy();
                if (granularity != null && gridPolicy != null) {
                    cursorTime = gridPolicy.getGridAdjustedStartTime(granularity, cursorTime, model, false);
                    cursor.x = this.dateline.getTimeLocation(cursorTime);
                }
            }
            String label = model.getTimeString(cursorTime);
            this.paintMarker(g2, cursor.x, label, true);
        }
        if (this.dragSpan != null && this.activeEventlineObject == null) {
            int x1 = this.dateline.getTimeLocation(this.dragSpan.getStartTime());
            int x2 = this.dateline.getTimeLocation(this.dragSpan.getEndTime());
            g2.setColor(this.selectionColor);
            g2.fillRect(x1, 0, x2 - x1, this.getHeight());
        }
        if (this.dragLayerSpan != null) {
            int x1 = this.dateline.getTimeLocation(this.dragLayerSpan.getStartTime());
            int x2 = this.dateline.getTimeLocation(this.dragLayerSpan.getEndTime());
            String label1 = model.getTimeString(this.dragLayerSpan.getStartTime());
            String label2 = model.getTimeString(this.dragLayerSpan.getEndTime());
            this.paintMarker(g2, x1, label1, false);
            if (x2 > x1) {
                this.paintMarker(g2, x2, label2, true);
            }
        }
        if (this.dragLayerSpan == null && this.timeNowVisible && this.timeNowOnTop) {
            String label = model.getTimeString(this.timeNow);
            int nowX = this.dateline.getTimeLocation(this.timeNow);
            this.paintMarker(g2, nowX, label, true);
        }
        g2.setColor(this.gridColor);
        g2.drawLine(clip.x, 0, clip.x + clip.width, 0);
    }

    protected void paintMarker(Graphics g2, int x2, String label, boolean leftAligned) {
        if (this.dragSpan == null && x2 < Integer.MAX_VALUE) {
            int h2 = this.getHeight();
            int my = 4;
            int gap = 6;
            FontMetrics fm = g2.getFontMetrics();
            int strWidth = fm.stringWidth(label) + gap;
            int[] xx = null;
            int[] yy = null;
            if (leftAligned) {
                int[] xxLeft = new int[]{x2 - gap, x2 - 3, x2, x2 + 3, x2 + strWidth, x2 + strWidth, x2 - gap, x2 - gap};
                int[] yyLeft = new int[]{my, my, 1, my, my, h2, h2, my};
                xx = xxLeft;
                yy = yyLeft;
            } else {
                int[] xxRight = new int[]{x2 - strWidth, x2 - 3, x2, x2 + 3, x2 + gap, x2 + gap, x2 - strWidth, x2 - strWidth};
                int[] yyRight = new int[]{my, my, 1, my, my, h2, h2, my};
                xx = xxRight;
                yy = yyRight;
            }
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.markerFillColor1, 0.0f, h2, this.markerFillColor2));
            g2d.fillPolygon(xx, yy, 8);
            g2d.setColor(this.gridColor);
            g2d.drawPolygon(xx, yy, 8);
            g2d.setColor(this.timeline.getForeground());
            g2d.drawString(label, xx[0] + gap, h2 - 2);
        }
    }

    protected void paintDSTMarker(Graphics g2, GridLine gl) {
        g2.setColor(this.gridColor);
        int h2 = this.getHeight();
        int x2 = gl.getLocation();
        g2.drawLine(x2, 0, x2, h2);
        x2 += 2;
        g2.setColor(this.getForeground());
        Icon icon = null;
        String text = "";
        if (gl.getDstChangeType().equals((Object)GridLine.DstChangeType.SUMMER_TIME_TO_WINTER_TIME)) {
            icon = IconRegistry.getIcon(IconId.DAYLIGHT_SAVINGS_TIME_BEGIN);
            text = Messages.getString("Eventline.DAYLIGHT_SAVINGS_TIME_START");
        } else if (gl.getDstChangeType().equals((Object)GridLine.DstChangeType.WINTER_TIME_TO_SUMMER_TIME)) {
            icon = IconRegistry.getIcon(IconId.DAYLIGHT_SAVINGS_TIME_END);
            text = Messages.getString("Eventline.DAYLIGHT_SAVINGS_TIME_END");
        }
        if (icon != null) {
            icon.paintIcon(this, g2, x2, (h2 - icon.getIconHeight()) / 2 + 1);
        }
        FontMetrics fm = g2.getFontMetrics();
        int ascent = fm.getAscent();
        g2.drawString(text, x2 + icon.getIconWidth() + 2, h2 / 2 + ascent / 2 - 1);
    }

    protected void paintEventlineObjects(Graphics g2) {
        this.boundsMap.clear();
        Rectangle visible = this.dateline.getVisibleRect();
        visible.x = Math.max(0, visible.x - this.lookAheadSize);
        visible.width = Math.min(this.getWidth(), visible.width + 2 * this.lookAheadSize);
        long t1 = this.dateline.getTimeAt(visible.x);
        long t2 = this.dateline.getTimeAt(visible.x + visible.width);
        if (t1 >= 0L && t2 >= 0L) {
            TimeSpan span = new TimeSpan(t1, t2);
            Iterator iterator = this.model.getEventlineObjectsIterator(span);
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                ITimeSpan objSpan = this.model.getTimeSpan(obj);
                this.paintEventlineObject(g2, obj, objSpan);
            }
            Graphics2D g2d = (Graphics2D)g2;
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
            if (this.activeEventlineObject != null && this.dragSpan != null) {
                this.paintEventlineObject(g2, this.activeEventlineObject, this.dragSpan);
            }
            g2d.setComposite(comp);
        }
    }

    protected void paintEventlineObject(Graphics g2, Object obj, ITimeSpan objSpan) {
        IEventlineLabelPolicy lp;
        String label;
        Class<?> cl = obj.getClass();
        IEventlineObjectRenderer renderer = this.getEventlineObjectRenderer(cl);
        Component comp = renderer.getEventlineRendererComponent(this, obj, this.selectionModel.isSelected(obj), obj.equals(this.activeEventlineObject));
        Insets insets = renderer.getEventlineRendererInsets();
        int x1 = this.dateline.getTimeLocation(objSpan.getStartTime());
        int x2 = this.dateline.getTimeLocation(objSpan.getEndTime());
        Rectangle bounds = new Rectangle();
        bounds.x = x1 + insets.left;
        bounds.y = insets.top + 1;
        bounds.width = x2 - x1 - insets.left - insets.right;
        bounds.height = this.getHeight() - insets.top - insets.bottom - 1;
        this.rendererPane.paintComponent(g2, comp, this, bounds.x, bounds.y, bounds.width, bounds.height, true);
        if (objSpan.isEvent() && (label = (lp = this.policyProvider.getPolicy(IEventlineLabelPolicy.class)).getLabel(obj, this.model, LabelType.NAME)) != null) {
            g2.setColor(this.getForeground());
            FontMetrics fm = g2.getFontMetrics();
            int ascent = fm.getAscent();
            int fontY = this.getHeight() / 2 + ascent / 2;
            g2.drawString(label, bounds.x + bounds.width + 4, fontY);
        }
        ObjectBounds ob2 = new ObjectBounds(obj);
        this.boundsMap.put(obj, ob2);
        ob2.x = bounds.x;
        ob2.y = bounds.y;
        ob2.width = bounds.width;
        ob2.height = bounds.height;
    }

    public IEventlineMenuProvider getMenuProvider() {
        return this.menuProvider;
    }

    public void setMenuProvider(IEventlineMenuProvider provider) {
        this.menuProvider = provider;
    }

    @Override
    public void eventlineChanged(EventlineModelEvent evt) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    private void selectObjects(MouseEvent e2) {
        IEventlineSelectionPolicy sp;
        Object topObject;
        Object[] currentSelection = this.selectionModel.getSelection();
        if (!(e2.isShiftDown() || e2.isControlDown() || e2.isPopupTrigger())) {
            this.selectionModel.clearSelection();
        }
        if ((topObject = this.getTopMostEventlineObjectAt(e2.getX(), e2.getY())) != null && (sp = this.policyProvider.getPolicy(IEventlineSelectionPolicy.class)).isSelectable(topObject, this.model)) {
            if (this.selectionModel.isSelected(topObject) && !e2.isPopupTrigger()) {
                this.selectionModel.removeSelection(topObject);
            } else {
                boolean previouslySelected = false;
                if (currentSelection != null) {
                    for (Object o2 : currentSelection) {
                        if (!o2.equals(topObject)) continue;
                        previouslySelected = true;
                        break;
                    }
                }
                if (!previouslySelected) {
                    this.selectionModel.addSelection(topObject);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        if (this.dragSpan == null) {
            this.activeEventlineObject = null;
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.timeline.getGanttChart().requestFocus();
        if (!this.maybeShowPopup(e2) && SwingUtilities.isLeftMouseButton(e2)) {
            this.selectObjects(e2);
            switch (this.editMode) {
                case CHANGE_END_TIME: 
                case CHANGE_START_TIME: 
                case CHANGE_TIME_SPAN: {
                    Object topObject = this.getTopMostEventlineObjectAt(e2.getX(), e2.getY());
                    if (topObject == null) break;
                    this.dragStartTime = this.dateline.getTimeAt(e2.getX());
                    this.dragSpan = this.model.getTimeSpan(topObject);
                    this.activeEventlineObject = topObject;
                    break;
                }
                case CREATE_EVENTLINE_OBJECT: {
                    this.dragStartTime = this.dateline.getTimeAt(e2.getX());
                    this.dragSpan = new TimeSpan(this.dragStartTime);
                    break;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        IEditEventlineObjectPolicy ep = this.policyProvider.getPolicy(IEditEventlineObjectPolicy.class);
        ICommand cmd = null;
        if (!this.maybeShowPopup(e2)) {
            switch (this.editMode) {
                case CHANGE_END_TIME: 
                case CHANGE_START_TIME: 
                case CHANGE_TIME_SPAN: {
                    ITimeSpan currentSpan;
                    if (this.activeEventlineObject == null || (currentSpan = this.model.getTimeSpan(this.activeEventlineObject)).equals(this.dragSpan)) break;
                    cmd = ep.getChangeTimeSpanCommand(this.activeEventlineObject, this.model, this.dragSpan);
                    break;
                }
                case CREATE_EVENTLINE_OBJECT: {
                    if (!this.createEventlineObjectsEnabled || !ep.isCreatable(this.model, this.dragSpan)) break;
                    cmd = ep.getCreateCommand(this.model, this.dragSpan);
                    break;
                }
            }
            this.activeEventlineObject = null;
            this.dragSpan = null;
            if (cmd != null) {
                this.timeline.getGanttChart().commandExecute(cmd);
                this.repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        IGridPolicy gp = this.policyProvider.getPolicy(IGridPolicy.class);
        long time = this.dateline.getTimeAt(e2.getX());
        long diff = time - this.dragStartTime;
        IDatelineModel datelineModel = this.dateline.getModel();
        if (!this.getVisibleRect().contains(new Point(e2.getX(), 0))) {
            Container parent = this.getParent();
            while (!(parent instanceof JScrollPane)) {
                parent = parent.getParent();
            }
            JScrollPane sp = (JScrollPane)parent;
            LayerContainer lc2 = (LayerContainer)sp.getViewport().getView();
            Point loc = lc2.getLocation();
            lc2.scrollRectToVisible(new Rectangle(e2.getX(), loc.y, 1, 1));
        }
        if (this.activeEventlineObject != null) {
            ITimeSpan span = this.model.getTimeSpan(this.activeEventlineObject);
            switch (this.editMode) {
                case CHANGE_TIME_SPAN: {
                    if (this.gridGranularity != null || this.gridAutomatic) {
                        this.dragSpan = gp.getGridAdjustedTimeSpan(this.gridGranularity, span.move(diff), datelineModel, this.gridAutomatic);
                        break;
                    }
                    this.dragSpan = span.move(diff);
                    break;
                }
                case CHANGE_END_TIME: {
                    if (this.gridGranularity != null || this.gridAutomatic) {
                        this.dragSpan = gp.getGridAdjustedTimeSpan(this.gridGranularity, new TimeSpan(span.getStartTime(), span.getEndTime() + diff), datelineModel, this.gridAutomatic);
                        break;
                    }
                    this.dragSpan = new TimeSpan(span.getStartTime(), span.getEndTime() + diff);
                    break;
                }
                case CHANGE_START_TIME: {
                    if (this.gridGranularity != null || this.gridAutomatic) {
                        this.dragSpan = gp.getGridAdjustedTimeSpan(this.gridGranularity, new TimeSpan(span.getStartTime() + diff, span.getEndTime()), datelineModel, this.gridAutomatic);
                        break;
                    }
                    this.dragSpan = new TimeSpan(span.getStartTime() + diff, span.getEndTime());
                    break;
                }
            }
            if (span.isEvent()) {
                this.dragSpan = new TimeSpan(this.dragSpan.getStartTime());
            }
            this.repaint();
        } else if (this.createEventlineObjectsEnabled && e2.isAltDown()) {
            long st = Math.min(this.dragStartTime, time);
            long et = Math.max(this.dragStartTime, time);
            this.dragSpan = this.gridGranularity != null || this.gridAutomatic ? gp.getGridAdjustedTimeSpan(this.gridGranularity, new TimeSpan(st, et), datelineModel, this.gridAutomatic) : new TimeSpan(st, et);
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        Object oldObject = this.activeEventlineObject;
        this.activeEventlineObject = this.getTopMostEventlineObjectAt(e2.getX(), e2.getY());
        if (oldObject != null && this.activeEventlineObject == null || oldObject != null && this.activeEventlineObject == null || oldObject != null && this.activeEventlineObject != null && !this.activeEventlineObject.equals(oldObject)) {
            this.repaint();
        }
        this.editMode = this.getEditMode(this.activeEventlineObject, e2);
        this.setCursor(this.cursorMap.get((Object)this.editMode));
    }

    protected EventlineEditMode getEditMode(Object eventlineObject, MouseEvent evt) {
        if (evt.isAltDown() && this.createEventlineObjectsEnabled) {
            return EventlineEditMode.CREATE_EVENTLINE_OBJECT;
        }
        if (eventlineObject != null) {
            ITimeSpan span = this.model.getTimeSpan(this.activeEventlineObject);
            int x2 = evt.getX();
            int x1 = this.dateline.getTimeLocation(span.getStartTime());
            int x22 = this.dateline.getTimeLocation(span.getEndTime());
            IEditEventlineObjectPolicy ep = this.policyProvider.getPolicy(IEditEventlineObjectPolicy.class);
            if (x2 >= x1 && x2 <= x1 + this.resizeHandleSize && span.isActivity() && ep.isStartTimeChangeable(this.activeEventlineObject, this.model) && ep.isDurationChangeable(this.activeEventlineObject, this.model)) {
                return EventlineEditMode.CHANGE_START_TIME;
            }
            if (x2 <= x22 && x2 >= x22 - this.resizeHandleSize && span.isActivity() && ep.isDurationChangeable(this.activeEventlineObject, this.model)) {
                return EventlineEditMode.CHANGE_END_TIME;
            }
            if (ep.isStartTimeChangeable(this.activeEventlineObject, this.model)) {
                return EventlineEditMode.CHANGE_TIME_SPAN;
            }
        }
        return EventlineEditMode.NONE;
    }

    private boolean maybeShowPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popup = null;
            this.popup = this.menuProvider != null ? this.retrievePopupFromManager(evt) : this.getComponentPopupMenu();
            if (this.popup != null) {
                this.selectObjects(evt);
                this.popup.show(this, evt.getX(), evt.getY());
                this.dragSpan = null;
                return true;
            }
        }
        return false;
    }

    private JPopupMenu retrievePopupFromManager(MouseEvent evt) {
        if (this.menuProvider != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (ObjectBounds b2 : this.boundsMap.values()) {
                result.add(b2.getEventlineObject());
            }
            long time = this.dateline.getTimeAt(evt.getX());
            return this.menuProvider.getPopupMenu(this, evt, time, result.toArray());
        }
        return null;
    }

    public Object[] getSelection() {
        return this.selectionModel.getSelection();
    }

    @Override
    public void selectionChanged(EventlineSelectionModelEvent evt) {
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this) && evt.getPropertyName().equals(PROPERTY_TIME_NOW)) {
            this.repaint();
        }
    }

    public void setEventlineObjectRenderer(Class objectType, IEventlineObjectRenderer renderer) {
        if (objectType == null) {
            throw new IllegalArgumentException("the eventline object type can not be NULL");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("the eventline object renderer can not be NULL");
        }
        this.rendererCache.clear();
        this.rendererMap.put(objectType, renderer);
    }

    public IEventlineObjectRenderer getEventlineObjectRenderer(Class cl) {
        if (cl == null) {
            return null;
        }
        IEventlineObjectRenderer renderer = this.rendererCache.get(cl);
        if (renderer != null) {
            return renderer;
        }
        renderer = this.rendererMap.get(cl);
        if (renderer != null) {
            this.rendererCache.put(cl, renderer);
            return renderer;
        }
        renderer = this.getEventlineObjectRenderer(cl.getSuperclass());
        this.rendererCache.put(cl, renderer);
        return renderer;
    }

    public Map<Class, IEventlineObjectRenderer> getRendererMap() {
        return this.rendererMap;
    }

    public void setRendererMap(Map<Class, IEventlineObjectRenderer> map) {
        if (map == null) {
            throw new IllegalArgumentException("renderer map can not be NULL");
        }
        this.rendererMap = map;
    }

    public boolean isCreateEventlineObjectsEnabled() {
        return this.createEventlineObjectsEnabled;
    }

    public void setCreateEventlineObjectsEnabled(boolean enabled) {
        boolean oldValue = this.createEventlineObjectsEnabled;
        this.createEventlineObjectsEnabled = enabled;
        this.firePropertyChange(PROPERTY_CREATE_EVENTLNE_OBJECTS_ENABLED, oldValue, this.createEventlineObjectsEnabled);
    }

    @Override
    public void addGridComponentListener(IGridComponentListener l2) {
        this.listenerList.add(IGridComponentListener.class, l2);
    }

    @Override
    public void removeGridComponentListener(IGridComponentListener l2) {
        this.listenerList.remove(IGridComponentListener.class, l2);
    }

    protected void fireGridChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IGridComponentListener.class) continue;
            ((IGridComponentListener)listeners[i2 + 1]).gridComponentChanged();
        }
    }

    @Override
    public void dragging(DragLayerEvent evt) {
        switch (evt.getId()) {
            case DRAG_FINISHED: {
                this.dragLayerSpan = null;
                break;
            }
            case DRAG_ONGOING: {
                this.dragLayerSpan = evt.getTimeSpan();
                break;
            }
            case DRAG_STARTED: {
                this.dragLayerSpan = evt.getTimeSpan();
            }
        }
        this.repaint();
    }

    @Override
    public void lassoChanged(LassoLayerEvent evt) {
        if (evt.getLassoMode().equals((Object)LassoLayer.LassoMode.CREATE_TIMELINE_OBJECTS)) {
            switch (evt.getId()) {
                case LASSO_FINISHED: {
                    this.dragLayerSpan = null;
                    break;
                }
                case LASSO_ONGOING: {
                    this.dragLayerSpan = evt.getTimeSpan();
                    break;
                }
                case LASSO_STARTED: {
                    this.dragLayerSpan = evt.getTimeSpan();
                }
            }
            this.repaint();
        }
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.selectionColor = color;
    }

    public void selectAllEventlineObjects() {
        ITimeSpan span = this.dateline.getTimeSpan();
        Iterator iter = this.model.getEventlineObjectsIterator(span);
        while (iter.hasNext()) {
            this.selectionModel.addSelection(iter.next());
        }
    }

    public void deleteSelectedEventlineObjects() {
        Object[] selection = this.selectionModel.getSelection();
        if (selection != null && selection.length > 0) {
            IEventlineModel model = this.getModel();
            IPolicyProvider pp = this.getPolicyProvider();
            IEditEventlineObjectPolicy ep = pp.getPolicy(IEditEventlineObjectPolicy.class);
            LinkedList<Object> deletedObjects = new LinkedList<Object>();
            for (Object eventlineObject : selection) {
                if (!ep.isDeletable(eventlineObject, model)) continue;
                deletedObjects.add(eventlineObject);
            }
            if (deletedObjects.size() > 0) {
                ICommand cmd = ep.getDeleteCommand(deletedObjects, model);
                Timeline timeline = this.getTimeline();
                AbstractGanttChart gc2 = timeline.getGanttChart();
                gc2.commandExecute(cmd);
            }
        }
    }

    public boolean isGridAdjustedMouseCursorTime() {
        return this.gridAdjustedMouseCursorTime;
    }

    public void setGridAdjustedMouseCursorTime(boolean adjusted) {
        this.gridAdjustedMouseCursorTime = adjusted;
    }

    protected Cursor createEditModeCursor(EventlineEditMode mode) {
        IconId id2 = null;
        Point hotSpot = new Point(16, 16);
        switch (mode) {
            case CHANGE_START_TIME: {
                id2 = IconId.CURSOR_CHANGE_START_TIME;
                break;
            }
            case CHANGE_END_TIME: {
                id2 = IconId.CURSOR_CHANGE_END_TIME;
                break;
            }
            case CHANGE_TIME_SPAN: {
                id2 = IconId.CURSOR_MOVE_HORIZONTAL;
                break;
            }
            case CREATE_EVENTLINE_OBJECT: {
                id2 = IconId.CURSOR_CREATE_EVENTLINE_OBJECTS;
                break;
            }
            default: {
                return Cursor.getPredefinedCursor(0);
            }
        }
        Icon icon = IconRegistry.getIcon(id2);
        if (!(icon instanceof ImageIcon)) {
            throw new IllegalArgumentException("the icons used for creating cursors have to be of type ImageIcon");
        }
        ImageIcon imageIcon = (ImageIcon)IconRegistry.getIcon(id2);
        return Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), hotSpot, mode.toString());
    }

    public int getResizeHandleSize() {
        return this.resizeHandleSize;
    }

    public void setResizeHandleSize(int size) {
        this.resizeHandleSize = size;
    }

    public Color getMarkerFillColor1() {
        return this.markerFillColor1;
    }

    public void setMarkerFillColor1(Color color) {
        this.markerFillColor1 = color;
    }

    public Color getMarkerFillColor2() {
        return this.markerFillColor2;
    }

    public void setMarkerFillColor2(Color color) {
        this.markerFillColor2 = color;
    }

    public EventlineEditMode getEditMode() {
        return this.editMode;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e2) {
        if (this.getMousePosition() != null) {
            if (e2.isAltDown()) {
                this.setCursor(this.cursorMap.get((Object)EventlineEditMode.CREATE_EVENTLINE_OBJECT));
            } else {
                this.setCursor(this.cursorMap.get((Object)EventlineEditMode.NONE));
            }
        }
        return false;
    }

    public boolean isTimeNowOnTop() {
        return this.timeNowOnTop;
    }

    public void setTimeNowOnTop(boolean onTop) {
        this.timeNowOnTop = onTop;
    }

    public boolean isShowingDSTMarkers() {
        return this.showingDSTMarkers;
    }

    public void setShowingDSTMarkers(boolean show) {
        this.showingDSTMarkers = show;
    }

    public int getLookAheadSize() {
        return this.lookAheadSize;
    }

    public void setLookAheadSize(int lookAheadSize) {
        if (lookAheadSize < 0) {
            throw new IllegalArgumentException("look ahead size can not be negative");
        }
        this.lookAheadSize = lookAheadSize;
    }

    public void tearDown() {
        this.keyboardFocusManager.removeKeyEventDispatcher(this);
    }

    class ObjectBounds
    extends Rectangle {
        private Object eventlineObject;

        public ObjectBounds(Object obj) {
            this.eventlineObject = obj;
        }

        public Object getEventlineObject() {
            return this.eventlineObject;
        }
    }

    public static enum EventlineEditMode {
        NONE,
        CHANGE_END_TIME,
        CHANGE_START_TIME,
        CHANGE_TIME_SPAN,
        CREATE_EVENTLINE_OBJECT;

    }
}

