/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.scheduling;

import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.dateline.SimpleGranularity;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.RelationshipType;
import com.dlsc.flexgantt.model.scheduling.BufferType;
import com.dlsc.flexgantt.model.scheduling.ConstraintType;
import com.dlsc.flexgantt.model.scheduling.IConstraint;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.scheduling.BufferTypeListCellRenderer;
import com.dlsc.flexgantt.swing.timeline.SimpleGranularityListCellRenderer;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityListCellRenderer;
import com.dlsc.flexgantt.swing.util.RelationshipTypeListCellRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class ConstraintSettingsPanel
extends JPanel
implements ActionListener,
ChangeListener,
DocumentListener {
    private JComboBox constraintTypeBox;
    private JRadioButton hardConstraintButton;
    private JRadioButton softConstraintButton;
    private JComboBox bufferTypeBox;
    private JFormattedTextField bufferTimeField;
    private JComboBox bufferGranularityBox;
    private IConstraint constraint;
    private LayerContainer layerContainer;
    private boolean settingConstraintValues;

    private ConstraintSettingsPanel(LayerContainer lc2, IGranularity<?>[] bufferGranularities) {
        if (lc2 == null) {
            throw new IllegalArgumentException("layer container can not be NULL");
        }
        this.layerContainer = lc2;
        this.setLayout(new MigLayout("insets 5 5 5 5, wrap 1", "[grow]", "[][]"));
        JPanel typePanel = new JPanel();
        typePanel.setBorder(this.createTitledBorder("Constraint Type"));
        this.add((Component)typePanel, "grow");
        JPanel bufferPanel = new JPanel();
        bufferPanel.setLayout(new MigLayout("insets 5 5 5 5", "[][][]", "[][grow][]"));
        bufferPanel.setBorder(this.createTitledBorder("Buffer"));
        this.add((Component)bufferPanel, "grow");
        typePanel.setLayout(new MigLayout("wrap 1, insets 5 5 5 5", "[grow]", "[][][]"));
        this.constraintTypeBox = new JComboBox<RelationshipType>(RelationshipType.values());
        typePanel.add(this.constraintTypeBox, "grow");
        this.constraintTypeBox.setRenderer(new RelationshipTypeListCellRenderer());
        this.hardConstraintButton = new JRadioButton("Must be enforced", true);
        typePanel.add((Component)this.hardConstraintButton, "wrap");
        this.softConstraintButton = new JRadioButton("Should be enforced");
        typePanel.add((Component)this.softConstraintButton, "wrap");
        ButtonGroup group = new ButtonGroup();
        group.add(this.softConstraintButton);
        group.add(this.hardConstraintButton);
        this.bufferTypeBox = new JComboBox<BufferType>(BufferType.values());
        bufferPanel.add(this.bufferTypeBox, "grow");
        this.bufferTypeBox.setRenderer(new BufferTypeListCellRenderer());
        this.bufferTimeField = new JFormattedTextField(new Integer(0));
        bufferPanel.add((Component)this.bufferTimeField, "");
        this.bufferTimeField.setColumns(5);
        this.bufferGranularityBox = new JComboBox(bufferGranularities);
        bufferPanel.add(this.bufferGranularityBox, "grow");
        this.updateComponents();
        this.bufferTypeBox.addActionListener(this);
        this.constraintTypeBox.addActionListener(this);
        this.bufferTimeField.getDocument().addDocumentListener(this);
        this.bufferGranularityBox.addActionListener(this);
        this.hardConstraintButton.addActionListener(this);
        this.softConstraintButton.addActionListener(this);
    }

    public ConstraintSettingsPanel(LayerContainer lc2, TimeGranularity[] bufferGranularities) {
        this(lc2, (IGranularity[])bufferGranularities);
        this.bufferGranularityBox.setRenderer(new TimeGranularityListCellRenderer());
    }

    public ConstraintSettingsPanel(LayerContainer lc2, SimpleGranularity[] bufferGranularities) {
        this(lc2, (IGranularity[])bufferGranularities);
        this.bufferGranularityBox.setRenderer(new SimpleGranularityListCellRenderer());
    }

    public ConstraintSettingsPanel(LayerContainer lc2) {
        this(lc2, new TimeGranularity[]{TimeGranularity.MONTH_SHORT, TimeGranularity.WEEK, TimeGranularity.DAY_SHORT, TimeGranularity.HOUR});
    }

    public void addChangeListener(ChangeListener l2) {
        this.listenerList.add(ChangeListener.class, l2);
    }

    public void removeChangeListener(ChangeListener l2) {
        this.listenerList.remove(ChangeListener.class, l2);
    }

    protected void fireSettingsChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent evt = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ChangeListener.class) continue;
            if (evt == null) {
                evt = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i2 + 1]).stateChanged(evt);
        }
    }

    public LayerContainer getLayerContainer() {
        return this.layerContainer;
    }

    public IConstraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(IConstraint con) {
        this.constraint = con;
        if (con != null) {
            this.settingConstraintValues = true;
            try {
                this.constraintTypeBox.setSelectedItem((Object)con.getType());
                this.bufferTypeBox.setSelectedItem((Object)con.getBufferType());
                this.bufferTimeField.setValue(con.getBufferDuration());
                this.bufferGranularityBox.setSelectedItem(con.getBufferGranularity());
                if (con.getConstraintType().equals((Object)ConstraintType.HARD)) {
                    this.hardConstraintButton.setSelected(true);
                } else {
                    this.softConstraintButton.setSelected(true);
                }
            }
            finally {
                this.settingConstraintValues = false;
            }
        }
        this.updateComponents();
    }

    private void updateComponents() {
        if (this.constraint == null) {
            this.constraintTypeBox.setEnabled(false);
            this.hardConstraintButton.setEnabled(false);
            this.softConstraintButton.setEnabled(false);
            this.bufferTypeBox.setEnabled(false);
        } else {
            this.constraintTypeBox.setEnabled(true);
            this.hardConstraintButton.setEnabled(true);
            this.softConstraintButton.setEnabled(true);
            this.bufferTypeBox.setEnabled(true);
        }
    }

    private Border createTitledBorder(String title) {
        Border b2 = UIManager.getBorder("TitledBorder.aquaVariant");
        if (b2 == null) {
            TitledBorder border = new TitledBorder(title);
            return border;
        }
        TitledBorder border = new TitledBorder(b2, title);
        return border;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.updateConstraint();
    }

    private void updateConstraint() {
        if (this.constraint != null && !this.settingConstraintValues) {
            this.constraint.setType((RelationshipType)((Object)this.constraintTypeBox.getSelectedItem()));
            if (this.hardConstraintButton.isSelected()) {
                this.constraint.setConstraintType(ConstraintType.HARD);
            } else {
                this.constraint.setConstraintType(ConstraintType.SOFT);
            }
            try {
                this.bufferTimeField.commitEdit();
                this.constraint.setBufferDuration((Integer)this.bufferTimeField.getValue());
            }
            catch (ParseException e2) {
                this.constraint.setBufferDuration(0);
            }
            this.constraint.setBufferGranularity((IGranularity)this.bufferGranularityBox.getSelectedItem());
            this.constraint.setBufferType((BufferType)((Object)this.bufferTypeBox.getSelectedItem()));
            this.layerContainer.repaint();
            this.fireSettingsChanged();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e2) {
        this.updateConstraint();
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.updateConstraint();
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.updateConstraint();
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.updateConstraint();
    }
}

