/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.print;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.policy.dateline.IZoomPolicy;
import com.dlsc.flexgantt.policy.eventline.IEditEventlineObjectPolicy;
import com.dlsc.flexgantt.policy.eventline.IEventlineLabelPolicy;
import com.dlsc.flexgantt.policy.eventline.IEventlineSelectionPolicy;
import com.dlsc.flexgantt.policy.gantt.IStatusBarPolicy;
import com.dlsc.flexgantt.policy.layer.ICrosshairPolicy;
import com.dlsc.flexgantt.policy.layer.IDragAndDropPolicy;
import com.dlsc.flexgantt.policy.layer.IDragInfoPolicy;
import com.dlsc.flexgantt.policy.layer.IEditActivityObjectPolicy;
import com.dlsc.flexgantt.policy.layer.IEditCapacityObjectPolicy;
import com.dlsc.flexgantt.policy.layer.IEditLayerPolicy;
import com.dlsc.flexgantt.policy.layer.IEditTimelineObjectPolicy;
import com.dlsc.flexgantt.policy.layer.IGridLinePolicy;
import com.dlsc.flexgantt.policy.layer.IGridPolicy;
import com.dlsc.flexgantt.policy.layer.ILabelPolicy;
import com.dlsc.flexgantt.policy.layer.ILinePolicy;
import com.dlsc.flexgantt.policy.layer.IOverviewPolicy;
import com.dlsc.flexgantt.policy.layer.IPopupPolicy;
import com.dlsc.flexgantt.policy.layer.IRelationshipPolicy;
import com.dlsc.flexgantt.policy.layer.ISelectionPolicy;
import com.dlsc.flexgantt.policy.treetable.INodeDragAndDropPolicy;
import com.dlsc.flexgantt.policy.treetable.INodeEditPolicy;
import com.dlsc.flexgantt.policy.treetable.IRowPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.layer.AbstractCustomLayer;
import com.dlsc.flexgantt.swing.layer.AbstractLayer;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.layer.system.BackgroundLayer;
import com.dlsc.flexgantt.swing.layer.system.CalendarLayer;
import com.dlsc.flexgantt.swing.layer.system.CrosshairLayer;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.EditingLayer;
import com.dlsc.flexgantt.swing.layer.system.EventlineLayer;
import com.dlsc.flexgantt.swing.layer.system.GridLayer;
import com.dlsc.flexgantt.swing.layer.system.LabelLayer;
import com.dlsc.flexgantt.swing.layer.system.LassoLayer;
import com.dlsc.flexgantt.swing.layer.system.PopupLayer;
import com.dlsc.flexgantt.swing.layer.system.RelationshipLayer;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import com.dlsc.flexgantt.swing.layer.system.SelectionLayer;
import com.dlsc.flexgantt.swing.layer.system.TimeNowLayer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.print.PreviewDialog;
import com.dlsc.flexgantt.swing.print.PrintContext;
import com.dlsc.flexgantt.swing.print.PrintSetup;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.SimpleGranularityDatelineModel;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityDatelineModel;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableRowHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableScrollPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.tree.TreePath;

public class PrintGanttChart
extends AbstractGanttChart
implements LayoutManager,
Printable,
IDatelineModelListener {
    private static final Logger LOGGER = Logger.getLogger(PrintGanttChart.class.getName());
    private TreeTable table;
    private LayerContainer layerContainer;
    private PreviewDialog previewDialog;
    private TreeTableRowHeader treeTableRowHeader;
    private int pageNumber;
    private int pageCount;

    public PrintGanttChart(PrintContext ctx) {
        super(ctx.getLayerContainer().getModel(), ctx.getGanttChart().getColumnModel(), ctx.getGanttChart().getComponentFactory());
        this.setLayout(this);
        this.setOpaque(false);
        this.table = this.getComponentFactory().createTreeTable(this, this.getModel());
        this.treeTableRowHeader = this.getComponentFactory().createTreeTableRowHeader(this.table);
        this.layerContainer = this.getComponentFactory().createLayerContainer(this, this.table, this.getModel());
        this.getTimeline().getDateline().setBorder(null);
        this.getTimeline().getEventline().setBorder(null);
        this.add(this.treeTableRowHeader);
        this.add(this.table);
        this.add(this.layerContainer);
        this.add(this.getTreeTableHeader());
        this.add(this.getTimeline());
        this.copySettings(ctx, true);
        this.updateState();
    }

    protected void copySettings(PrintContext ctx) {
        this.copySettings(ctx, false);
    }

    protected void copySettings(PrintContext ctx, boolean initialCopy) {
        this.setModel(ctx.getLayerContainer().getModel());
        this.setColumnModel(ctx.getTreeTable().getColumnModel());
        this.copySettings(ctx.getGanttChart(), this, initialCopy);
        this.copySettings(ctx.getTimeline(), this.getTimeline(), initialCopy);
        this.copySettings(ctx.getTimeline().getDateline(), this.getTimeline().getDateline(), ctx.getTimeSpan(), initialCopy);
        this.copySettings(ctx.getTimeline().getEventline(), this.getTimeline().getEventline(), initialCopy);
        this.copySettings(ctx.getTreeTable(), this.getTreeTable(), initialCopy);
        this.copySettings(ctx.getTreeTableHeader(), this.getTreeTableHeader(), initialCopy);
        this.copySettings(ctx.getRowHeader(), this.getRowHeader(), initialCopy);
        this.copySettings(ctx.getLayerContainer(), this.getLayerContainer(), initialCopy);
        this.setPrintSetup(ctx.getPrintSetup());
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) {
    }

    @Override
    public void datelineModelChanged(DatelineModelEvent e2) {
        this.updateState();
    }

    public LayerContainer getLayerContainer() {
        return this.layerContainer;
    }

    public TreeTable getTreeTable() {
        return this.table;
    }

    public TreeTableRowHeader getRowHeader() {
        return this.treeTableRowHeader;
    }

    @Override
    public int print(Graphics g2, PageFormat pageFormat, int pageIndex) throws PrinterException {
        PrintSetup setup = this.getPrintSetup();
        this.pageNumber = pageIndex;
        int horizontalPages = 1;
        int verticalPages = 1;
        if (this.previewDialog != null) {
            horizontalPages = this.previewDialog.getHorizontalPages();
            verticalPages = this.previewDialog.getVerticalPages();
        }
        this.pageCount = horizontalPages * verticalPages;
        if (pageIndex < 0 | pageIndex > this.pageCount - 1) {
            return 1;
        }
        double iw = pageFormat.getImageableWidth();
        double ih = pageFormat.getImageableHeight();
        double ix = pageFormat.getImageableX();
        double iy = pageFormat.getImageableY();
        int headerHeight = setup.getHeaderHeight();
        int footerHeight = setup.getFooterHeight();
        int printGap = setup.getVerticalGap();
        if (setup.isHeaderVisible()) {
            this.printHeader(g2, pageFormat);
            ih -= (double)headerHeight;
            ih -= (double)printGap;
            iy = pageFormat.getImageableY() + (double)headerHeight + (double)printGap;
        }
        if (setup.isFooterVisible()) {
            this.printHeader(g2, pageFormat);
            ih -= (double)footerHeight;
            ih -= (double)printGap;
        }
        Graphics2D g2d = (Graphics2D)g2.create();
        if (iw <= 0.0) {
            throw new PrinterException("Width of printable area is too small.");
        }
        if (ih <= 0.0) {
            throw new PrinterException("Height of printable area is too small.");
        }
        double sfWidth = iw / (double)this.getWidth() * (double)horizontalPages;
        double sfHeight = ih / (double)this.getHeight() * (double)verticalPages;
        double sf = Math.min(1.0, Math.min(sfWidth, sfHeight));
        Rectangle clip = g2d.getClipBounds();
        clip.y = Math.max(clip.y, headerHeight);
        int column = pageIndex % horizontalPages;
        int row = pageIndex / horizontalPages;
        int tx = column * (int)iw;
        int ty = row * (int)ih;
        g2d.translate(ix, iy);
        g2d.translate(-tx, -ty);
        if (this.previewDialog != null && this.previewDialog.isFillPage()) {
            g2d.scale(sfWidth, sfHeight);
        } else {
            g2d.scale(sf, sf);
        }
        this.printAll(g2d);
        g2d.dispose();
        this.printFooter(g2, pageFormat);
        return 0;
    }

    protected void printHeader(Graphics g2, PageFormat pageFormat) {
        Image logo;
        PrintSetup setup = this.getPrintSetup();
        double w2 = pageFormat.getImageableWidth();
        double x2 = pageFormat.getImageableX();
        double y2 = pageFormat.getImageableY();
        int headerHeight = setup.getHeaderHeight();
        Graphics2D g2d = (Graphics2D)g2.create();
        String title = setup.getTitle();
        if (title != null) {
            title = this.substituteVariables(title);
            g2d.setColor(setup.getTitleColor());
            g2d.setFont(setup.getTitleFont());
            g2d.drawString(title, (int)x2, (int)(y2 + (double)(headerHeight / 2 + g2d.getFontMetrics().getAscent() / 2)));
        }
        if ((logo = setup.getLogo()) != null) {
            double sfWidth = w2 / (double)logo.getWidth(this);
            double sfHeight = (double)headerHeight / (double)logo.getHeight(this);
            double sf = Math.min(1.0, Math.min(sfWidth, sfHeight));
            int iw = (int)((double)logo.getWidth(this) * sf);
            int ih = (int)((double)logo.getHeight(this) * sf) - 5;
            g2d.drawImage(logo, (int)(x2 + w2 - (double)iw), (int)y2 + 5, iw, ih, this);
        }
        g2d.dispose();
    }

    protected void printFooter(Graphics g2, PageFormat pageFormat) {
        PrintSetup setup = this.getPrintSetup();
        int footerHeight = setup.getFooterHeight();
        double w2 = pageFormat.getImageableWidth();
        double h2 = pageFormat.getImageableHeight();
        double x2 = pageFormat.getImageableX();
        double y2 = pageFormat.getImageableY();
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.setFont(setup.getFooterFont());
        g2d.setColor(setup.getFooterColor());
        FontMetrics fm = g2d.getFontMetrics();
        int ascent = fm.getAscent();
        int textY = (int)(y2 + h2 - (double)(footerHeight / 2) + (double)(ascent / 2));
        String left = setup.getLeftFooter();
        String center = setup.getCenterFooter();
        String right = setup.getRightFooter();
        if (left != null) {
            left = this.substituteVariables(left);
            g2d.drawString(left, (int)x2, textY);
        }
        if (center != null) {
            center = this.substituteVariables(center);
            g2d.drawString(center, (int)(x2 + (w2 - (double)fm.stringWidth(center)) / 2.0), textY);
        }
        if (right != null) {
            right = this.substituteVariables(right);
            g2d.drawString(right, (int)(x2 + w2 - (double)fm.stringWidth(right)), textY);
        }
        g2d.dispose();
    }

    private String substituteVariables(String text) {
        text = text.replaceAll("\\$USER\\$", System.getProperty("user.name"));
        text = text.replaceAll("\\$DATE\\$", DateFormat.getDateInstance().format(Calendar.getInstance().getTime()));
        text = text.replaceAll("\\$TIME\\$", DateFormat.getTimeInstance(3).format(Calendar.getInstance().getTime()));
        text = text.replaceAll("\\$PAGE_NUMBER\\$", Integer.toString(this.pageNumber + 1));
        text = text.replaceAll("\\$PAGE_TOTAL\\$", Integer.toString(this.pageCount));
        return text;
    }

    @Override
    public void showEarliestObjects() {
        throw new UnsupportedOperationException("a printable Gantt chart can not be asked to show the earliest objects");
    }

    @Override
    public void showLatestObjects() {
        throw new UnsupportedOperationException("a printable Gantt chart can not be asked to show the latest objects");
    }

    @Override
    public void showAllObjects() {
        throw new UnsupportedOperationException("a printable Gantt chart can not be asked show all objects");
    }

    @Override
    public void showTime(long time, boolean center) {
        throw new UnsupportedOperationException("a printable Gantt chart can not be asked show a specific time");
    }

    @Override
    public void showTimeNow(boolean center) {
        throw new UnsupportedOperationException("a printable Gantt chart can not be asked show the time now");
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = this.getInsets();
        int height = insets.top + insets.bottom + this.getTreeTableHeader().getPreferredSize().height + this.table.getPreferredSize().height;
        int width = insets.left + insets.right + this.getTreeTableHeader().getPreferredSize().width + this.getTimeline().getPreferredSize().width;
        Dimension dim = new Dimension(width, height);
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Dimension ps1 = this.getTreeTableHeader().getPreferredSize();
        Dimension ps2 = this.treeTableRowHeader.getPreferredSize();
        Dimension ps3 = this.getTimeline().getPreferredSize();
        this.treeTableRowHeader.setBounds(insets.left, insets.top + ps1.height, ps2.width, ps2.height);
        this.getTreeTableHeader().setBounds(insets.left + ps2.width, insets.top, ps1.width, Math.max(ps1.height, ps3.height));
        this.table.setBounds(insets.left + ps2.width, insets.top + Math.max(ps1.height, ps3.height), ps1.width, parent.getHeight() - ps1.height - insets.top - insets.bottom);
        this.getTimeline().setBounds(ps1.width + ps2.width + insets.left - 1, insets.top, parent.getWidth() - ps1.width - insets.left - insets.right - 1, Math.max(ps1.height, ps3.height));
        this.layerContainer.setBounds(ps1.width + ps2.width + insets.left - 1, Math.max(ps1.height, ps3.height) + insets.top, parent.getWidth() - ps1.width - insets.left - insets.right - 1, parent.getHeight() - ps1.height - insets.top - insets.bottom);
        this.getTimeline().doLayout();
    }

    @Override
    public void print(boolean preview, ITimeSpan span) {
        throw new UnsupportedOperationException("this gantt chart can not be printed directly");
    }

    @Override
    public void expandAll() {
        throw new UnsupportedOperationException("the nodes of the treetable of this gantt chart can not be all automatically expanded");
    }

    @Override
    public void collapseAll() {
        throw new UnsupportedOperationException("the nodes of the treetable of this gantt chart can not be all automatically collapsed");
    }

    @Override
    public void showMessageContext(IMessage msg) {
        throw new UnsupportedOperationException("this printable gantt chart can not show message contexts");
    }

    @Override
    public void resetToPreferredSizes() {
        throw new UnsupportedOperationException("a printable gantt chart can not be reset to its preferred sizes");
    }

    @Override
    public void alignEndTimes() {
        throw new UnsupportedOperationException("this gantt chart does not support object alignment");
    }

    @Override
    public void alignStartTimes() {
        throw new UnsupportedOperationException("this gantt chart does not support object alignment");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState() {
        this.setSize(this.getPreferredSize());
        for (Component comp : this.getComponents()) {
            comp.invalidate();
            comp.validate();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
        if (this.previewDialog != null && this.previewDialog.getScrollPane() != null) {
            this.previewDialog.getScrollPane().repaint();
        }
    }

    protected void copySettings(AbstractGanttChart from, AbstractGanttChart to, boolean initialCopy) {
        to.setTreeTableRowHeaderWidth(from.getTreeTableRowHeaderWidth());
        to.setLayerContainerRowHeaderWidth(from.getLayerContainerRowHeaderWidth());
        to.setKeyColumnPosition(from.getKeyColumnPosition());
        to.setCalendarModel(from.getCalendarModel());
        to.setCalendarVisible(from.isCalendarVisible());
        to.setControlsForeground(from.getControlsForeground());
        to.setControlsBackground(from.getControlsBackground());
        to.setFont(from.getFont());
        to.setGridLineMode(from.getGridLineMode());
        to.setForeground(from.getForeground());
        to.setBackground(from.getBackground());
        to.setTimeNowVisible(from.isTimeNowVisible());
        to.setPopupVisible(from.isPopupVisible());
        to.setLabelsVisible(from.isLabelsVisible());
        to.setPopupVisible(from.isPopupVisible());
        to.setRelationsVisible(from.isRelationsVisible());
        to.setRowLayerVisible(from.isRowLayerVisible());
        to.setVerticalLinesOnTop(from.isVerticalLinesOnTop());
        to.getPolicyProvider().setPolicy(IStatusBarPolicy.class, from.getPolicyProvider().getPolicy(IStatusBarPolicy.class));
    }

    protected void copySettings(TreeTable from, TreeTable to, boolean initialCopy) {
        to.setRendererMap(from.getRendererMap());
        to.setHorizontalLinesVisible(from.isHorizontalLinesVisible());
        to.setVerticalLinesVisible(from.isVerticalLinesVisible());
        to.setRootVisible(from.isRootVisible());
        to.setRowNumbersVisible(from.isRowNumbersVisible());
        to.setAlpha(from.getAlpha());
        to.setForeground(from.getForeground());
        to.setBackground(from.getBackground());
        to.setAlternatingForeground(from.getAlternatingForeground());
        to.setAlternatingBackground(from.getAlternatingBackground());
        to.setFont(from.getFont());
        to.setTexture(from.getTexture());
        to.getPolicyProvider().setPolicy(INodeDragAndDropPolicy.class, from.getPolicyProvider().getPolicy(INodeDragAndDropPolicy.class));
        to.getPolicyProvider().setPolicy(INodeEditPolicy.class, from.getPolicyProvider().getPolicy(INodeEditPolicy.class));
        to.getPolicyProvider().setPolicy(IRowPolicy.class, from.getPolicyProvider().getPolicy(IRowPolicy.class));
        this.copyExpansionState(from, to);
    }

    protected void copyExpansionState(TreeTable from, TreeTable to) {
        to.collapseAll();
        int count = from.getRowCount();
        for (int row = 0; row < count; ++row) {
            TreePath path = from.getTreePath(row);
            if (!from.isTreeNodeExpanded(path) || row >= to.getRowCount()) continue;
            to.expandRow(row);
        }
    }

    protected void copySettings(TreeTableHeader from, TreeTableHeader to, boolean initialCopy) {
        to.setRendererMap(from.getRendererMap());
        to.setForeground(from.getForeground());
        to.setBackground(from.getBackground());
        to.setFont(from.getFont());
    }

    protected void copySettings(TreeTableRowHeader from, TreeTableRowHeader to, boolean initialCopy) {
        to.setVisible(from.isVisible());
        to.setRendererMap(from.getRendererMap());
        to.setForeground(from.getForeground());
        to.setBackground(from.getBackground());
        to.setFont(from.getFont());
        to.setGridColor(from.getGridColor());
    }

    protected void copySettings(Dateline from, Dateline to, ITimeSpan span, boolean initialCopy) {
        to.setRendererMap(from.getRendererMap());
        to.setForeground(from.getForeground());
        to.setBackground(from.getBackground());
        to.setFont(from.getFont());
        to.getPolicyProvider().setPolicy(IZoomPolicy.class, from.getPolicyProvider().getPolicy(IZoomPolicy.class));
        if (initialCopy) {
            try {
                IDatelineModel model = from.getModel();
                if (model.getClass().equals(TimeGranularityDatelineModel.class)) {
                    to.setModel(new TimeGranularityDatelineModel(to));
                } else if (model.getClass().equals(SimpleGranularityDatelineModel.class)) {
                    to.setModel(new SimpleGranularityDatelineModel(to));
                }
                IDatelineModel toModel = to.getModel();
                toModel.setTimeSpan(span);
                toModel.setGranularity(model.getGranularity());
                toModel.setZoom(model.getZoom());
                toModel.addDatelineModelListener(this);
            }
            catch (DatelineModelException ex) {
                LOGGER.throwing(this.getClass().getName(), "createPrintableGanttChart", ex);
            }
        } else {
            IDatelineModel toModel = to.getModel();
            try {
                toModel.setTimeSpan(span);
            }
            catch (DatelineModelException e2) {
                e2.printStackTrace();
            }
        }
    }

    protected void copySettings(Eventline from, Eventline to, boolean initialCopy) {
        to.setModel(from.getModel());
        to.setVisible(from.isVisible());
        to.setRendererMap(from.getRendererMap());
        to.setForeground(from.getForeground());
        to.setBackground(from.getBackground());
        to.setFont(from.getFont());
        to.getPolicyProvider().setPolicy(IEditEventlineObjectPolicy.class, from.getPolicyProvider().getPolicy(IEditEventlineObjectPolicy.class));
        to.getPolicyProvider().setPolicy(IEventlineLabelPolicy.class, from.getPolicyProvider().getPolicy(IEventlineLabelPolicy.class));
        to.getPolicyProvider().setPolicy(IEventlineSelectionPolicy.class, from.getPolicyProvider().getPolicy(IEventlineSelectionPolicy.class));
    }

    protected void copySettings(Timeline from, Timeline to, boolean initialCopy) {
        to.setForeground(from.getForeground());
        to.setBackground(from.getBackground());
        to.setFont(from.getFont());
    }

    protected void copySettings(LayerContainer from, LayerContainer to, boolean initialCopy) {
        Class[] cl;
        to.setRendererMap(from.getRendererMap());
        to.setForeground(from.getForeground());
        to.setBackground(from.getBackground());
        to.setFont(from.getFont());
        to.setAlternatingBackground(from.getAlternatingBackground());
        BackgroundLayer blFrom = from.getSystemLayer(BackgroundLayer.class);
        BackgroundLayer blTo = to.getSystemLayer(BackgroundLayer.class);
        blTo.setTexture(blFrom.getTexture());
        RelationshipLayer relFrom = from.getSystemLayer(RelationshipLayer.class);
        RelationshipLayer relTo = to.getSystemLayer(RelationshipLayer.class);
        relTo.setRelationshipRendererMap(relFrom.getRelationshipRendererMap());
        GridLayer glFrom = from.getSystemLayer(GridLayer.class);
        GridLayer glTo = to.getSystemLayer(GridLayer.class);
        glTo.setMajorGridColor(glFrom.getMajorGridColor());
        glTo.setMinorGridColor(glFrom.getMajorGridColor());
        glTo.setThickMajorGridLines(glFrom.isThickMajorGridLines());
        glTo.setVerticalLinesOnTop(glFrom.isVerticalLinesOnTop());
        blTo.setTexture(blFrom.getTexture());
        CalendarLayer clFrom = from.getSystemLayer(CalendarLayer.class);
        CalendarLayer clTo = to.getSystemLayer(CalendarLayer.class);
        clTo.setCalendarEntryRendererMap(clFrom.getCalendarEntryRendererMap());
        PopupLayer plFrom = from.getSystemLayer(PopupLayer.class);
        PopupLayer plTo = to.getSystemLayer(PopupLayer.class);
        plTo.setPinnedPopups(plFrom.getPinnedPopups());
        RowLayer rlFrom = from.getSystemLayer(RowLayer.class);
        RowLayer rlTo = to.getSystemLayer(RowLayer.class);
        rlTo.setRowRendererMap(rlFrom.getRowRendererMap());
        for (Class clazz : cl = new Class[]{BackgroundLayer.class, CalendarLayer.class, CrosshairLayer.class, DragLayer.class, EditingLayer.class, EventlineLayer.class, GridLayer.class, LabelLayer.class, LassoLayer.class, PopupLayer.class, RelationshipLayer.class, RowLayer.class, SelectionLayer.class, TimeNowLayer.class}) {
            Object fromLayer = from.getSystemLayer(clazz);
            Object toLayer = to.getSystemLayer(clazz);
            ((AbstractLayer)toLayer).setAlpha(((AbstractLayer)fromLayer).getAlpha());
            ((AbstractLayer)toLayer).setVisible(((AbstractLayer)fromLayer).isVisible());
        }
        IGanttChartModel model = from.getModel();
        Iterator<ILayer> layers = model.getLayers();
        while (layers.hasNext()) {
            ILayer layer = layers.next();
            if (layer.isCustomLayer()) {
                AbstractCustomLayer clayerFrom = from.getCustomLayer(layer);
                AbstractCustomLayer clayerTo = to.getCustomLayer(layer);
                if (clayerFrom == null || clayerTo == null) continue;
                clayerTo.setAlpha(clayerFrom.getAlpha());
                clayerTo.setVisible(clayerFrom.isVisible());
                continue;
            }
            TimelineObjectLayer tolFrom = from.getTimelineObjectLayer(layer);
            TimelineObjectLayer tolTo = to.getTimelineObjectLayer(layer);
            if (tolFrom == null || tolTo == null) continue;
            tolTo.setAlpha(tolFrom.getAlpha());
            tolTo.setVisible(tolFrom.isVisible());
        }
        to.getPolicyProvider().setPolicy(ICrosshairPolicy.class, from.getPolicyProvider().getPolicy(ICrosshairPolicy.class));
        to.getPolicyProvider().setPolicy(IDragAndDropPolicy.class, from.getPolicyProvider().getPolicy(IDragAndDropPolicy.class));
        to.getPolicyProvider().setPolicy(IDragInfoPolicy.class, from.getPolicyProvider().getPolicy(IDragInfoPolicy.class));
        to.getPolicyProvider().setPolicy(IEditActivityObjectPolicy.class, from.getPolicyProvider().getPolicy(IEditActivityObjectPolicy.class));
        to.getPolicyProvider().setPolicy(IEditCapacityObjectPolicy.class, from.getPolicyProvider().getPolicy(IEditCapacityObjectPolicy.class));
        to.getPolicyProvider().setPolicy(IEditLayerPolicy.class, from.getPolicyProvider().getPolicy(IEditLayerPolicy.class));
        to.getPolicyProvider().setPolicy(IEditTimelineObjectPolicy.class, from.getPolicyProvider().getPolicy(IEditTimelineObjectPolicy.class));
        to.getPolicyProvider().setPolicy(IGridLinePolicy.class, from.getPolicyProvider().getPolicy(IGridLinePolicy.class));
        to.getPolicyProvider().setPolicy(IGridPolicy.class, from.getPolicyProvider().getPolicy(IGridPolicy.class));
        to.getPolicyProvider().setPolicy(ILabelPolicy.class, from.getPolicyProvider().getPolicy(ILabelPolicy.class));
        to.getPolicyProvider().setPolicy(ILinePolicy.class, from.getPolicyProvider().getPolicy(ILinePolicy.class));
        to.getPolicyProvider().setPolicy(IPopupPolicy.class, from.getPolicyProvider().getPolicy(IPopupPolicy.class));
        to.getPolicyProvider().setPolicy(IRelationshipPolicy.class, from.getPolicyProvider().getPolicy(IRelationshipPolicy.class));
        to.getPolicyProvider().setPolicy(ISelectionPolicy.class, from.getPolicyProvider().getPolicy(ISelectionPolicy.class));
        to.getPolicyProvider().setPolicy(IOverviewPolicy.class, from.getPolicyProvider().getPolicy(IOverviewPolicy.class));
    }

    public PreviewDialog getPreviewDialog() {
        return this.previewDialog;
    }

    public void setPreviewDialog(PreviewDialog dialog) {
        this.previewDialog = dialog;
    }

    @Override
    public PrintContext[] getPrintContexts() {
        return null;
    }

    @Override
    public LayerContainerScrollPane[] getLayerContainerScrollPanes() {
        throw new UnsupportedOperationException("this gantt chart does not have layer container scrollpanes");
    }

    @Override
    public TreeTableScrollPane[] getTreeTableScrollPanes() {
        throw new UnsupportedOperationException("this gantt chart does not have tree table scrollpanes");
    }

    @Override
    public IGridComponent[] getGridComponents() {
        return new IGridComponent[]{this.layerContainer, this.getEventline()};
    }

    @Override
    public LayerContainer[] getLayerContainers() {
        return new LayerContainer[]{this.getLayerContainer()};
    }

    @Override
    public TreeTable[] getTreeTables() {
        return new TreeTable[]{this.getTreeTable()};
    }
}

