/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class TimeNowLayer
extends AbstractSystemLayer
implements PropertyChangeListener {
    public TimeNowLayer(LayerContainer lc2) {
        super("Time Now", lc2);
        Timeline timeline = this.getGanttChart().getTimeline();
        Eventline eventline = timeline.getEventline();
        eventline.addPropertyChangeListener(this);
    }

    @Override
    protected void paintLayer(Graphics g2) {
        super.paintLayer(g2);
        Rectangle clip = g2.getClipBounds();
        long now = this.getEventline().getTimeNow();
        int x2 = this.getDateline().getTimeLocation(now);
        if (x2 >= clip.x && x2 < clip.x + clip.width) {
            this.paintTimeNow(g2, x2);
        }
    }

    protected void paintTimeNow(Graphics g2, int x2) {
        int start;
        Graphics2D g2d = (Graphics2D)g2;
        Composite comp = g2d.getComposite();
        Rectangle clip = g2.getClipBounds();
        g2d.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
        for (int y2 = start = clip.y - clip.y % 16; y2 < clip.y + clip.height; y2 += 16) {
            g2.setColor(Color.RED.brighter());
            g2.drawLine(x2 - 1, y2, x2 - 1, y2 + 7);
            g2.drawLine(x2, y2, x2, y2 + 7);
            g2.drawLine(x2 + 1, y2, x2 + 1, y2 + 7);
            g2.setColor(Color.RED.darker());
            g2.drawLine(x2 - 1, y2 + 7, x2 - 1, y2 + 15);
            g2.drawLine(x2, y2 + 7, x2, y2 + 15);
            g2.drawLine(x2 + 1, y2 + 7, x2 + 1, y2 + 15);
        }
        g2d.setComposite(comp);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (evt.getSource() == this.getEventline() && property.equals("timeNow")) {
            this.repaint();
        }
    }
}

