/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.layer.DefaultCreateMultipleTimelineObjectsCommand;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IDragAndDropPolicy;
import com.dlsc.flexgantt.policy.layer.IEditTimelineObjectPolicy;
import com.dlsc.flexgantt.policy.layer.IGridPolicy;
import com.dlsc.flexgantt.policy.layer.ILinePolicy;
import com.dlsc.flexgantt.policy.layer.ISelectionPolicy;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.ILayerContainerSelectionModel;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.ILassoLayerListener;
import com.dlsc.flexgantt.swing.layer.system.LassoLayerEvent;
import com.dlsc.flexgantt.swing.layer.system.LinkLayer;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectSelectionModel;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.util.Messages;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;

public class LassoLayer
extends AbstractSystemLayer
implements MouseListener,
MouseMotionListener,
KeyEventDispatcher {
    private static final Logger LOGGER = Logger.getLogger(LassoLayer.class.getName());
    private LassoMode lassoMode = LassoMode.SELECT_TIMELINE_OBJECTS;
    private LassoMode tempLassoMode;
    private SelectionBehaviour selectionBehaviour = SelectionBehaviour.INTERSECTION;
    private List<LassoMode> supportedLassoModes = Arrays.asList(LassoMode.values());
    private Point selectionStart;
    private Point selectionEnd;
    private Color selectionColor = ColorUtil.getSelectionBackground();
    private boolean singleRowObjectCreation = true;
    private ObjectBounds selectionStartBounds;
    private ObjectBounds selectionEndBounds;
    private ObjectBounds lastSelectionEndBounds;
    private Map<LassoMode, Cursor> cursorMap;
    private Map<LassoMode, Cursor> cursorMultiMap;
    private EventListenerList listenerList = new EventListenerList();
    private KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();

    public LassoLayer(LayerContainer lc2) {
        super("Lasso", lc2);
        lc2.addMouseListener(this);
        lc2.addMouseMotionListener(this);
        this.cursorMap = new HashMap<LassoMode, Cursor>(LassoMode.values().length);
        for (LassoMode mode : LassoMode.values()) {
            this.cursorMap.put(mode, this.createLassoCursor(mode, false));
        }
        this.cursorMultiMap = new HashMap<LassoMode, Cursor>(LassoMode.values().length);
        for (LassoMode mode : LassoMode.values()) {
            this.cursorMultiMap.put(mode, this.createLassoCursor(mode, true));
        }
        this.keyboardFocusManager.addKeyEventDispatcher(this);
    }

    public boolean isSelecting() {
        return this.selectionStart != null && this.selectionEnd != null;
    }

    @Override
    protected void paintLayer(Graphics g2) {
        super.paintLayer(g2);
        if (this.isSelecting()) {
            Rectangle bounds = this.getSelectedRectangle();
            this.paintLasso(g2, bounds);
        }
    }

    protected void paintLasso(Graphics g2, Rectangle lasso) {
        Graphics2D g2d = (Graphics2D)g2;
        Composite comp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2d.setColor(this.getSelectionColor());
        g2d.fillRoundRect(lasso.x, lasso.y, lasso.width, lasso.height, 4, 4);
        g2d.setColor(this.getSelectionColor().darker());
        g2d.setComposite(comp);
        g2d.setColor(this.getSelectionColor().darker());
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawRoundRect(lasso.x, lasso.y, lasso.width - 1, lasso.height - 1, 4, 4);
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        DragLayer dragLayer = this.layerContainer.getSystemLayer(DragLayer.class);
        if (!dragLayer.isDragging() && !e2.isConsumed() && this.isSelecting()) {
            Rectangle before = this.getSelectedRectangle();
            this.selectionEnd = e2.getPoint();
            this.adjustSelection();
            Rectangle after = this.getSelectedRectangle();
            Rectangle rect = before.union(after);
            if (this.selectionStartBounds != null) {
                rect = rect.union(this.selectionStartBounds);
            }
            if (this.selectionEndBounds != null) {
                rect = rect.union(this.selectionEndBounds);
            }
            if (this.lastSelectionEndBounds != null) {
                rect = rect.union(this.lastSelectionEndBounds);
            }
            rect.translate(-10, -10);
            rect.grow(20, 20);
            this.repaint(rect);
            this.fireLassoLayerEvent(LassoLayerEvent.ID.LASSO_ONGOING);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        DragLayer dragLayer;
        if (this.isLassoLocation(e2) && !(dragLayer = this.layerContainer.getSystemLayer(DragLayer.class)).isDragging()) {
            this.layerContainer.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ((mask & e2.getModifiers()) == 0 && !e2.isConsumed()) {
            LayerContainer lc2 = this.getLayerContainer();
            ILayerContainerSelectionModel sm = lc2.getSelectionModel();
            sm.clearSelectedTimeSpans();
        }
    }

    private boolean isAllowingLasso(Collection<ObjectBounds> bounds) {
        if (bounds != null && bounds.size() > 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("bounds.size() = " + bounds.size());
            }
            IPolicyProvider pp = this.getLayerPolicyProvider();
            ISelectionPolicy sp = pp.getPolicy(ISelectionPolicy.class);
            IDragAndDropPolicy dnd = pp.getPolicy(IDragAndDropPolicy.class);
            IEditTimelineObjectPolicy ep = pp.getPolicy(IEditTimelineObjectPolicy.class);
            IGanttChartModel model = this.getModel();
            for (ObjectBounds b2 : bounds) {
                TimelineObjectPath path = b2.getPath();
                Object timelineObject = b2.getObject();
                Object node = b2.getNode();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("timelineObject = " + timelineObject);
                    LOGGER.finer("node = " + node);
                }
                if (sp.isSelectable(path, model)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("timeline object is selectable");
                    }
                    return false;
                }
                int dragActions = dnd.getDragActions(path, model);
                if (dragActions != 0) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("timeline object is draggable");
                    }
                    return false;
                }
                if (ep.isStartTimeChangeable(path, model)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("timeline object is moveable");
                    }
                    return false;
                }
                if (!ep.isDurationChangeable(path, model)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("timeline object is resizable");
                }
                return false;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("timeline objects allow lasso");
        }
        return true;
    }

    private boolean isLassoLocation(MouseEvent evt) {
        Collection<ObjectBounds> bounds = this.layerContainer.getAllObjectBoundsAt(evt.getX(), evt.getY());
        if (evt.isConsumed()) {
            LOGGER.fine("event is already consumed");
            return false;
        }
        if (evt.isPopupTrigger()) {
            LOGGER.fine("event is popup trigger");
            return false;
        }
        return evt.isAltDown() || this.isAllowingLasso(bounds);
    }

    private boolean isLassoStartEvent(MouseEvent evt) {
        if (this.isVisible()) {
            if (evt.isConsumed()) {
                return false;
            }
            LinkLayer linkLayer = this.layerContainer.getSystemLayer(LinkLayer.class);
            if (linkLayer.isLinkStartLocation(evt.getPoint())) {
                return false;
            }
            return this.isLassoLocation(evt) && SwingUtilities.isLeftMouseButton(evt);
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (this.isLassoStartEvent(e2)) {
            this.selectionStart = e2.getPoint();
            this.selectionEnd = e2.getPoint();
            if (!this.layerContainer.isIgnoringTreeTableSelection()) {
                this.getTreeTable().clearSelection();
            }
            this.adjustSelection();
            this.repaint();
            this.fireLassoLayerEvent(LassoLayerEvent.ID.LASSO_STARTED);
        }
    }

    private void adjustSelection() {
        if (this.lassoMode.equals((Object)LassoMode.CREATE_TIMELINE_OBJECTS) || this.tempLassoMode != null && this.tempLassoMode.equals((Object)LassoMode.CREATE_TIMELINE_OBJECTS)) {
            TreeTable table = this.getTreeTable();
            TreeTableNode startNode = table.getTreeTableNodeAt(this.selectionStart.y);
            TreeTableNode endNode = table.getTreeTableNodeAt(this.selectionEnd.y);
            if (startNode != null) {
                this.selectionStart.y = startNode.getY();
                this.selectionEnd.y = this.isSingleRowObjectCreation() || endNode == null ? startNode.getY() + startNode.getHeight() - 1 : endNode.getY() + endNode.getHeight() - 1;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.isVisible() && !e2.isConsumed() && this.selectionStart != null) {
            LassoMode lm = this.lassoMode;
            if (this.tempLassoMode != null) {
                lm = this.tempLassoMode;
            }
            switch (lm) {
                case SELECT_TIMELINE_OBJECTS: {
                    this.selectObjects();
                    break;
                }
                case SELECT_TIME_SPANS: {
                    this.selectTimeSpans();
                    break;
                }
                case CREATE_TIMELINE_OBJECTS: {
                    this.createTimelineObjects();
                }
            }
            this.selectionStart = null;
            this.selectionEnd = null;
            this.selectionStartBounds = null;
            this.selectionEndBounds = null;
            this.fireLassoLayerEvent(LassoLayerEvent.ID.LASSO_FINISHED);
        }
        this.repaint();
    }

    private void createTimelineObjects() {
        IPolicyProvider pp = this.getLayerPolicyProvider();
        IEditTimelineObjectPolicy top = pp.getPolicy(IEditTimelineObjectPolicy.class);
        int startRow = this.getSelectedStartRow();
        if (startRow != -1) {
            int endRow = this.getSelectedEndRow();
            if (this.singleRowObjectCreation) {
                endRow = startRow;
            }
            TreeTable table = this.getTreeTable();
            List<TreeTableNode> nodes = table.getTreeTableNodes();
            ITimeSpan span = this.getSelectedTimeSpan();
            IGanttChartModel model = this.getModel();
            DefaultCreateMultipleTimelineObjectsCommand comp = new DefaultCreateMultipleTimelineObjectsCommand();
            ILayer layer = this.selectLayer();
            if (layer != null) {
                int lineIndex = this.getSelectedLineIndex();
                for (int i2 = startRow; i2 <= endRow; ++i2) {
                    ICommand cmd;
                    Object modelNode = nodes.get(i2).getModelNode();
                    if (!top.isCreatable(modelNode, model, layer, span)) continue;
                    IGranularity granularity = this.layerContainer.getGridGranularity();
                    boolean autoGrid = this.layerContainer.isGridAutomatic();
                    if (granularity != null || autoGrid) {
                        IGridPolicy gp = this.layerContainer.getGridPolicy();
                        span = gp.getGridAdjustedTimeSpan(granularity, span, this.getDateline().getModel(), autoGrid);
                    }
                    if ((cmd = top.getCreateCommand(modelNode, model, layer, span, lineIndex)) == null) continue;
                    comp.addCommand(cmd);
                }
                if (comp.getCommandCount() > 0) {
                    this.ganttChart.commandExecute(comp);
                } else {
                    this.ganttChart.showMessage(Messages.getString("LassoLayer.UNABLE_TO_CREATE_ACTIVITIES"), MessageTypeId.ERROR);
                }
            }
        }
    }

    private ILayer selectLayer() {
        ArrayList<ILayer> result = new ArrayList<ILayer>();
        IGanttChartModel model = this.getModel();
        Iterator<ILayer> layers = model.getLayers();
        while (layers.hasNext()) {
            ILayer layer = layers.next();
            if (!layer.isFeatureEnabled(ILayer.Feature.TIMELINE_OBJECT_CREATION)) continue;
            result.add(layer);
        }
        int s2 = result.size();
        if (s2 == 0) {
            throw new UnsupportedOperationException("no layer supports the creation of timeline objects");
        }
        if (s2 == 1) {
            return (ILayer)result.get(0);
        }
        Object[] selection = new ILayer[s2];
        result.toArray(selection);
        Object selectedLayer = JOptionPane.showInputDialog(this.ganttChart, Messages.getString("LassoLayer.CHOOSE_LAYER"), Messages.getString("LassoLayer.LAYER_SELECTION"), -1, null, selection, selection[0]);
        return (ILayer)selectedLayer;
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.tempLassoMode = null;
    }

    private ITimeSpan getSelectedTimeSpan() {
        Rectangle rect = this.getSelectedRectangle();
        Dateline dateline = this.getDateline();
        long startTime = dateline.getTimeAt(rect.x);
        long endTime = dateline.getTimeAt(rect.x + rect.width);
        ITimeSpan selectionSpan = new TimeSpan(startTime, endTime);
        if (this.isGridDependentLassoMode()) {
            boolean autoGrid = this.layerContainer.isGridAutomatic();
            IGranularity granularity = this.layerContainer.getGridGranularity();
            IGridPolicy gp = this.layerContainer.getGridPolicy();
            selectionSpan = gp.getGridAdjustedTimeSpan(granularity, selectionSpan, this.getDateline().getModel(), autoGrid);
        }
        return selectionSpan;
    }

    private Rectangle getSelectedRectangle() {
        int x1 = Math.min(this.selectionStart.x, this.selectionEnd.x);
        int x2 = Math.max(this.selectionStart.x, this.selectionEnd.x);
        int y1 = Math.min(this.selectionStart.y, this.selectionEnd.y);
        int y2 = Math.max(this.selectionStart.y, this.selectionEnd.y);
        if (this.isGridDependentLassoMode()) {
            long st = this.getTimeAt(x1);
            long et = this.getTimeAt(x2);
            ITimeSpan selectionSpan = new TimeSpan(st, et);
            boolean autoGrid = this.layerContainer.isGridAutomatic();
            IGranularity granularity = this.layerContainer.getGridGranularity();
            IGridPolicy gp = this.layerContainer.getGridPolicy();
            selectionSpan = gp.getGridAdjustedTimeSpan(granularity, selectionSpan, this.getDateline().getModel(), autoGrid);
            if (x1 <= x2) {
                x1 = this.getTimeLocation(selectionSpan.getStartTime());
                x2 = this.getTimeLocation(selectionSpan.getEndTime());
            } else {
                x1 = this.getTimeLocation(selectionSpan.getEndTime());
                x2 = this.getTimeLocation(selectionSpan.getStartTime());
            }
        }
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    private int getSelectedStartRow() {
        TreeTable table = this.getTreeTable();
        Rectangle lasso = this.getSelectedRectangle();
        return table.getRowAt(lasso.y);
    }

    private int getSelectedEndRow() {
        TreeTable table = this.getTreeTable();
        Rectangle lasso = this.getSelectedRectangle();
        int row = table.getRowAt(lasso.y + lasso.height);
        if (row == -1) {
            return table.getRowCount() - 1;
        }
        return row;
    }

    private int getSelectedLineIndex() {
        if (this.singleRowObjectCreation) {
            ILinePolicy lp = this.getLayerPolicyProvider().getPolicy(ILinePolicy.class);
            TreeTable table = this.getTreeTable();
            Rectangle lasso = this.getSelectedRectangle();
            int y2 = lasso.y;
            int row = table.getRowAt(y2);
            if (row != -1) {
                TreeTableNode node = table.getTreeTableNodes().get(row);
                int rowY = node.getY();
                int rowHeight = node.getHeight();
                y2 -= rowY;
                Object modelNode = node.getModelNode();
                int count = lp.getLineCount(modelNode, this.getModel());
                for (int i2 = 0; i2 < count; ++i2) {
                    int lineY = lp.getLineLocation(modelNode, this.getModel(), i2, rowHeight);
                    int lineHeight = lp.getLineHeight(modelNode, this.getModel(), i2, rowHeight);
                    if (y2 < lineY || y2 >= lineY + lineHeight) continue;
                    return i2;
                }
            }
        }
        return -1;
    }

    private boolean isGridDependentLassoMode() {
        if (this.lassoMode.equals((Object)LassoMode.CREATE_TIMELINE_OBJECTS) || this.tempLassoMode != null && this.tempLassoMode.equals((Object)LassoMode.CREATE_TIMELINE_OBJECTS)) {
            return true;
        }
        return this.lassoMode.equals((Object)LassoMode.SELECT_TIME_SPANS) || this.tempLassoMode != null && this.tempLassoMode.equals((Object)LassoMode.SELECT_TIME_SPANS);
    }

    private void selectObjects() {
        TreeTable table = this.getTreeTable();
        ITimeSpan span = this.getSelectedTimeSpan();
        LayerContainer lc2 = this.getLayerContainer();
        IGanttChartModel model = this.getModel();
        Rectangle lasso = this.getSelectedRectangle();
        int startRow = this.getSelectedStartRow();
        if (startRow != -1) {
            int endRow = this.getSelectedEndRow();
            for (int i2 = startRow; i2 <= endRow; ++i2) {
                if (i2 >= table.getRowCount()) continue;
                TreeTableNode node = table.getTreeTableNodes().get(i2);
                TreePath path = node.getPath();
                Object data = node.getModelNode();
                for (ILayer layer : lc2.getVisibleLayers()) {
                    TimelineObjectLayer layerUI = lc2.getTimelineObjectLayer(layer);
                    ITimelineObjectSelectionModel sm = this.layerContainer.getSelectionModel(layer);
                    Iterator iter = model.getTimelineObjectsIterator(data, layer, span);
                    ISelectionPolicy sp = this.getLayerPolicyProvider().getPolicy(ISelectionPolicy.class);
                    ArrayList<TimelineObjectPath> selection = new ArrayList<TimelineObjectPath>();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        TimelineObjectPath top = new TimelineObjectPath(path, obj, layer);
                        ObjectBounds bounds = layerUI.getObjectBounds(top);
                        if (!this.includeInSelection(bounds, lasso) || !sp.isSelectable(top, model)) continue;
                        TimelineObjectPath tlop = new TimelineObjectPath(path, obj, layer);
                        selection.add(tlop);
                    }
                    if (selection.size() <= 0) continue;
                    sm.addSelection(selection);
                }
            }
        }
    }

    private boolean includeInSelection(ObjectBounds bounds, Rectangle lasso) {
        switch (this.selectionBehaviour) {
            case BOUNDS_CONTAINMENT: {
                return lasso.contains(bounds);
            }
            case TIME_SPAN_CONTAINMENT: {
                return lasso.x <= bounds.x && lasso.x + lasso.width >= bounds.x + bounds.width && (lasso.y >= bounds.y && lasso.y <= bounds.y + bounds.height || lasso.y + lasso.height >= bounds.y && lasso.y + lasso.height <= bounds.y + bounds.height || lasso.y <= bounds.y && lasso.y + lasso.height >= bounds.y + bounds.height);
            }
            case INTERSECTION: {
                return lasso.intersects(bounds);
            }
        }
        return false;
    }

    private void selectTimeSpans() {
        TreeTable table = this.getTreeTable();
        int startRow = this.getSelectedStartRow();
        if (startRow != -1) {
            int endRow = this.getSelectedEndRow();
            ITimeSpan span = this.getSelectedTimeSpan();
            LayerContainer lc2 = this.getLayerContainer();
            ILayerContainerSelectionModel sm = lc2.getSelectionModel();
            IPolicyProvider pp = lc2.getPolicyProvider();
            ISelectionPolicy sp = pp.getPolicy(ISelectionPolicy.class);
            IGanttChartModel model = this.getModel();
            IGridPolicy gp = pp.getPolicy(IGridPolicy.class);
            IGranularity grid = this.layerContainer.getGridGranularity();
            IDatelineModel datelineModel = this.getDateline().getModel();
            boolean autoGrid = this.layerContainer.isGridAutomatic();
            if (grid != null || autoGrid) {
                span = gp.getGridAdjustedTimeSpan(grid, span, datelineModel, autoGrid);
            }
            List<TreeTableNode> nodes = table.getTreeTableNodes();
            if (startRow >= 0 && startRow < nodes.size()) {
                for (int i2 = startRow; i2 <= endRow; ++i2) {
                    TreeTableNode node = nodes.get(i2);
                    Object data = node.getModelNode();
                    if (!sp.isSelectable(data, span, model)) continue;
                    sm.addSelectedTimeSpan(data, span);
                }
            }
        }
        this.repaint();
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public LassoMode getLassoMode() {
        return this.lassoMode;
    }

    public void setLassoMode(LassoMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("lasso mode can not be NULL");
        }
        this.lassoMode = mode;
    }

    public boolean isSingleRowObjectCreation() {
        return this.singleRowObjectCreation;
    }

    public void setSingleRowObjectCreation(boolean single) {
        this.singleRowObjectCreation = single;
    }

    protected Cursor createLassoCursor(LassoMode mode, boolean multi) {
        IconId id2 = IconId.CURSOR_SELECT_TIMELINE_OBJECTS;
        switch (mode) {
            case SELECT_TIMELINE_OBJECTS: {
                if (multi) {
                    id2 = IconId.CURSOR_SELECT_TIMELINE_OBJECTS_MULTI;
                    break;
                }
                id2 = IconId.CURSOR_SELECT_TIMELINE_OBJECTS;
                break;
            }
            case CREATE_TIMELINE_OBJECTS: {
                id2 = IconId.CURSOR_CREATE_TIMELINE_OBJECTS;
                break;
            }
            case SELECT_TIME_SPANS: {
                id2 = multi ? IconId.CURSOR_SELECT_TIME_SPANS_MULTI : IconId.CURSOR_SELECT_TIME_SPANS;
            }
        }
        ImageIcon icon = (ImageIcon)IconRegistry.getIcon(id2);
        return Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), new Point(15, 15), "lasso_cursor");
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e2) {
        ObjectBounds bounds;
        this.tempLassoMode = null;
        DragLayer dragLayer = this.layerContainer.getSystemLayer(DragLayer.class);
        Point pos = this.layerContainer.getMousePosition();
        if (pos != null && !dragLayer.isDragging() && ((bounds = this.layerContainer.getObjectBoundsAt(pos.x, pos.y)) == null || e2.isAltDown())) {
            Cursor newCursor = this.cursorMap.get((Object)this.lassoMode);
            this.tempLassoMode = null;
            int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            if (e2.isShiftDown() || (e2.getModifiers() & mask) != 0) {
                newCursor = this.cursorMultiMap.get((Object)this.lassoMode);
            } else if (e2.isAltDown() && this.isSupportedLassoMode(LassoMode.CREATE_TIMELINE_OBJECTS)) {
                this.tempLassoMode = LassoMode.CREATE_TIMELINE_OBJECTS;
                newCursor = this.cursorMap.get((Object)this.tempLassoMode);
            }
            if (newCursor != this.layerContainer.getCursor()) {
                this.layerContainer.setCursor(newCursor);
            }
        }
        return false;
    }

    public LassoMode[] getSupportedLassoModes() {
        int s2 = this.supportedLassoModes.size();
        LassoMode[] modes = new LassoMode[s2];
        this.supportedLassoModes.toArray(modes);
        return modes;
    }

    public void setSupportedLassoModes(LassoMode ... modes) {
        if (modes == null) {
            throw new IllegalArgumentException("lasso modes can not be NULL");
        }
        this.supportedLassoModes = Arrays.asList(modes);
    }

    public boolean isSupportedLassoMode(LassoMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("lasso mode can not be NULL");
        }
        return this.supportedLassoModes.contains((Object)mode);
    }

    public void addLassoLayerListener(ILassoLayerListener l2) {
        this.listenerList.add(ILassoLayerListener.class, l2);
    }

    public void removeLassoLayerListener(ILassoLayerListener l2) {
        this.listenerList.remove(ILassoLayerListener.class, l2);
    }

    private void fireLassoLayerEvent(LassoLayerEvent.ID id2) {
        ITimeSpan span = TimeSpan.UNDEFINED;
        int startRow = -1;
        int endRow = -1;
        if (!id2.equals((Object)LassoLayerEvent.ID.LASSO_FINISHED)) {
            span = this.getSelectedTimeSpan();
            startRow = this.getSelectedStartRow();
            endRow = this.getSelectedEndRow();
        }
        LassoMode mode = this.getLassoMode();
        if (this.tempLassoMode != null) {
            mode = this.tempLassoMode;
        }
        LassoLayerEvent lassoEvent = new LassoLayerEvent(this, id2, span, startRow, endRow, mode);
        this.fireLassoLayerEvent(lassoEvent);
    }

    protected void fireLassoLayerEvent(LassoLayerEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("lasso layer event can not be NULL");
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ILassoLayerListener.class) continue;
            ((ILassoLayerListener)listeners[i2 + 1]).lassoChanged(evt);
        }
    }

    public SelectionBehaviour getSelectionBehaviour() {
        return this.selectionBehaviour;
    }

    public void setSelectionBehaviour(SelectionBehaviour behaviour) {
        if (behaviour == null) {
            throw new IllegalArgumentException("behaviour can not be NULL");
        }
        this.selectionBehaviour = behaviour;
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.keyboardFocusManager.removeKeyEventDispatcher(this);
    }

    public static enum SelectionBehaviour {
        INTERSECTION,
        TIME_SPAN_CONTAINMENT,
        BOUNDS_CONTAINMENT;

    }

    public static enum LassoMode {
        SELECT_TIMELINE_OBJECTS,
        CREATE_TIMELINE_OBJECTS,
        SELECT_TIME_SPANS;

    }
}

