/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.gantt.DefaultActivityObject;
import com.dlsc.flexgantt.model.gantt.DefaultCapacityObject;
import com.dlsc.flexgantt.model.gantt.IActivityObject;
import com.dlsc.flexgantt.model.gantt.ICapacityObject;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.IResourceNode;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IDragAndDropPolicy;
import com.dlsc.flexgantt.policy.layer.IDragInfoPolicy;
import com.dlsc.flexgantt.policy.layer.IEditActivityObjectPolicy;
import com.dlsc.flexgantt.policy.layer.IEditCapacityObjectPolicy;
import com.dlsc.flexgantt.policy.layer.IEditTimelineObjectPolicy;
import com.dlsc.flexgantt.policy.layer.IGridPolicy;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.system.ActivityObjectEditModeController;
import com.dlsc.flexgantt.swing.layer.system.CapacityObjectEditModeController;
import com.dlsc.flexgantt.swing.layer.system.DefaultDragInfoRenderer;
import com.dlsc.flexgantt.swing.layer.system.DefaultDragRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.DefaultEditModeController;
import com.dlsc.flexgantt.swing.layer.system.DragLayerEvent;
import com.dlsc.flexgantt.swing.layer.system.IDragInfoRenderer;
import com.dlsc.flexgantt.swing.layer.system.IDragLayerListener;
import com.dlsc.flexgantt.swing.layer.system.IDragRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.IEditModeController;
import com.dlsc.flexgantt.swing.layer.system.LinkLayer;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectSelectionModel;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import com.dlsc.flexgantt.swing.util.MultiDropTarget;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;

public class DragLayer
extends AbstractSystemLayer
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
MouseMotionListener {
    private static final Logger LOGGER = Logger.getLogger(DragLayer.class.getName());
    private static IEditModeController.EditMode editMode = IEditModeController.EditMode.NONE;
    private static Rectangle dragBounds;
    private static Point dragOffset;
    private static ObjectBounds dragObjectBounds;
    static DataFlavor localObjectFlavor;
    private boolean targetOfDrop;
    private Map<IEditModeController.EditMode, Cursor> cursorMap;
    private Map<Class, IDragInfoRenderer> dragInfoRendererMap;
    private Map<Class, IDragInfoRenderer> dragInfoRendererCache;
    private Map<Class, IDragRowRenderer> dragRowRendererMap;
    private Map<Class, IDragRowRenderer> dragRowRendererCache;
    private Map<Class, IEditModeController> editModeControllerMap;
    private Map<Class, IEditModeController> editModeControllerCache;
    private Point dragOverLocation;
    private boolean dragInfoVisible = true;
    private double oldPercentage;
    private double oldCapacity;
    private EventListenerList listenerList = new EventListenerList();
    private Rectangle lastDrawnRectangle;
    private double percentageComplete;
    private long percentageCompleteTime;
    private double capacityUsed;
    private int capacityUsedRowHeight;
    private int capacityUsedY;
    private int dragAction = 0;
    private DropTarget dropTarget;
    private MouseEvent triggerEvent;
    private boolean showingDefaultCursors = true;

    public DragLayer(LayerContainer lc2) {
        super("Drag", lc2);
        this.createCursors();
        this.dragInfoRendererMap = new HashMap<Class, IDragInfoRenderer>(8);
        this.dragInfoRendererCache = new HashMap<Class, IDragInfoRenderer>(8);
        this.dragRowRendererMap = new HashMap<Class, IDragRowRenderer>(8);
        this.dragRowRendererCache = new HashMap<Class, IDragRowRenderer>(8);
        this.editModeControllerMap = new HashMap<Class, IEditModeController>(2);
        this.editModeControllerCache = new HashMap<Class, IEditModeController>(2);
        this.setDragInfoRenderer(Object.class, new DefaultDragInfoRenderer());
        this.setDragRowRenderer(Object.class, new DefaultDragRowRenderer());
        this.setEditModeController(Object.class, new DefaultEditModeController());
        this.setEditModeController(DefaultActivityObject.class, new ActivityObjectEditModeController());
        this.setEditModeController(DefaultCapacityObject.class, new CapacityObjectEditModeController());
        this.setAlpha(0.8f);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(lc2, 3, this);
        this.dropTarget = new MultiDropTarget(lc2, 3, this);
        lc2.addMouseMotionListener(this);
    }

    private void createCursors() {
        this.cursorMap = new HashMap<IEditModeController.EditMode, Cursor>(IEditModeController.EditMode.values().length);
        for (IEditModeController.EditMode mode : IEditModeController.EditMode.values()) {
            Cursor cursor = this.createEditModeCursor(mode);
            this.cursorMap.put(mode, cursor);
        }
    }

    public boolean isDragging() {
        return dragBounds != null;
    }

    @Override
    protected void paintLayer(Graphics g2) {
        super.paintLayer(g2);
        if (dragBounds != null && dragObjectBounds != null && this.targetOfDrop && this.layerContainer.getMousePosition() != null) {
            Object dropNode;
            this.paintDragRowRenderers(g2);
            TimelineObjectPath path = dragObjectBounds.getPath();
            TreeTableNode treeNode = dragObjectBounds.getTreeTableNode();
            Object timelineObject = dragObjectBounds.getObject();
            Graphics2D g2d = (Graphics2D)g2;
            Composite comp = g2d.getComposite();
            switch (editMode) {
                case CHANGE_CAPACITY: 
                case CHANGE_PERCENTAGE_COMPLETE: {
                    break;
                }
                case CHANGE_END_TIME: 
                case CHANGE_START_TIME: 
                case CHANGE_TIME_SPAN: 
                case NONE: {
                    if (dragObjectBounds.getLayerUI().getLayerContainer() != this.getLayerContainer()) break;
                }
                case CHANGE_NODE: 
                case CHANGE_NODE_AND_TIME_SPAN: {
                    TimelineObjectLayer layer = dragObjectBounds.getLayerUI();
                    int row = treeNode.getRow();
                    ITimelineObjectRenderer renderer = this.layerContainer.getTimelineObjectRenderer(timelineObject.getClass());
                    Component rendererComp = renderer.getTimelineObjectRendererComponent(layer, path, false, true, false, row);
                    this.layerContainer.getRendererPane().paintComponent(g2, rendererComp, this.layerContainer, DragLayer.dragBounds.x, DragLayer.dragBounds.y, DragLayer.dragBounds.width, DragLayer.dragBounds.height, true);
                    g2d.setComposite(comp);
                }
            }
            this.lastDrawnRectangle = new Rectangle(dragBounds);
            if (this.isDragInfoVisible() && this.dragOverLocation != null && (dropNode = this.getDropNode(this.dragOverLocation.y)) != null) {
                IDragInfoRenderer infoRenderer;
                ITimeSpan dropSpan = this.getDropSpan(this.dragOverLocation.x);
                IPolicyProvider pp = this.layerContainer.getPolicyProvider();
                IDragInfoPolicy dip = pp.getPolicy(IDragInfoPolicy.class);
                Object dragInfo = null;
                dragInfo = editMode.equals((Object)IEditModeController.EditMode.CHANGE_PERCENTAGE_COMPLETE) ? dip.getDragInfo(path, this.getModel(), this.percentageCompleteTime, this.percentageComplete) : (editMode.equals((Object)IEditModeController.EditMode.CHANGE_CAPACITY) ? dip.getDragInfo(path, this.getModel(), this.capacityUsedRowHeight, this.capacityUsedY, this.capacityUsed) : dip.getDragInfo(path, this.getModel(), this.getDateline().getModel(), dropNode, dropSpan));
                if (dragInfo != null && (infoRenderer = this.getDragInfoRenderer(dragInfo.getClass())) != null) {
                    Component rendererComp = infoRenderer.getDragInfoRendererComponent(this, path, dragInfo, dropSpan, this.dragAction);
                    Rectangle infoBounds = this.calculateInfoBounds();
                    this.layerContainer.getRendererPane().paintComponent(g2, rendererComp, this.layerContainer, infoBounds.x, infoBounds.y, infoBounds.width, infoBounds.height, true);
                    this.lastDrawnRectangle = this.lastDrawnRectangle.union(infoBounds);
                }
            }
        }
    }

    protected void paintDragRowRenderers(Graphics g2) {
        if (this.layerContainer.hasClipNodes()) {
            int width = this.layerContainer.getWidth();
            for (TreeTableNode node : this.layerContainer.getClipNodes()) {
                Object modelNode = node.getModelNode();
                IDragRowRenderer rowRenderer = this.getDragRowRenderer(modelNode.getClass());
                TimelineObjectPath path = dragObjectBounds.getPath();
                Object timelineObject = dragObjectBounds.getObject();
                ITimeSpan span = dragObjectBounds.getModel().getTimeSpan(timelineObject);
                Component rendererComp = rowRenderer.getDragRowRendererComponent(this, modelNode, path, span, this.dragAction);
                this.layerContainer.getRendererPane().paintComponent(g2, rendererComp, this.layerContainer, 0, node.getY(), width, node.getHeight(), true);
            }
        }
    }

    private Rectangle calculateInfoBounds() {
        Object dropNode;
        if (this.isDragInfoVisible() && this.dragOverLocation != null && (dropNode = this.getDropNode(this.dragOverLocation.y)) != null) {
            IDragInfoRenderer infoRenderer;
            TimelineObjectPath path = dragObjectBounds.getPath();
            ITimeSpan dropSpan = this.getDropSpan(this.dragOverLocation.x);
            IPolicyProvider pp = this.layerContainer.getPolicyProvider();
            IDragInfoPolicy dip = pp.getPolicy(IDragInfoPolicy.class);
            Object dragInfo = null;
            dragInfo = editMode.equals((Object)IEditModeController.EditMode.CHANGE_PERCENTAGE_COMPLETE) ? dip.getDragInfo(path, this.getModel(), this.percentageCompleteTime, this.percentageComplete) : (editMode.equals((Object)IEditModeController.EditMode.CHANGE_CAPACITY) ? dip.getDragInfo(path, this.getModel(), this.capacityUsedRowHeight, this.capacityUsedY, this.capacityUsed) : dip.getDragInfo(path, this.getModel(), this.getDateline().getModel(), dropNode, dropSpan));
            if (dragInfo != null && (infoRenderer = this.getDragInfoRenderer(dragInfo.getClass())) != null) {
                Component rendererComp = infoRenderer.getDragInfoRendererComponent(this, path, dragInfo, dropSpan, this.dragAction);
                Dimension dim = rendererComp.getPreferredSize();
                Rectangle infoBounds = new Rectangle(this.dragOverLocation.x, DragLayer.dragBounds.y + DragLayer.dragBounds.height + 5, dim.width, dim.height);
                return infoBounds;
            }
        }
        return null;
    }

    private ITimeSpan getDropSpan(int x2) {
        ITimeSpan targetSpan = new TimeSpan(dragObjectBounds.getTimeSpan());
        IPolicyProvider pp = this.getLayerPolicyProvider();
        IGridPolicy gp = pp.getPolicy(IGridPolicy.class);
        IGranularity grid = this.layerContainer.getGridGranularity();
        IDatelineModel datelineModel = this.getDateline().getModel();
        boolean autoGrid = this.layerContainer.isGridAutomatic();
        switch (editMode) {
            case CHANGE_NODE: {
                targetSpan = dragObjectBounds.getTimeSpan();
                break;
            }
            case CHANGE_TIME_SPAN: {
                long newStartTime = this.getTimeAt(x2 - DragLayer.dragOffset.x);
                long duration = dragObjectBounds.getTimeSpan().getDuration();
                if (grid != null || autoGrid) {
                    newStartTime = gp.getGridAdjustedStartTime(grid, newStartTime, datelineModel, autoGrid);
                }
                targetSpan = new TimeSpan(newStartTime, newStartTime + duration);
                break;
            }
            case CHANGE_NODE_AND_TIME_SPAN: {
                long newStartTime = this.getTimeAt(x2 - DragLayer.dragOffset.x);
                long duration = dragObjectBounds.getTimeSpan().getDuration();
                targetSpan = new TimeSpan(newStartTime, newStartTime + duration);
                if (grid != null || autoGrid) {
                    long adjusted = gp.getGridAdjustedStartTime(grid, targetSpan.getStartTime(), datelineModel, autoGrid);
                    targetSpan = new TimeSpan(adjusted, adjusted + duration);
                    break;
                }
                long st = targetSpan.getStartTime();
                targetSpan = new TimeSpan(st, st + duration);
                break;
            }
            case CHANGE_START_TIME: {
                long newStartTime = this.getTimeAt(x2);
                if (grid != null || autoGrid) {
                    newStartTime = Math.min(targetSpan.getEndTime(), gp.getGridAdjustedStartTime(grid, newStartTime, datelineModel, autoGrid));
                }
                targetSpan = new TimeSpan(newStartTime, targetSpan.getEndTime());
                break;
            }
            case CHANGE_END_TIME: {
                long newEndTime = this.getTimeAt(x2);
                if (grid != null || autoGrid) {
                    newEndTime = Math.max(targetSpan.getStartTime(), gp.getGridAdjustedEndTime(grid, newEndTime, datelineModel, autoGrid));
                }
                newEndTime = Math.max(newEndTime, targetSpan.getStartTime());
                targetSpan = new TimeSpan(targetSpan.getStartTime(), newEndTime);
                break;
            }
        }
        return targetSpan;
    }

    private Object getDropNode(int y2) {
        TreeTable table = this.getTreeTable();
        TreeTableNode node = table.getTreeTableNodeAt(y2);
        if (node != null) {
            return node.getModelNode();
        }
        return null;
    }

    private Object[] getSelectionsOnSameNode(ObjectBounds bounds) {
        ArrayList list = new ArrayList();
        TreePath path = new TreePath(bounds.getPath().getPath());
        LayerContainer lc2 = bounds.getLayerUI().getLayerContainer();
        for (ILayer layer : lc2.getVisibleLayers()) {
            ITimelineObjectSelectionModel selectionModel = lc2.getSelectionModel(layer);
            Iterator<TimelineObjectPath> iter = selectionModel.getSelection(path);
            while (iter.hasNext()) {
                TimelineObjectPath tloPath = iter.next();
                list.add(tloPath.getTimelineObject());
            }
        }
        list.remove(bounds.getPath().getTimelineObject());
        int s2 = list.size();
        Object[] result = new Object[s2];
        list.toArray(result);
        return result;
    }

    public void setDragInfoRenderer(Class objectType, IDragInfoRenderer renderer) {
        if (objectType == null) {
            throw new IllegalArgumentException("the object type can not be NULL");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("the drag info renderer can not be NULL");
        }
        this.dragInfoRendererCache.clear();
        this.dragInfoRendererMap.put(objectType, renderer);
    }

    public IDragInfoRenderer getDragInfoRenderer(Class cl) {
        if (cl == null) {
            return null;
        }
        IDragInfoRenderer renderer = this.dragInfoRendererCache.get(cl);
        if (renderer != null) {
            return renderer;
        }
        renderer = this.dragInfoRendererMap.get(cl);
        if (renderer != null) {
            this.dragInfoRendererCache.put(cl, renderer);
            return renderer;
        }
        renderer = this.getDragInfoRenderer(cl.getSuperclass());
        this.dragInfoRendererCache.put(cl, renderer);
        return renderer;
    }

    public boolean isDragInfoVisible() {
        return this.dragInfoVisible;
    }

    public void setDragInfoVisible(boolean visible) {
        this.dragInfoVisible = visible;
    }

    public void setDragRowRenderer(Class objectType, IDragRowRenderer renderer) {
        if (objectType == null) {
            throw new IllegalArgumentException("the object type can not be NULL");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("the drag row renderer can not be NULL");
        }
        this.dragRowRendererCache.clear();
        this.dragRowRendererMap.put(objectType, renderer);
    }

    public IDragRowRenderer getDragRowRenderer(Class cl) {
        if (cl == null) {
            return null;
        }
        IDragRowRenderer renderer = this.dragRowRendererCache.get(cl);
        if (renderer != null) {
            return renderer;
        }
        renderer = this.dragRowRendererMap.get(cl);
        if (renderer != null) {
            this.dragRowRendererCache.put(cl, renderer);
            return renderer;
        }
        renderer = this.getDragRowRenderer(cl.getSuperclass());
        this.dragRowRendererCache.put(cl, renderer);
        return renderer;
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        ObjectBounds bounds;
        if (e2.isAltDown()) {
            return;
        }
        if (this.layerContainer.isDraggingEnabled() && (bounds = this.layerContainer.getObjectBoundsAt(e2.getX(), e2.getY())) != null) {
            Object timelineObject = bounds.getObject();
            IEditModeController controller = this.getEditModeController(timelineObject.getClass());
            if (controller == null) {
                throw new IllegalArgumentException("no edit mode controller found for timeline object of type " + bounds.getClass().getName());
            }
            editMode = controller.getEditMode(this, bounds, e2);
            this.layerContainer.setCursor(this.cursorMap.get((Object)editMode));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        this.triggerEvent = (MouseEvent)dge.getTriggerEvent();
        if (this.triggerEvent.isAltDown()) {
            return;
        }
        LinkLayer linkLayer = this.layerContainer.getSystemLayer(LinkLayer.class);
        if (!linkLayer.isLinking() && this.layerContainer.isDraggingEnabled() && (dragObjectBounds = this.getLayerContainer().getObjectBoundsAt(this.triggerEvent.getPoint().x, this.triggerEvent.getPoint().y)) != null) {
            this.dragAction = dge.getDragAction();
            boolean dragAllowed1 = this.isDraggable(dragObjectBounds, dge);
            boolean dragAllowed2 = this.isPercentageEditable(dragObjectBounds);
            boolean dragAllowed3 = this.isCapacityEditable(dragObjectBounds);
            if (dragAllowed1 || dragAllowed2 || dragAllowed3) {
                dragBounds = new Rectangle(dragObjectBounds);
                Object timelineObject = dragObjectBounds.getObject();
                IEditModeController controller = this.getEditModeController(timelineObject.getClass());
                editMode = controller.getEditMode(this, dragObjectBounds, this.triggerEvent);
                Cursor cursor = this.cursorMap.get((Object)editMode);
                dragOffset = new Point(this.triggerEvent.getX() - DragLayer.dragObjectBounds.x, this.triggerEvent.getY() - DragLayer.dragObjectBounds.y);
                this.targetOfDrop = true;
                this.dragOverLocation = null;
                BufferedImage dragImage = new BufferedImage(1, 1, 2);
                dge.startDrag(cursor, dragImage, new Point(0, 0), new ObjectBoundsTransferable(dragObjectBounds), this);
                DragLayerEvent dragLayerEvent = new DragLayerEvent(this, DragLayerEvent.ID.DRAG_STARTED, dragObjectBounds, dragObjectBounds.getTimeSpan(), dge.getDragAction());
                if (!editMode.equals((Object)IEditModeController.EditMode.CHANGE_PERCENTAGE_COMPLETE)) {
                    this.ensureSelection(dragObjectBounds);
                }
                this.fireDragLayerEvent(dragLayerEvent);
            }
        }
    }

    private void ensureSelection(ObjectBounds dragBounds) {
        TimelineObjectPath path = dragBounds.getPath();
        ILayer layer = dragBounds.getLayer();
        ITimelineObjectSelectionModel selectionModel = this.layerContainer.getSelectionModel(layer);
        selectionModel.addSelection(path);
    }

    private boolean isDraggable(ObjectBounds bounds, DragGestureEvent dge) {
        IPolicyProvider pp = this.layerContainer.getPolicyProvider();
        IDragAndDropPolicy dnd = pp.getPolicy(IDragAndDropPolicy.class);
        TimelineObjectPath path = bounds.getPath();
        IGanttChartModel model = bounds.getModel();
        this.dragAction = dge.getDragAction();
        int possibleDragActions = dnd.getDragActions(path, model);
        boolean allowed1 = (this.dragAction & possibleDragActions) != 0;
        IEditTimelineObjectPolicy ep = pp.getPolicy(IEditTimelineObjectPolicy.class);
        boolean allowed2 = ep.isStartTimeChangeable(path, model);
        boolean allowed3 = ep.isDurationChangeable(path, model);
        return allowed1 || allowed2 || allowed3;
    }

    private boolean isPercentageEditable(ObjectBounds bounds) {
        Object timelineObject = bounds.getObject();
        if (timelineObject instanceof IActivityObject) {
            this.oldPercentage = ((IActivityObject)timelineObject).getPercentageComplete();
            IPolicyProvider pp = this.layerContainer.getPolicyProvider();
            IEditActivityObjectPolicy policy = pp.getPolicy(IEditActivityObjectPolicy.class);
            TimelineObjectPath path = bounds.getPath();
            return policy.isPercentageChangeable(path, bounds.getModel());
        }
        return false;
    }

    private boolean isCapacityEditable(ObjectBounds bounds) {
        Object timelineObject = bounds.getObject();
        if (timelineObject instanceof ICapacityObject) {
            this.oldCapacity = ((ICapacityObject)timelineObject).getCapacityUsed();
            IPolicyProvider pp = this.layerContainer.getPolicyProvider();
            IEditCapacityObjectPolicy policy = pp.getPolicy(IEditCapacityObjectPolicy.class);
            TimelineObjectPath path = bounds.getPath();
            return policy.isCapacityChangeable(path, bounds.getModel());
        }
        return false;
    }

    protected Image createDragImage(ObjectBounds bounds) {
        Object timelineObject = bounds.getObject();
        TimelineObjectLayer layerUI = bounds.getLayerUI();
        Class<?> cl = timelineObject.getClass();
        ITimelineObjectRenderer renderer = this.layerContainer.getTimelineObjectRenderer(cl);
        int row = bounds.getTreeTableNode().getRow();
        TimelineObjectPath path = bounds.getPath();
        Component comp = renderer.getTimelineObjectRendererComponent(layerUI, path, false, false, false, row);
        comp.setBounds(bounds);
        BufferedImage image = new BufferedImage(bounds.width, bounds.height, 2);
        Graphics2D g2 = image.createGraphics();
        comp.paint(g2);
        return image;
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        dragObjectBounds = null;
        dragBounds = null;
        this.dragAction = 0;
        this.targetOfDrop = false;
        this.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        this.dragAction = dsde.getDropAction();
        this.targetOfDrop = true;
        this.repaint();
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        this.dragAction = 0;
        this.targetOfDrop = false;
        this.repaint();
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragAction = dtde.getDropAction();
        this.targetOfDrop = true;
        this.repaint();
        DragLayerEvent dragLayerEvent = new DragLayerEvent(this, DragLayerEvent.ID.DRAG_STARTED, dragObjectBounds, TimeSpan.UNDEFINED, 0);
        this.fireDragLayerEvent(dragLayerEvent);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.dragAction = 0;
        this.targetOfDrop = false;
        this.repaint();
        DragLayerEvent dragLayerEvent = new DragLayerEvent(this, DragLayerEvent.ID.DRAG_FINISHED, dragObjectBounds, TimeSpan.UNDEFINED, 0);
        this.fireDragLayerEvent(dragLayerEvent);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        boolean dropFromOutside = false;
        Transferable trans = dtde.getTransferable();
        try {
            if (trans.getTransferData(localObjectFlavor) instanceof ObjectBounds) {
                this.dragAction = dtde.getDropAction();
                this.dragOverLocation = dtde.getLocation();
                Object timelineObject = dragObjectBounds.getObject();
                switch (editMode) {
                    case CHANGE_TIME_SPAN: {
                        DragLayer.dragBounds.x = (int)(this.dragOverLocation.getX() - dragOffset.getX());
                        break;
                    }
                    case CHANGE_NODE: {
                        DragLayer.dragBounds.y = (int)(this.dragOverLocation.getY() - dragOffset.getY());
                        IPolicyProvider pp = this.layerContainer.getPolicyProvider();
                        IDragAndDropPolicy dnd = pp.getPolicy(IDragAndDropPolicy.class);
                        TreeTable table = this.layerContainer.getTreeTable();
                        TreeTableNode newNode = table.getTreeTableNodeAt(this.dragOverLocation.y);
                        if (newNode != null) {
                            TimelineObjectPath path;
                            int dropActions;
                            Object newModelNode = newNode.getModelNode();
                            IGanttChartModel oldModel = dragObjectBounds.getModel();
                            IGanttChartModel newModel = this.layerContainer.getModel();
                            IDatelineModel datelineModel = this.getDateline().getModel();
                            boolean autoGrid = this.layerContainer.isGridAutomatic();
                            long newStartTime = this.getTimeAt(this.dragOverLocation.x);
                            IGranularity gridGranularity = this.layerContainer.getGridGranularity();
                            if (gridGranularity != null || autoGrid) {
                                IGridPolicy gp = pp.getPolicy(IGridPolicy.class);
                                newStartTime = gp.getGridAdjustedStartTime(gridGranularity, newStartTime, datelineModel, autoGrid);
                            }
                            if ((dropActions = dnd.getDropActions(path = dragObjectBounds.getPath(), oldModel, newModelNode, newModel, newStartTime)) != 0) {
                                dtde.acceptDrag(dropActions);
                                break;
                            }
                            dtde.rejectDrag();
                            break;
                        }
                        dtde.rejectDrag();
                        break;
                    }
                    case CHANGE_NODE_AND_TIME_SPAN: {
                        DragLayer.dragBounds.x = (int)(this.dragOverLocation.getX() - dragOffset.getX());
                        DragLayer.dragBounds.y = (int)(this.dragOverLocation.getY() - dragOffset.getY());
                        break;
                    }
                    case CHANGE_START_TIME: {
                        int x2 = DragLayer.dragBounds.x + DragLayer.dragBounds.width;
                        DragLayer.dragBounds.x = (int)(this.dragOverLocation.getX() - dragOffset.getX());
                        DragLayer.dragBounds.width = x2 - DragLayer.dragBounds.x;
                        break;
                    }
                    case CHANGE_END_TIME: {
                        DragLayer.dragBounds.width = (int)(this.dragOverLocation.getX() - (double)DragLayer.dragBounds.x);
                        break;
                    }
                    case CHANGE_PERCENTAGE_COMPLETE: {
                        int x1 = DragLayer.dragBounds.x;
                        int x2 = this.dragOverLocation.x;
                        this.percentageComplete = Math.min(100.0, (double)Math.max(0, x2 - x1) / dragBounds.getWidth() * 100.0);
                        this.percentageCompleteTime = this.getTimeAt(x2);
                        LOGGER.fine("percentage = " + this.percentageComplete);
                        ((IActivityObject)timelineObject).setPercentageComplete(this.percentageComplete);
                        break;
                    }
                    case CHANGE_CAPACITY: {
                        int y2 = this.dragOverLocation.y;
                        Object modelNode = dragObjectBounds.getNode();
                        if (!(modelNode instanceof IResourceNode)) {
                            throw new IllegalArgumentException("the tree node needs to implement the " + IResourceNode.class.getName() + " interface!");
                        }
                        if (!(timelineObject instanceof ICapacityObject)) {
                            throw new IllegalArgumentException("the timeline object needs to implement the " + ICapacityObject.class.getName() + " interface!");
                        }
                        IResourceNode resourceNode = (IResourceNode)modelNode;
                        ICapacityObject capObject = (ICapacityObject)timelineObject;
                        TreeTableNode treeTableNode = dragObjectBounds.getTreeTableNode();
                        this.capacityUsedRowHeight = treeTableNode.getHeight();
                        int rowY = treeTableNode.getY();
                        this.capacityUsedY = Math.min(this.capacityUsedRowHeight, Math.max(0, rowY + this.capacityUsedRowHeight - y2));
                        this.capacityUsed = resourceNode.getCapacityAt(this.capacityUsedRowHeight, this.capacityUsedY);
                        capObject.setCapacityUsed(this.capacityUsed);
                        this.repaint(DragLayer.dragBounds.x, rowY, DragLayer.dragBounds.width, this.capacityUsedRowHeight);
                        break;
                    }
                }
                Rectangle infoBounds = this.calculateInfoBounds();
                if (this.lastDrawnRectangle != null) {
                    if (infoBounds != null) {
                        this.repaint(dragBounds.union(this.lastDrawnRectangle).union(infoBounds));
                    } else {
                        this.repaint(dragBounds.union(this.lastDrawnRectangle));
                    }
                } else if (infoBounds != null) {
                    this.repaint(dragBounds.union(infoBounds));
                } else {
                    this.repaint(dragBounds);
                }
                ITimeSpan dropSpan = this.getDropSpan(this.dragOverLocation.x);
                DragLayerEvent dragLayerEvent = new DragLayerEvent(this, DragLayerEvent.ID.DRAG_ONGOING, dragObjectBounds, dropSpan, dtde.getDropAction());
                this.fireDragLayerEvent(dragLayerEvent);
            } else {
                dropFromOutside = true;
            }
        }
        catch (Exception ex) {
            dropFromOutside = true;
            LOGGER.throwing(this.getClass().getName(), "dragOver()", ex);
        }
        if (dropFromOutside) {
            long time = this.getTimeAt(dtde.getLocation().x);
            ITimeSpan span = new TimeSpan(time);
            boolean autoGrid = this.layerContainer.isGridAutomatic();
            IGridPolicy gp = this.layerContainer.getGridPolicy();
            IGranularity gridGranularity = this.layerContainer.getGridGranularity();
            span = gp.getGridAdjustedTimeSpan(gridGranularity, span, this.getDateline().getModel(), autoGrid);
            DragLayerEvent evt = new DragLayerEvent(this, DragLayerEvent.ID.DRAG_ONGOING, null, span, dtde.getDropAction());
            this.fireDragLayerEvent(evt);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable trans = dtde.getTransferable();
        Point dropLocation = dtde.getLocation();
        try {
            if (dtde.isDataFlavorSupported(localObjectFlavor) && trans.getTransferData(localObjectFlavor) instanceof ObjectBounds) {
                dragObjectBounds = (ObjectBounds)trans.getTransferData(localObjectFlavor);
                ITimeSpan dropSpan = this.getDropSpan(dropLocation.x);
                Object dropNode = this.getDropNode(dropLocation.y);
                Object timelineObject = dragObjectBounds.getObject();
                TimelineObjectPath path = dragObjectBounds.getPath();
                if (dropNode == null) {
                    dtde.rejectDrop();
                    this.repaint();
                    return;
                }
                Object node = dragObjectBounds.getNode();
                ILayer layer = dragObjectBounds.getLayer();
                IGanttChartModel model = dragObjectBounds.getModel();
                IPolicyProvider pp = this.getLayerPolicyProvider();
                IEditTimelineObjectPolicy ep = pp.getPolicy(IEditTimelineObjectPolicy.class);
                int dropAction = dtde.getDropAction();
                ICommand cmd = null;
                switch (editMode) {
                    case CHANGE_NODE: 
                    case CHANGE_NODE_AND_TIME_SPAN: {
                        if (node.equals(dropNode)) {
                            cmd = ep.getChangeTimeSpanCommand(path, model, dropSpan, dropAction);
                            break;
                        }
                        IGanttChartModel newModel = this.getModel();
                        IDragAndDropPolicy dnd = pp.getPolicy(IDragAndDropPolicy.class);
                        int supportedDropActions = dnd.getDropActions(path, model, dropNode, newModel, dropSpan.getStartTime());
                        if ((dtde.getDropAction() & supportedDropActions) == 0) {
                            dtde.rejectDrop();
                            break;
                        }
                        Object[] selections = this.getSelectionsOnSameNode(dragObjectBounds);
                        cmd = dnd.getDragAndDropCommand(path, model, dropNode, newModel, dropSpan.getStartTime(), selections, layer, dtde.getDropAction());
                        break;
                    }
                    case CHANGE_END_TIME: 
                    case CHANGE_START_TIME: 
                    case CHANGE_TIME_SPAN: {
                        cmd = ep.getChangeTimeSpanCommand(path, model, dropSpan, dropAction);
                        break;
                    }
                    case CHANGE_PERCENTAGE_COMPLETE: {
                        IEditActivityObjectPolicy ap = pp.getPolicy(IEditActivityObjectPolicy.class);
                        if (!ap.isPercentageChangeable(path, model)) break;
                        double xx = DragLayer.dragBounds.x;
                        double p2 = Math.min(100.0, Math.max(0.0, (double)dropLocation.x - xx) / dragBounds.getWidth() * 100.0);
                        LOGGER.fine("percentage = " + p2);
                        ((IActivityObject)dragObjectBounds.getObject()).setPercentageComplete(this.oldPercentage);
                        cmd = ap.getChangePercentageCommand(path, model, p2);
                        break;
                    }
                    case CHANGE_CAPACITY: {
                        int y2 = this.dragOverLocation.y;
                        Object modelNode = dragObjectBounds.getNode();
                        if (!(modelNode instanceof IResourceNode)) {
                            throw new IllegalArgumentException("the tree node needs to implement the " + IResourceNode.class.getName() + " interface!");
                        }
                        if (!(timelineObject instanceof ICapacityObject)) {
                            throw new IllegalArgumentException("the timeline object needs to implement the " + ICapacityObject.class.getName() + " interface!");
                        }
                        IResourceNode resourceNode = (IResourceNode)modelNode;
                        ICapacityObject capObject = (ICapacityObject)timelineObject;
                        capObject.setCapacityUsed(this.oldCapacity);
                        TreeTableNode treeTableNode = dragObjectBounds.getTreeTableNode();
                        int rowHeight = treeTableNode.getHeight();
                        int rowY = treeTableNode.getY();
                        double newCapacity = resourceNode.getCapacityAt(rowHeight, Math.min(rowHeight, Math.max(0, rowY + rowHeight - y2)));
                        IEditCapacityObjectPolicy ecp = pp.getPolicy(IEditCapacityObjectPolicy.class);
                        if (!ecp.isCapacityChangeable(path, model)) break;
                        cmd = ecp.getChangeCapacityCommand(path, model, newCapacity);
                        break;
                    }
                }
                if (cmd != null) {
                    this.ganttChart.commandExecute(cmd);
                } else {
                    this.repaint();
                }
                DragLayerEvent dragLayerEvent = new DragLayerEvent(this, DragLayerEvent.ID.DRAG_FINISHED, dragObjectBounds, dropSpan, dtde.getDropAction());
                this.fireDragLayerEvent(dragLayerEvent);
            } else {
                LOGGER.fine("data flavor is not supported");
                DragLayerEvent dragLayerEvent = new DragLayerEvent(this, DragLayerEvent.ID.DRAG_FINISHED, null, TimeSpan.UNDEFINED, dtde.getDropAction());
                this.fireDragLayerEvent(dragLayerEvent);
            }
        }
        catch (UnsupportedFlavorException ex) {
            LOGGER.throwing(this.getClass().getName(), "drop()", ex);
            DragLayerEvent dragLayerEvent = new DragLayerEvent(this, DragLayerEvent.ID.DRAG_FINISHED, null, TimeSpan.UNDEFINED, dtde.getDropAction());
            this.fireDragLayerEvent(dragLayerEvent);
        }
        catch (IOException ex) {
            LOGGER.throwing(this.getClass().getName(), "drop()", ex);
        }
        editMode = IEditModeController.EditMode.NONE;
        dragBounds = null;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.dragAction = dtde.getDropAction();
        this.repaint();
    }

    public void addDragLayerListener(IDragLayerListener l2) {
        this.listenerList.add(IDragLayerListener.class, l2);
    }

    public void removeDragLayerListener(IDragLayerListener l2) {
        this.listenerList.remove(IDragLayerListener.class, l2);
    }

    protected void fireDragLayerEvent(DragLayerEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("drag layer event can not be NULL");
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IDragLayerListener.class) continue;
            ((IDragLayerListener)listeners[i2 + 1]).dragging(evt);
        }
    }

    public void setEditModeController(Class objectType, IEditModeController controller) {
        if (objectType == null) {
            throw new IllegalArgumentException("the object type can not be NULL");
        }
        if (controller == null) {
            throw new IllegalArgumentException("the controller can not be NULL");
        }
        this.editModeControllerCache.clear();
        this.editModeControllerMap.put(objectType, controller);
    }

    public IEditModeController getEditModeController(Class cl) {
        if (cl == null) {
            return null;
        }
        IEditModeController controller = this.editModeControllerCache.get(cl);
        if (controller != null) {
            return controller;
        }
        controller = this.editModeControllerMap.get(cl);
        if (controller != null) {
            this.editModeControllerCache.put(cl, controller);
            return controller;
        }
        controller = this.getEditModeController(cl.getSuperclass());
        this.editModeControllerCache.put(cl, controller);
        return controller;
    }

    public void setShowingDefaultCursors(boolean show) {
        this.showingDefaultCursors = show;
        this.createCursors();
    }

    public boolean isShowingDefaultCursors() {
        return this.showingDefaultCursors;
    }

    protected Cursor createEditModeCursor(IEditModeController.EditMode mode) {
        if (this.showingDefaultCursors) {
            return this.createEditModeDefaultCursors(mode);
        }
        return this.createEditModeCustomCursors(mode);
    }

    protected Cursor createEditModeCustomCursors(IEditModeController.EditMode mode) {
        IconId id2 = null;
        Point hotSpot = new Point(16, 16);
        switch (mode) {
            case CHANGE_CAPACITY: {
                id2 = IconId.CURSOR_EDIT_CAPACITY;
                break;
            }
            case CHANGE_PERCENTAGE_COMPLETE: {
                id2 = IconId.CURSOR_EDIT_PERCENTAGE;
                hotSpot = new Point(31, 15);
                break;
            }
            case CHANGE_START_TIME: {
                id2 = IconId.CURSOR_CHANGE_START_TIME;
                break;
            }
            case CHANGE_END_TIME: {
                id2 = IconId.CURSOR_CHANGE_END_TIME;
                break;
            }
            case CHANGE_TIME_SPAN: {
                id2 = IconId.CURSOR_MOVE_HORIZONTAL;
                break;
            }
            case CHANGE_NODE: {
                id2 = IconId.CURSOR_MOVE_VERTICAL;
                break;
            }
            case CHANGE_NODE_AND_TIME_SPAN: {
                id2 = IconId.CURSOR_MOVE;
                break;
            }
            default: {
                return Cursor.getPredefinedCursor(0);
            }
        }
        ImageIcon icon = (ImageIcon)IconRegistry.getIcon(id2);
        return Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), hotSpot, mode.toString());
    }

    protected Cursor createEditModeDefaultCursors(IEditModeController.EditMode mode) {
        switch (mode) {
            case CHANGE_CAPACITY: {
                return Cursor.getPredefinedCursor(8);
            }
            case CHANGE_PERCENTAGE_COMPLETE: {
                IconId id2 = IconId.CURSOR_EDIT_PERCENTAGE;
                ImageIcon icon = (ImageIcon)IconRegistry.getIcon(id2);
                Point hotSpot = new Point(31, 15);
                return Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), hotSpot, mode.toString());
            }
            case CHANGE_START_TIME: {
                return Cursor.getPredefinedCursor(10);
            }
            case CHANGE_END_TIME: {
                return Cursor.getPredefinedCursor(11);
            }
            case CHANGE_TIME_SPAN: {
                return Cursor.getPredefinedCursor(0);
            }
            case CHANGE_NODE: {
                return Cursor.getPredefinedCursor(0);
            }
            case CHANGE_NODE_AND_TIME_SPAN: {
                return Cursor.getPredefinedCursor(0);
            }
        }
        return Cursor.getPredefinedCursor(0);
    }

    public IEditModeController.EditMode getEditMode() {
        return editMode;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public MouseEvent getTriggerEvent() {
        return this.triggerEvent;
    }

    static {
        dragOffset = new Point(0, 0);
        try {
            localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException e2) {
            LOGGER.log(Level.WARNING, "error while creating DataFlavor.javaJVMLocalObjectMimeType", e2);
        }
    }

    class ObjectBoundsTransferable
    implements Transferable {
        private ObjectBounds bounds;

        public ObjectBoundsTransferable(ObjectBounds bounds) {
            this.bounds = bounds;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{localObjectFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(localObjectFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.bounds;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public ObjectBounds getObjectBounds() {
            return this.bounds;
        }
    }
}

