/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.system.AbstractPopupRenderer;
import com.dlsc.flexgantt.swing.layer.system.PopupLayer;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.tree.TreePath;

public class DefaultPopupRenderer
extends AbstractPopupRenderer {
    private static final Logger LOGGER = Logger.getLogger(DefaultPopupRenderer.class.getName());
    private JTextArea area;

    @Override
    protected JComponent createContentArea() {
        this.area = new JTextArea();
        this.area.setEditable(false);
        this.area.setOpaque(false);
        return this.area;
    }

    @Override
    public JComponent getPopupRendererComponent(PopupLayer pl, Object titleValue, Object popupValue, TimelineObjectPath path, IGanttChartModel model, boolean pinned) {
        super.getPopupRendererComponent(pl, titleValue, popupValue, path, model, pinned);
        String text = this.getPopupText(popupValue);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("text: " + text);
        }
        this.area.setText(text);
        return this;
    }

    @Override
    public Component getPopupRendererComponent(PopupLayer pl, Object titleValue, Object popupValue, TreePath path, IGanttChartModel model, boolean pinned) {
        super.getPopupRendererComponent(pl, titleValue, popupValue, path, model, pinned);
        String text = this.getPopupText(popupValue);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("text: " + text);
        }
        this.area.setText(text);
        return this;
    }

    @Override
    public Component getPopupRendererComponent(PopupLayer pl, Object titleValue, Object popupValue, IRelationship relationship, IGanttChartModel model) {
        super.getPopupRendererComponent(pl, titleValue, popupValue, relationship, model);
        String text = this.getPopupText(popupValue);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("text: " + text);
        }
        this.area.setText(text);
        return this;
    }

    @Override
    protected String getPopupText(Object popupValue) {
        if (popupValue != null) {
            return popupValue.toString();
        }
        return "";
    }

    public JTextArea getTextArea() {
        return this.area;
    }
}

