/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TimeZone;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TimeZonePanel
extends JPanel {
    private JList list = new JList();

    public TimeZonePanel() {
        this.updateList(null);
        this.list.setCellRenderer(new TimeZoneListCellRenderer());
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(20);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.list));
    }

    private void updateList(String filter) {
        if (filter != null) {
            filter = filter.toLowerCase();
        }
        DefaultListModel<TimeZone> model = new DefaultListModel<TimeZone>();
        String[] available = TimeZone.getAvailableIDs();
        int l2 = available.length;
        ArrayList<TimeZone> zones = new ArrayList<TimeZone>();
        for (int i2 = 0; i2 < l2; ++i2) {
            TimeZone zone = TimeZone.getTimeZone(available[i2]);
            if (filter != null && !zone.getDisplayName().toLowerCase().contains(filter)) continue;
            zones.add(zone);
        }
        Collections.sort(zones, new Comparator<TimeZone>(){

            @Override
            public int compare(TimeZone tz1, TimeZone tz2) {
                String s1 = tz1.getDisplayName() + tz1.getID();
                String s2 = tz2.getDisplayName() + tz2.getID();
                return s1.compareTo(s2);
            }
        });
        for (TimeZone zone : zones) {
            model.addElement(zone);
        }
        this.list.setModel(model);
    }

    public TimeZone getSelectedTimeZone() {
        return (TimeZone)this.list.getSelectedValue();
    }

    public void setSelectedTimeZone(TimeZone zone) {
        this.list.setSelectedValue(zone, true);
    }

    public JList getList() {
        return this.list;
    }

    public void setFilter(String filter) {
        this.updateList(filter);
    }

    private class TimeZoneListCellRenderer
    extends DefaultListCellRenderer {
        private TimeZoneListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            TimeZone zone = (TimeZone)value;
            this.setText(zone.getDisplayName() + " (" + zone.getID() + ")");
            this.setIcon(IconRegistry.getIcon(IconId.TIME_ZONE));
            return this;
        }
    }
}

