/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.command.CommandStackEvent;
import com.dlsc.flexgantt.command.DefaultCommandStack;
import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.ICommandStack;
import com.dlsc.flexgantt.command.ICommandStackListener;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.command.IProgressMonitorFactory;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.calendar.ICalendarModel;
import com.dlsc.flexgantt.model.calendar.TimeGranularityCalendarModel;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ISpreadsheet;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.paging.IPagingModel;
import com.dlsc.flexgantt.model.paging.IPagingModelListener;
import com.dlsc.flexgantt.model.paging.Page;
import com.dlsc.flexgantt.model.paging.PagingEvent;
import com.dlsc.flexgantt.model.treetable.ColumnModelEvent;
import com.dlsc.flexgantt.model.treetable.DefaultColumnModel;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.model.treetable.IColumnModelListener;
import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.model.treetable.KeyColumn;
import com.dlsc.flexgantt.model.treetable.SortDirection;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.PolicyProvider;
import com.dlsc.flexgantt.policy.gantt.IStatusBarPolicy;
import com.dlsc.flexgantt.policy.gantt.TimeGranularityStatusBarPolicy;
import com.dlsc.flexgantt.swing.DefaultComponentFactory;
import com.dlsc.flexgantt.swing.GanttChartProgressMonitor;
import com.dlsc.flexgantt.swing.ICommandInterceptor;
import com.dlsc.flexgantt.swing.IComponentFactory;
import com.dlsc.flexgantt.swing.IEditable;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.IMessageListener;
import com.dlsc.flexgantt.swing.ISortingListener;
import com.dlsc.flexgantt.swing.ITimelineObjectPathMessage;
import com.dlsc.flexgantt.swing.ITreePathMessage;
import com.dlsc.flexgantt.swing.LicenseDialog;
import com.dlsc.flexgantt.swing.MessageDialog;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.SortingEvent;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.layer.system.SpreadsheetLayer;
import com.dlsc.flexgantt.swing.print.PrintContext;
import com.dlsc.flexgantt.swing.print.PrintGanttChart;
import com.dlsc.flexgantt.swing.print.PrintSetup;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.selector.TimeGranularitySelectorFactory;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.CellFocusManager;
import com.dlsc.flexgantt.swing.treetable.IColumnHeaderRenderer;
import com.dlsc.flexgantt.swing.treetable.ITreeTableCellEditor;
import com.dlsc.flexgantt.swing.treetable.ITreeTableCellRenderer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import com.dlsc.flexgantt.swing.treetable.TreeTableScrollPane;
import com.dlsc.flexgantt.util.FlexGanttLicenseManager;
import com.dlsc.flexgantt.util.GridLineMode;
import com.dlsc.flexgantt.util.Messages;
import com.dlsc.flexgantt.util.Version;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreePath;

public abstract class AbstractGanttChart
extends JPanel
implements IColumnModelListener,
PropertyChangeListener,
IPagingModelListener,
KeyListener,
ICommandStackListener {
    private static final Logger LOGGER = Logger.getLogger(AbstractGanttChart.class.getName());
    private static boolean naggingShown;
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_COLUMN_MODEL = "columnModel";
    public static final String PROPERTY_CALENDAR_MODEL = "calendarModel";
    public static final String PROPERTY_POLICY_PROVIDER = "policyProvider";
    public static final String PROPERTY_COMMAND_STACK = "commandStack";
    public static final String PROPERTY_TREE_TABLE_ROW_HEADER_WIDTH = "treeTableRowHeaderWidth";
    public static final String PROPERTY_LAYER_CONTAINER_ROW_HEADER_WIDTH = "layerContainerRowHeaderWidth";
    public static final String PROPERTY_GRID_LINE_MODE = "gridLineMode";
    public static final String PROPERTY_CONTROLS_BG_COLOR = "controlsBgColor";
    public static final String PROPERTY_CONTROLS_FG_COLOR = "controlsFgColor";
    public static final String PROPERTY_CALENDAR_VISIBLE = "calendarVisible";
    public static final String PROPERTY_CROSSHAIR_VISIBLE = "crosshairVisible";
    public static final String PROPERTY_KEY_COLUMN_POSITION = "keyColumnPosition";
    public static final String PROPERTY_LABELS_VISIBLE = "labelsVisible";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";
    public static final String PROPERTY_RELATIONS_VISIBLE = "relationsVisible";
    public static final String PROPERTY_ROW_LAYER_VISIBLE = "rowLayerVisible";
    public static final String PROPERTY_TIME_NOW_VISIBLE = "timeNowVisible";
    public static final String PROPERTY_VERTICAL_LINES_ON_TOP = "verticalLinesOnTop";
    public static final String PROPERTY_TIME_NOW_SCROLLING = "timeNowScrolling";
    public static final String PROPERTY_PAGING_MODEL = "pagingModel";
    public static final String PROPERTY_ROW_RESIZE_POSITION = "rowResizePosition";
    public static final String PROPERTY_ACTIVE_SPREADSHEET = "activeSpreadsheet";
    private static final String INSTALLATION_DATE = "INST_DATE";
    private static final String NAGGING_DATE = "NAG_DATE";
    private Timeline timeline;
    private Dateline dateline;
    private ICommandStack commandStack = new DefaultCommandStack();
    private List<IMessage> messages = new ArrayList<IMessage>();
    private IColumnModel columnModel;
    private TreeTableHeader treeTableHeader;
    private MessageDialog messageDialog;
    private IProgressMonitorFactory progressMonitorFactory;
    private IComponentFactory componentFactory;
    private IGanttChartModel model;
    private Map<Class<? extends ICommand>, ICommandInterceptor> interceptorMap;
    private ICalendarModel calendarModel;
    private IPolicyProvider policyProvider;
    private int keyColumnPosition = 0;
    private Color controlsBackgroundColor = UIManager.getColor("Panel.background");
    private Color controlsForegroundColor = UIManager.getColor("Panel.foreground");
    private GridLineMode gridLineMode = GridLineMode.MINOR_GRID_LINES;
    private boolean popupVisible;
    private boolean relationsVisible = true;
    private boolean labelsVisible = true;
    private boolean calendarVisible = true;
    private boolean crosshairVisible;
    private boolean rowLayerVisible = true;
    private boolean timeNowVisible = true;
    private boolean verticalLinesOnTop;
    private int treeTableRowHeaderWidth = 50;
    private int layerContainerRowHeaderWidth = 50;
    private boolean timeNowScrolling;
    private IPagingModel pagingModel;
    private List<TreeTableColumn> availableColumns;
    private int rowResizePosition = -1;
    private List<Action> toolbarActions;
    private boolean showingCommandExceptions = true;
    private PrintSetup printSetup;
    private ISpreadsheet activeSpreadsheet;

    protected AbstractGanttChart(IGanttChartModel model, IColumnModel columnModel, IComponentFactory compFactory) {
        super(true);
        if (model == null) {
            throw new IllegalArgumentException("a model must be provided, it can not be NULL");
        }
        if (columnModel == null) {
            throw new IllegalArgumentException("a column model must be provided, it can not be NULL");
        }
        if (compFactory == null) {
            throw new IllegalArgumentException("a gantt chart must have a component factory");
        }
        this.interceptorMap = new HashMap<Class<? extends ICommand>, ICommandInterceptor>(10);
        this.availableColumns = new ArrayList<TreeTableColumn>();
        this.setModel(model);
        this.setFocusable(true);
        this.calendarModel = new TimeGranularityCalendarModel();
        this.componentFactory = compFactory;
        this.progressMonitorFactory = new ProgressMonitorFactory(this);
        this.commandStack.addCommandStackListener(this);
        this.setColumnModel(columnModel);
        this.timeline = compFactory.createTimeline(this);
        this.dateline = this.timeline.getDateline();
        this.dateline.addPropertyChangeListener(this);
        this.treeTableHeader = compFactory.createTreeTableHeader(this);
        this.addPropertyChangeListener(this);
        this.policyProvider = new PolicyProvider();
        this.policyProvider.setPolicy(IStatusBarPolicy.class, new TimeGranularityStatusBarPolicy());
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e2) {
                AbstractGanttChart.this.nagging();
            }

            @Override
            public void componentMoved(ComponentEvent e2) {
                AbstractGanttChart.this.nagging();
            }

            @Override
            public void componentResized(ComponentEvent e2) {
                AbstractGanttChart.this.nagging();
            }

            @Override
            public void componentShown(ComponentEvent e2) {
                AbstractGanttChart.this.nagging();
            }
        });
        this.addKeyListener(this);
        this.setFocusTraversalKeysEnabled(false);
        this.printSetup = new PrintSetup();
    }

    protected AbstractGanttChart(IGanttChartModel model, IColumnModel columnModel) {
        this(model, columnModel, DefaultComponentFactory.getInstance());
    }

    protected AbstractGanttChart(IColumnModel columnModel) {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()), columnModel, DefaultComponentFactory.getInstance());
    }

    protected AbstractGanttChart(IGanttChartModel model, IComponentFactory compFactory) {
        this(model, new DefaultColumnModel(), compFactory);
    }

    protected AbstractGanttChart(IComponentFactory compFactory) {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()), new DefaultColumnModel(), compFactory);
    }

    protected AbstractGanttChart(IGanttChartModel model) {
        this(model, new DefaultColumnModel(), DefaultComponentFactory.getInstance());
    }

    protected AbstractGanttChart() {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()));
    }

    private synchronized void nagging() {
        if (!naggingShown && !FlexGanttLicenseManager.isRuntimeLicense()) {
            naggingShown = true;
            System.out.println("FlexGantt user interface framework for Java");
            if (FlexGanttLicenseManager.isTrialLicense()) {
                System.out.println("Unlicensed evaluation / trial version.");
                this.showNaggingScreen();
                this.checkEvaluationPeriod();
                this.exitAfter30Minutes();
                System.out.println("Application will automatically SHUT DOWN in 30 minutes");
            } else if (FlexGanttLicenseManager.isDevelopmentLicense()) {
                System.out.println("Development License (do not use in production systems)");
            }
            System.out.println("(c) 2006-2012 Dirk Lemmermann Software & Consulting");
            System.out.println("http://www.dlsc.com");
        }
    }

    private void showNaggingScreen() {
        long duration;
        Preferences prefs = Preferences.userNodeForPackage(AbstractGanttChart.class);
        long systemTime = Calendar.getInstance().getTimeInMillis();
        long naggingScreenLastShownOn = prefs.getLong(NAGGING_DATE, -1L);
        if (naggingScreenLastShownOn == -1L) {
            naggingScreenLastShownOn = systemTime;
            prefs.putLong(NAGGING_DATE, naggingScreenLastShownOn);
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                LOGGER.throwing(AbstractGanttChart.class.getName(), "showNaggingScreen()", ex);
            }
        }
        if ((duration = systemTime - naggingScreenLastShownOn) > 14400000L) {
            prefs.putLong(NAGGING_DATE, systemTime);
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                LOGGER.throwing(AbstractGanttChart.class.getName(), "showNaggingScreen()", ex);
            }
            Window window = SwingUtilities.getWindowAncestor(this);
            UnlicensedDialog dialog = null;
            dialog = window instanceof Dialog ? new UnlicensedDialog((Dialog)window) : new UnlicensedDialog((Frame)window);
            dialog.setModal(true);
            dialog.setVisible(true);
        }
    }

    private void exitAfter30Minutes() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1800000L);
                    System.err.println("### Trial duration expired after 30 minutes.");
                    System.err.println("### Exiting application.");
                    System.exit(0);
                }
                catch (InterruptedException e2) {
                    LOGGER.throwing(AbstractGanttChart.class.getName(), "run()", e2);
                }
            }
        };
        thread.setName("LicenseThread");
        thread.start();
    }

    private void checkEvaluationPeriod() {
        long remainingDays = this.getRemainingDays();
        if (remainingDays > 0L) {
            System.out.println("Evaluation period ends in " + remainingDays + " days!");
        } else {
            System.err.println("############################################################");
            System.err.println("#                                                          #");
            System.err.println("#   FlexGantt evaluation period has ended after 30 days!   #");
            System.err.println("#                                                          #");
            System.err.println("############################################################");
            System.exit(0);
        }
    }

    private long getRemainingDays() {
        long systemTime = Calendar.getInstance().getTimeInMillis();
        Preferences prefs = Preferences.userNodeForPackage(AbstractGanttChart.class);
        long instDate = prefs.getLong(INSTALLATION_DATE, -1L);
        if (instDate == -1L) {
            prefs.putLong(INSTALLATION_DATE, systemTime);
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                LOGGER.throwing(AbstractGanttChart.class.getName(), "checkEvaluationPeriod()", ex);
            }
            instDate = systemTime;
        }
        long daysUsed = (systemTime - instDate) / 86400000L;
        long remainingDays = 30L - daysUsed;
        return remainingDays;
    }

    public void setModel(IGanttChartModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        IGanttChartModel oldModel = this.model;
        this.model = model;
        this.firePropertyChange(PROPERTY_MODEL, oldModel, model);
    }

    public IGanttChartModel getModel() {
        return this.model;
    }

    public void setTimeSpan(ITimeSpan span) {
        try {
            this.getDatelineModel().setTimeSpan(span);
        }
        catch (DatelineModelException ex) {
            LOGGER.throwing(this.getClass().getName(), "setTimeSpan", ex);
            this.showMessage(Messages.getString("AbstractGanttChart.TIME_SPAN_REQUEST_FAILED"), MessageTypeId.ERROR);
        }
    }

    public void setGranularity(IGranularity granularity) {
        try {
            this.getDatelineModel().setGranularity(granularity);
        }
        catch (DatelineModelException ex) {
            LOGGER.throwing(this.getClass().getName(), "setGranularity", ex);
            this.showMessage(Messages.getString("AbstractGanttChart.GRANULARITY_REQUEST_FAILED"), MessageTypeId.ERROR);
        }
    }

    public IGranularity getGranularity() {
        IDatelineModel model = this.getDatelineModel();
        return model.getGranularity();
    }

    public ITimeSpan getTimeSpan() {
        return this.getDatelineModel().getTimeSpan();
    }

    public void setCommandStack(ICommandStack stack) {
        if (stack == null) {
            throw new IllegalArgumentException("command stack can not be NULL");
        }
        ICommandStack oldStack = this.commandStack;
        this.commandStack = stack;
        this.firePropertyChange(PROPERTY_COMMAND_STACK, oldStack, stack);
    }

    public ICommandStack getCommandStack() {
        return this.commandStack;
    }

    public void setCommandInterceptor(Class<? extends ICommand> cl, ICommandInterceptor interceptor) {
        if (cl == null) {
            throw new IllegalArgumentException("class can not be NULL");
        }
        if (interceptor == null) {
            this.interceptorMap.remove(cl);
        } else {
            this.interceptorMap.put(cl, interceptor);
        }
    }

    public ICommandInterceptor getCommandInterceptor(Class cl) {
        if (cl == null) {
            return null;
        }
        ICommandInterceptor interceptor = this.interceptorMap.get(cl);
        if (interceptor != null) {
            return interceptor;
        }
        return this.getCommandInterceptor(cl.getSuperclass());
    }

    public void commandExecute(ICommand cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("command can not be NULL");
        }
        ICommandInterceptor interceptor = this.getCommandInterceptor(cmd.getClass());
        boolean success = true;
        if (interceptor != null) {
            success = interceptor.intercept(this, cmd);
        }
        if (success) {
            IProgressMonitor monitor = this.progressMonitorFactory.createProgressMonitor();
            this.commandStack.execute(cmd, monitor);
        }
    }

    public void commandUndo() {
        if (this.commandStack.isUndoable()) {
            IProgressMonitor monitor = this.progressMonitorFactory.createProgressMonitor();
            this.commandStack.undo(monitor);
        }
    }

    public void commandRedo() {
        if (this.commandStack.isRedoable()) {
            IProgressMonitor monitor = this.progressMonitorFactory.createProgressMonitor();
            this.commandStack.redo(monitor);
        }
    }

    public void setColumnModel(IColumnModel model) {
        int i2;
        int count;
        TreeTableColumn column;
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        IColumnModel oldModel = this.columnModel;
        if (oldModel != null) {
            oldModel.removeColumnModelListener(this);
            column = oldModel.getKeyColumn();
            if (column != null) {
                column.removePropertyChangeListener(this);
            }
            count = oldModel.getColumnCount();
            for (i2 = 0; i2 < count; ++i2) {
                column = oldModel.getColumn(i2);
                column.removePropertyChangeListener(this);
            }
        }
        this.columnModel = model;
        this.columnModel.addColumnModelListener(this);
        column = model.getKeyColumn();
        if (column != null) {
            column.addPropertyChangeListener(this);
        }
        count = model.getColumnCount();
        for (i2 = 0; i2 < count; ++i2) {
            column = model.getColumn(i2);
            column.addPropertyChangeListener(this);
        }
        this.firePropertyChange(PROPERTY_COLUMN_MODEL, oldModel, model);
    }

    public IColumnModel getColumnModel() {
        return this.columnModel;
    }

    public TreeTableColumn getColumn(int index) {
        return this.columnModel.getColumn(index);
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    @Override
    public void columnModelChanged(ColumnModelEvent e2) {
        switch (e2.getId()) {
            case COLUMN_ADDED: 
            case COLUMN_INSERTED: {
                e2.getColumn().addPropertyChangeListener(this);
                break;
            }
            case COLUMN_REMOVED: {
                e2.getColumn().removePropertyChangeListener(this);
                break;
            }
        }
        this.repaint();
    }

    public TreeTableHeader getTreeTableHeader() {
        return this.treeTableHeader;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public Dateline getDateline() {
        return this.dateline;
    }

    public IDatelineModel getDatelineModel() {
        return this.getDateline().getModel();
    }

    public Eventline getEventline() {
        return this.timeline.getEventline();
    }

    public void addMessage(IMessage msg) {
        this.messages.add(msg);
        this.fireMessageAdded(msg);
    }

    public void removeMessage(IMessage msg) {
        this.messages.remove(msg);
        this.fireMessageRemoved(msg);
    }

    public void clearMessages() {
        this.messages.clear();
        this.fireMessagesCleared();
    }

    public Collection<IMessage> getMessages() {
        return this.messages;
    }

    public void addMessageListener(IMessageListener l2) {
        this.listenerList.add(IMessageListener.class, l2);
    }

    public void removeMessageListener(IMessageListener l2) {
        this.listenerList.remove(IMessageListener.class, l2);
    }

    protected void fireMessageAdded(IMessage msg) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IMessageListener.class) continue;
            ((IMessageListener)listeners[i2 + 1]).messageAdded(msg);
        }
    }

    protected void fireMessageRemoved(IMessage msg) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IMessageListener.class) continue;
            ((IMessageListener)listeners[i2 + 1]).messageRemoved(msg);
        }
    }

    protected void fireMessagesCleared() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IMessageListener.class) continue;
            ((IMessageListener)listeners[i2 + 1]).messagesCleared();
        }
    }

    public void showMessages() {
        if (this.messageDialog == null) {
            Window owner = SwingUtilities.getWindowAncestor(this);
            if (owner instanceof Frame) {
                this.messageDialog = new MessageDialog((Frame)owner, this);
            } else if (owner instanceof Dialog) {
                this.messageDialog = new MessageDialog((Dialog)owner, this);
            }
        }
        if (this.messageDialog != null) {
            this.messageDialog.setVisible(true);
        }
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        if (this.rowResizePosition != -1) {
            this.paintRowResizePosition(g2);
        }
    }

    protected void paintRowResizePosition(Graphics g2) {
        g2.setColor(Color.BLACK);
        g2.fillRect(0, this.rowResizePosition - 1, this.getWidth(), 3);
    }

    public void print(boolean preview) {
        this.print(preview, this.getTimeSpan());
    }

    public abstract void print(boolean var1, ITimeSpan var2);

    public PrintGanttChart createPrintableGanttChart(PrintContext context) {
        return new PrintGanttChart(context);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this)) {
            if (evt.getPropertyName().equals(PROPERTY_ROW_RESIZE_POSITION)) {
                Integer y1 = Math.min((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
                Integer y2 = Math.max((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
                this.repaint(0, y1 - 2, this.getWidth(), y2 - y1 + 4);
            } else if (evt.getPropertyName().equals(PROPERTY_COMMAND_STACK)) {
                ICommandStack oldStack = (ICommandStack)evt.getOldValue();
                ICommandStack newStack = (ICommandStack)evt.getNewValue();
                oldStack.removeCommandStackListener(this);
                newStack.addCommandStackListener(this);
            }
        }
    }

    public void showMessage(String msg) {
        this.showMessage(msg, MessageTypeId.INFORMATION);
    }

    public void showMessage(String msg, MessageTypeId id2) {
        this.showMessage(msg, id2, null);
    }

    public void showMessage(String msg, MessageTypeId id2, Object details) {
        String title = null;
        int messageType = 1;
        switch (id2) {
            case WARNING: {
                title = Messages.getString("AbstractGanttChart.MESSAGE_TITLE_WARNING");
                messageType = 2;
                break;
            }
            case ERROR: {
                title = Messages.getString("AbstractGanttChart.MESSAGE_TITLE_ERROR");
                messageType = 0;
                break;
            }
            case INFORMATION: {
                title = Messages.getString("AbstractGanttChart.MESSAGE_TITLE_INFORMATION");
                messageType = 1;
            }
        }
        JOptionPane.showMessageDialog(this, msg, title, messageType);
        if (details != null && details instanceof Exception) {
            ((Exception)details).printStackTrace();
        }
    }

    public void showMessageContext(IMessage msg) {
        if (msg instanceof ITimelineObjectPathMessage) {
            ITimelineObjectPathMessage pm = (ITimelineObjectPathMessage)msg;
            TimelineObjectPath path = pm.getTimelineObjectPath();
            boolean found = false;
            for (TreeTableScrollPane ttsp : this.getTreeTableScrollPanes()) {
                TreeTable table = ttsp.getTreeTable();
                if (!table.containsPath(path)) continue;
                table.expandPath(path);
                table.scrollTo(path);
                table.getLayerContainer().clearHighlightedObjects();
                table.getLayerContainer().addHighlightedObject(path);
                found = true;
            }
            if (found) {
                ITimeSpan span = this.getModel().getTimeSpan(path.getTimelineObject());
                this.showTime(span.getStartTime(), true);
            }
        } else if (msg instanceof ITreePathMessage) {
            ITreePathMessage pm = (ITreePathMessage)msg;
            TreePath treePath = pm.getTreePath();
            for (TreeTableScrollPane ttsp : this.getTreeTableScrollPanes()) {
                TreeTable table = ttsp.getTreeTable();
                if (!table.containsPath(treePath)) continue;
                table.expandPath(treePath);
                table.scrollTo(treePath);
            }
        }
    }

    public void showAllObjects() {
        ITimeSpan span = TimeSpan.UNDEFINED;
        for (LayerContainerScrollPane lcsp : this.getLayerContainerScrollPanes()) {
            LayerContainer lc2 = lcsp.getLayerContainer();
            ITimeSpan usedSpan = lc2.getTimeSpanUsed();
            span = span.union(usedSpan);
        }
        if (span != null && !span.isUndefined()) {
            Dateline dateline = this.getDateline();
            ITimeSpan horizon = dateline.getTimeSpan();
            dateline.requestVisibleTimeSpan(horizon.intersection(span));
        }
    }

    public void showEarliestObjects() {
        long time = Long.MAX_VALUE;
        for (LayerContainerScrollPane lcsp : this.getLayerContainerScrollPanes()) {
            LayerContainer lc2 = lcsp.getLayerContainer();
            ITimeSpan used = lc2.getTimeSpanUsed();
            time = Math.min(time, used.getStartTime());
        }
        this.showTime(time, true);
    }

    public void showLatestObjects() {
        long time = Long.MIN_VALUE;
        for (LayerContainerScrollPane lcsp : this.getLayerContainerScrollPanes()) {
            LayerContainer lc2 = lcsp.getLayerContainer();
            ITimeSpan used = lc2.getTimeSpanUsed();
            time = Math.max(time, used.getEndTime());
        }
        this.showTime(time, true);
    }

    public void showTimeNow(boolean center) {
        Eventline el = this.getTimeline().getEventline();
        long timeNow = el.getTimeNow();
        if (this.getTimeSpan().contains(timeNow)) {
            this.showTime(timeNow, center);
        } else {
            String msg = Messages.getString("AbstractGanttChart.TIME_NOW_OUTSIDE_HORIZON");
            this.showMessage(msg, MessageTypeId.WARNING);
        }
    }

    public void showTime(long time, boolean center) {
        LayerContainerScrollPane[] lcsp = this.getLayerContainerScrollPanes();
        LayerContainer lc2 = lcsp[0].getLayerContainer();
        Rectangle visible = lc2.getVisibleRect();
        int x2 = this.getDateline().getTimeLocation(time);
        x2 = Math.max(x2, 0);
        x2 = Math.min(x2, lc2.getWidth() - 1);
        if (center) {
            lc2.scrollRectToVisible(new Rectangle(x2 - visible.width / 2, visible.y, visible.width, visible.height));
        } else {
            lc2.scrollRectToVisible(new Rectangle(x2, visible.y, visible.width, visible.height));
        }
    }

    public abstract PrintContext[] getPrintContexts();

    public abstract LayerContainerScrollPane[] getLayerContainerScrollPanes();

    public abstract LayerContainer[] getLayerContainers();

    public abstract TreeTableScrollPane[] getTreeTableScrollPanes();

    public abstract TreeTable[] getTreeTables();

    public abstract IGridComponent[] getGridComponents();

    public void collapseAll() {
        for (TreeTableScrollPane ttsp : this.getTreeTableScrollPanes()) {
            ttsp.getTreeTable().collapseAll();
        }
    }

    public void expandAll() {
        for (TreeTableScrollPane ttsp : this.getTreeTableScrollPanes()) {
            ttsp.getTreeTable().expandAll();
        }
    }

    public void alignStartTimes() {
        for (LayerContainerScrollPane lcsp : this.getLayerContainerScrollPanes()) {
            lcsp.getLayerContainer().alignStartTimes();
        }
    }

    public void alignEndTimes() {
        for (LayerContainerScrollPane lcsp : this.getLayerContainerScrollPanes()) {
            lcsp.getLayerContainer().alignEndTimes();
        }
    }

    public void addSortingListener(ISortingListener l2) {
        this.listenerList.add(ISortingListener.class, l2);
    }

    public void removeSortingListener(ISortingListener l2) {
        this.listenerList.remove(ISortingListener.class, l2);
    }

    protected void fireSortingEvent(SortingEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ISortingListener.class) continue;
            ((ISortingListener)listeners[i2 + 1]).sorting(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortTables(int[] modelIndices, boolean[] sortDirections) {
        try {
            this.fireSortingEvent(new SortingEvent(this, SortingEvent.ID.SORTING_STARTED));
            for (TreeTableScrollPane pane : this.getTreeTableScrollPanes()) {
                TreeTable table = pane.getTreeTable();
                ITreeTableModel model = table.getModel();
                model.sort(model.getRoot(), modelIndices, sortDirections);
            }
        }
        finally {
            this.fireSortingEvent(new SortingEvent(this, SortingEvent.ID.SORTING_FINISHED));
        }
    }

    public abstract void resetToPreferredSizes();

    public void setProgressMonitorFactory(IProgressMonitorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("progress monitor factory can not be NULL");
        }
        this.progressMonitorFactory = factory;
    }

    public IProgressMonitorFactory getProgressMonitorFactory() {
        return this.progressMonitorFactory;
    }

    public IComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public ICalendarModel getCalendarModel() {
        return this.calendarModel;
    }

    public void setCalendarModel(ICalendarModel model) {
        if (model == null) {
            throw new IllegalArgumentException("calendar model can not be NULL");
        }
        ICalendarModel oldModel = this.calendarModel;
        this.calendarModel = model;
        this.firePropertyChange(PROPERTY_CALENDAR_MODEL, oldModel, model);
    }

    public IPolicyProvider getPolicyProvider() {
        return this.policyProvider;
    }

    public void setPolicyProvider(IPolicyProvider provider) {
        IPolicyProvider oldProvider = this.policyProvider;
        this.policyProvider = provider;
        this.firePropertyChange(PROPERTY_POLICY_PROVIDER, oldProvider, this.policyProvider);
    }

    public int getTreeTableRowHeaderWidth() {
        return this.treeTableRowHeaderWidth;
    }

    public void setTreeTableRowHeaderWidth(int width) {
        int oldWidth = this.treeTableRowHeaderWidth;
        this.treeTableRowHeaderWidth = width;
        this.firePropertyChange(PROPERTY_TREE_TABLE_ROW_HEADER_WIDTH, oldWidth, this.treeTableRowHeaderWidth);
    }

    public int getLayerContainerRowHeaderWidth() {
        return this.layerContainerRowHeaderWidth;
    }

    public void setLayerContainerRowHeaderWidth(int width) {
        int oldWidth = this.layerContainerRowHeaderWidth;
        this.layerContainerRowHeaderWidth = width;
        this.firePropertyChange(PROPERTY_LAYER_CONTAINER_ROW_HEADER_WIDTH, oldWidth, this.layerContainerRowHeaderWidth);
    }

    public void setGridLineMode(GridLineMode mode) {
        GridLineMode oldGridMode = this.gridLineMode;
        this.gridLineMode = mode;
        this.firePropertyChange(PROPERTY_GRID_LINE_MODE, (Object)oldGridMode, (Object)this.gridLineMode);
    }

    public GridLineMode getGridLineMode() {
        return this.gridLineMode;
    }

    public void setControlsBackground(Color color) {
        Color oldColor = this.controlsBackgroundColor;
        this.controlsBackgroundColor = color;
        this.firePropertyChange(PROPERTY_CONTROLS_BG_COLOR, oldColor, this.controlsBackgroundColor);
    }

    public Color getControlsBackground() {
        return this.controlsBackgroundColor;
    }

    public void setControlsForeground(Color color) {
        Color oldColor = this.controlsForegroundColor;
        this.controlsForegroundColor = color;
        this.firePropertyChange(PROPERTY_CONTROLS_FG_COLOR, oldColor, this.controlsForegroundColor);
    }

    public Color getControlsForeground() {
        return this.controlsForegroundColor;
    }

    public boolean isCalendarVisible() {
        return this.calendarVisible;
    }

    public void setCalendarVisible(boolean visible) {
        boolean oldValue = this.calendarVisible;
        this.calendarVisible = visible;
        this.firePropertyChange(PROPERTY_CALENDAR_VISIBLE, oldValue, this.calendarVisible);
    }

    public int getKeyColumnPosition() {
        return this.keyColumnPosition;
    }

    public boolean isCrosshairVisible() {
        return this.crosshairVisible;
    }

    public boolean isLabelsVisible() {
        return this.labelsVisible;
    }

    public boolean isPopupVisible() {
        return this.popupVisible;
    }

    public boolean isRelationsVisible() {
        return this.relationsVisible;
    }

    public boolean isRowLayerVisible() {
        return this.rowLayerVisible;
    }

    public boolean isTimeNowVisible() {
        return this.timeNowVisible;
    }

    public boolean isVerticalLinesOnTop() {
        return this.verticalLinesOnTop;
    }

    public void setCrosshairVisible(boolean visible) {
        boolean oldValue = this.crosshairVisible;
        this.crosshairVisible = visible;
        this.firePropertyChange(PROPERTY_CROSSHAIR_VISIBLE, oldValue, this.crosshairVisible);
    }

    public void setKeyColumnPosition(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position must be larger than 0");
        }
        int oldPosition = this.keyColumnPosition;
        this.keyColumnPosition = position;
        this.firePropertyChange(PROPERTY_KEY_COLUMN_POSITION, oldPosition, this.keyColumnPosition);
    }

    public void setLabelsVisible(boolean visible) {
        boolean oldValue = this.labelsVisible;
        this.labelsVisible = visible;
        this.firePropertyChange(PROPERTY_LABELS_VISIBLE, oldValue, this.labelsVisible);
    }

    public void setPopupVisible(boolean visible) {
        boolean oldValue = this.popupVisible;
        this.popupVisible = visible;
        this.firePropertyChange(PROPERTY_POPUP_VISIBLE, oldValue, this.popupVisible);
    }

    public void setRelationsVisible(boolean visible) {
        boolean oldValue = this.relationsVisible;
        this.relationsVisible = visible;
        this.firePropertyChange(PROPERTY_RELATIONS_VISIBLE, oldValue, this.relationsVisible);
    }

    public void setRowLayerVisible(boolean visible) {
        boolean oldValue = this.rowLayerVisible;
        this.rowLayerVisible = visible;
        this.firePropertyChange(PROPERTY_ROW_LAYER_VISIBLE, oldValue, this.rowLayerVisible);
    }

    public void setTimeNowVisible(boolean visible) {
        boolean oldValue = this.timeNowVisible;
        this.timeNowVisible = visible;
        this.firePropertyChange(PROPERTY_TIME_NOW_VISIBLE, oldValue, this.timeNowVisible);
    }

    public void setVerticalLinesOnTop(boolean top) {
        boolean oldValue = this.verticalLinesOnTop;
        this.verticalLinesOnTop = top;
        this.firePropertyChange(PROPERTY_VERTICAL_LINES_ON_TOP, oldValue, this.verticalLinesOnTop);
    }

    public boolean isTimeNowScrolling() {
        return this.timeNowScrolling;
    }

    public void setTimeNowScrolling(boolean scrolling) {
        boolean oldValue = this.timeNowScrolling;
        this.timeNowScrolling = scrolling;
        this.firePropertyChange(PROPERTY_TIME_NOW_SCROLLING, oldValue, scrolling);
    }

    public IPagingModel getPagingModel() {
        return this.pagingModel;
    }

    public void setPagingModel(IPagingModel model) {
        IPagingModel oldModel = this.pagingModel;
        if (oldModel != null) {
            oldModel.removePagingModelListener(this);
        }
        this.pagingModel = model;
        if (this.pagingModel != null) {
            Page page = this.pagingModel.getPage();
            if (page != null) {
                this.setTimeSpan(page.getTimeSpan());
            }
            this.pagingModel.addPagingModelListener(this);
        }
        this.firePropertyChange(PROPERTY_PAGING_MODEL, oldModel, this.pagingModel);
    }

    @Override
    public void pageWillChange(PagingEvent evt) {
    }

    @Override
    public void pageChanged(PagingEvent evt) {
        if (evt.getSource().equals(this.pagingModel)) {
            Page page = this.pagingModel.getPage();
            this.setTimeSpan(page.getTimeSpan());
        }
    }

    public void setAvailableColumns(Collection<TreeTableColumn<?>> columns) {
        if (columns == null) {
            throw new IllegalArgumentException("columns can not be NULL");
        }
        this.availableColumns = new ArrayList(columns);
        Collections.sort(this.availableColumns);
    }

    public void addAvailableColumn(TreeTableColumn column) {
        if (column == null) {
            throw new IllegalArgumentException("column can not be NULL");
        }
        this.availableColumns.add(column);
        Collections.sort(this.availableColumns);
    }

    public void removeAvailableColumn(TreeTableColumn column) {
        if (column == null) {
            throw new IllegalArgumentException("column can not be NULL");
        }
        this.availableColumns.remove(column);
    }

    public List<TreeTableColumn> getAvailableColumns() {
        return new ArrayList<TreeTableColumn>(this.availableColumns);
    }

    public KeyColumn getKeyColumn() {
        KeyColumn col = this.columnModel.getKeyColumn();
        if (col == null) {
            for (TreeTableColumn ttc : this.availableColumns) {
                if (!(ttc instanceof KeyColumn)) continue;
                col = (KeyColumn)ttc;
                break;
            }
        }
        if (col == null) {
            throw new IllegalStateException("Gantt chart does not have a key column defined");
        }
        return col;
    }

    public int getRowResizePosition() {
        return this.rowResizePosition;
    }

    public void setRowResizePosition(int position) {
        int oldValue = this.rowResizePosition;
        this.rowResizePosition = position;
        this.firePropertyChange(PROPERTY_ROW_RESIZE_POSITION, oldValue, this.rowResizePosition);
    }

    public void addToolBarAction(Action action) {
        if (this.toolbarActions == null) {
            this.toolbarActions = new ArrayList<Action>();
        }
        this.toolbarActions.add(action);
    }

    public void removeToolBarAction(Action action) {
        if (this.toolbarActions != null) {
            this.toolbarActions.remove(action);
            if (this.toolbarActions.size() == 0) {
                this.toolbarActions = null;
            }
        }
    }

    public void clearToolBarActions() {
        this.toolbarActions = null;
    }

    public Action[] getToolBarActions() {
        Action[] actions = new Action[]{};
        if (this.toolbarActions != null) {
            int s2 = this.toolbarActions.size();
            actions = new Action[s2];
            this.toolbarActions.toArray(actions);
        }
        return actions;
    }

    @Override
    public void keyTyped(KeyEvent e2) {
        if (Character.getType(e2.getKeyChar()) != 15) {
            LayerContainer[] layerContainers;
            TreeTable[] tables;
            for (TreeTable table : tables = this.getTreeTables()) {
                CellFocusManager mgr = table.getCellFocusManager();
                if (!mgr.hasFocus()) continue;
                this.handleKeyEvent(table, e2);
                return;
            }
            for (LayerContainer lc2 : layerContainers = this.getLayerContainers()) {
                SpreadsheetLayer spreadsheetLayer = lc2.getSystemLayer(SpreadsheetLayer.class);
                if (spreadsheetLayer == null || !spreadsheetLayer.hasFocus()) continue;
                this.handleKeyEvent(spreadsheetLayer, e2);
                return;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e2) {
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    private void handleKeyEvent(IEditable table, KeyEvent e2) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke((int)e2.getKeyChar(), e2.getModifiers());
        keyStroke = KeyStroke.getKeyStrokeForEvent(e2);
        InputMap map = this.getInputMap(0);
        if (map != null && map.get(keyStroke) != null) {
            return;
        }
        map = this.getInputMap(1);
        if (map != null && map.get(keyStroke) != null) {
            return;
        }
        map = this.getInputMap(2);
        if (map != null && map.get(keyStroke) != null) {
            return;
        }
        if (e2.getKeyChar() == '\r') {
            return;
        }
        if (!table.isEditing() && !table.editCellFocused(null)) {
            return;
        }
        Component editorComp = table.getEditorComponent();
        if (table.isEditing() && editorComp != null && editorComp instanceof JComponent) {
            Object binding;
            JComponent component = (JComponent)editorComp;
            map = component.getInputMap(0);
            Object object = binding = map != null ? map.get(keyStroke) : null;
            if (binding == null) {
                map = component.getInputMap(1);
                Object object2 = binding = map != null ? map.get(keyStroke) : null;
            }
            if (binding != null) {
                Action action;
                ActionMap am = component.getActionMap();
                Action action2 = action = am != null ? am.get(binding) : null;
                if (action != null && SwingUtilities.notifyAction(action, keyStroke, e2, component, e2.getModifiers())) {
                    e2.consume();
                }
            }
        }
    }

    public void tearDown() {
        LayerContainer[] containers;
        LOGGER.fine("tearing down Gantt chart " + this);
        Eventline eventline = this.getEventline();
        LOGGER.fine("tearing down eventline " + eventline);
        eventline.tearDown();
        for (LayerContainer lc2 : containers = this.getLayerContainers()) {
            LOGGER.fine("tearing down layer container " + lc2);
            lc2.tearDown();
        }
    }

    public ISelectorFactory getSelectorFactory() {
        return TimeGranularitySelectorFactory.getInstance();
    }

    public void optimizeColumnWidth() {
        this.optimizeColumnWidth(false);
    }

    public void optimizeColumnWidth(boolean includeEditors) {
        LOGGER.fine("optimizing include editors = " + includeEditors);
        KeyColumn keyColumn = this.getKeyColumn();
        LOGGER.fine("key column = " + keyColumn);
        if (keyColumn != null) {
            this.optimizeColumnWidth(keyColumn, includeEditors);
        }
        int count = this.getColumnCount();
        LOGGER.fine("column count = " + count);
        for (int i2 = 0; i2 < count; ++i2) {
            this.optimizeColumnWidth(this.getColumn(i2), includeEditors);
        }
        this.repaint();
        LOGGER.fine("returning from optimization");
    }

    public void optimizeColumnWidth(int index) {
        LOGGER.fine("optimizing column at index " + index);
        this.optimizeColumnWidth(index, false);
    }

    public void optimizeColumnWidth(int index, boolean includeEditors) {
        LOGGER.fine("optimizing column at index " + index + ", include editors = " + includeEditors);
        TreeTableColumn col = this.treeTableHeader.getColumn(index);
        if (col == null) {
            throw new IllegalArgumentException("no column found for index " + index);
        }
        if (index == -1) {
            this.optimizeColumnWidth(this.getKeyColumn(), includeEditors);
        } else {
            this.optimizeColumnWidth(this.getColumn(index), includeEditors);
        }
    }

    public void optimizeColumnWidth(TreeTableColumn column) {
        LOGGER.fine("optimizing column = " + column);
        if (column == null) {
            throw new IllegalArgumentException("column can not be NULL");
        }
        this.optimizeColumnWidth(column, false);
    }

    public void optimizeColumnWidth(TreeTableColumn column, boolean includeEditors) {
        TreeTable[] tables;
        if (column == null) {
            throw new IllegalArgumentException("column can not be NULL");
        }
        int width = 0;
        for (TreeTable table : tables = this.getTreeTables()) {
            int w2 = this.calculatePreferredColumnWidth(includeEditors, column, table);
            width = Math.max(width, w2);
        }
        LOGGER.fine("column min width = " + column.getMinimumWidth());
        LOGGER.fine("column max width = " + column.getMaximumWidth());
        width = Math.max(width, column.getMinimumWidth());
        width = Math.min(width, column.getMaximumWidth());
        LOGGER.fine("setting column width to " + width);
        column.setWidth(width);
    }

    private int calculatePreferredColumnWidth(boolean includeEditors, TreeTableColumn column, TreeTable table) {
        LOGGER.fine("calculating pref width for " + column.getName() + ", table = " + table);
        boolean keyColumn = column instanceof KeyColumn;
        int width = column.getMinimumWidth();
        List<TreeTableNode> nodes = table.getTreeTableNodes();
        if (nodes != null) {
            Object headerValue = column.getHeaderValue();
            if (headerValue == null) {
                headerValue = column.getName();
            }
            LOGGER.fine("header value = " + headerValue);
            IColumnHeaderRenderer columnRenderer = this.getTreeTableHeader().getColumnHeaderRenderer(headerValue.getClass());
            Component comp = columnRenderer.getColumnHeaderRendererComponent(this.treeTableHeader, column, false, false, SortDirection.ASCENDING, 1);
            LOGGER.fine("column renderer comp = " + comp);
            if (comp != null) {
                this.getTreeTableHeader().add(comp);
                width = Math.max(width, comp.getPreferredSize().width + 1);
                this.getTreeTableHeader().remove(comp);
            }
            Class columnClass = column.getColumnClass();
            LOGGER.fine("column class = " + columnClass);
            ITreeTableCellRenderer defaultRenderer = table.getCellRenderer(columnClass);
            LOGGER.fine("default renderer = " + defaultRenderer);
            if (defaultRenderer == null) {
                throw new IllegalArgumentException("renderer can not be NULL");
            }
            ITreeTableCellEditor defaultEditor = table.getCellEditor(columnClass);
            LOGGER.fine("default editor = " + defaultEditor);
            int modelIndex = column.getModelIndex();
            for (int row = 0; row < nodes.size(); ++row) {
                ITreeTableCellRenderer renderer = defaultRenderer;
                ITreeTableCellEditor editor = defaultEditor;
                Object value = null;
                value = keyColumn ? nodes.get(row).getKey() : nodes.get(row).getValueAt(modelIndex);
                if (value != null) {
                    renderer = table.getCellRenderer(value.getClass());
                    editor = table.getCellEditor(value.getClass());
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("renderer = " + renderer);
                    LOGGER.fine("editor = " + editor);
                }
                comp = renderer.getTreeTableCellRendererComponent(table, nodes.get(row).getModelNode(), value, nodes.get(row).getDepth(), false, true, nodes.get(row).isLeaf(), row, column.getModelIndex(), false);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("renderer component = " + comp);
                }
                if (comp != null) {
                    table.add(comp);
                    width = Math.max(width, comp.getPreferredSize().width + 1);
                    table.remove(comp);
                }
                if (!includeEditors || !table.isCellEditable(row, modelIndex) || editor == null) continue;
                comp = editor.getTreeTableCellEditorComponent(table, value, false, row, modelIndex);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("editor component = " + comp);
                }
                if (comp == null) continue;
                table.add(comp);
                width = Math.max(width, comp.getPreferredSize().width + 1);
                table.remove(comp);
            }
        }
        LOGGER.fine("returning width = " + (width + 2));
        return width + 2;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component comp : this.getComponents()) {
            this.setEnabled(enabled, comp);
        }
    }

    private void setEnabled(boolean enabled, Component comp) {
        comp.setEnabled(enabled);
        if (comp instanceof Container) {
            for (Component child : ((Container)comp).getComponents()) {
                this.setEnabled(enabled, child);
            }
        }
    }

    public void setShowingCommandExceptions(boolean show) {
        this.showingCommandExceptions = show;
    }

    public boolean isShowingCommandExceptions() {
        return this.showingCommandExceptions;
    }

    @Override
    public void commandStackChanged(CommandStackEvent e2) {
        if (e2.getId().equals((Object)CommandStackEvent.ID.COMMAND_FAILED) && this.isShowingCommandExceptions()) {
            this.showMessage(e2.getCommandException().getLocalizedMessage(), MessageTypeId.ERROR, e2.getCommandException());
        }
    }

    public void setPrintSetup(PrintSetup ps) {
        this.printSetup = ps;
    }

    public PrintSetup getPrintSetup() {
        return this.printSetup;
    }

    public void setActiveSpreadsheet(ISpreadsheet activeSpreadsheet) {
        ISpreadsheet oldSpreadsheet = this.activeSpreadsheet;
        this.activeSpreadsheet = activeSpreadsheet;
        this.firePropertyChange(PROPERTY_ACTIVE_SPREADSHEET, oldSpreadsheet, this.activeSpreadsheet);
    }

    public ISpreadsheet getActiveSpreadsheet() {
        return this.activeSpreadsheet;
    }

    static class ProgressMonitorFactory
    implements IProgressMonitorFactory {
        private AbstractGanttChart gc;

        public ProgressMonitorFactory(AbstractGanttChart gc2) {
            this.gc = gc2;
        }

        @Override
        public IProgressMonitor createProgressMonitor() {
            return new GanttChartProgressMonitor(this.gc);
        }
    }

    protected class Banner
    extends JPanel {
        public Banner() {
            this.setFont(new Font("helvetica", 0, 12));
            this.setPreferredSize(new Dimension(300, 40));
            this.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 5, 0), new LineBorder(Color.BLACK)));
            this.setLayout(new FlowLayout(2));
            if (!FlexGanttLicenseManager.isTrialLicense()) {
                JButton hideButton = new JButton(Messages.getString("AbstractGanttChart.HIDE_LICENSE_INFO"));
                hideButton.setOpaque(false);
                this.add(hideButton);
                hideButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        Banner.this.setVisible(false);
                    }
                });
                JButton licenseInfo = new JButton(Messages.getString("AbstractGanttChart.SHOW_LICENSE_INFO"));
                licenseInfo.setOpaque(false);
                this.add(licenseInfo);
                licenseInfo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        LicenseDialog.showDialog(AbstractGanttChart.this);
                    }
                });
            }
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            if (FlexGanttLicenseManager.isTrialLicense()) {
                this.paintTrialLicenseHeader(g2);
            } else if (FlexGanttLicenseManager.isDevelopmentLicense()) {
                this.paintDevLicenseHeader(g2);
            } else {
                this.paintRuntimeLicenseHeader(g2);
            }
        }

        private void paintHeader(Graphics g2, String text) {
            text = "FlexGantt (www.dlsc.com) - " + text;
            Insets insets = this.getInsets();
            int h2 = this.getHeight() - insets.top - insets.bottom + 1;
            Graphics2D g2d = (Graphics2D)g2;
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, Color.RED.brighter(), 0.0f, h2, Color.RED);
            if (FlexGanttLicenseManager.isDevelopmentLicense()) {
                paint = new GradientPaint(0.0f, 0.0f, Color.YELLOW, 0.0f, h2, Color.YELLOW.darker());
            } else if (FlexGanttLicenseManager.isRuntimeLicense()) {
                paint = new GradientPaint(0.0f, 0.0f, Color.GREEN, 0.0f, h2, Color.GREEN.darker());
            }
            g2d.setPaint(paint);
            Rectangle clip = g2.getClipBounds();
            g2d.fillRect(clip.x, clip.y, clip.width, h2);
            int stripWidth = 20;
            paint = new GradientPaint(0.0f, 0.0f, Color.GRAY, 0.0f, h2, Color.BLACK);
            g2d.setPaint(paint);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            for (int x2 = clip.x - clip.x % (2 * stripWidth); x2 < clip.x - clip.x % stripWidth + clip.width + stripWidth; x2 += 2 * stripWidth) {
                int[] xx = new int[]{x2, x2 + stripWidth, x2 + stripWidth - h2, x2 - h2, x2};
                int[] yy = new int[]{insets.top, insets.top, h2, h2, insets.top};
                g2d.fillPolygon(xx, yy, 5);
            }
            FontMetrics fm = g2.getFontMetrics();
            int strWidth = fm.stringWidth(text);
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.BLACK, 0.0f, h2, Color.GRAY));
            g2d.fillRect(30, 5, strWidth + 40, h2 - 12);
            g2d.setColor(Color.GRAY);
            g2d.draw3DRect(30, 5, strWidth + 40, h2 - 12, false);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            Font font = g2.getFont();
            g2.setColor(Color.BLACK);
            g2.drawString(text, 51, 22);
            g2.setColor(Color.WHITE);
            g2.drawString(text, 50, 21);
            g2.setFont(font);
        }

        private void paintTrialLicenseHeader(Graphics g2) {
            String text = Messages.getString("AbstractGanttChart.LICENSE_TYPE_TRIAL");
            this.paintHeader(g2, text);
        }

        private void paintDevLicenseHeader(Graphics g2) {
            String text = Messages.getString("AbstractGanttChart.LICENSE_TYPE_DEVELOPMENT");
            this.paintHeader(g2, text);
        }

        private void paintRuntimeLicenseHeader(Graphics g2) {
            String text = Messages.getString("AbstractGanttChart.LICENSE_TYPE_RUNTIME");
            this.paintHeader(g2, text);
        }
    }

    class UnlicensedDialog
    extends JDialog
    implements Runnable {
        private String delay;
        private JLabel countdownLabel;

        public UnlicensedDialog(Dialog owner) {
            super(owner, Messages.getString("AbstractGanttChart.UNLICENSED_VERSION"));
            this.delay = "";
            this.init();
        }

        public UnlicensedDialog(Frame owner) {
            super(owner, Messages.getString("AbstractGanttChart.UNLICENSED_VERSION"));
            this.delay = "";
            this.init();
        }

        private void init() {
            Box box = new Box(1);
            this.setContentPane(box);
            box.setBorder(new EmptyBorder(5, 5, 5, 5));
            box.setOpaque(true);
            box.setBackground(Color.WHITE);
            URL url = this.getClass().getResource("FlexGantt.png");
            ImageIcon icon = new ImageIcon(url);
            JLabel label = new JLabel(icon);
            label.setText("FlexGantt");
            label.setHorizontalTextPosition(0);
            label.setVerticalTextPosition(3);
            label.setBorder(new EmptyBorder(20, 100, 5, 100));
            label.setFont(label.getFont().deriveFont(32.0f).deriveFont(1));
            label.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            this.add(label);
            JLabel versionLabel = new JLabel("Version " + Version.getVersion());
            versionLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            versionLabel.setHorizontalAlignment(0);
            versionLabel.setForeground(Color.GRAY);
            versionLabel.setBorder(new EmptyBorder(5, 5, 20, 5));
            this.add(versionLabel);
            JLabel trialLabel = new JLabel("Trial License");
            trialLabel.setHorizontalAlignment(0);
            trialLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            trialLabel.setForeground(Color.GRAY);
            trialLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.add(trialLabel);
            long remaining = AbstractGanttChart.this.getRemainingDays();
            JLabel daysLabel = new JLabel(Long.toString(Math.max(0L, remaining)));
            daysLabel.setHorizontalAlignment(0);
            daysLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            daysLabel.setFont(label.getFont().deriveFont(24.0f).deriveFont(1));
            daysLabel.setForeground(Color.BLACK);
            daysLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
            if (remaining <= 0L) {
                daysLabel.setForeground(Color.RED);
            }
            this.add(daysLabel);
            JLabel daysLeftLabel = new JLabel("days left");
            daysLeftLabel.setHorizontalAlignment(0);
            daysLeftLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            daysLeftLabel.setForeground(Color.GRAY);
            daysLeftLabel.setBorder(new EmptyBorder(5, 5, 20, 5));
            this.add(daysLeftLabel);
            this.countdownLabel = new JLabel(" --- ");
            this.countdownLabel.setHorizontalAlignment(0);
            this.countdownLabel.setOpaque(true);
            this.countdownLabel.setBackground(Color.GREEN);
            this.countdownLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            this.countdownLabel.setForeground(Color.WHITE);
            this.countdownLabel.setBackground(Color.BLACK);
            this.countdownLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.add(this.countdownLabel);
            this.setDefaultCloseOperation(0);
            this.setResizable(true);
            this.pack();
            this.setLocationRelativeTo(AbstractGanttChart.this);
        }

        @Override
        public void dispose() {
        }

        @Override
        public void setVisible(boolean b2) {
            if (b2) {
                Thread thread = new Thread(this);
                thread.setName("LicenseDialogThread");
                thread.start();
                super.setVisible(b2);
            }
        }

        @Override
        public void hide() {
            super.hide();
        }

        protected void done() {
            super.setVisible(false);
            super.dispose();
        }

        @Override
        public void run() {
            for (int i2 = 10; i2 >= 0; --i2) {
                this.delay = i2 + " " + Messages.getString("AbstractGanttChart.SECONDS");
                this.countdownLabel.setText(this.delay);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e2) {
                    LOGGER.throwing(AbstractGanttChart.class.getName(), "run()", e2);
                }
            }
            super.setVisible(false);
        }
    }
}

