/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.timenow;

import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.demo.timenow.TimeNowDemoModel;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.layer.timeline.DefaultTimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.timeline.TimeNowThread;
import java.awt.Color;
import java.awt.Component;
import java.util.Calendar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TimeNowDemo
extends AbstractDemo {
    public TimeNowDemo() {
        super("Time Now");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"TimeNowDemo", "TimeNowDemoModel"};
    }

    @Override
    public void run(boolean embedded) {
        GanttChart gc2 = this.createGanttChart();
        final TimeNowDemoModel model = new TimeNowDemoModel();
        gc2.setModel(model);
        gc2.getLayerContainer().setTimelineObjectRenderer(DefaultTimelineObject.class, new ColoredRenderer());
        gc2.getTreeTable().setRootVisible(false);
        gc2.getTreeTable().setAlternatingBackground(new Color(240, 240, 240));
        gc2.getLayerContainer().setAlternatingBackground(new Color(240, 240, 240));
        gc2.getKeyColumn().setWidth(150);
        gc2.resetToPreferredSizes();
        IDatelineModel datelineModel = gc2.getDatelineModel();
        try {
            Calendar s2 = Calendar.getInstance();
            Calendar e2 = Calendar.getInstance();
            e2.add(11, 2);
            TimeSpan span = new TimeSpan(s2, e2);
            datelineModel.setTimeSpan(span);
            datelineModel.setGranularity(TimeGranularity.FIVE_SECONDS);
        }
        catch (DatelineModelException e3) {
            e3.printStackTrace();
        }
        gc2.setTimeNowVisible(true);
        gc2.setTimeNowScrolling(true);
        TimeNowThread timeNowThread = new TimeNowThread(gc2);
        timeNowThread.start();
        Thread thread = new Thread(){

            @Override
            public void run() {
                for (int i2 = 0; i2 < 100; i2 += 4) {
                    this.addTimelineObject(i2);
                }
                while (true) {
                    this.addTimelineObject((int)(Math.random() * 100.0));
                    try {
                        1.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                        continue;
                    }
                    break;
                }
            }

            private void addTimelineObject(int row) {
                Calendar s2 = Calendar.getInstance();
                s2.add(13, 5 + (int)(Math.random() * 10.0));
                Calendar e2 = Calendar.getInstance();
                e2.setTimeInMillis(s2.getTimeInMillis());
                e2.add(13, Math.max(1, (int)(Math.random() * 50.0)));
                TimeSpan span = null;
                span = Math.random() > 0.8 ? new TimeSpan(s2) : new TimeSpan(s2, e2);
                DefaultTimelineObject tlo = new DefaultTimelineObject(span);
                tlo.setPopupObject(s2.getTime().toString(), false);
                switch ((int)(Math.random() * 3.0)) {
                    case 0: {
                        tlo.setProperty("color", Color.ORANGE);
                        break;
                    }
                    case 1: {
                        tlo.setProperty("color", Color.GREEN);
                        break;
                    }
                    case 2: {
                        tlo.setProperty("color", Color.LIGHT_GRAY);
                        break;
                    }
                    case 3: {
                        tlo.setProperty("color", Color.CYAN);
                    }
                }
                DefaultGanttChartNode node = model.node[row];
                node.addTimelineObject(model.layer, tlo);
            }
        };
        thread.start();
        GanttChartFrame<?> frame = this.createFrame("Time Now", gc2, embedded);
        DemoControlsPanel controls = new DemoControlsPanel(this);
        frame.add("East", controls);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        SwingUtilities.invokeLater(new TimeNowDemo());
    }

    class ColoredRenderer
    extends DefaultTimelineObjectRenderer {
        public ColoredRenderer() {
            this.setVisualizingPastTime(true);
        }

        @Override
        public Component getTimelineObjectRendererComponent(TimelineObjectLayer layer, TimelineObjectPath path, boolean selected, boolean hasFocus, boolean highlighted, int row) {
            Component comp = super.getTimelineObjectRendererComponent(layer, path, selected, hasFocus, highlighted, row);
            DefaultTimelineObject obj = (DefaultTimelineObject)this.getTimelineObject();
            this.setBackground((Color)obj.getProperty("color"));
            return comp;
        }
    }
}

