/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.timeline;

import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.OSXAdapter;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartStatusBar;
import com.dlsc.flexgantt.swing.SimpleGranularityGanttChart;
import com.dlsc.flexgantt.swing.timeline.SimpleGranularityTimelineControlPanel;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityTimelineControlPanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class TimelineDemo
extends AbstractDemo {
    public TimelineDemo() {
        super("Timeline");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"TimelineDemo"};
    }

    @Override
    public void run(boolean embedded) {
        GanttChart topGC = new GanttChart();
        topGC.getKeyColumn().setWidth(120);
        topGC.getTreeTable().setRootVisible(false);
        topGC.resetToPreferredSizes();
        SimpleGranularityGanttChart bottomGC = new SimpleGranularityGanttChart();
        bottomGC.getKeyColumn().setWidth(120);
        bottomGC.getTreeTable().setRootVisible(false);
        bottomGC.resetToPreferredSizes();
        GanttChartStatusBar<GanttChart> topStatusBar = new GanttChartStatusBar<GanttChart>(topGC);
        GanttChartStatusBar<SimpleGranularityGanttChart> bottomStatusBar = new GanttChartStatusBar<SimpleGranularityGanttChart>(bottomGC);
        DemoControlsPanel topControls = new DemoControlsPanel(this);
        ((Container)topControls).setLayout(new BorderLayout());
        ((Container)topControls).add("North", new TimeGranularityTimelineControlPanel(topGC.getTimeline()));
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        top.add("Center", topGC);
        top.add("East", topControls);
        top.add("South", topStatusBar);
        top.setBorder(new CompoundBorder(new EmptyBorder(20, 20, 20, 20), new TitledBorder("Gantt Chart using standard time granularity")));
        DemoControlsPanel bottomControls = new DemoControlsPanel(this);
        ((Container)bottomControls).setLayout(new BorderLayout());
        ((Container)bottomControls).add("North", new SimpleGranularityTimelineControlPanel(bottomGC.getTimeline()));
        JPanel bottom = new JPanel();
        bottom.setLayout(new BorderLayout());
        bottom.add("Center", bottomGC);
        bottom.add("East", bottomControls);
        bottom.add("South", bottomStatusBar);
        bottom.setBorder(new CompoundBorder(new EmptyBorder(20, 20, 20, 20), new TitledBorder("Gantt Chart using simple granularity")));
        JPanel gcPanel = new JPanel();
        gcPanel.setLayout(new GridLayout(2, 1));
        gcPanel.add(top);
        gcPanel.add(bottom);
        JFrame frame = new JFrame("Timeline");
        OSXAdapter.setWindowCanFullScreen(frame, true);
        frame.add(gcPanel);
        if (embedded) {
            frame.setDefaultCloseOperation(2);
        } else {
            frame.setDefaultCloseOperation(3);
        }
        frame.setSize(1000, 800);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new TimelineDemo());
    }
}

