/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.textures;

import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.BackgroundLayer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class TextureChooser
extends JPanel {
    public TextureChooser(String title, GanttChart gc2, final TreeTable tt, final LayerContainer lc2) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        DefaultComboBoxModel<Entry> model = new DefaultComboBoxModel<Entry>();
        model.addElement(new Entry("None", null));
        model.addElement(new Entry("Cracked", "tile1.jpg"));
        model.addElement(new Entry("Rough Ground", "tile2.jpg"));
        model.addElement(new Entry("Grass", "tile3.jpg"));
        model.addElement(new Entry("Wood", "tile4.jpg"));
        model.addElement(new Entry("Concrete", "tile5.jpg"));
        model.addElement(new Entry("Leafs", "tile6.jpg"));
        final JComboBox<Object> box = new JComboBox<Object>(model);
        box.setRenderer(new Renderer());
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Entry entry = (Entry)box.getSelectedItem();
                tt.setTexture(entry.originalImage);
                lc2.getSystemLayer(BackgroundLayer.class).setTexture(entry.originalImage);
            }
        });
        this.add("Center", box);
    }

    class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Entry entry = (Entry)value;
            this.setText(entry.name);
            this.setIcon(entry.icon);
            if (isSelected) {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("Table.foreground"));
                this.setBackground(UIManager.getColor("Table.background"));
            }
            return this;
        }
    }

    class Entry {
        public ImageIcon icon;
        public Image originalImage;
        public String name;

        public Entry(String name, String fileName) {
            this.name = name;
            if (fileName != null) {
                URL url = this.getClass().getResource(fileName);
                this.icon = new ImageIcon(url);
                this.originalImage = this.icon.getImage();
                this.icon.setImage(this.icon.getImage().getScaledInstance(12, 12, 4));
            }
        }
    }
}

