/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.spreadsheet;

import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.Layer;
import com.dlsc.flexgantt.model.gantt.Spreadsheet;
import com.dlsc.flexgantt.showcase.demo.spreadsheet.SpreadsheetValues;
import java.util.Calendar;

public class SpreadsheetGanttChartModel
extends DefaultGanttChartModel<DefaultGanttChartNode<String, ITimelineObject>, ITimelineObject> {
    private Layer layer = new Layer("Layer");
    private final int ROW_COUNT = 20;
    private DefaultGanttChartNode[] node;
    public Spreadsheet spreadsheet1;
    public Spreadsheet spreadsheet2;
    public Spreadsheet spreadsheet3;

    public SpreadsheetGanttChartModel() {
        super(new DefaultGanttChartNode());
        this.layer.removeFeature(ILayer.Feature.TIMELINE_OBJECT_DESCRIPTIONS);
        this.addLayer(this.layer);
        this.spreadsheet1 = new Spreadsheet("Integer Spreadsheet", TimeGranularity.DAY_SHORT, 50, Integer.class);
        this.addSpreadsheet(this.spreadsheet1);
        this.spreadsheet2 = new Spreadsheet("String Spreadsheet", TimeGranularity.MONTH_SHORT, 40, String.class);
        this.addSpreadsheet(this.spreadsheet2);
        this.spreadsheet3 = new Spreadsheet("Enum Spreadsheet", TimeGranularity.DAY_SHORT, 30, SpreadsheetValues.class);
        this.addSpreadsheet(this.spreadsheet3);
        DefaultGanttChartNode rootNode = (DefaultGanttChartNode)this.getRoot();
        this.node = new DefaultGanttChartNode[20];
        for (int i2 = 0; i2 < 20; ++i2) {
            this.node[i2] = new DefaultGanttChartNode(true);
            this.node[i2].setKey("Node " + i2);
            this.node[i2].setColumnValue("Test", 0);
            this.node[i2].setValueEditable(0, true);
            rootNode.add(this.node[i2]);
            for (int j2 = 0; j2 < 3; ++j2) {
                DefaultGanttChartNode subNode = new DefaultGanttChartNode(false);
                subNode.setKey("Sub Node " + j2);
                this.node[i2].add(subNode);
                Calendar c1 = Calendar.getInstance();
                for (int day = 0; day < 300; ++day) {
                    Calendar c2 = (Calendar)c1.clone();
                    TimeGranularity.DAY_SHORT.adjustCalendar(c1);
                    TimeGranularity.DAY_SHORT.adjustCalendar(c2);
                    TimeGranularity.DAY_SHORT.increment(c2);
                    TimeSpan span = new TimeSpan(c1, c2);
                    SpreadsheetValues sv = SpreadsheetValues.TEN;
                    if (Math.random() > 0.9) {
                        sv = SpreadsheetValues.values()[(int)(Math.random() * (double)SpreadsheetValues.values().length)];
                    }
                    subNode.setSpreadsheetValue(this.spreadsheet3, (Object)sv, span);
                    c1.add(6, 1);
                }
            }
        }
    }
}

