/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.spreadsheet;

import com.dlsc.flexgantt.model.gantt.ISpreadsheet;
import com.dlsc.flexgantt.model.treetable.DefaultColumnModel;
import com.dlsc.flexgantt.model.treetable.KeyColumn;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.demo.spreadsheet.SpreadsheetGanttChartModel;
import com.dlsc.flexgantt.showcase.demo.spreadsheet.SpreadsheetValues;
import com.dlsc.flexgantt.showcase.demo.spreadsheet.SpreadsheetValuesCellRenderer;
import com.dlsc.flexgantt.showcase.demo.spreadsheet.SpreadsheetValuesEditor;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.layer.system.SpreadsheetLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;

public class SpreadsheetDemo
extends AbstractDemo
implements ActionListener,
PropertyChangeListener {
    private SpreadsheetGanttChartModel model;
    private GanttChart gc;
    private JComboBox box;
    private String offLabel = "Off";

    public SpreadsheetDemo() {
        super("Spreadsheets");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"SpreadsheetDemo", "SpreadsheetGanttChartModel", "SpreadsheetValues", "SpreadsheetValuesCellRenderer", "SpreadsheetValuesEditor"};
    }

    @Override
    public void run(boolean embedded) {
        this.gc = this.createGanttChart();
        this.model = new SpreadsheetGanttChartModel();
        this.gc.setModel(this.model);
        this.gc.getTreeTable().setRootVisible(false);
        DefaultColumnModel columnModel = (DefaultColumnModel)this.gc.getColumnModel();
        TreeTableColumn column = new TreeTableColumn("Text", String.class);
        column.setWidth(50);
        columnModel.addColumn(column);
        this.gc.expandAll();
        this.gc.addPropertyChangeListener(this);
        SpreadsheetLayer layer = this.gc.getLayerContainer().getSystemLayer(SpreadsheetLayer.class);
        layer.setCellRenderer(SpreadsheetValues.class, new SpreadsheetValuesCellRenderer());
        layer.setCellEditor(SpreadsheetValues.class, new SpreadsheetValuesEditor(this.gc));
        KeyColumn key = this.gc.getColumnModel().getKeyColumn();
        key.setWidth(200);
        this.gc.resetToPreferredSizes();
        GanttChartFrame<?> frame = this.createFrame("Spreadsheet", this.gc, embedded);
        DemoControlsPanel controls = new DemoControlsPanel(this);
        frame.add("East", controls);
        this.box = new JComboBox();
        this.box.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ISpreadsheet) {
                    ISpreadsheet spreadsheet = (ISpreadsheet)value;
                    this.setText(spreadsheet.getName());
                }
                return this;
            }
        });
        controls.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        controls.setLayout(new BorderLayout());
        controls.add("North", this.box);
        this.box.addItem(this.offLabel);
        this.box.addActionListener(this);
        Iterator<ISpreadsheet> spreadsheets = this.model.getSpreadsheets();
        while (spreadsheets.hasNext()) {
            this.box.addItem(spreadsheets.next());
        }
        this.gc.setActiveSpreadsheet(this.model.spreadsheet3);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new SpreadsheetDemo());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object item = this.box.getSelectedItem();
        if (item instanceof ISpreadsheet) {
            this.gc.setActiveSpreadsheet((ISpreadsheet)item);
        } else {
            this.gc.setActiveSpreadsheet(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.gc) && evt.getPropertyName().equals("activeSpreadsheet")) {
            ISpreadsheet spreadsheet = this.gc.getActiveSpreadsheet();
            if (spreadsheet != null) {
                this.box.setSelectedItem(spreadsheet);
            } else {
                this.box.setSelectedItem(this.offLabel);
            }
        }
    }
}

