/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.layers;

import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.showcase.demo.layers.LayerDemoLayer;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class LayerDemoObjectRenderer
extends JPanel
implements ITimelineObjectRenderer {
    private final Insets INSETS = new Insets(0, -10, 0, -10);
    private String number;
    private Color color;
    private boolean event;
    private boolean selected;

    public LayerDemoObjectRenderer() {
        this.setFont(new Font("helvetica", 1, 12));
        this.setOpaque(false);
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        Graphics2D g2d = (Graphics2D)g2;
        g2.setColor(this.color);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.event) {
            g2d.fillOval(w2 / 2 - Math.min(w2 - 2, h2 - 2) / 2, h2 / 2 - Math.min(w2 - 2, h2 - 2) / 2, Math.min(w2 - 2, h2 - 2), Math.min(w2 - 2, h2 - 2));
        } else {
            g2d.fillRect(0, 0, w2, h2);
        }
        g2d.setColor(Color.WHITE);
        int a2 = g2d.getFontMetrics().getAscent();
        int l2 = g2d.getFontMetrics().stringWidth(this.number);
        g2d.drawString(this.number, w2 / 2 - l2 / 2 + 1, h2 / 2 + a2 / 2);
        if (this.selected) {
            g2d.setColor(Color.BLACK);
        } else {
            g2d.setColor(Color.RED);
        }
        if (this.event) {
            g2d.drawOval(w2 / 2 - Math.min(w2 - 2, h2 - 2) / 2, h2 / 2 - Math.min(w2 - 2, h2 - 2) / 2, Math.min(w2 - 2, h2 - 2), Math.min(w2 - 2, h2 - 2));
        } else {
            g2d.drawRect(0, 0, w2 - 1, h2 - 1);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    @Override
    public Component getTimelineObjectRendererComponent(TimelineObjectLayer layer, TimelineObjectPath path, boolean selected, boolean focus, boolean highlighted, int row) {
        LayerDemoLayer l2 = (LayerDemoLayer)layer.getLayer();
        this.number = Integer.toString(l2.getNumber());
        this.color = l2.getColor();
        this.event = layer.getModel().getTimeSpan(path.getTimelineObject()).isEvent();
        this.selected = selected;
        return this;
    }

    @Override
    public Insets getTimelineObjectRendererInsets(int x2, int y2, int width, int height) {
        return this.INSETS;
    }
}

