/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.calendar;

import com.dlsc.flexgantt.model.calendar.TimeGranularityCalendarModel;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import java.awt.BorderLayout;
import java.awt.Container;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CalendarDemo
extends AbstractDemo {
    public CalendarDemo() {
        super("Calendar");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"CalendarDemo"};
    }

    @Override
    public void run(boolean embedded) {
        final GanttChart gc2 = this.createGanttChart();
        gc2.getTreeTable().setRootVisible(false);
        GanttChartFrame<?> frame = this.createFrame("Calendar", gc2, embedded);
        DefaultListModel<WeekendDay> model = new DefaultListModel<WeekendDay>();
        model.addElement(new WeekendDay("Monday", 2));
        model.addElement(new WeekendDay("Tuesday", 3));
        model.addElement(new WeekendDay("Wednesday", 4));
        model.addElement(new WeekendDay("Thursday", 5));
        model.addElement(new WeekendDay("Friday", 6));
        model.addElement(new WeekendDay("Saturday", 7));
        model.addElement(new WeekendDay("Sunday", 1));
        final JList list = new JList(model);
        list.setSelectionMode(2);
        list.setVisibleRowCount(7);
        DemoControlsPanel controls = new DemoControlsPanel(this);
        ((Container)controls).setLayout(new BorderLayout());
        ((Container)controls).add("North", list);
        frame.add("East", controls);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (!e2.getValueIsAdjusting()) {
                    Object[] selection = list.getSelectedValues();
                    TimeGranularityCalendarModel calModel = (TimeGranularityCalendarModel)gc2.getCalendarModel();
                    if (selection != null && selection.length > 0) {
                        int s2 = selection.length;
                        int[] days = new int[s2];
                        for (int i2 = 0; i2 < s2; ++i2) {
                            days[i2] = ((WeekendDay)selection[i2]).value;
                        }
                        calModel.setWeekendDays(days);
                    } else {
                        calModel.setWeekendDays(null);
                    }
                }
            }
        });
        frame.center();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        SwingUtilities.invokeLater(new CalendarDemo());
    }

    class WeekendDay {
        String name;
        int value;

        public WeekendDay(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name;
        }
    }
}

