/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase;

import com.dlsc.flexgantt.showcase.DemoLauncher;
import com.dlsc.flexgantt.showcase.DemosPanel;
import com.dlsc.flexgantt.showcase.GalleryPanel;
import com.dlsc.flexgantt.showcase.NavigationHeader;
import com.dlsc.flexgantt.showcase.customers.CustomersPanel;
import com.sun.animation.transitions.ScreenTransition;
import com.sun.animation.transitions.TransitionTarget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;

class TransitionPanel
extends JPanel {
    private static final int TRANSITION_TIME_IN_MILLIS = 1500;
    private final JPanel content;
    private final DemosPanel demosPanel;
    private final GalleryPanel snapshotsPanel;
    private final CustomersPanel customersPanel;
    private ScreenType currentScreen;
    private final ScreenTransition screenTransition;
    private DemoLauncher demoLauncher;

    public TransitionPanel(DemoLauncher demo, NavigationHeader navigationHeader) {
        super(new BorderLayout());
        this.demoLauncher = demo;
        this.setOpaque(false);
        this.content = new JPanel();
        this.content.setLayout(new BorderLayout());
        this.content.setOpaque(false);
        this.demosPanel = new DemosPanel(demo);
        this.snapshotsPanel = new GalleryPanel();
        this.customersPanel = new CustomersPanel();
        this.content.add((Component)this.demosPanel, "Center");
        this.add((Component)navigationHeader, "North");
        this.add((Component)this.content, "Center");
        Dimension dim1 = this.demosPanel.getPreferredSize();
        Dimension dim2 = navigationHeader.getPreferredSize();
        this.setPreferredSize(new Dimension(Math.max(dim1.width, dim2.width), dim1.height + dim2.height));
        this.currentScreen = ScreenType.DEMOS;
        this.screenTransition = new ScreenTransition(this.content, new ContentTransitionTarget());
    }

    void setContentVisible(boolean visible) {
        this.content.setVisible(visible);
    }

    public void startTransition(ScreenType newScreen) {
        if (newScreen != this.currentScreen) {
            this.demoLauncher.getGlassPane().setVisible(true);
            this.currentScreen = newScreen;
            this.screenTransition.startTransition(1500);
        }
    }

    private class ContentTransitionTarget
    implements TransitionTarget {
        private ContentTransitionTarget() {
        }

        @Override
        public void resetCurrentScreen() {
            TransitionPanel.this.content.removeAll();
        }

        @Override
        public void setupNextScreen() {
            switch (TransitionPanel.this.currentScreen) {
                case DEMOS: {
                    TransitionPanel.this.content.add((Component)TransitionPanel.this.demosPanel, "Center");
                    TransitionPanel.this.demosPanel.fill();
                    break;
                }
                case CUSTOMERS: {
                    TransitionPanel.this.content.add((Component)TransitionPanel.this.customersPanel, "Center");
                    break;
                }
                case SNAPSHOTS: {
                    TransitionPanel.this.content.add((Component)TransitionPanel.this.snapshotsPanel, "Center");
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        @Override
        public void transitionComplete() {
            TransitionPanel.this.demoLauncher.getGlassPane().setVisible(false);
        }
    }

    public static enum ScreenType {
        DEMOS,
        CUSTOMERS,
        SNAPSHOTS;

    }
}

