/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase;

import com.dlsc.flexgantt.showcase.DemoLauncher;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

class NavigationHeader
extends JComponent {
    private final PathButtonHandler eventHandler;
    private final Stack<PathButton> buttonStack;
    private int preferredHeight = 28;
    private BufferedImage backgroundGradient;
    private Font pathFont = new Font("Arial", 0, 12);
    private Color pathColor = new Color(255, 255, 255);
    private float pathShadowOpacity = 0.7f;
    private Color pathShadowColor = new Color(0, 0, 0);
    private int pathShadowDistance = 1;
    private int pathShadowDirection = 60;
    private BufferedImage pathSeparatorLeft;
    private BufferedImage pathSeparatorRight;
    private BufferedImage haloPicture;
    private DemoLauncher launcher;

    public NavigationHeader(DemoLauncher launcher) {
        this.launcher = launcher;
        Image image = new ImageIcon(this.getClass().getResource("header-gradient.png")).getImage();
        this.backgroundGradient = new BufferedImage(image.getWidth(this), image.getHeight(this), 2);
        this.backgroundGradient.getGraphics().drawImage(image, 0, 0, this);
        image = new ImageIcon(this.getClass().getResource("header-slash-left.png")).getImage();
        this.pathSeparatorLeft = new BufferedImage(image.getWidth(this), image.getHeight(this), 2);
        this.pathSeparatorLeft.getGraphics().drawImage(image, 0, 0, this);
        image = new ImageIcon(this.getClass().getResource("header-slash-right.png")).getImage();
        this.pathSeparatorRight = new BufferedImage(image.getWidth(this), image.getHeight(this), 2);
        this.pathSeparatorRight.getGraphics().drawImage(image, 0, 0, this);
        image = new ImageIcon(this.getClass().getResource("header-halo.png")).getImage();
        this.haloPicture = new BufferedImage(image.getWidth(this), image.getHeight(this), 2);
        this.haloPicture.getGraphics().drawImage(image, 0, 0, this);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(Box.createRigidArea(new Dimension(2, 2)));
        this.eventHandler = new PathButtonHandler();
        this.buttonStack = new Stack();
        this.addLink("Demos");
        this.addLink("Gallery");
        this.addLink("Customers");
    }

    void addLink(String title) {
        PathButton pathButton = new PathButton(title);
        this.add(this.buttonStack.push(pathButton));
        this.revalidate();
        this.repaint();
    }

    void clearLinks() {
        while (this.buttonStack.size() > 0) {
            this.remove(this.buttonStack.pop());
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = this.preferredHeight;
        return size;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size = super.getMaximumSize();
        size.height = this.preferredHeight;
        return size;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g22 = (Graphics2D)g2;
        NavigationHeader.setupGraphics(g22);
        this.paintBackground(g22);
    }

    private static void setupGraphics(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    private void paintBackground(Graphics2D g2) {
        int height = this.backgroundGradient.getHeight();
        Rectangle bounds = g2.getClipBounds();
        g2.drawImage(this.backgroundGradient, (int)bounds.getX(), 0, (int)bounds.getWidth(), height, null);
    }

    private class PathButtonHandler
    extends MouseAdapter {
        private PathButtonHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            PathButton pathButton = (PathButton)e2.getSource();
            int index = NavigationHeader.this.buttonStack.indexOf(pathButton);
            switch (index) {
                case 0: {
                    NavigationHeader.this.launcher.showDemos();
                    break;
                }
                case 1: {
                    NavigationHeader.this.launcher.showSnapshots();
                    break;
                }
                case 2: {
                    NavigationHeader.this.launcher.showCustomers();
                    break;
                }
            }
        }
    }

    private class PathButton
    extends JButton
    implements MouseListener,
    TimingTarget {
        private final float shadowOffsetX;
        private final float shadowOffsetY;
        private int textWidth;
        private float ghostValue;
        private Animator animator;

        private PathButton(String item) {
            super(item);
            this.ghostValue = 0.0f;
            this.setFont(NavigationHeader.this.pathFont);
            this.setFocusable(false);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            FontMetrics metrics = this.getFontMetrics(NavigationHeader.this.pathFont);
            this.textWidth = SwingUtilities.computeStringWidth(metrics, this.getText());
            double rads = Math.toRadians(NavigationHeader.this.pathShadowDirection);
            this.shadowOffsetX = (float)Math.cos(rads) * (float)NavigationHeader.this.pathShadowDistance;
            this.shadowOffsetY = (float)Math.sin(rads) * (float)NavigationHeader.this.pathShadowDistance;
            this.addMouseListener(NavigationHeader.this.eventHandler);
            this.addMouseListener(this);
        }

        @Override
        public Dimension getSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            int width = 20 + this.textWidth;
            if (this != NavigationHeader.this.buttonStack.peek()) {
                width += NavigationHeader.this.pathSeparatorLeft.getWidth();
            }
            if (this != NavigationHeader.this.buttonStack.get(0)) {
                width += NavigationHeader.this.pathSeparatorRight.getWidth();
            }
            return new Dimension(width, NavigationHeader.this.preferredHeight);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            Graphics2D g22 = (Graphics2D)g2;
            Composite composite = g22.getComposite();
            if (this.ghostValue > 0.0f) {
                int x2 = -5;
                g22.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g22.setComposite(AlphaComposite.getInstance(3, this.ghostValue));
                g22.drawImage(NavigationHeader.this.haloPicture, x2 += NavigationHeader.this.pathSeparatorLeft.getWidth(), 0, this.textWidth + 20, this.getHeight(), null);
            }
            float offset = 10.0f;
            if (this != NavigationHeader.this.buttonStack.get(0)) {
                offset += (float)NavigationHeader.this.pathSeparatorRight.getWidth();
            }
            FontRenderContext context = g22.getFontRenderContext();
            TextLayout layout = new TextLayout(this.getText(), NavigationHeader.this.pathFont, context);
            g22.setComposite(AlphaComposite.getInstance(3, NavigationHeader.this.pathShadowOpacity));
            g22.setColor(NavigationHeader.this.pathShadowColor);
            layout.draw(g22, this.shadowOffsetX + offset, (float)(this.getHeight() / 2) + layout.getAscent() / 2.0f + this.shadowOffsetY - 2.0f);
            g22.setComposite(composite);
            g22.setColor(NavigationHeader.this.pathColor);
            layout.draw(g22, offset, (float)(this.getHeight() / 2) + layout.getAscent() / 2.0f - 2.0f);
            if (this != NavigationHeader.this.buttonStack.peek()) {
                g22.drawImage((Image)NavigationHeader.this.pathSeparatorLeft, this.getWidth() - NavigationHeader.this.pathSeparatorLeft.getWidth(), 0, null);
            }
            if (this != NavigationHeader.this.buttonStack.get(0)) {
                g22.drawImage((Image)NavigationHeader.this.pathSeparatorRight, 0, 0, null);
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            if (this.animator != null) {
                this.animator.stop();
            }
            this.animator = new Animator(333, this);
            this.animator.start();
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (this.animator != null) {
                this.animator.stop();
            }
            this.animator = new Animator(333, this);
            this.animator.setStartFraction(1.0f);
            this.animator.setStartDirection(Animator.Direction.BACKWARD);
            this.animator.start();
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void timingEvent(float fraction) {
            this.ghostValue = fraction;
            this.repaint();
        }

        @Override
        public void begin() {
        }

        @Override
        public void end() {
        }

        @Override
        public void repeat() {
        }
    }
}

