/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.policy.layer;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.policy.layer.AbstractGridPolicy;
import java.util.Date;

public class TimeGranularityGridPolicy
extends AbstractGridPolicy<TimeGranularity> {
    public TimeGranularityGridPolicy(boolean adjustingStartTimes, boolean adjustingEndTimes, TimeGranularity ... granularities) {
        super(adjustingStartTimes, adjustingEndTimes, (IGranularity[])granularities);
    }

    public TimeGranularityGridPolicy(TimeGranularity ... granularities) {
        this(true, true, granularities);
    }

    public TimeGranularityGridPolicy() {
        this(TimeGranularity.MONTH_SHORT, TimeGranularity.WEEK, TimeGranularity.DAY_SHORT, TimeGranularity.HOUR, TimeGranularity.MINUTE, TimeGranularity.SECOND);
    }

    @Override
    public ITimeSpan getGridAdjustedTimeSpan(TimeGranularity tg, ITimeSpan timeSpan, IDatelineModel<TimeGranularity> datelineModel, boolean autoGrid) {
        long s2 = this.getGridAdjustedStartTime(tg, timeSpan.getStartTime(), datelineModel, autoGrid);
        long e2 = this.getGridAdjustedEndTime(tg, timeSpan.getEndTime(), datelineModel, autoGrid);
        return new TimeSpan(s2, e2);
    }

    @Override
    public long getGridAdjustedStartTime(TimeGranularity tg, long startTime, IDatelineModel<TimeGranularity> datelineModel, boolean autoGrid) {
        if (this.isAdjustingStartTimes()) {
            return this.getGridAdjustedTime(tg, startTime, datelineModel, autoGrid);
        }
        return startTime;
    }

    @Override
    public long getGridAdjustedEndTime(TimeGranularity tg, long endTime, IDatelineModel<TimeGranularity> datelineModel, boolean autoGrid) {
        if (this.isAdjustingEndTimes()) {
            return this.getGridAdjustedTime(tg, endTime, datelineModel, autoGrid);
        }
        return endTime;
    }

    private long getGridAdjustedTime(TimeGranularity tg, long time, IDatelineModel<TimeGranularity> datelineModel, boolean autoGrid) {
        if (autoGrid) {
            tg = datelineModel.getGranularity();
        }
        if (tg == null) {
            return time;
        }
        Date d1 = new Date(time);
        tg.adjustDate(d1, datelineModel.getTimeZone());
        long t1 = d1.getTime();
        Date d2 = new Date(time);
        tg.adjustDate(d2, datelineModel.getTimeZone());
        tg.increment(d2, datelineModel.getTimeZone());
        long t2 = d2.getTime();
        if (Math.abs(time - t1) < Math.abs(time - t2)) {
            return t1;
        }
        return t2;
    }
}

