/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.treetable;

import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ColumnModelIterator
implements Iterator<TreeTableColumn> {
    private IColumnModel model;
    private int keyColumnPosition;
    private int index;
    private boolean keyReturned;

    public ColumnModelIterator(IColumnModel model, int keyColumnPosition) {
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (keyColumnPosition < 0) {
            throw new IllegalArgumentException("key column position can not be negative: " + keyColumnPosition);
        }
        this.model = model;
        this.keyColumnPosition = keyColumnPosition;
    }

    @Override
    public boolean hasNext() {
        if (this.model.getKeyColumn() != null) {
            return this.index < this.model.getColumnCount() + 1;
        }
        return this.index < this.model.getColumnCount();
    }

    @Override
    public TreeTableColumn next() throws NoSuchElementException {
        int count = this.model.getColumnCount();
        TreeTableColumn result = null;
        if (!(this.keyReturned || this.index != this.keyColumnPosition && this.index < count || this.model.getKeyColumn() == null)) {
            result = this.model.getKeyColumn();
            this.keyReturned = true;
        } else if (this.keyReturned) {
            if (this.index - 1 < count) {
                result = this.model.getColumn(this.index - 1);
            }
        } else if (this.index < count) {
            result = this.model.getColumn(this.index);
        }
        ++this.index;
        if (result == null) {
            throw new NoSuchElementException("iterator has no more elements");
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("columns can not be removed this way");
    }
}

