/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.treetable;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.util.Messages;
import java.util.Iterator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultReassignNodesCommand
extends AbstractCommand {
    private DefaultTreeModel model;
    private MutableTreeNode newParent;
    private MutableTreeNode oldParent;
    private MutableTreeNode[] nodes;
    private int[] newChildIndices;
    private int[] oldChildIndices;

    public DefaultReassignNodesCommand(String name, MutableTreeNode[] nodes, MutableTreeNode oldParent, int[] oldChildIndices, MutableTreeNode newParent, int[] newChildIndices, DefaultTreeModel model) {
        super(name);
        if (nodes == null) {
            throw new IllegalArgumentException("array of nodes can not be NULL");
        }
        if (oldParent == null) {
            throw new IllegalArgumentException("old parent can not be NULL");
        }
        if (oldChildIndices == null) {
            throw new IllegalArgumentException("array of old child indices can not be NULL");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("new parent can not be NULL");
        }
        if (newChildIndices == null) {
            throw new IllegalArgumentException("array of new child indices can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("tree table model can not be NULL");
        }
        int l1 = nodes.length;
        int l2 = oldChildIndices.length;
        int l3 = newChildIndices.length;
        if (l1 != l2) {
            throw new IllegalArgumentException("number of nodes does not match number of old child indices (nodes = " + l1 + ", indices = " + l2 + ")");
        }
        if (l1 != l3) {
            throw new IllegalArgumentException("number of nodes does not match number of new child indices (nodes = " + l1 + ", indices = " + l3 + ")");
        }
        this.newParent = newParent;
        this.oldParent = oldParent;
        this.nodes = nodes;
        this.model = model;
        this.oldChildIndices = oldChildIndices;
        this.newChildIndices = newChildIndices;
    }

    public DefaultReassignNodesCommand(MutableTreeNode[] nodes, MutableTreeNode oldParent, int[] oldChildIndices, MutableTreeNode newParent, int[] newChildIndices, DefaultTreeModel model) {
        this(Messages.getString("DefaultReassignNodesCommand.NAME"), nodes, oldParent, oldChildIndices, newParent, newChildIndices, model);
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        TreePath oldParentPath = new TreePath(this.model.getPathToRoot(this.oldParent));
        TreePath newParentPath = new TreePath(this.model.getPathToRoot(this.newParent));
        this.fixRelationships(oldParentPath, newParentPath);
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            this.oldParent.remove(this.oldChildIndices[i2] - i2);
            this.newParent.insert(this.nodes[i2], this.newChildIndices[i2]);
        }
        this.model.nodesWereRemoved(this.oldParent, this.oldChildIndices, this.nodes);
        this.model.nodesWereInserted(this.newParent, this.newChildIndices);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        TreePath oldParentPath = new TreePath(this.model.getPathToRoot(this.newParent));
        TreePath newParentPath = new TreePath(this.model.getPathToRoot(this.oldParent));
        this.fixRelationships(oldParentPath, newParentPath);
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            this.newParent.remove(this.newChildIndices[i2] - i2);
            this.oldParent.insert(this.nodes[i2], this.oldChildIndices[i2]);
        }
        this.model.nodesWereRemoved(this.newParent, this.newChildIndices, this.nodes);
        this.model.nodesWereInserted(this.oldParent, this.oldChildIndices);
    }

    private void fixRelationships(TreePath oldParentPath, TreePath newParentPath) {
        for (MutableTreeNode node : this.nodes) {
            this.fixRelationshipsForNode(node, oldParentPath, newParentPath);
        }
    }

    private void fixRelationshipsForNode(TreeNode node, TreePath oldParentPath, TreePath newParentPath) {
        IGanttChartModel gm = (IGanttChartModel)((Object)this.model);
        Iterator iter = gm.getRelationships();
        while (iter.hasNext()) {
            this.fixRelationship(node, iter.next(), oldParentPath, newParentPath);
            int count = node.getChildCount();
            for (int i2 = 0; i2 < count; ++i2) {
                TreeNode child = node.getChildAt(i2);
                this.fixRelationshipsForNode(child, oldParentPath.pathByAddingChild(node), newParentPath.pathByAddingChild(node));
            }
        }
    }

    private void fixRelationship(TreeNode node, IRelationship rel, TreePath oldParentPath, TreePath newParentPath) {
        TreePath oldPath = oldParentPath.pathByAddingChild(node);
        TreePath newPath = newParentPath.pathByAddingChild(node);
        TimelineObjectPath sourcePath = rel.getSourcePath();
        TimelineObjectPath targetPath = rel.getTargetPath();
        if (sourcePath.getTreePath().equals(oldPath)) {
            sourcePath = new TimelineObjectPath(newPath, sourcePath.getTimelineObject(), sourcePath.getLayer());
        }
        if (targetPath.getTreePath().equals(oldPath)) {
            targetPath = new TimelineObjectPath(newPath, targetPath.getTimelineObject(), targetPath.getLayer());
        }
        rel.setSourcePath(sourcePath);
        rel.setTargetPath(targetPath);
    }

    public DefaultTreeModel getModel() {
        return this.model;
    }

    public MutableTreeNode getNewParent() {
        return this.newParent;
    }

    public MutableTreeNode getOldParent() {
        return this.oldParent;
    }

    public MutableTreeNode[] getNodes() {
        return this.nodes;
    }

    public int[] getNewChildIndices() {
        return this.newChildIndices;
    }

    public int[] getOldChildIndices() {
        return this.oldChildIndices;
    }
}

