/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.treetable;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.treetable.DefaultTreeTableModel;
import com.dlsc.flexgantt.model.treetable.IMutableTreeTableNode;
import com.dlsc.flexgantt.util.Messages;

public class DefaultInsertNodeCommand
extends AbstractCommand {
    private IMutableTreeTableNode childNode;
    private IMutableTreeTableNode parentNode;
    private DefaultTreeTableModel model;
    private int childIndex;

    public DefaultInsertNodeCommand(IMutableTreeTableNode parent, int childIndex, DefaultTreeTableModel model) {
        super(Messages.getString("DefaultInsertNodeCommand.NAME"));
        if (parent == null) {
            throw new IllegalArgumentException("parent can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        this.parentNode = parent;
        this.model = model;
        this.childIndex = childIndex;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        if (this.childNode == null) {
            this.childNode = this.createNewNode();
        }
        if (this.childNode.getParent() != this.parentNode) {
            this.parentNode.insert(this.childNode, this.childIndex);
            this.model.nodesWereInserted(this.parentNode, new int[]{this.childIndex});
        }
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        int index = this.parentNode.getIndex(this.childNode);
        this.parentNode.remove(this.childNode);
        this.model.nodesWereRemoved(this.parentNode, new int[]{index}, new Object[]{this.childNode});
    }

    protected IMutableTreeTableNode createNewNode() {
        return new DefaultGanttChartNode(true);
    }

    public IMutableTreeTableNode getParentNode() {
        return this.parentNode;
    }

    public DefaultTreeTableModel getModel() {
        return this.model;
    }

    public IMutableTreeTableNode getChildNode() {
        return this.childNode;
    }

    public int getChildIndex() {
        return this.childIndex;
    }
}

