/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.RelationshipType;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.scheduling.IConstraint;
import com.dlsc.flexgantt.model.scheduling.TimeGranularityConstraint;
import com.dlsc.flexgantt.util.Messages;

public class DefaultCreateConstraintCommand
extends AbstractCommand {
    private IConstraint constraint;
    private RelationshipType type;
    private TimelineObjectPath sourcePath;
    private TimelineObjectPath targetPath;
    private DefaultGanttChartModel model;

    public DefaultCreateConstraintCommand(TimelineObjectPath sourcePath, TimelineObjectPath targetPath, RelationshipType type, DefaultGanttChartModel model) {
        super(Messages.getString("DefaulCreateConstraintCommand.NAME"));
        if (sourcePath == null) {
            throw new IllegalArgumentException("source path can not be NULL");
        }
        if (targetPath == null) {
            throw new IllegalArgumentException("target path can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (type == null) {
            throw new IllegalArgumentException("type can not be NULL");
        }
        this.model = model;
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
        this.type = type;
        this.constraint = this.createConstraint(sourcePath, targetPath);
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.model.addRelationship(this.constraint);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.model.removeRelationship(this.constraint);
    }

    public DefaultGanttChartModel getModel() {
        return this.model;
    }

    public IConstraint getConstraint() {
        return this.constraint;
    }

    public RelationshipType getRelationshipType() {
        return this.type;
    }

    public TimelineObjectPath getSourcePath() {
        return this.sourcePath;
    }

    public TimelineObjectPath getTargetPath() {
        return this.targetPath;
    }

    protected IConstraint createConstraint(TimelineObjectPath sourcePath, TimelineObjectPath targetPath) {
        return new TimeGranularityConstraint(sourcePath, targetPath, this.type);
    }
}

