/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.dateline;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.util.Messages;
import java.util.TimeZone;
import java.util.logging.Logger;

public class DefaultChangeTimeZoneCommand
extends AbstractCommand {
    private static final Logger LOGGER = Logger.getLogger(DefaultChangeTimeZoneCommand.class.getName());
    private TimeZone newTimeZone;
    private TimeZone oldTimeZone;
    private IDatelineModel datelineModel;

    public DefaultChangeTimeZoneCommand(IDatelineModel model, TimeZone timeZone) {
        super(Messages.getString("DefaultChangeTimeZoneCommand.NAME"));
        if (model == null) {
            throw new IllegalArgumentException("dateline model can not be NULL");
        }
        if (timeZone == null) {
            throw new IllegalArgumentException("time zone can not be NULL");
        }
        this.datelineModel = model;
        this.newTimeZone = timeZone;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.oldTimeZone = this.datelineModel.getTimeZone();
        try {
            this.datelineModel.setTimeZone(this.newTimeZone);
        }
        catch (DatelineModelException e2) {
            LOGGER.throwing(DefaultChangeTimeZoneCommand.class.getName(), "executeCommand", e2);
        }
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        try {
            this.datelineModel.setTimeZone(this.oldTimeZone);
        }
        catch (DatelineModelException e2) {
            LOGGER.throwing(DefaultChangeTimeZoneCommand.class.getName(), "undoCommand", e2);
        }
    }
}

