/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.swingx.JXPanel;

@Deprecated
public class JXGlassBox
extends JXPanel {
    private static final int SHOW_DELAY = 30;
    private static final int TIMER_INCREMENT = 10;
    private float alphaStart = 0.01f;
    private float alphaEnd = 0.8f;
    private Timer animateTimer;
    private float alphaIncrement = 0.02f;
    private boolean dismissOnClick = false;
    private MouseAdapter dismissListener = null;

    public JXGlassBox() {
        this.setOpaque(false);
        this.setAlpha(this.alphaStart);
        this.setBackground(Color.white);
        this.setDismissOnClick(true);
        this.animateTimer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JXGlassBox.this.setAlpha(Math.min(JXGlassBox.this.alphaEnd, JXGlassBox.this.getAlpha() + JXGlassBox.this.alphaIncrement));
            }
        });
    }

    public JXGlassBox(float alpha) {
        this();
        this.setAlpha(alpha);
    }

    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        this.alphaIncrement = (this.alphaEnd - this.alphaStart) / 3.0f;
    }

    public void dismiss() {
        JComponent parent = (JComponent)this.getParent();
        if (parent != null) {
            Container toplevel = parent.getTopLevelAncestor();
            parent.remove(this);
            toplevel.validate();
            toplevel.repaint();
        }
    }

    public boolean isDismissOnClick() {
        return this.dismissOnClick;
    }

    public void setDismissOnClick(boolean dismissOnClick) {
        boolean oldDismissOnClick = this.dismissOnClick;
        this.dismissOnClick = dismissOnClick;
        this.firePropertyChange("dismissOnClick", oldDismissOnClick, this.isDismissOnClick());
        if (dismissOnClick && !oldDismissOnClick) {
            if (this.dismissListener == null) {
                this.dismissListener = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e2) {
                        JXGlassBox.this.dismiss();
                    }
                };
            }
            this.addMouseListener(this.dismissListener);
        } else if (!dismissOnClick && oldDismissOnClick) {
            this.removeMouseListener(this.dismissListener);
        }
    }

    public void paint(Graphics g2) {
        super.paint(g2);
        if (!this.animateTimer.isRunning() && this.getAlpha() < this.alphaEnd) {
            this.animateTimer.start();
        }
        if (this.animateTimer.isRunning() && this.getAlpha() >= this.alphaEnd) {
            this.animateTimer.stop();
        }
    }

    public void setVisible(boolean visible) {
        boolean old = this.isVisible();
        this.setAlpha(this.alphaStart);
        super.setVisible(visible);
        this.firePropertyChange("visible", old, this.isVisible());
    }

    private Container getTopLevel() {
        Container p2;
        for (p2 = this.getParent(); p2 != null && !(p2 instanceof Window) && !(p2 instanceof Applet); p2 = p2.getParent()) {
        }
        return p2;
    }

    public void showOnGlassPane(Container glassPane, Component origin, int offsetX, int offsetY, int positionHint) {
        Rectangle r2 = SwingUtilities.convertRectangle(origin, origin.getBounds(), glassPane);
        Dimension d2 = this.getPreferredSize();
        int originX = offsetX + r2.x;
        int originY = offsetY + r2.y;
        switch (positionHint) {
            case 1: {
                originX += (r2.width - d2.width) / 2;
                originY -= d2.height;
                break;
            }
            case 3: {
                originX += (r2.width - d2.width) / 2;
                originY += r2.height;
                break;
            }
            case 2: {
                originX -= d2.width;
                originY += (r2.height - d2.height) / 2;
                break;
            }
            case 4: {
                originX += r2.width;
                originY += (r2.height - d2.height) / 2;
                break;
            }
            case 0: {
                originX += (r2.width - d2.width) / 2;
                originY += (r2.height - d2.height) / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("inavlid position hint");
            }
        }
        this.showOnGlassPane(glassPane, originX, originY);
    }

    public void showOnGlassPane(Container glassPane, int originX, int originY) {
        Dimension gd2 = glassPane.getSize();
        Dimension bd2 = this.getPreferredSize();
        int x2 = Math.min(originX, gd2.width - bd2.width);
        int y2 = Math.min(originY, gd2.height - bd2.height);
        if (x2 < 0) {
            x2 = 0;
        }
        if (y2 < 0) {
            y2 = 0;
        }
        int width = x2 + bd2.width < gd2.width ? bd2.width : gd2.width;
        int height = y2 + bd2.height < gd2.height ? bd2.height : gd2.height;
        glassPane.setLayout(null);
        this.setBounds(x2, y2, width, height);
        glassPane.add(this);
        glassPane.setVisible(true);
        Container topLevel = this.getTopLevel();
        topLevel.validate();
        topLevel.repaint();
    }
}

