/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JSplitPane;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.SplitPaneState;

public class SplitPaneProperty
implements PropertySupport {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof JSplitPane)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    @Override
    public Object getSessionState(Component c2) {
        this.checkComponent(c2);
        JSplitPane p2 = (JSplitPane)c2;
        return new SplitPaneState(p2.getUI().getDividerLocation(p2), p2.getOrientation());
    }

    @Override
    public void setSessionState(Component c2, Object state) {
        this.checkComponent(c2);
        if (state == null) {
            return;
        }
        if (state instanceof SplitPaneState) {
            final JSplitPane p2 = (JSplitPane)c2;
            final SplitPaneState sps = (SplitPaneState)state;
            if (p2.getOrientation() == sps.getOrientation()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        p2.setDividerLocation(sps.getDividerLocation());
                    }
                });
            }
        } else {
            throw new IllegalArgumentException("invalid state");
        }
    }
}

