/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdesktop.application.ResourceMap;

public abstract class ResourceConverter {
    protected final Class type;
    private static ResourceConverter[] resourceConvertersArray = new ResourceConverter[]{new BooleanResourceConverter("true", "on", "yes"), new IntegerResourceConverter(), new MessageFormatResourceConverter(), new FloatResourceConverter(), new DoubleResourceConverter(), new LongResourceConverter(), new ShortResourceConverter(), new ByteResourceConverter(), new URLResourceConverter(), new URIResourceConverter()};
    private static List<ResourceConverter> resourceConverters = new ArrayList<ResourceConverter>(Arrays.asList(resourceConvertersArray));

    public abstract Object parseString(String var1, ResourceMap var2) throws ResourceConverterException;

    public String toString(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    protected ResourceConverter(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        this.type = type;
    }

    private ResourceConverter() {
        this.type = null;
    }

    public boolean supportsType(Class testType) {
        return this.type.equals(testType);
    }

    public static void register(ResourceConverter resourceConverter) {
        if (resourceConverter == null) {
            throw new IllegalArgumentException("null resourceConverter");
        }
        resourceConverters.add(resourceConverter);
    }

    public static ResourceConverter forType(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        for (ResourceConverter sc2 : resourceConverters) {
            if (!sc2.supportsType(type)) continue;
            return sc2;
        }
        return null;
    }

    private static class URIResourceConverter
    extends ResourceConverter {
        URIResourceConverter() {
            super(URI.class);
        }

        @Override
        public Object parseString(String s2, ResourceMap ignore) throws ResourceConverterException {
            try {
                return new URI(s2);
            }
            catch (URISyntaxException e2) {
                throw new ResourceConverterException("invalid URI", s2, e2);
            }
        }
    }

    private static class URLResourceConverter
    extends ResourceConverter {
        URLResourceConverter() {
            super(URL.class);
        }

        @Override
        public Object parseString(String s2, ResourceMap ignore) throws ResourceConverterException {
            try {
                return new URL(s2);
            }
            catch (MalformedURLException e2) {
                throw new ResourceConverterException("invalid URL", s2, e2);
            }
        }
    }

    private static class MessageFormatResourceConverter
    extends ResourceConverter {
        MessageFormatResourceConverter() {
            super(MessageFormat.class);
        }

        @Override
        public Object parseString(String s2, ResourceMap ignore) {
            return new MessageFormat(s2);
        }
    }

    private static class ShortResourceConverter
    extends INumberResourceConverter {
        ShortResourceConverter() {
            super(Short.class, Short.TYPE);
        }

        @Override
        protected Number parseString(String s2, int radix) throws NumberFormatException {
            return radix == -1 ? Short.decode(s2) : Short.parseShort(s2, radix);
        }
    }

    private static class LongResourceConverter
    extends INumberResourceConverter {
        LongResourceConverter() {
            super(Long.class, Long.TYPE);
        }

        @Override
        protected Number parseString(String s2, int radix) throws NumberFormatException {
            return radix == -1 ? Long.decode(s2) : Long.parseLong(s2, radix);
        }
    }

    private static class IntegerResourceConverter
    extends INumberResourceConverter {
        IntegerResourceConverter() {
            super(Integer.class, Integer.TYPE);
        }

        @Override
        protected Number parseString(String s2, int radix) throws NumberFormatException {
            return radix == -1 ? Integer.decode(s2) : Integer.parseInt(s2, radix);
        }
    }

    private static class ByteResourceConverter
    extends INumberResourceConverter {
        ByteResourceConverter() {
            super(Byte.class, Byte.TYPE);
        }

        @Override
        protected Number parseString(String s2, int radix) throws NumberFormatException {
            return radix == -1 ? Byte.decode(s2) : Byte.parseByte(s2, radix);
        }
    }

    private static abstract class INumberResourceConverter
    extends ResourceConverter {
        private final Class primitiveType;

        INumberResourceConverter(Class type, Class primitiveType) {
            super(type);
            this.primitiveType = primitiveType;
        }

        protected abstract Number parseString(String var1, int var2) throws NumberFormatException;

        @Override
        public Object parseString(String s2, ResourceMap ignore) throws ResourceConverterException {
            try {
                String[] nar = s2.split("&");
                int radix = nar.length == 2 ? Integer.parseInt(nar[1]) : -1;
                return this.parseString(nar[0], radix);
            }
            catch (NumberFormatException e2) {
                throw new ResourceConverterException("invalid " + this.type.getSimpleName(), s2, e2);
            }
        }

        @Override
        public boolean supportsType(Class testType) {
            return testType.equals(this.type) || testType.equals(this.primitiveType);
        }
    }

    private static class DoubleResourceConverter
    extends NumberResourceConverter {
        DoubleResourceConverter() {
            super(Double.class, Double.TYPE);
        }

        @Override
        protected Number parseString(String s2) throws NumberFormatException {
            return Double.parseDouble(s2);
        }
    }

    private static class FloatResourceConverter
    extends NumberResourceConverter {
        FloatResourceConverter() {
            super(Float.class, Float.TYPE);
        }

        @Override
        protected Number parseString(String s2) throws NumberFormatException {
            return Float.valueOf(Float.parseFloat(s2));
        }
    }

    private static abstract class NumberResourceConverter
    extends ResourceConverter {
        private final Class primitiveType;

        NumberResourceConverter(Class type, Class primitiveType) {
            super(type);
            this.primitiveType = primitiveType;
        }

        protected abstract Number parseString(String var1) throws NumberFormatException;

        @Override
        public Object parseString(String s2, ResourceMap ignore) throws ResourceConverterException {
            try {
                return this.parseString(s2);
            }
            catch (NumberFormatException e2) {
                throw new ResourceConverterException("invalid " + this.type.getSimpleName(), s2, e2);
            }
        }

        @Override
        public boolean supportsType(Class testType) {
            return testType.equals(this.type) || testType.equals(this.primitiveType);
        }
    }

    private static class BooleanResourceConverter
    extends ResourceConverter {
        private final String[] trueStrings;

        BooleanResourceConverter(String ... trueStrings) {
            super(Boolean.class);
            this.trueStrings = trueStrings;
        }

        @Override
        public Object parseString(String s2, ResourceMap ignore) {
            s2 = s2.trim();
            for (String trueString : this.trueStrings) {
                if (!s2.equalsIgnoreCase(trueString)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public boolean supportsType(Class testType) {
            return testType.equals(Boolean.class) || testType.equals(Boolean.TYPE);
        }
    }

    public static class ResourceConverterException
    extends Exception {
        private final String badString;

        private String maybeShorten(String s2) {
            int n2 = s2.length();
            return n2 < 128 ? s2 : s2.substring(0, 128) + "...[" + (n2 - 128) + " more characters]";
        }

        public ResourceConverterException(String message, String badString, Throwable cause) {
            super(message, cause);
            this.badString = this.maybeShorten(badString);
        }

        public ResourceConverterException(String message, String badString) {
            super(message);
            this.badString = this.maybeShorten(badString);
        }

        @Override
        public String toString() {
            StringBuffer sb2 = new StringBuffer(super.toString());
            sb2.append(" string: \"");
            sb2.append(this.badString);
            sb2.append("\"");
            return sb2.toString();
        }
    }
}

