/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Rectangle;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.utils.AppHelper;
import org.jdesktop.application.utils.PlatformType;

public class LocalStorage
extends AbstractBean {
    private static Logger logger = Logger.getLogger(LocalStorage.class.getName());
    private final ApplicationContext context;
    private long storageLimit = -1L;
    private LocalIO localIO = null;
    private final File unspecifiedFile;
    private File directory = this.unspecifiedFile = new File("unspecified");
    private static boolean persistenceDelegatesInitialized = false;

    protected LocalStorage(ApplicationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = context;
    }

    protected final ApplicationContext getContext() {
        return this.context;
    }

    private void checkFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
    }

    public InputStream openInputFile(String fileName) throws IOException {
        this.checkFileName(fileName);
        return this.getLocalIO().openInputFile(fileName);
    }

    public OutputStream openOutputFile(String fileName) throws IOException {
        return this.openOutputFile(fileName, false);
    }

    public OutputStream openOutputFile(String fileName, boolean append) throws IOException {
        this.checkFileName(fileName);
        return this.getLocalIO().openOutputFile(fileName, append);
    }

    public boolean deleteFile(String fileName) throws IOException {
        this.checkFileName(fileName);
        return this.getLocalIO().deleteFile(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Object bean, String fileName) throws IOException {
        AbortExceptionListener el = new AbortExceptionListener();
        XMLEncoder e2 = null;
        ByteArrayOutputStream bst = new ByteArrayOutputStream();
        try {
            e2 = new XMLEncoder(bst);
            if (!persistenceDelegatesInitialized) {
                e2.setPersistenceDelegate(Rectangle.class, new RectanglePD());
                persistenceDelegatesInitialized = true;
            }
            e2.setExceptionListener(el);
            e2.writeObject(bean);
        }
        finally {
            if (e2 != null) {
                e2.close();
            }
        }
        if (el.exception != null) {
            throw new IOException("save failed \"" + fileName + "\"", el.exception);
        }
        OutputStream ost = null;
        try {
            ost = this.openOutputFile(fileName);
            ost.write(bst.toByteArray());
        }
        finally {
            if (ost != null) {
                ost.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(String fileName) throws IOException {
        InputStream ist;
        try {
            ist = this.openInputFile(fileName);
        }
        catch (IOException e2) {
            return null;
        }
        AbortExceptionListener el = new AbortExceptionListener();
        XMLDecoder d2 = null;
        try {
            d2 = new XMLDecoder(ist);
            d2.setExceptionListener(el);
            Object bean = d2.readObject();
            if (el.exception != null) {
                throw new IOException("load failed \"" + fileName + "\"", el.exception);
            }
            Object object = bean;
            return object;
        }
        finally {
            if (d2 != null) {
                d2.close();
            }
        }
    }

    public long getStorageLimit() {
        return this.storageLimit;
    }

    public void setStorageLimit(long storageLimit) {
        if (storageLimit < -1L) {
            throw new IllegalArgumentException("invalid storageLimit");
        }
        long oldValue = this.storageLimit;
        this.storageLimit = storageLimit;
        this.firePropertyChange("storageLimit", oldValue, this.storageLimit);
    }

    private String getId(String key, String def) {
        ResourceMap appResourceMap = this.getContext().getResourceMap();
        String id2 = appResourceMap.getString(key, new Object[0]);
        if (id2 == null) {
            logger.log(Level.WARNING, "unspecified resource " + key + " using " + def);
            id2 = def;
        } else if (id2.trim().length() == 0) {
            logger.log(Level.WARNING, "empty resource " + key + " using " + def);
            id2 = def;
        }
        return id2;
    }

    private String getApplicationId() {
        return this.getId("Application.id", this.getContext().getApplicationClass().getSimpleName());
    }

    private String getVendorId() {
        return this.getId("Application.vendorId", "UnknownApplicationVendor");
    }

    public File getDirectory() {
        if (this.directory == this.unspecifiedFile) {
            this.directory = null;
            String userHome = null;
            try {
                userHome = System.getProperty("user.home");
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (userHome != null) {
                String applicationId = this.getApplicationId();
                PlatformType osId = AppHelper.getPlatform();
                if (osId == PlatformType.WINDOWS) {
                    File appDataDir = null;
                    try {
                        String appDataEV = System.getenv("APPDATA");
                        if (appDataEV != null && appDataEV.length() > 0) {
                            appDataDir = new File(appDataEV);
                        }
                    }
                    catch (SecurityException ignore) {
                        // empty catch block
                    }
                    String vendorId = this.getVendorId();
                    if (appDataDir != null && appDataDir.isDirectory()) {
                        String path = vendorId + "\\" + applicationId + "\\";
                        this.directory = new File(appDataDir, path);
                    } else {
                        String path = "Application Data\\" + vendorId + "\\" + applicationId + "\\";
                        this.directory = new File(userHome, path);
                    }
                } else if (osId == PlatformType.OS_X) {
                    String path = "Library/Application Support/" + applicationId + "/";
                    this.directory = new File(userHome, path);
                } else {
                    String path = "." + applicationId + "/";
                    this.directory = new File(userHome, path);
                }
            }
        }
        return this.directory;
    }

    public void setDirectory(File directory) {
        File oldValue = this.directory;
        this.directory = directory;
        this.firePropertyChange("directory", oldValue, this.directory);
    }

    private synchronized LocalIO getLocalIO() {
        if (this.localIO == null) {
            this.localIO = this.getPersistenceServiceIO();
            if (this.localIO == null) {
                this.localIO = new LocalFileIO();
            }
        }
        return this.localIO;
    }

    private LocalIO getPersistenceServiceIO() {
        try {
            Class<?> smClass = Class.forName("javax.jnlp.ServiceManager");
            Method getServiceNamesMethod = smClass.getMethod("getServiceNames", new Class[0]);
            String[] serviceNames = (String[])getServiceNamesMethod.invoke(null, new Object[0]);
            boolean psFound = false;
            boolean bsFound = false;
            for (String serviceName : serviceNames) {
                if (serviceName.equals("javax.jnlp.BasicService")) {
                    bsFound = true;
                    continue;
                }
                if (!serviceName.equals("javax.jnlp.PersistenceService")) continue;
                psFound = true;
            }
            if (bsFound && psFound) {
                return new PersistenceServiceIO();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final class PersistenceServiceIO
    extends LocalIO {
        private BasicService bs;
        private PersistenceService ps;

        private String initFailedMessage(String s2) {
            return this.getClass().getName() + " initialization failed: " + s2;
        }

        PersistenceServiceIO() {
            try {
                this.bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                this.ps = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            }
            catch (UnavailableServiceException e2) {
                logger.log(Level.SEVERE, this.initFailedMessage("ServiceManager.lookup"), e2);
                this.bs = null;
                this.ps = null;
            }
        }

        private void checkBasics(String s2) throws IOException {
            if (this.bs == null || this.ps == null) {
                throw new IOException(this.initFailedMessage(s2));
            }
        }

        private URL fileNameToURL(String name) throws IOException {
            if (name == null) {
                throw new IOException("name is not set");
            }
            try {
                return new URL(this.bs.getCodeBase(), name);
            }
            catch (MalformedURLException e2) {
                throw new IOException("invalid filename \"" + name + "\"", e2);
            }
        }

        @Override
        public InputStream openInputFile(String fileName) throws IOException {
            this.checkBasics("openInputFile");
            URL fileURL = this.fileNameToURL(fileName);
            try {
                return new BufferedInputStream(this.ps.get(fileURL).getInputStream());
            }
            catch (Exception e2) {
                throw new IOException("openInputFile \"" + fileName + "\" failed", e2);
            }
        }

        @Override
        public OutputStream openOutputFile(String fileName, boolean append) throws IOException {
            this.checkBasics("openOutputFile");
            URL fileURL = this.fileNameToURL(fileName);
            try {
                FileContents fc2;
                block5: {
                    fc2 = null;
                    try {
                        fc2 = this.ps.get(fileURL);
                    }
                    catch (FileNotFoundException e2) {
                        long maxSizeRequest = 131072L;
                        long maxSize = this.ps.create(fileURL, maxSizeRequest);
                        if (maxSize < maxSizeRequest) break block5;
                        fc2 = this.ps.get(fileURL);
                    }
                }
                if (fc2 != null && fc2.canWrite()) {
                    return new BufferedOutputStream(fc2.getOutputStream(!append));
                }
                throw new IOException("unable to create FileContents object");
            }
            catch (Exception e3) {
                throw new IOException("openOutputFile \"" + fileName + "\" failed", e3);
            }
        }

        @Override
        public boolean deleteFile(String fileName) throws IOException {
            this.checkBasics("deleteFile");
            URL fileURL = this.fileNameToURL(fileName);
            try {
                this.ps.delete(fileURL);
                return true;
            }
            catch (Exception e2) {
                throw new IOException("openInputFile \"" + fileName + "\" failed", e2);
            }
        }
    }

    private final class LocalFileIO
    extends LocalIO {
        private LocalFileIO() {
        }

        @Override
        public InputStream openInputFile(String fileName) throws IOException {
            File path = this.getFile(fileName);
            try {
                return new BufferedInputStream(new FileInputStream(path));
            }
            catch (IOException e2) {
                throw new IOException("couldn't open input file \"" + fileName + "\"", e2);
            }
        }

        @Override
        public OutputStream openOutputFile(String name, boolean append) throws IOException {
            try {
                File file = this.getFile(name);
                File dir = file.getParentFile();
                if (!dir.isDirectory() && !dir.mkdirs()) {
                    throw new IOException("couldn't create directory " + dir);
                }
                return new BufferedOutputStream(new FileOutputStream(file, append));
            }
            catch (SecurityException exception) {
                throw new IOException("could not write to entry: " + name, exception);
            }
        }

        @Override
        public boolean deleteFile(String fileName) throws IOException {
            File path = new File(LocalStorage.this.getDirectory(), fileName);
            return path.delete();
        }

        private File getFile(String name) throws IOException {
            if (name == null) {
                throw new IOException("name is not set");
            }
            return new File(LocalStorage.this.getDirectory(), name);
        }
    }

    private abstract class LocalIO {
        private LocalIO() {
        }

        public abstract InputStream openInputFile(String var1) throws IOException;

        public OutputStream openOutputFile(String fileName) throws IOException {
            return this.openOutputFile(fileName, false);
        }

        public abstract OutputStream openOutputFile(String var1, boolean var2) throws IOException;

        public abstract boolean deleteFile(String var1) throws IOException;
    }

    private static class RectanglePD
    extends DefaultPersistenceDelegate {
        public RectanglePD() {
            super(new String[]{"x", "y", "width", "height"});
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Rectangle oldR = (Rectangle)oldInstance;
            Object[] constructorArgs = new Object[]{oldR.x, oldR.y, oldR.width, oldR.height};
            return new Expression(oldInstance, oldInstance.getClass(), "new", constructorArgs);
        }
    }

    private static class AbortExceptionListener
    implements ExceptionListener {
        public Exception exception = null;

        private AbortExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception e2) {
            if (this.exception == null) {
                this.exception = e2;
            }
        }
    }
}

