/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.helpers.BaseRowColShifter;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class ColumnShifter
extends BaseRowColShifter {
    protected final Sheet sheet;

    public ColumnShifter(Sheet sh) {
        this.sheet = sh;
    }

    @Override
    public List<CellRangeAddress> shiftMergedRegions(int startColumn, int endColumn, int n2) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        HashSet<Integer> removedIndices = new HashSet<Integer>();
        int size = this.sheet.getNumMergedRegions();
        for (int i2 = 0; i2 < size; ++i2) {
            boolean inEnd;
            CellRangeAddress merged = this.sheet.getMergedRegion(i2);
            if (this.removalNeeded(merged, startColumn, endColumn, n2)) {
                removedIndices.add(i2);
                continue;
            }
            boolean inStart = merged.getFirstColumn() >= startColumn || merged.getLastColumn() >= startColumn;
            boolean bl = inEnd = merged.getFirstColumn() <= endColumn || merged.getLastColumn() <= endColumn;
            if (!inStart || !inEnd || merged.containsColumn(startColumn - 1) || merged.containsColumn(endColumn + 1)) continue;
            merged.setFirstColumn(merged.getFirstColumn() + n2);
            merged.setLastColumn(merged.getLastColumn() + n2);
            shiftedRegions.add(merged);
            removedIndices.add(i2);
        }
        if (!removedIndices.isEmpty()) {
            this.sheet.removeMergedRegions(removedIndices);
        }
        for (CellRangeAddress region : shiftedRegions) {
            this.sheet.addMergedRegion(region);
        }
        return shiftedRegions;
    }

    private boolean removalNeeded(CellRangeAddress merged, int startColumn, int endColumn, int n2) {
        CellRangeAddress overwrite;
        int movedColumns = endColumn - startColumn + 1;
        if (n2 > 0) {
            int firstCol = Math.max(endColumn + 1, endColumn + n2 - movedColumns);
            int lastCol = endColumn + n2;
            overwrite = new CellRangeAddress(0, 0, firstCol, lastCol);
        } else {
            int firstCol = startColumn + n2;
            int lastCol = Math.min(startColumn - 1, startColumn + n2 + movedColumns);
            overwrite = new CellRangeAddress(0, 0, firstCol, lastCol);
        }
        return merged.intersects(overwrite);
    }

    public void shiftColumns(int firstShiftColumnIndex, int lastShiftColumnIndex, int step) {
        block3: {
            block2: {
                if (step <= 0) break block2;
                for (Row row : this.sheet) {
                    if (row == null) continue;
                    row.shiftCellsRight(firstShiftColumnIndex, lastShiftColumnIndex, step);
                }
                break block3;
            }
            if (step >= 0) break block3;
            for (Row row : this.sheet) {
                if (row == null) continue;
                row.shiftCellsLeft(firstShiftColumnIndex, lastShiftColumnIndex, -step);
            }
        }
    }
}

