/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.ptg;

import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.SheetNameFormatter;

final class ExternSheetNameResolver {
    private ExternSheetNameResolver() {
    }

    public static String prependSheetName(FormulaRenderingWorkbook book, int field_1_index_extern_sheet, String cellRefText) {
        StringBuilder sb2;
        EvaluationWorkbook.ExternalSheet externalSheet = book.getExternalSheet(field_1_index_extern_sheet);
        if (externalSheet != null) {
            EvaluationWorkbook.ExternalSheetRange r2;
            String wbName = externalSheet.getWorkbookName();
            String sheetName = externalSheet.getSheetName();
            if (wbName != null) {
                sb2 = new StringBuilder(wbName.length() + (sheetName == null ? 0 : sheetName.length()) + cellRefText.length() + 4);
                SheetNameFormatter.appendFormat(sb2, wbName, sheetName);
            } else {
                sb2 = new StringBuilder(sheetName.length() + cellRefText.length() + 4);
                SheetNameFormatter.appendFormat(sb2, sheetName);
            }
            if (externalSheet instanceof EvaluationWorkbook.ExternalSheetRange && !(r2 = (EvaluationWorkbook.ExternalSheetRange)externalSheet).getFirstSheetName().equals(r2.getLastSheetName())) {
                sb2.append(':');
                SheetNameFormatter.appendFormat(sb2, r2.getLastSheetName());
            }
        } else {
            String firstSheetName = book.getSheetFirstNameByExternSheet(field_1_index_extern_sheet);
            String lastSheetName = book.getSheetLastNameByExternSheet(field_1_index_extern_sheet);
            sb2 = new StringBuilder(firstSheetName.length() + cellRefText.length() + 4);
            if (firstSheetName.length() < 1) {
                sb2.append("#REF");
            } else {
                SheetNameFormatter.appendFormat(sb2, firstSheetName);
                if (!firstSheetName.equals(lastSheetName)) {
                    sb2.append(':');
                    sb2.append(lastSheetName);
                }
            }
        }
        sb2.append('!');
        sb2.append(cellRefText);
        return sb2.toString();
    }
}

