/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.poi.ss.util.NumberToTextConverter;

final class MathX {
    private MathX() {
    }

    public static double round(double n2, int p2) {
        return MathX.round(n2, p2, RoundingMode.HALF_UP);
    }

    public static double roundUp(double n2, int p2) {
        return MathX.round(n2, p2, RoundingMode.UP);
    }

    public static double roundDown(double n2, int p2) {
        return MathX.round(n2, p2, RoundingMode.DOWN);
    }

    private static double round(double n2, int p2, RoundingMode rounding) {
        if (Double.isNaN(n2) || Double.isInfinite(n2)) {
            return Double.NaN;
        }
        String excelNumber = NumberToTextConverter.toText(n2);
        return new BigDecimal(excelNumber).setScale(p2, rounding).doubleValue();
    }

    public static short sign(double d2) {
        return (short)(d2 == 0.0 ? 0 : (d2 < 0.0 ? -1 : 1));
    }

    public static double average(double[] values) {
        double ave = 0.0;
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        ave = sum / (double)values.length;
        return ave;
    }

    public static double sum(double[] values) {
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        return sum;
    }

    public static double sumsq(double[] values) {
        double sumsq = 0.0;
        for (double value : values) {
            sumsq += value * value;
        }
        return sumsq;
    }

    public static double product(double[] values) {
        double product = 0.0;
        if (values != null && values.length > 0) {
            product = 1.0;
            for (double value : values) {
                product *= value;
            }
        }
        return product;
    }

    public static double min(double[] values) {
        double min = Double.POSITIVE_INFINITY;
        for (double value : values) {
            min = Math.min(min, value);
        }
        return min;
    }

    public static double max(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        for (double value : values) {
            max = Math.max(max, value);
        }
        return max;
    }

    public static double floor(double n2, double s2) {
        if (s2 == 0.0 && n2 != 0.0) {
            return Double.NaN;
        }
        return n2 == 0.0 || s2 == 0.0 ? 0.0 : Math.floor(n2 / s2) * s2;
    }

    public static double ceiling(double n2, double s2) {
        if (n2 > 0.0 && s2 < 0.0) {
            return Double.NaN;
        }
        return n2 == 0.0 || s2 == 0.0 ? 0.0 : Math.ceil(n2 / s2) * s2;
    }

    public static double factorial(int n2) {
        double d2 = 1.0;
        if (n2 >= 0) {
            if (n2 <= 170) {
                for (int i2 = 1; i2 <= n2; ++i2) {
                    d2 *= (double)i2;
                }
            } else {
                d2 = Double.POSITIVE_INFINITY;
            }
        } else {
            d2 = Double.NaN;
        }
        return d2;
    }

    public static double mod(double n2, double d2) {
        if (d2 == 0.0) {
            return Double.NaN;
        }
        if (MathX.sign(n2) == MathX.sign(d2)) {
            return n2 % d2;
        }
        return (n2 % d2 + d2) % d2;
    }

    public static double acosh(double d2) {
        return Math.log(Math.sqrt(Math.pow(d2, 2.0) - 1.0) + d2);
    }

    public static double asinh(double d2) {
        return Math.log(Math.sqrt(d2 * d2 + 1.0) + d2);
    }

    public static double atanh(double d2) {
        return Math.log((1.0 + d2) / (1.0 - d2)) / 2.0;
    }

    public static double cosh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX + ePowNegX) / 2.0;
    }

    public static double sinh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX - ePowNegX) / 2.0;
    }

    public static double tanh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX - ePowNegX) / (ePowX + ePowNegX);
    }

    public static double nChooseK(int n2, int k2) {
        double d2 = 1.0;
        if (n2 < 0 || k2 < 0 || n2 < k2) {
            d2 = Double.NaN;
        } else {
            int maxnk;
            int minnk = Math.min(n2 - k2, k2);
            for (int i2 = maxnk = Math.max(n2 - k2, k2); i2 < n2; ++i2) {
                d2 *= (double)(i2 + 1);
            }
            d2 /= MathX.factorial(minnk);
        }
        return d2;
    }
}

